/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.api.transform.QualifiedContent;
import com.android.builder.files.IncrementalRelativeFileSets;
import com.android.builder.files.KeyedFileCache;
import com.android.builder.files.RelativeFile;
import com.android.builder.files.RelativeFiles;
import com.android.builder.files.SerializableChange;
import com.android.builder.files.SerializableInputChanges;
import com.android.builder.files.ZipCentralDirectory;
import com.android.builder.merge.IncrementalFileMergerInput;
import com.android.builder.merge.LazyIncrementalFileMergerInput;
import com.android.builder.merge.LazyIncrementalFileMergerInputs;
import com.android.ide.common.resources.FileStatus;
import com.android.tools.build.apkzlib.utils.CachedSupplier;
import com.android.tools.build.apkzlib.utils.IOExceptionRunnable;
import com.android.utils.FileUtils;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000`\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u001a\u001c\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\u0002H\u0002\u001a\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a0\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00030\u000e2\u0006\u0010\t\u001a\u00020\u00022\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001H\u0002\u001a8\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00030\u00012\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u001a8\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00022\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017\u001a\\\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00140\u001a2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u001d0\u001c2\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u001e\u001a\u00020\u001f2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u001d0\u001c\u001a&\u0010!\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017\u00a8\u0006\""}, d2={"collectChanges", "", "Ljava/io/File;", "Lcom/android/ide/common/resources/FileStatus;", "changes", "Lcom/android/builder/files/SerializableInputChanges;", "computeFilesFromDir", "", "Lcom/android/builder/files/RelativeFile;", "dir", "computeFilesFromJar", "jar", "Lcom/android/builder/files/ZipCentralDirectory;", "computeUpdatesFromDir", "Lcom/google/common/collect/ImmutableMap;", "changedInputs", "computeUpdatesFromJar", "zipCache", "Lcom/android/builder/files/KeyedFileCache;", "toIncrementalInput", "Lcom/android/builder/merge/IncrementalFileMergerInput;", "input", "cacheUpdates", "", "Ljava/lang/Runnable;", "toInputs", "Lcom/google/common/collect/ImmutableList;", "inputMap", "", "Lcom/android/build/api/transform/QualifiedContent$ScopeType;", "full", "", "scopeMap", "toNonIncrementalInput", "gradle-core"})
@JvmName(name="IncrementalFileMergerTaskUtils")
public final class IncrementalFileMergerTaskUtils {
    @NotNull
    public static final IncrementalFileMergerInput toIncrementalInput(@NotNull File input, @NotNull Map<File, ? extends FileStatus> changedInputs, @NotNull KeyedFileCache zipCache2, @NotNull List<Runnable> cacheUpdates) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter(changedInputs, (String)"changedInputs");
        Intrinsics.checkNotNullParameter((Object)zipCache2, (String)"zipCache");
        Intrinsics.checkNotNullParameter(cacheUpdates, (String)"cacheUpdates");
        String string = input.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"input.name");
        if (StringsKt.endsWith$default((String)string, (String)".jar", (boolean)false, (int)2, null)) {
            ZipCentralDirectory jarCDR = new ZipCentralDirectory(input);
            if (changedInputs.containsKey(input)) {
                Runnable runnable = IOExceptionRunnable.asRunnable((IOExceptionRunnable)new IOExceptionRunnable(input, zipCache2, jarCDR){
                    final /* synthetic */ File $input;
                    final /* synthetic */ KeyedFileCache $zipCache;
                    final /* synthetic */ ZipCentralDirectory $jarCDR;
                    {
                        this.$input = $input;
                        this.$zipCache = $zipCache;
                        this.$jarCDR = $jarCDR;
                    }

                    public final void run() {
                        if (this.$input.isFile()) {
                            this.$zipCache.add(this.$jarCDR);
                        } else {
                            this.$zipCache.remove(this.$input);
                        }
                    }
                });
                Intrinsics.checkNotNullExpressionValue((Object)runnable, (String)"input: File,\n    changed\u2026          }\n            }");
                cacheUpdates.add(runnable);
            }
            return (IncrementalFileMergerInput)new LazyIncrementalFileMergerInput(input.getAbsolutePath(), new CachedSupplier(new Supplier(jarCDR, changedInputs, zipCache2){
                final /* synthetic */ ZipCentralDirectory $jarCDR;
                final /* synthetic */ Map<File, FileStatus> $changedInputs;
                final /* synthetic */ KeyedFileCache $zipCache;
                {
                    this.$jarCDR = $jarCDR;
                    this.$changedInputs = $changedInputs;
                    this.$zipCache = $zipCache;
                }

                public final Map<RelativeFile, FileStatus> get() {
                    return IncrementalFileMergerTaskUtils.access$computeUpdatesFromJar(this.$jarCDR, this.$changedInputs, this.$zipCache);
                }
            }), new CachedSupplier(new Supplier(jarCDR){
                final /* synthetic */ ZipCentralDirectory $jarCDR;
                {
                    this.$jarCDR = $jarCDR;
                }

                public final Set<RelativeFile> get() {
                    return IncrementalFileMergerTaskUtils.access$computeFilesFromJar(this.$jarCDR);
                }
            }));
        }
        Preconditions.checkState((!input.isFile() ? 1 : 0) != 0, (String)Intrinsics.stringPlus((String)"Non-directory inputs must have .jar extension: ", (Object)input), (Object[])new Object[0]);
        return (IncrementalFileMergerInput)new LazyIncrementalFileMergerInput(input.getAbsolutePath(), new CachedSupplier(new Supplier(input, changedInputs){
            final /* synthetic */ File $input;
            final /* synthetic */ Map<File, FileStatus> $changedInputs;
            {
                this.$input = $input;
                this.$changedInputs = $changedInputs;
            }

            public final Map<RelativeFile, FileStatus> get() {
                return (Map)IncrementalFileMergerTaskUtils.access$computeUpdatesFromDir(this.$input, this.$changedInputs);
            }
        }), new CachedSupplier(new Supplier(input){
            final /* synthetic */ File $input;
            {
                this.$input = $input;
            }

            public final Set<RelativeFile> get() {
                return IncrementalFileMergerTaskUtils.access$computeFilesFromDir(this.$input);
            }
        }));
    }

    @Nullable
    public static final IncrementalFileMergerInput toNonIncrementalInput(@NotNull File input, @NotNull KeyedFileCache zipCache2, @NotNull List<Runnable> cacheUpdates) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)zipCache2, (String)"zipCache");
        Intrinsics.checkNotNullParameter(cacheUpdates, (String)"cacheUpdates");
        if (!input.isFile() && !input.isDirectory()) {
            return null;
        }
        if (input.isFile()) {
            Runnable runnable = IOExceptionRunnable.asRunnable((IOExceptionRunnable)new IOExceptionRunnable(zipCache2, input){
                final /* synthetic */ KeyedFileCache $zipCache;
                final /* synthetic */ File $input;
                {
                    this.$zipCache = $zipCache;
                    this.$input = $input;
                }

                public final void run() {
                    this.$zipCache.add(this.$input);
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)runnable, (String)"input: File,\n    zipCach\u2026 {  zipCache.add(input) }");
            cacheUpdates.add(runnable);
        }
        return (IncrementalFileMergerInput)LazyIncrementalFileMergerInputs.fromNew((String)input.getAbsolutePath(), (Set)((Set)ImmutableSet.of((Object)input)));
    }

    private static final Map<RelativeFile, FileStatus> computeUpdatesFromJar(ZipCentralDirectory jar, Map<File, ? extends FileStatus> changedInputs, KeyedFileCache zipCache2) {
        ImmutableMap immutableMap = changedInputs;
        File file = jar.getFile();
        int n = 0;
        Object object = immutableMap;
        boolean bl = false;
        if (object.containsKey(file)) {
            FileStatus fileStatus = (FileStatus)changedInputs.get(jar.getFile());
            try {
                Map map;
                file = fileStatus;
                n = file == null ? -1 : WhenMappings.$EnumSwitchMapping$0[file.ordinal()];
                switch (n) {
                    case 1: {
                        object = IncrementalRelativeFileSets.fromZip((ZipCentralDirectory)jar, (FileStatus)FileStatus.NEW);
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fromZip(jar, FileStatus.NEW)");
                        map = (Map)object;
                        break;
                    }
                    case 2: {
                        File file2 = zipCache2.get(jar.getFile());
                        if (file2 == null) {
                            throw new RuntimeException("File '" + jar + "' was deleted, but previous version not found in cache");
                        }
                        File cached = file2;
                        object = IncrementalRelativeFileSets.fromZip((File)cached, (FileStatus)FileStatus.REMOVED);
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"{\n                    va\u2026EMOVED)\n                }");
                        map = (Map)object;
                        break;
                    }
                    case 3: {
                        object = IncrementalRelativeFileSets.fromZip((ZipCentralDirectory)jar, (KeyedFileCache)zipCache2, (Set)new HashSet());
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fromZip(jar, zipCache, HashSet())");
                        map = object;
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)Intrinsics.stringPlus((String)"Unexpected FileStatus: ", (Object)fileStatus));
                    }
                }
                return map;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        immutableMap = ImmutableMap.of();
        Intrinsics.checkNotNullExpressionValue((Object)immutableMap, (String)"of()");
        return (Map)immutableMap;
    }

    private static final Set<RelativeFile> computeFilesFromJar(ZipCentralDirectory jar) {
        if (!jar.getFile().isFile()) {
            ImmutableSet immutableSet = ImmutableSet.of();
            Intrinsics.checkNotNullExpressionValue((Object)immutableSet, (String)"of()");
            return (Set)immutableSet;
        }
        try {
            Set set = RelativeFiles.fromZip((ZipCentralDirectory)jar);
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"fromZip(jar)");
            return set;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static final ImmutableMap<RelativeFile, FileStatus> computeUpdatesFromDir(File dir, Map<File, ? extends FileStatus> changedInputs) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        Object object = changedInputs;
        boolean bl = false;
        ImmutableMap immutableMap = object.entrySet().iterator();
        while (immutableMap.hasNext()) {
            RelativeFile rf;
            Object object2 = object = immutableMap.next();
            boolean bl2 = false;
            File file = (File)object2.getKey();
            Object object3 = object;
            boolean bl3 = false;
            FileStatus status = (FileStatus)object3.getValue();
            if (!FileUtils.isFileInDirectory((File)file, (File)dir) || (rf = new RelativeFile(dir, file)).getFile().isDirectory()) continue;
            builder.put((Object)rf, (Object)status);
        }
        immutableMap = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)immutableMap, (String)"builder.build()");
        return immutableMap;
    }

    private static final Set<RelativeFile> computeFilesFromDir(File dir) {
        if (!dir.isDirectory()) {
            ImmutableSet immutableSet = ImmutableSet.of();
            Intrinsics.checkNotNullExpressionValue((Object)immutableSet, (String)"of()");
            return (Set)immutableSet;
        }
        Set set = RelativeFiles.fromDirectory((File)dir);
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"fromDirectory(dir)");
        return set;
    }

    @NotNull
    public static final ImmutableList<IncrementalFileMergerInput> toInputs(@NotNull Map<File, QualifiedContent.ScopeType> inputMap, @Nullable SerializableInputChanges changes, @NotNull KeyedFileCache zipCache2, @NotNull List<Runnable> cacheUpdates, boolean full, @NotNull Map<IncrementalFileMergerInput, QualifiedContent.ScopeType> scopeMap) {
        boolean $i$a$-let-IncrementalFileMergerTaskUtils$toInputs$changedInputs$232;
        Object it;
        Object object;
        Map<File, FileStatus> map;
        SerializableInputChanges serializableInputChanges;
        Intrinsics.checkNotNullParameter(inputMap, (String)"inputMap");
        Intrinsics.checkNotNullParameter((Object)zipCache2, (String)"zipCache");
        Intrinsics.checkNotNullParameter(cacheUpdates, (String)"cacheUpdates");
        Intrinsics.checkNotNullParameter(scopeMap, (String)"scopeMap");
        if (full) {
            Runnable runnable = IOExceptionRunnable.asRunnable((IOExceptionRunnable)new IOExceptionRunnable(zipCache2){
                final /* synthetic */ KeyedFileCache $zipCache;
                {
                    this.$zipCache = $zipCache;
                }

                public final void run() {
                    this.$zipCache.clear();
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)runnable, (String)"zipCache: KeyedFileCache\u2026able { zipCache.clear() }");
            cacheUpdates.add(runnable);
        }
        if ((serializableInputChanges = changes) == null) {
            map = null;
        } else {
            object = serializableInputChanges;
            boolean bl = false;
            boolean bl2 = false;
            it = object;
            $i$a$-let-IncrementalFileMergerTaskUtils$toInputs$changedInputs$232 = false;
            map = IncrementalFileMergerTaskUtils.collectChanges((SerializableInputChanges)it);
        }
        Map<File, FileStatus> changedInputs = map;
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Map.Entry entry : inputMap.entrySet()) {
            IncrementalFileMergerInput fileMergerInput;
            IncrementalFileMergerInput incrementalFileMergerInput;
            it = entry;
            $i$a$-let-IncrementalFileMergerTaskUtils$toInputs$changedInputs$232 = false;
            File input = (File)it.getKey();
            Map.Entry $i$a$-let-IncrementalFileMergerTaskUtils$toInputs$changedInputs$232 = entry;
            boolean bl = false;
            QualifiedContent.ScopeType scope2 = (QualifiedContent.ScopeType)$i$a$-let-IncrementalFileMergerTaskUtils$toInputs$changedInputs$232.getValue();
            if (full) {
                incrementalFileMergerInput = IncrementalFileMergerTaskUtils.toNonIncrementalInput(input, zipCache2, cacheUpdates);
            } else {
                Map<File, FileStatus> map2 = changedInputs;
                if (map2 == null) {
                    throw new IllegalArgumentException("changes must be specified for incremental merging.");
                }
                incrementalFileMergerInput = IncrementalFileMergerTaskUtils.toIncrementalInput(input, map2, zipCache2, cacheUpdates);
            }
            IncrementalFileMergerInput incrementalFileMergerInput2 = fileMergerInput = incrementalFileMergerInput;
            if (incrementalFileMergerInput2 == null) continue;
            IncrementalFileMergerInput incrementalFileMergerInput3 = incrementalFileMergerInput2;
            boolean bl3 = false;
            boolean bl4 = false;
            IncrementalFileMergerInput it2 = incrementalFileMergerInput3;
            boolean bl5 = false;
            builder.add((Object)it2);
            Map<IncrementalFileMergerInput, QualifiedContent.ScopeType> map3 = scopeMap;
            boolean bl6 = false;
            map3.put(it2, scope2);
        }
        object = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"builder.build()");
        return object;
    }

    private static final Map<File, FileStatus> collectChanges(SerializableInputChanges changes) {
        boolean bl = false;
        Map map = new LinkedHashMap();
        Iterable $this$forEach$iv = changes.getChanges();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FileStatus fileStatus;
            SerializableChange change = (SerializableChange)element$iv;
            boolean bl2 = false;
            FileStatus currentState = (FileStatus)map.get(change.getFile());
            FileStatus changeState = change.getFileStatus();
            if (currentState == null) {
                fileStatus = changeState;
            } else if (currentState == FileStatus.NEW && changeState == FileStatus.REMOVED) {
                fileStatus = FileStatus.CHANGED;
            } else if (currentState == FileStatus.REMOVED && changeState == FileStatus.NEW) {
                fileStatus = FileStatus.CHANGED;
            } else {
                throw new IllegalStateException("Unexpected combination of states " + currentState + ", " + changeState + " for file " + change.getFile());
            }
            FileStatus newState = fileStatus;
            map.put(change.getFile(), newState);
        }
        Map<File, FileStatus> map2 = Collections.unmodifiableMap(map);
        Intrinsics.checkNotNullExpressionValue(map2, (String)"unmodifiableMap(map)");
        return map2;
    }

    public static final /* synthetic */ Map access$computeUpdatesFromJar(ZipCentralDirectory jar, Map changedInputs, KeyedFileCache zipCache2) {
        return IncrementalFileMergerTaskUtils.computeUpdatesFromJar(jar, changedInputs, zipCache2);
    }

    public static final /* synthetic */ Set access$computeFilesFromJar(ZipCentralDirectory jar) {
        return IncrementalFileMergerTaskUtils.computeFilesFromJar(jar);
    }

    public static final /* synthetic */ ImmutableMap access$computeUpdatesFromDir(File dir, Map changedInputs) {
        return IncrementalFileMergerTaskUtils.computeUpdatesFromDir(dir, changedInputs);
    }

    public static final /* synthetic */ Set access$computeFilesFromDir(File dir) {
        return IncrementalFileMergerTaskUtils.computeFilesFromDir(dir);
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FileStatus.values().length];
            nArray[FileStatus.NEW.ordinal()] = 1;
            nArray[FileStatus.REMOVED.ordinal()] = 2;
            nArray[FileStatus.CHANGED.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

