/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.testing;

import com.android.build.gradle.internal.testing.ConnectedDevice;
import com.android.builder.testing.api.DeviceConnector;
import com.android.builder.testing.api.DeviceException;
import com.android.builder.testing.api.DeviceProvider;
import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.DdmPreferences;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.Log;
import com.android.utils.ILogger;
import com.android.utils.concurrency.ReadWriteThreadLock;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Suppliers;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.Provider;

public class ConnectedDeviceProvider
extends DeviceProvider {
    private ReadWriteThreadLock.Lock sessionLock = new ReadWriteThreadLock((Object)DeviceProvider.class.toString()).writeLock();
    private final Supplier<File> adbLocationSupplier;
    private final long timeOut;
    private final TimeUnit timeOutUnit;
    private final ILogger iLogger;
    private final String androidSerialsEnv;
    private final List<ConnectedDevice> localDevices = Lists.newArrayList();
    private LogAdapter logAdapter;

    public ConnectedDeviceProvider(File adbLocation, int timeOutInMs, ILogger logger, String androidSerialsEnv) {
        this((Supplier<File>)Suppliers.ofInstance((Object)adbLocation), timeOutInMs, logger, androidSerialsEnv);
    }

    public ConnectedDeviceProvider(Provider<RegularFile> adbLocationProvider, int timeOutInMs, ILogger logger, String androidSerialsEnv) {
        this(() -> ((RegularFile)adbLocationProvider.get()).getAsFile(), timeOutInMs, logger, androidSerialsEnv);
    }

    public ConnectedDeviceProvider(Supplier<File> adbLocationSupplier, int timeOutInMs, ILogger logger, String androidSerialsEnv) {
        this.adbLocationSupplier = adbLocationSupplier;
        this.timeOut = timeOutInMs;
        this.timeOutUnit = TimeUnit.MILLISECONDS;
        this.iLogger = logger;
        this.androidSerialsEnv = androidSerialsEnv;
    }

    public String getName() {
        return "connected";
    }

    public List<? extends DeviceConnector> getDevices() {
        return this.localDevices;
    }

    public void init() throws DeviceException {
        this.sessionLock.lock();
        this.logAdapter = new LogAdapter(this.iLogger);
        Log.addLogger((Log.ILogOutput)this.logAdapter);
        try {
            DdmPreferences.setLogLevel((String)Log.LogLevel.VERBOSE.getStringValue());
            if (this.timeOut > 0L) {
                DdmPreferences.setTimeOut((int)((int)this.timeOutUnit.toMillis(this.timeOut)));
            } else {
                DdmPreferences.setTimeOut((int)Integer.MAX_VALUE);
            }
            AndroidDebugBridge.initIfNeeded((boolean)false);
            File adbLocation = this.adbLocationSupplier.get();
            AndroidDebugBridge bridge = AndroidDebugBridge.createBridge((String)adbLocation.getAbsolutePath(), (boolean)false, (long)(this.timeOut == 0L ? Long.MAX_VALUE : this.timeOut), (TimeUnit)this.timeOutUnit);
            if (bridge == null) {
                throw new DeviceException("Could not create ADB Bridge. ADB location: " + adbLocation.getAbsolutePath());
            }
            long getDevicesCountdown = this.timeOutUnit.toMillis(this.timeOut);
            int sleepTime = 1000;
            while (!bridge.hasInitialDeviceList() && getDevicesCountdown >= 0L) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    throw new DeviceException((Throwable)e);
                }
                if (this.timeOut == 0L) continue;
                getDevicesCountdown -= 1000L;
            }
            if (!bridge.hasInitialDeviceList()) {
                throw new DeviceException("Timeout getting device list.");
            }
            IDevice[] devices = bridge.getDevices();
            if (devices.length == 0) {
                throw new DeviceException("No connected devices!");
            }
            boolean isValidSerial = this.androidSerialsEnv != null && !this.androidSerialsEnv.isEmpty();
            HashSet serials = isValidSerial ? Sets.newHashSet((Iterable)Splitter.on((char)',').split((CharSequence)this.androidSerialsEnv)) : Collections.emptySet();
            ArrayList filteredDevices = Lists.newArrayListWithCapacity((int)devices.length);
            for (IDevice iDevice : devices) {
                if (isValidSerial && !serials.contains(iDevice.getSerialNumber())) continue;
                serials.remove(iDevice.getSerialNumber());
                filteredDevices.add(iDevice);
            }
            if (!serials.isEmpty()) {
                throw new DeviceException(String.format("Connected device with serial%s '%s' not found!", serials.size() == 1 ? "" : "s", Joiner.on((String)"', '").join((Iterable)serials)));
            }
            for (IDevice device : filteredDevices) {
                if (device.getState() == IDevice.DeviceState.ONLINE) {
                    this.localDevices.add(new ConnectedDevice(device, this.iLogger, this.timeOut, this.timeOutUnit));
                    continue;
                }
                this.iLogger.lifecycle("Skipping device '%s' (%s): Device is %s%s.", new Object[]{device.getName(), device.getSerialNumber(), device.getState(), device.getState() == IDevice.DeviceState.UNAUTHORIZED ? ",\n    see http://d.android.com/tools/help/adb.html#Enabling" : ""});
            }
            if (this.localDevices.isEmpty()) {
                if (isValidSerial) {
                    throw new DeviceException(String.format("Connected device with serial $1%s is not online.", this.androidSerialsEnv));
                }
                throw new DeviceException("No online devices found.");
            }
            this.makeDeviceNamesUnique();
        }
        catch (Throwable throwable) {
            Log.removeLogger((Log.ILogOutput)this.logAdapter);
            this.logAdapter = null;
            this.sessionLock.unlock();
            throw throwable;
        }
    }

    private boolean hasDevicesWithDuplicateName() {
        HashSet<String> deviceNames = new HashSet<String>();
        for (ConnectedDevice device : this.localDevices) {
            if (deviceNames.add(device.getName())) continue;
            return true;
        }
        return false;
    }

    private void makeDeviceNamesUnique() {
        if (this.hasDevicesWithDuplicateName()) {
            for (ConnectedDevice device : this.localDevices) {
                device.setNameSuffix(device.getSerialNumber());
            }
        }
        if (this.hasDevicesWithDuplicateName()) {
            int counter = 0;
            for (ConnectedDevice device : this.localDevices) {
                device.setNameSuffix(device.getSerialNumber() + "-" + counter);
                ++counter;
            }
        }
    }

    public void terminate() {
        try {
            Preconditions.checkNotNull((Object)this.logAdapter, (Object)"logAdapter should not be null");
            Log.removeLogger((Log.ILogOutput)this.logAdapter);
            this.logAdapter = null;
        }
        finally {
            this.sessionLock.unlock();
        }
    }

    public int getTimeoutInMs() {
        return (int)this.timeOutUnit.toMillis(this.timeOut);
    }

    public boolean isConfigured() {
        return true;
    }

    private static final class LogAdapter
    implements Log.ILogOutput {
        private final ILogger logger;

        private LogAdapter(ILogger logger) {
            this.logger = logger;
        }

        public void printLog(Log.LogLevel logLevel, String tag, String message2) {
            switch (logLevel) {
                case VERBOSE: {
                    break;
                }
                case DEBUG: {
                    break;
                }
                case INFO: {
                    this.logger.info("[%1$s]: %2$s", new Object[]{tag, message2});
                    break;
                }
                case WARN: {
                    this.logger.warning("[%1$s]: %2$s", new Object[]{tag, message2});
                    break;
                }
                case ERROR: {
                    this.logger.error(null, "[%1$s]: %2$s", new Object[]{tag, message2});
                    break;
                }
                case ASSERT: {
                    this.logger.error(null, "[%1$s]: %2$s", new Object[]{tag, message2});
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown log level " + logLevel);
                }
            }
        }

        public void printAndPromptLog(Log.LogLevel logLevel, String tag, String message2) {
            this.printLog(logLevel, tag, message2);
        }
    }
}

