/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.manifmerger.ManifestMerger2;
import com.google.common.collect.ImmutableList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\u0010\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0010\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0010\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u00a8\u0006\u0006"}, d2={"removeSplitNames", "", "document", "Lorg/w3c/dom/Document;", "stripMinSdkFromFeatureManifest", "stripUsesSplitFromFeatureManifest", "gradle-core"})
public final class XmlDocumentUtilsKt {
    public static final void stripUsesSplitFromFeatureManifest(@NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Element manifest = document.getDocumentElement();
        ImmutableList usesSplitList = ManifestMerger2.getChildElementsByName((Element)manifest, (String)"uses-split");
        Intrinsics.checkNotNullExpressionValue((Object)usesSplitList, (String)"usesSplitList");
        Iterable $this$forEach$iv = (Iterable)usesSplitList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Element node = (Element)element$iv;
            boolean bl = false;
            manifest.removeChild(node);
        }
    }

    public static final void stripMinSdkFromFeatureManifest(@NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Element manifest = document.getDocumentElement();
        ImmutableList usesSdkList = ManifestMerger2.getChildElementsByName((Element)manifest, (String)"uses-sdk");
        Element usesSdk = null;
        if (!usesSdkList.isEmpty()) {
            Object object = usesSdkList.get(0);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"usesSdkList[0]");
            usesSdk = (Element)object;
            usesSdk.removeAttributeNS("http://schemas.android.com/apk/res/android", "minSdkVersion");
        }
    }

    public static final void removeSplitNames(@NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Element element = document.getDocumentElement();
        if (element == null) {
            return;
        }
        Element manifest = element;
        ImmutableList applicationElements = ManifestMerger2.getChildElementsByName((Element)manifest, (String)"application");
        if (applicationElements.isEmpty()) {
            return;
        }
        Element application = (Element)applicationElements.get(0);
        String[] stringArray = new String[]{"activity", "service", "provider"};
        List elementNamesToUpdate = CollectionsKt.listOf((Object[])stringArray);
        for (String elementName : elementNamesToUpdate) {
            for (Element elementToUpdate : ManifestMerger2.getChildElementsByName((Element)application, (String)elementName)) {
                elementToUpdate.removeAttributeNS("http://schemas.android.com/apk/res/android", "splitName");
            }
        }
    }
}

