/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.ndk;

import com.android.build.gradle.internal.core.Abi;
import com.android.build.gradle.internal.ndk.NdkInfo;
import com.android.repository.Revision;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import java.io.File;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\t\u0010 \u001a\u00020\u0003H\u00c6\u0003J\t\u0010!\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\"\u001a\u00020\u0007H\u00c6\u0003J\t\u0010#\u001a\u00020\tH\u00c2\u0003J1\u0010$\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010%\u001a\u00020\u001c2\b\u0010&\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010'\u001a\u00020(H\u00d6\u0001J\t\u0010)\u001a\u00020\tH\u00d6\u0001R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R!\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\r0\f8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u0011\u001a\u0004\b\u0019\u0010\u000fR\u001b\u0010\u001b\u001a\u00020\u001c8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001f\u0010\u0011\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006*"}, d2={"Lcom/android/build/gradle/internal/ndk/NdkPlatform;", "", "ndkDirectory", "Ljava/io/File;", "ndkInfo", "Lcom/android/build/gradle/internal/ndk/NdkInfo;", "revision", "Lcom/android/repository/Revision;", "compileSdkVersion", "", "(Ljava/io/File;Lcom/android/build/gradle/internal/ndk/NdkInfo;Lcom/android/repository/Revision;Ljava/lang/String;)V", "defaultAbis", "", "Lcom/android/build/gradle/internal/core/Abi;", "getDefaultAbis", "()Ljava/util/List;", "defaultAbis$delegate", "Lkotlin/Lazy;", "getNdkDirectory", "()Ljava/io/File;", "getNdkInfo", "()Lcom/android/build/gradle/internal/ndk/NdkInfo;", "getRevision", "()Lcom/android/repository/Revision;", "supportedAbis", "getSupportedAbis", "supportedAbis$delegate", "supports64Bits", "", "getSupports64Bits", "()Z", "supports64Bits$delegate", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toString", "gradle-core"})
public final class NdkPlatform {
    @NotNull
    private final File ndkDirectory;
    @NotNull
    private final NdkInfo ndkInfo;
    @NotNull
    private final Revision revision;
    @NotNull
    private final String compileSdkVersion;
    @NotNull
    private final Lazy supports64Bits$delegate;
    @NotNull
    private final Lazy supportedAbis$delegate;
    @NotNull
    private final Lazy defaultAbis$delegate;

    public NdkPlatform(@NotNull File ndkDirectory2, @NotNull NdkInfo ndkInfo, @NotNull Revision revision, @NotNull String compileSdkVersion) {
        Intrinsics.checkNotNullParameter((Object)ndkDirectory2, (String)"ndkDirectory");
        Intrinsics.checkNotNullParameter((Object)ndkInfo, (String)"ndkInfo");
        Intrinsics.checkNotNullParameter((Object)revision, (String)"revision");
        Intrinsics.checkNotNullParameter((Object)compileSdkVersion, (String)"compileSdkVersion");
        this.ndkDirectory = ndkDirectory2;
        this.ndkInfo = ndkInfo;
        this.revision = revision;
        this.compileSdkVersion = compileSdkVersion;
        this.supports64Bits$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Boolean>(this){
            final /* synthetic */ NdkPlatform this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                AndroidVersion androidVersion = AndroidTargetHash.getVersionFromHash((String)NdkPlatform.access$getCompileSdkVersion$p(this.this$0));
                if (androidVersion == null) {
                    throw new RuntimeException(Intrinsics.stringPlus((String)"Unable to parse compileSdkVersion: ", (Object)NdkPlatform.access$getCompileSdkVersion$p(this.this$0)));
                }
                AndroidVersion androidVersion2 = androidVersion;
                return androidVersion2.compareTo(AndroidVersion.SUPPORTS_64_BIT) >= 0;
            }
        }));
        this.supportedAbis$delegate = LazyKt.lazy((Function0)((Function0)new Function0<List<? extends Abi>>(this){
            final /* synthetic */ NdkPlatform this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final List<Abi> invoke() {
                return CollectionsKt.toList((Iterable)(NdkPlatform.access$getSupports64Bits(this.this$0) ? this.this$0.getNdkInfo().getSupportedAbis() : this.this$0.getNdkInfo().getSupported32BitsAbis()));
            }
        }));
        this.defaultAbis$delegate = LazyKt.lazy((Function0)((Function0)new Function0<List<? extends Abi>>(this){
            final /* synthetic */ NdkPlatform this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final List<Abi> invoke() {
                return CollectionsKt.toList((Iterable)(NdkPlatform.access$getSupports64Bits(this.this$0) ? this.this$0.getNdkInfo().getDefaultAbis() : this.this$0.getNdkInfo().getDefault32BitsAbis()));
            }
        }));
    }

    @NotNull
    public final File getNdkDirectory() {
        return this.ndkDirectory;
    }

    @NotNull
    public final NdkInfo getNdkInfo() {
        return this.ndkInfo;
    }

    @NotNull
    public final Revision getRevision() {
        return this.revision;
    }

    private final boolean getSupports64Bits() {
        Lazy lazy = this.supports64Bits$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (Boolean)lazy.getValue();
    }

    @NotNull
    public final List<Abi> getSupportedAbis() {
        Lazy lazy = this.supportedAbis$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (List)lazy.getValue();
    }

    @NotNull
    public final List<Abi> getDefaultAbis() {
        Lazy lazy = this.defaultAbis$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (List)lazy.getValue();
    }

    @NotNull
    public final File component1() {
        return this.ndkDirectory;
    }

    @NotNull
    public final NdkInfo component2() {
        return this.ndkInfo;
    }

    @NotNull
    public final Revision component3() {
        return this.revision;
    }

    private final String component4() {
        return this.compileSdkVersion;
    }

    @NotNull
    public final NdkPlatform copy(@NotNull File ndkDirectory2, @NotNull NdkInfo ndkInfo, @NotNull Revision revision, @NotNull String compileSdkVersion) {
        Intrinsics.checkNotNullParameter((Object)ndkDirectory2, (String)"ndkDirectory");
        Intrinsics.checkNotNullParameter((Object)ndkInfo, (String)"ndkInfo");
        Intrinsics.checkNotNullParameter((Object)revision, (String)"revision");
        Intrinsics.checkNotNullParameter((Object)compileSdkVersion, (String)"compileSdkVersion");
        return new NdkPlatform(ndkDirectory2, ndkInfo, revision, compileSdkVersion);
    }

    public static /* synthetic */ NdkPlatform copy$default(NdkPlatform ndkPlatform, File file, NdkInfo ndkInfo, Revision revision, String string, int n, Object object) {
        if ((n & 1) != 0) {
            file = ndkPlatform.ndkDirectory;
        }
        if ((n & 2) != 0) {
            ndkInfo = ndkPlatform.ndkInfo;
        }
        if ((n & 4) != 0) {
            revision = ndkPlatform.revision;
        }
        if ((n & 8) != 0) {
            string = ndkPlatform.compileSdkVersion;
        }
        return ndkPlatform.copy(file, ndkInfo, revision, string);
    }

    @NotNull
    public String toString() {
        return "NdkPlatform(ndkDirectory=" + this.ndkDirectory + ", ndkInfo=" + this.ndkInfo + ", revision=" + this.revision + ", compileSdkVersion=" + this.compileSdkVersion + ')';
    }

    public int hashCode() {
        int result2 = this.ndkDirectory.hashCode();
        result2 = result2 * 31 + this.ndkInfo.hashCode();
        result2 = result2 * 31 + this.revision.hashCode();
        result2 = result2 * 31 + this.compileSdkVersion.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof NdkPlatform)) {
            return false;
        }
        NdkPlatform ndkPlatform = (NdkPlatform)other;
        if (!Intrinsics.areEqual((Object)this.ndkDirectory, (Object)ndkPlatform.ndkDirectory)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.ndkInfo, (Object)ndkPlatform.ndkInfo)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.revision, (Object)ndkPlatform.revision)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.compileSdkVersion, (Object)ndkPlatform.compileSdkVersion);
    }

    public static final /* synthetic */ String access$getCompileSdkVersion$p(NdkPlatform $this) {
        return $this.compileSdkVersion;
    }

    public static final /* synthetic */ boolean access$getSupports64Bits(NdkPlatform $this) {
        return $this.getSupports64Bits();
    }
}

