/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.errors;

import com.android.ide.common.blame.Message;
import com.android.ide.common.blame.SourceFilePosition;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\u000e\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u00a8\u0006\u0004"}, d2={"humanReadableMessage", "", "message", "Lcom/android/ide/common/blame/Message;", "gradle-core"})
public final class MessageReceiverImplKt {
    @NotNull
    public static final String humanReadableMessage(@NotNull Message message2) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        StringBuilder errorStringBuilder = new StringBuilder();
        errorStringBuilder.append(message2.getKind().name());
        errorStringBuilder.append(":");
        List positions = message2.getSourceFilePositions();
        if (positions.size() != 1 || !Intrinsics.areEqual((Object)SourceFilePosition.UNKNOWN, (Object)Iterables.getOnlyElement((Iterable)positions))) {
            errorStringBuilder.append(Joiner.on((char)' ').join((Iterable)positions));
            errorStringBuilder.append(": ");
        }
        if (message2.getToolName() != null) {
            errorStringBuilder.append(message2.getToolName()).append(": ");
        }
        errorStringBuilder.append(message2.getText());
        String rawMessage = message2.getRawMessage();
        if (!Intrinsics.areEqual((Object)message2.getText(), (Object)message2.getRawMessage())) {
            String separator = System.lineSeparator();
            StringBuilder stringBuilder = errorStringBuilder.append("\n    ");
            Intrinsics.checkNotNullExpressionValue((Object)separator, (String)"separator");
            stringBuilder.append(StringsKt.replace$default((String)rawMessage, (String)separator, (String)Intrinsics.stringPlus((String)separator, (Object)"    "), (boolean)false, (int)4, null));
        }
        String string = errorStringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"errorStringBuilder.toString()");
        return string;
    }
}

