/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.tasks.AarMetadataArtifact;
import com.android.build.gradle.internal.tasks.AarMetadataReader;
import com.android.build.gradle.internal.tasks.CheckAarMetadataWorkParameters;
import com.android.build.gradle.internal.utils.CompileData;
import com.android.build.gradle.internal.utils.SdkUtilsKt;
import com.android.ide.common.repository.GradleVersion;
import com.android.repository.Revision;
import com.android.sdklib.SdkVersionInfo;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.workers.WorkAction;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002J\b\u0010\u000b\u001a\u00020\u0005H\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\nH\u0002J\u001e\u0010\u000f\u001a\u00020\u0005*\u00060\u0010j\u0002`\u00112\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\u0012H\u0002\u00a8\u0006\u0013"}, d2={"Lcom/android/build/gradle/internal/tasks/CheckAarMetadataWorkAction;", "Lorg/gradle/workers/WorkAction;", "Lcom/android/build/gradle/internal/tasks/CheckAarMetadataWorkParameters;", "()V", "checkAarMetadataArtifact", "", "aarMetadataArtifact", "Lcom/android/build/gradle/internal/tasks/AarMetadataArtifact;", "errorMessages", "", "", "execute", "getApiIntFromString", "", "sdkVersion", "appendNumberedErrorMessages", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "", "gradle-core"})
public abstract class CheckAarMetadataWorkAction
implements WorkAction<CheckAarMetadataWorkParameters> {
    public void execute() {
        boolean bl = false;
        List errorMessages = new ArrayList();
        Object object = ((CheckAarMetadataWorkParameters)this.getParameters()).getAarMetadataArtifacts().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.aarMetadataArtifacts.get()");
        Iterable $this$forEach$iv = (Iterable)object;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AarMetadataArtifact it = (AarMetadataArtifact)element$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            this.checkAarMetadataArtifact(it, errorMessages);
        }
        if (errorMessages.size() > 0) {
            object = new StringBuilder();
            boolean bl3 = false;
            boolean bl4 = false;
            Object $this$execute_u24lambda_u2d1 = object;
            boolean bl5 = false;
            int n = errorMessages.size();
            if (n == 1) {
                ((StringBuilder)$this$execute_u24lambda_u2d1).append("An issue was");
            } else {
                ((StringBuilder)$this$execute_u24lambda_u2d1).append(errorMessages.size()).append(" issues were");
            }
            ((StringBuilder)$this$execute_u24lambda_u2d1).append(" found when checking AAR metadata:");
            this.appendNumberedErrorMessages((StringBuilder)$this$execute_u24lambda_u2d1, errorMessages);
            Unit unit = Unit.INSTANCE;
            String string = ((StringBuilder)object).toString();
            throw new RuntimeException(string);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void appendNumberedErrorMessages(StringBuilder $this$appendNumberedErrorMessages, List<String> errorMessages) {
        Iterable $this$forEachIndexed$iv = errorMessages;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void errorMessage;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string = (String)item$iv;
            int index = n;
            boolean bl2 = false;
            $this$appendNumberedErrorMessages.append("\n\n");
            String string2 = "%3d";
            Locale locale = Locale.US;
            Object[] objectArray = new Object[]{index + 1};
            boolean bl3 = false;
            String string3 = String.format(locale, string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(locale, this, *args)");
            $this$appendNumberedErrorMessages.append(string3);
            $this$appendNumberedErrorMessages.append(".  ");
            Iterable $this$forEachIndexed$iv2 = StringsKt.lines((CharSequence)((CharSequence)errorMessage));
            boolean $i$f$forEachIndexed2 = false;
            int index$iv2 = 0;
            for (Object item$iv2 : $this$forEachIndexed$iv2) {
                void line;
                int n2 = index$iv2++;
                boolean bl4 = false;
                if (n2 < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                String string4 = (String)item$iv2;
                int lineIndex = n2;
                boolean bl5 = false;
                if (lineIndex > 0) {
                    $this$appendNumberedErrorMessages.append("\n");
                    CharSequence charSequence = (CharSequence)line;
                    boolean bl6 = false;
                    if (charSequence.length() > 0) {
                        $this$appendNumberedErrorMessages.append("      ");
                    }
                }
                $this$appendNumberedErrorMessages.append((String)line);
            }
        }
    }

    private final void checkAarMetadataArtifact(AarMetadataArtifact aarMetadataArtifact, List<String> errorMessages) {
        String minAgpVersion;
        String minCompileSdk;
        File aarMetadataFile = aarMetadataArtifact.getFile();
        String displayName = aarMetadataArtifact.getDisplayName();
        AarMetadataReader aarMetadataReader = new AarMetadataReader(aarMetadataFile);
        String aarFormatVersion = aarMetadataReader.getAarFormatVersion();
        if (aarFormatVersion == null) {
            errorMessages.add(StringsKt.trimIndent((String)("\n                    The AAR metadata for dependency '" + displayName + "' does not specify an\n                    aarFormatVersion value, which is a required value.\n                    ")));
        } else {
            try {
                int majorAarVersion = Revision.parseRevision((String)aarFormatVersion).getMajor();
                int maxMajorAarVersion = Revision.parseRevision((String)((String)((CheckAarMetadataWorkParameters)this.getParameters()).getAarFormatVersion().get())).getMajor();
                if (majorAarVersion > maxMajorAarVersion) {
                    errorMessages.add(StringsKt.trimIndent((String)("\n                            Dependency '" + displayName + "' has an aarFormatVersion value of\n                            '" + aarFormatVersion + "', which is not compatible with this version of the\n                            Android Gradle plugin.\n\n                            Please upgrade to a newer version of the Android Gradle plugin.\n                            ")));
                }
            }
            catch (NumberFormatException e) {
                errorMessages.add(StringsKt.trimIndent((String)("\n                        The AAR metadata for dependency '" + displayName + "' has an invalid\n                        aarFormatVersion value (" + aarFormatVersion + ").\n\n                        " + e.getMessage() + "\n                        ")));
            }
        }
        String aarMetadataVersion = aarMetadataReader.getAarMetadataVersion();
        if (aarMetadataVersion == null) {
            errorMessages.add(StringsKt.trimIndent((String)("\n                    The AAR metadata for dependency '" + displayName + "' does not specify an\n                    aarMetadataVersion value, which is a required value.\n                    ")));
        } else {
            try {
                int majorAarMetadataVersion = Revision.parseRevision((String)aarMetadataVersion).getMajor();
                int maxMajorAarMetadataVersion = Revision.parseRevision((String)((String)((CheckAarMetadataWorkParameters)this.getParameters()).getAarMetadataVersion().get())).getMajor();
                if (majorAarMetadataVersion > maxMajorAarMetadataVersion) {
                    errorMessages.add(StringsKt.trimIndent((String)("\n                            Dependency '" + displayName + "' has an aarMetadataVersion value of\n                            '" + aarMetadataVersion + "', which is not compatible with this version of the\n                            Android Gradle plugin.\n\n                            Please upgrade to a newer version of the Android Gradle plugin.\n                            ")));
                }
            }
            catch (NumberFormatException e) {
                errorMessages.add(StringsKt.trimIndent((String)("\n                        The AAR metadata for dependency '" + displayName + "' has an invalid\n                        aarMetadataVersion value (" + aarMetadataVersion + ").\n\n                        " + e.getMessage() + "\n                        ")));
            }
        }
        String forceCompileSdkPreview = aarMetadataReader.getForceCompileSdkPreview();
        if (forceCompileSdkPreview != null) {
            String compileSdkVersion = (String)((CheckAarMetadataWorkParameters)this.getParameters()).getCompileSdkVersion().get();
            Object object = ((CheckAarMetadataWorkParameters)this.getParameters()).getCompileSdkVersion().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.compileSdkVersion.get()");
            String compileSdkPreview = SdkUtilsKt.parseTargetHash((String)object).getCodeName();
            if (!Intrinsics.areEqual((Object)compileSdkPreview, (Object)forceCompileSdkPreview)) {
                errorMessages.add(StringsKt.trimIndent((String)("\n                        Dependency '" + displayName + "' requires libraries and applications that\n                        depend on it to compile against codename \"" + forceCompileSdkPreview + "\" of the\n                        Android APIs.\n\n                        " + ((CheckAarMetadataWorkParameters)this.getParameters()).getProjectPath().get() + " is currently compiled against " + compileSdkVersion + ".\n\n                        Recommended action: Use a different version of dependency '" + displayName + "',\n                        or set compileSdkPreview to \"" + forceCompileSdkPreview + "\" in your build.gradle\n                        file if you intend to experiment with that preview SDK.\n                    ")));
            }
        }
        if ((minCompileSdk = aarMetadataReader.getMinCompileSdk()) != null) {
            Integer minCompileSdkInt = StringsKt.toIntOrNull((String)minCompileSdk);
            if (minCompileSdkInt == null) {
                errorMessages.add(StringsKt.trimIndent((String)("\n                        The AAR metadata for dependency '" + displayName + "' has an invalid\n                        minCompileSdk value (" + minCompileSdk + ").\n\n                        minCompileSdk must be an integer.\n                        ")));
            } else {
                String compileSdkVersion = (String)((CheckAarMetadataWorkParameters)this.getParameters()).getCompileSdkVersion().get();
                Intrinsics.checkNotNullExpressionValue((Object)compileSdkVersion, (String)"compileSdkVersion");
                int compileSdkVersionInt = this.getApiIntFromString(compileSdkVersion);
                if (minCompileSdkInt > compileSdkVersionInt) {
                    Integer maxRecommendedCompileSdk = (Integer)((CheckAarMetadataWorkParameters)this.getParameters()).getMaxRecommendedStableCompileSdkVersionForThisAgp().get();
                    int n = minCompileSdkInt;
                    Intrinsics.checkNotNullExpressionValue((Object)maxRecommendedCompileSdk, (String)"maxRecommendedCompileSdk");
                    String recommendation = n <= maxRecommendedCompileSdk ? StringsKt.trimIndent((String)("\n                            Recommended action: Update this project to use a newer compileSdkVersion\n                            of at least " + minCompileSdk + ", for example " + maxRecommendedCompileSdk + ".\n                        ")) : StringsKt.trimIndent((String)("\n                            Also, the maximum recommended compile SDK version for Android Gradle\n                            plugin " + ((CheckAarMetadataWorkParameters)this.getParameters()).getAgpVersion().get() + " is " + maxRecommendedCompileSdk + ".\n\n                            Recommended action: Update this project's version of the Android Gradle\n                            plugin to one that supports " + minCompileSdk + ", then update this project to use\n                            compileSdkVerion of at least " + minCompileSdk + ".\n                        "));
                    errorMessages.add(StringsKt.trimIndent((String)("\n                            Dependency '" + displayName + "' requires libraries and applications that\n                            depend on it to compile against version " + minCompileSdk + " or later of the\n                            Android APIs.\n\n                            " + ((CheckAarMetadataWorkParameters)this.getParameters()).getProjectPath().get() + " is currently compiled against " + compileSdkVersion + ".\n                        ")) + "\n\n" + recommendation + "\n\n" + "Note that updating a library or application's compileSdkVersion (which\nallows newer APIs to be used) can be done separately from updating\ntargetSdkVersion (which opts the app in to new runtime behavior) and\nminSdkVersion (which determines which devices the app can be installed\non).");
                }
            }
        }
        if ((minAgpVersion = aarMetadataReader.getMinAgpVersion()) != null) {
            GradleVersion parsedMinAgpVersion = GradleVersion.tryParseStableAndroidGradlePluginVersion((String)minAgpVersion);
            if (parsedMinAgpVersion == null) {
                errorMessages.add(StringsKt.trimIndent((String)("\n                        The AAR metadata for dependency '" + displayName + "' has an invalid\n                        minAndroidGradlePluginVersion value (" + minAgpVersion + ").\n\n                        minAndroidGradlePluginVersion must be a stable AGP version,\n                        formatted with major, minor, and micro values (for example \"4.0.0\").\n                        ")));
            } else {
                GradleVersion parsedAgpVersion = GradleVersion.parseAndroidGradlePluginVersion((String)((String)((CheckAarMetadataWorkParameters)this.getParameters()).getAgpVersion().get()));
                if (parsedMinAgpVersion.compareTo(parsedAgpVersion) > 0) {
                    errorMessages.add(StringsKt.trimIndent((String)("\n                            Dependency '" + displayName + "' requires Android Gradle plugin " + minAgpVersion + " or higher.\n\n                            This build currently uses Android Gradle plugin " + ((CheckAarMetadataWorkParameters)this.getParameters()).getAgpVersion().get() + ".\n                            ")));
                }
            }
        }
    }

    private final int getApiIntFromString(String sdkVersion) {
        CompileData compileData = SdkUtilsKt.parseTargetHash(sdkVersion);
        if (compileData.getApiLevel() != null) {
            return compileData.getApiLevel();
        }
        if (compileData.getCodeName() != null) {
            return SdkVersionInfo.getApiByPreviewName((String)compileData.getCodeName(), (boolean)true);
        }
        throw new RuntimeException(Intrinsics.stringPlus((String)"Unsupported target hash: ", (Object)sdkVersion));
    }
}

