/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.api;

import com.android.build.api.artifact.Artifact;
import com.android.build.gradle.api.BaseVariantOutput;
import com.android.build.gradle.api.InstallableVariant;
import com.android.build.gradle.internal.api.AndroidArtifactVariantImpl;
import com.android.build.gradle.internal.api.ReadOnlyObjectProvider;
import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.errors.DeprecationReporter;
import com.android.build.gradle.internal.services.DslServices;
import com.android.build.gradle.internal.variant.ApkVariantData;
import org.gradle.api.DefaultTask;
import org.gradle.api.Incubating;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskProvider;

public abstract class InstallableVariantImpl
extends AndroidArtifactVariantImpl
implements InstallableVariant {
    protected InstallableVariantImpl(ComponentCreationConfig component2, DslServices services, ReadOnlyObjectProvider immutableObjectProvider, NamedDomainObjectContainer<BaseVariantOutput> outputs) {
        super(component2, services, immutableObjectProvider, outputs);
    }

    @Override
    public abstract ApkVariantData getVariantData();

    @Override
    public DefaultTask getInstall() {
        this.services.getDeprecationReporter().reportDeprecatedApi("variantOutput.getInstallProvider()", "variantOutput.getInstall()", "https://d.android.com/r/tools/task-configuration-avoidance", DeprecationReporter.DeprecationTarget.TASK_ACCESS_VIA_VARIANT);
        if (this.component.getTaskContainer().getInstallTask() != null) {
            return (DefaultTask)this.component.getTaskContainer().getInstallTask().getOrNull();
        }
        return null;
    }

    @Override
    public TaskProvider<Task> getInstallProvider() {
        return this.component.getTaskContainer().getInstallTask();
    }

    @Override
    public DefaultTask getUninstall() {
        this.services.getDeprecationReporter().reportDeprecatedApi("variantOutput.getUninstallProvider()", "variantOutput.getUninstall()", "https://d.android.com/r/tools/task-configuration-avoidance", DeprecationReporter.DeprecationTarget.TASK_ACCESS_VIA_VARIANT);
        if (this.component.getTaskContainer().getUninstallTask() != null) {
            return (DefaultTask)this.component.getTaskContainer().getUninstallTask().getOrNull();
        }
        return null;
    }

    @Override
    public TaskProvider<Task> getUninstallProvider() {
        return this.component.getTaskContainer().getUninstallTask();
    }

    @Incubating
    public Provider<FileCollection> getFinalArtifact(Artifact.Single<? extends FileSystemLocation> artifactType) {
        return this.component.getServices().provider(() -> this.component.getServices().fileCollection(this.component.getArtifacts().get(artifactType)));
    }
}

