/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.ide.dependencies;

import com.google.common.collect.ImmutableMap;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.initialization.IncludedBuild;
import org.gradle.api.invocation.Gradle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u001a\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u0004j\u0002`\u0005*\u00020\t\u001a$\u0010\n\u001a\u0004\u0018\u00010\u0001*\u00020\u000b2\u0016\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u0004j\u0002`\u0005\u001a\n\u0010\r\u001a\u00020\u0001*\u00020\u000b\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"'\u0010\u0003\u001a\u0004\u0018\u00010\u0001*\u0012\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u0004j\u0002`\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007*\"\u0010\u000e\"\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u00042\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u0004\u00a8\u0006\u000f"}, d2={"CURRENT_BUILD_NAME", "", "UNKNOWN_BUILD_NAME", "currentBuild", "Lcom/google/common/collect/ImmutableMap;", "Lcom/android/build/gradle/internal/ide/dependencies/BuildMapping;", "getCurrentBuild", "(Lcom/google/common/collect/ImmutableMap;)Ljava/lang/String;", "computeBuildMapping", "Lorg/gradle/api/invocation/Gradle;", "getBuildId", "Lorg/gradle/api/artifacts/component/ProjectComponentIdentifier;", "mapping", "getIdString", "BuildMapping", "gradle-core"})
@JvmName(name="BuildMappingUtils")
public final class BuildMappingUtils {
    @NotNull
    private static final String CURRENT_BUILD_NAME = "__current_build__";
    @NotNull
    public static final String UNKNOWN_BUILD_NAME = "__unknown__";

    @Nullable
    public static final String getBuildId(@NotNull ProjectComponentIdentifier $this$getBuildId, @NotNull ImmutableMap<String, String> mapping) {
        Intrinsics.checkNotNullParameter((Object)$this$getBuildId, (String)"<this>");
        Intrinsics.checkNotNullParameter(mapping, (String)"mapping");
        return (String)mapping.get((Object)($this$getBuildId.getBuild().isCurrentBuild() ? CURRENT_BUILD_NAME : $this$getBuildId.getBuild().getName()));
    }

    @NotNull
    public static final String getIdString(@NotNull ProjectComponentIdentifier $this$getIdString) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$getIdString, (String)"<this>");
        String $this$getIdString_u24lambda_u2d1 = string = $this$getIdString.getProjectPath();
        boolean bl = false;
        BuildIdentifier buildIdentifier = $this$getIdString.getBuild();
        if (buildIdentifier != null) {
            BuildIdentifier it = buildIdentifier;
            boolean bl2 = false;
            String cfr_ignored_0 = $this$getIdString_u24lambda_u2d1 + ":" + it.getName();
        }
        String string2 = string;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"projectPath.apply {\n    \u2026us(\":${it.name}\") }\n    }");
        return string2;
    }

    @NotNull
    public static final ImmutableMap<String, String> computeBuildMapping(@NotNull Gradle $this$computeBuildMapping) {
        Intrinsics.checkNotNullParameter((Object)$this$computeBuildMapping, (String)"<this>");
        ImmutableMap.Builder builder = ImmutableMap.builder();
        String currentBuildPath = $this$computeBuildMapping.getRootProject().getProjectDir().getAbsolutePath();
        builder.put((Object)CURRENT_BUILD_NAME, (Object)currentBuildPath);
        Gradle rootGradleProject = $this$computeBuildMapping;
        while (true) {
            Gradle gradle = rootGradleProject;
            Intrinsics.checkNotNull((Object)gradle);
            if (gradle.getParent() == null) break;
            rootGradleProject = rootGradleProject.getParent();
        }
        if (rootGradleProject != $this$computeBuildMapping) {
            builder.put((Object)rootGradleProject.getRootProject().getName(), (Object)rootGradleProject.getRootProject().getProjectDir().getAbsolutePath());
        }
        for (IncludedBuild includedBuild : rootGradleProject.getIncludedBuilds()) {
            String includedBuildPath = includedBuild.getProjectDir().getAbsolutePath();
            if (Intrinsics.areEqual((Object)includedBuildPath, (Object)currentBuildPath)) continue;
            builder.put((Object)includedBuild.getName(), (Object)includedBuildPath);
        }
        ImmutableMap immutableMap = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)immutableMap, (String)"builder.build()");
        return immutableMap;
    }

    @Nullable
    public static final String getCurrentBuild(@NotNull ImmutableMap<String, String> $this$currentBuild) {
        Intrinsics.checkNotNullParameter($this$currentBuild, (String)"<this>");
        return (String)$this$currentBuild.get((Object)CURRENT_BUILD_NAME);
    }
}

