/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.res;

import com.android.aaptcompiler.BlameLogger;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.errors.MessageReceiverImpl;
import com.android.build.gradle.internal.errors.MessageReceiverImplKt;
import com.android.build.gradle.internal.res.Aapt2ErrorUtils;
import com.android.build.gradle.internal.tasks.manifest.ManifestHelperKt;
import com.android.build.gradle.options.SyncOptions;
import com.android.builder.internal.aapt.v2.Aapt2Exception;
import com.android.ide.common.blame.MergingLog;
import com.android.ide.common.blame.Message;
import com.android.ide.common.blame.SourceFilePosition;
import com.android.ide.common.blame.SourcePosition;
import com.android.ide.common.blame.parser.PatternAwareOutputParser;
import com.android.ide.common.blame.parser.ToolOutputParser;
import com.android.ide.common.blame.parser.aapt.Aapt2OutputParser;
import com.android.ide.common.resources.CompileResourceRequest;
import com.android.ide.common.resources.RelativeResourceUtils;
import com.android.tools.build.bundletool.model.utils.files.FileUtils;
import com.android.utils.ILogger;
import com.android.utils.StdLogger;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000X\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a.\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\r\u001aR\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\r2\u0014\b\u0002\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u00112\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00150\u0014H\u0002\u001aF\u0010\u0016\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u00182\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0004\u001a\u00020\r\u001a0\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00150\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00150\u001d2\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00150\u0014H\u0002\u00a8\u0006\u001e"}, d2={"blameLoggerFor", "Lcom/android/aaptcompiler/BlameLogger;", "request", "Lcom/android/ide/common/resources/CompileResourceRequest;", "logger", "Lcom/android/build/gradle/internal/LoggerWrapper;", "rewriteCompileException", "Lcom/android/builder/internal/aapt/v2/Aapt2Exception;", "e", "errorFormatMode", "Lcom/android/build/gradle/options/SyncOptions$ErrorFormatMode;", "enableBlame", "", "Lorg/gradle/api/logging/Logger;", "rewriteException", "rewriteFilePositions", "identifiedSourceSetMap", "", "", "blameLookup", "Lkotlin/Function1;", "Lcom/android/ide/common/blame/SourceFilePosition;", "rewriteLinkException", "mergeBlameFolder", "Ljava/io/File;", "manifestMergeBlameFile", "rewritePositions", "Lcom/google/common/collect/ImmutableList;", "sourceFilePositions", "", "gradle-core"})
@JvmName(name="Aapt2ErrorUtils")
public final class Aapt2ErrorUtils {
    @NotNull
    public static final Aapt2Exception rewriteCompileException(@NotNull Aapt2Exception e, @NotNull CompileResourceRequest request2, @NotNull SyncOptions.ErrorFormatMode errorFormatMode, boolean enableBlame, @NotNull org.gradle.api.logging.Logger logger) {
        Intrinsics.checkNotNullParameter((Object)((Object)e), (String)"e");
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        Intrinsics.checkNotNullParameter((Object)((Object)errorFormatMode), (String)"errorFormatMode");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        if (!enableBlame) {
            return Aapt2ErrorUtils.rewriteException$default(e, errorFormatMode, false, logger, null, rewriteCompileException.1.INSTANCE, 16, null);
        }
        if (request2.getBlameMap().isEmpty()) {
            Aapt2Exception aapt2Exception;
            if (request2.getMergeBlameFolder() != null) {
                File file = request2.getMergeBlameFolder();
                Intrinsics.checkNotNull((Object)file);
                MergingLog mergingLog2 = new MergingLog(file);
                return Aapt2ErrorUtils.rewriteException$default(e, errorFormatMode, true, logger, null, (Function1)new Function1<SourceFilePosition, SourceFilePosition>(mergingLog2){
                    final /* synthetic */ MergingLog $mergingLog;
                    {
                        this.$mergingLog = $mergingLog;
                        super(1);
                    }

                    @NotNull
                    public final SourceFilePosition invoke(@NotNull SourceFilePosition it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        SourceFilePosition sourceFilePosition = this.$mergingLog.find(it);
                        Intrinsics.checkNotNullExpressionValue((Object)sourceFilePosition, (String)"mergingLog.find(it)");
                        return sourceFilePosition;
                    }
                }, 16, null);
            }
            if (Intrinsics.areEqual((Object)request2.getInputFile(), (Object)request2.getOriginalInputFile())) {
                aapt2Exception = e;
            } else {
                String string;
                String string2 = "Failed to compile android resource '" + request2.getOriginalInputFile().getAbsolutePath() + "'.";
                Throwable throwable = e;
                String string3 = e.getOutput();
                if (string3 != null) {
                    String string4 = request2.getInputFile().getAbsolutePath();
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"request.inputFile.absolutePath");
                    String string5 = request2.getOriginalInputFile().getAbsolutePath();
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"request.originalInputFile.absolutePath");
                    string = StringsKt.replace$default((String)string3, (String)string4, (String)string5, (boolean)false, (int)4, null);
                } else {
                    string = null;
                }
                aapt2Exception = Aapt2Exception.Companion.create$default((Aapt2Exception.Companion)Aapt2Exception.Companion, null, (String)string2, (Throwable)throwable, string, (String)e.getProcessName(), (String)e.getCommand(), (int)1, null);
            }
            Aapt2Exception originalException = aapt2Exception;
            return Aapt2ErrorUtils.rewriteException$default(originalException, errorFormatMode, false, logger, null, rewriteCompileException.3.INSTANCE, 16, null);
        }
        return Aapt2ErrorUtils.rewriteException$default(e, errorFormatMode, true, logger, null, (Function1)new Function1<SourceFilePosition, SourceFilePosition>(request2){
            final /* synthetic */ CompileResourceRequest $request;
            {
                this.$request = $request;
                super(1);
            }

            @NotNull
            public final SourceFilePosition invoke(@NotNull SourceFilePosition it) {
                SourceFilePosition sourceFilePosition;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                File file = it.getFile().getSourceFile();
                if (Intrinsics.areEqual((Object)(file != null ? file.getAbsolutePath() : null), (Object)this.$request.getOriginalInputFile().getAbsolutePath())) {
                    sourceFilePosition = MergingLog.find((SourcePosition)it.getPosition(), (Map)this.$request.getBlameMap());
                    if (sourceFilePosition == null) {
                        sourceFilePosition = it;
                    }
                } else {
                    sourceFilePosition = it;
                }
                return sourceFilePosition;
            }
        }, 16, null);
    }

    @NotNull
    public static final Aapt2Exception rewriteLinkException(@NotNull Aapt2Exception e, @NotNull SyncOptions.ErrorFormatMode errorFormatMode, @Nullable File mergeBlameFolder, @Nullable File manifestMergeBlameFile, @NotNull Map<String, String> identifiedSourceSetMap, @NotNull org.gradle.api.logging.Logger logger) {
        Intrinsics.checkNotNullParameter((Object)((Object)e), (String)"e");
        Intrinsics.checkNotNullParameter((Object)((Object)errorFormatMode), (String)"errorFormatMode");
        Intrinsics.checkNotNullParameter(identifiedSourceSetMap, (String)"identifiedSourceSetMap");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        if (mergeBlameFolder == null && manifestMergeBlameFile == null) {
            return Aapt2ErrorUtils.rewriteException$default(e, errorFormatMode, false, logger, null, rewriteLinkException.1.INSTANCE, 16, null);
        }
        Ref.ObjectRef mergingLog2 = new Ref.ObjectRef();
        if (mergeBlameFolder != null) {
            mergingLog2.element = new MergingLog(mergeBlameFolder, identifiedSourceSetMap);
        }
        Ref.ObjectRef manifestMergeBlameContents = new Ref.ObjectRef();
        if (manifestMergeBlameFile != null && manifestMergeBlameFile.isFile()) {
            Charset charset = Charsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            manifestMergeBlameContents.element = FilesKt.readLines((File)manifestMergeBlameFile, (Charset)charset);
        }
        return Aapt2ErrorUtils.rewriteException(e, errorFormatMode, true, logger, identifiedSourceSetMap, (Function1<? super SourceFilePosition, SourceFilePosition>)((Function1)new Function1<SourceFilePosition, SourceFilePosition>((Ref.ObjectRef<MergingLog>)mergingLog2, (Ref.ObjectRef<List<String>>)manifestMergeBlameContents){
            final /* synthetic */ Ref.ObjectRef<MergingLog> $mergingLog;
            final /* synthetic */ Ref.ObjectRef<List<String>> $manifestMergeBlameContents;
            {
                this.$mergingLog = $mergingLog;
                this.$manifestMergeBlameContents = $manifestMergeBlameContents;
                super(1);
            }

            @NotNull
            public final SourceFilePosition invoke(@NotNull SourceFilePosition it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                SourceFilePosition newFile = it;
                if (this.$mergingLog.element != null) {
                    SourceFilePosition sourceFilePosition = ((MergingLog)this.$mergingLog.element).find(it);
                    Intrinsics.checkNotNullExpressionValue((Object)sourceFilePosition, (String)"mergingLog.find(it)");
                    newFile = sourceFilePosition;
                }
                if (Intrinsics.areEqual((Object)it, (Object)newFile) && this.$manifestMergeBlameContents.element != null) {
                    newFile = ManifestHelperKt.findOriginalManifestFilePosition((List)this.$manifestMergeBlameContents.element, it);
                }
                return newFile;
            }
        }));
    }

    @NotNull
    public static final BlameLogger blameLoggerFor(@NotNull CompileResourceRequest request2, @NotNull LoggerWrapper logger) {
        Function1 sourcePathFunc2;
        Function1 function1;
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        if (MapsKt.any((Map)request2.getIdentifiedSourceSetMap())) {
            Map map = request2.getIdentifiedSourceSetMap();
            FileSystem fileSystem = FileSystems.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)fileSystem, (String)"getDefault()");
            function1 = RelativeResourceUtils.relativeResourcePathToAbsolutePath((Map)map, (FileSystem)fileSystem);
        } else {
            function1 = sourcePathFunc2 = (Function1)blameLoggerFor.sourcePathFunc.1.INSTANCE;
        }
        if (request2.getBlameMap().isEmpty()) {
            if (request2.getMergeBlameFolder() != null) {
                File file = request2.getMergeBlameFolder();
                Intrinsics.checkNotNull((Object)file);
                MergingLog mergingLog2 = new MergingLog(file);
                return new BlameLogger((ILogger)logger, sourcePathFunc2, (Function1)new Function1<BlameLogger.Source, BlameLogger.Source>(mergingLog2){
                    final /* synthetic */ MergingLog $mergingLog;
                    {
                        this.$mergingLog = $mergingLog;
                        super(1);
                    }

                    @NotNull
                    public final BlameLogger.Source invoke(@NotNull BlameLogger.Source it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        SourceFilePosition sourceFile = it.toSourceFilePosition();
                        SourceFilePosition sourceFilePosition = this.$mergingLog.find(sourceFile);
                        Intrinsics.checkNotNullExpressionValue((Object)sourceFilePosition, (String)"mergingLog.find(sourceFile)");
                        return BlameLogger.Source.Companion.fromSourceFilePosition(sourceFilePosition);
                    }
                });
            }
            return new BlameLogger((ILogger)logger, sourcePathFunc2, null, 4, null);
        }
        return new BlameLogger((ILogger)logger, sourcePathFunc2, (Function1)new Function1<BlameLogger.Source, BlameLogger.Source>(request2){
            final /* synthetic */ CompileResourceRequest $request;
            {
                this.$request = $request;
                super(1);
            }

            @NotNull
            public final BlameLogger.Source invoke(@NotNull BlameLogger.Source it) {
                SourceFilePosition sourceFile;
                SourceFilePosition foundSource;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return Intrinsics.areEqual((Object)FileUtils.getPath((String)it.getSourcePath()).toAbsolutePath(), (Object)this.$request.getOriginalInputFile().toPath().toAbsolutePath()) ? ((foundSource = MergingLog.find((SourcePosition)(sourceFile = it.toSourceFilePosition()).getPosition(), (Map)this.$request.getBlameMap())) == null ? it : BlameLogger.Source.Companion.fromSourceFilePosition(foundSource)) : it;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private static final Aapt2Exception rewriteException(Aapt2Exception e, SyncOptions.ErrorFormatMode errorFormatMode, boolean rewriteFilePositions, org.gradle.api.logging.Logger logger, Map<String, String> identifiedSourceSetMap, Function1<? super SourceFilePosition, SourceFilePosition> blameLookup) {
        try {
            List messages = null;
            ToolOutputParser toolOutputParser = new ToolOutputParser((PatternAwareOutputParser)new Aapt2OutputParser(identifiedSourceSetMap), Message.Kind.SIMPLE, (ILogger)new StdLogger(StdLogger.Level.INFO));
            String string = e.getOutput();
            if (string == null) {
                string = "";
            }
            if ((messages = toolOutputParser.parseToolOutput(string, true)).isEmpty()) {
                String string2 = e.getOutput();
                if (string2 == null) {
                    string2 = "";
                }
                SourceFilePosition sourceFilePosition = SourceFilePosition.UNKNOWN;
                Intrinsics.checkNotNullExpressionValue((Object)sourceFilePosition, (String)"UNKNOWN");
                messages = CollectionsKt.listOf((Object)new Message(Message.Kind.ERROR, string2, "", "AAPT", sourceFilePosition, new SourceFilePosition[0]));
            }
            if (rewriteFilePositions) {
                void $this$mapTo$iv$iv;
                List list = messages;
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"messages");
                Iterable $this$map$iv = list;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void message2;
                    Message message3 = (Message)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)message2, (String)"message");
                    collection.add(Message.copy$default((Message)message2, null, null, (List)((List)Aapt2ErrorUtils.rewritePositions(message2.getSourceFilePositions(), blameLookup)), null, null, (int)27, null));
                }
                messages = (List)destination$iv$iv;
            }
            List list = messages;
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"messages");
            String detailedMessage2 = CollectionsKt.joinToString$default((Iterable)list, (CharSequence)"\n", null, null, (int)0, null, (Function1)rewriteException.detailedMessage.1.INSTANCE, (int)30, null);
            if (errorFormatMode == SyncOptions.ErrorFormatMode.MACHINE_PARSABLE) {
                void $this$forEach$iv;
                void $this$mapTo$iv$iv;
                Object item$iv$iv;
                MessageReceiverImpl $this$rewriteException_u24lambda_u2d2 = new MessageReceiverImpl(errorFormatMode, (Logger)logger);
                boolean bl = false;
                List list2 = messages;
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"messages");
                Iterable $this$map$iv = list2;
                boolean $i$f$map = false;
                item$iv$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
                    void message4;
                    Message message5 = (Message)item$iv$iv2;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)message4, (String)"message");
                    collection.add(Message.copy$default((Message)message4, null, (String)e.getDescription(), null, (String)MessageReceiverImplKt.humanReadableMessage((Message)message4), null, (int)21, null));
                }
                $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Message p0 = (Message)element$iv;
                    boolean bl3 = false;
                    $this$rewriteException_u24lambda_u2d2.receiveMessage(p0);
                }
            }
            return Aapt2Exception.Companion.create$default((Aapt2Exception.Companion)Aapt2Exception.Companion, null, (String)e.getDescription(), (Throwable)e.getCause(), (String)detailedMessage2, (String)e.getProcessName(), (String)e.getCommand(), (int)1, null);
        }
        catch (Exception e2) {
            Aapt2Exception aapt2Exception;
            Aapt2Exception $this$rewriteException_u24lambda_u2d3 = aapt2Exception = e;
            boolean bl = false;
            ExceptionsKt.addSuppressed((Throwable)$this$rewriteException_u24lambda_u2d3, (Throwable)e2);
            return aapt2Exception;
        }
    }

    static /* synthetic */ Aapt2Exception rewriteException$default(Aapt2Exception aapt2Exception, SyncOptions.ErrorFormatMode errorFormatMode, boolean bl, org.gradle.api.logging.Logger logger, Map map, Function1 function1, int n, Object object) {
        if ((n & 0x10) != 0) {
            map = MapsKt.emptyMap();
        }
        return Aapt2ErrorUtils.rewriteException(aapt2Exception, errorFormatMode, bl, logger, map, (Function1<? super SourceFilePosition, SourceFilePosition>)function1);
    }

    private static final ImmutableList<SourceFilePosition> rewritePositions(List<SourceFilePosition> sourceFilePositions, Function1<? super SourceFilePosition, SourceFilePosition> blameLookup) {
        ImmutableList.Builder builder;
        ImmutableList.Builder $this$rewritePositions_u24lambda_u2d5 = builder = ImmutableList.builder();
        boolean bl = false;
        Iterable $this$forEach$iv = sourceFilePositions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SourceFilePosition it = (SourceFilePosition)element$iv;
            boolean bl2 = false;
            $this$rewritePositions_u24lambda_u2d5.add(blameLookup.invoke((Object)it));
        }
        ImmutableList immutableList = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"builder<SourceFilePositi\u2026voke(it)) }\n    }.build()");
        return immutableList;
    }
}

