/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.res.namespaced;

import com.android.build.api.artifact.Artifact;
import com.android.build.api.variant.impl.DirectoryEntries;
import com.android.build.api.variant.impl.DirectoryEntry;
import com.android.build.gradle.internal.component.ApkCreationConfig;
import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.component.TestComponentCreationConfig;
import com.android.build.gradle.internal.res.LinkApplicationAndroidResourcesTask;
import com.android.build.gradle.internal.res.namespaced.CompileRClassTaskCreationAction;
import com.android.build.gradle.internal.res.namespaced.CreateNonNamespacedLibraryManifestTask;
import com.android.build.gradle.internal.res.namespaced.GenerateNamespacedLibraryRFilesTask;
import com.android.build.gradle.internal.res.namespaced.LinkLibraryAndroidResourcesTask;
import com.android.build.gradle.internal.res.namespaced.ProcessAndroidAppResourcesTask;
import com.android.build.gradle.internal.res.namespaced.StaticLibraryManifestTask;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.tasks.factory.TaskFactory;
import com.android.build.gradle.tasks.CompileLibraryResourcesTask;
import com.android.utils.StringHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.Provider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0002J.\u0010\t\u001a\u00020\b2\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0012\u001a\u00020\b2\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bH\u0002J,\u0010\u0013\u001a\u00020\b2\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/android/build/gradle/internal/res/namespaced/NamespacedResourcesTaskManager;", "", "taskFactory", "Lcom/android/build/gradle/internal/tasks/factory/TaskFactory;", "creationConfig", "Lcom/android/build/gradle/internal/component/ComponentCreationConfig;", "(Lcom/android/build/gradle/internal/tasks/factory/TaskFactory;Lcom/android/build/gradle/internal/component/ComponentCreationConfig;)V", "createCompileResourcesTask", "", "createNamespacedAppProcessTask", "packageOutputType", "Lcom/android/build/api/artifact/Artifact$Single;", "Lorg/gradle/api/file/Directory;", "baseName", "Lorg/gradle/api/provider/Provider;", "", "useAaptToGenerateLegacyMultidexMainDexProguardRules", "", "createNamespacedLibraryTestProcessResourcesTask", "createNamespacedResourceTasks", "gradle-core"})
public final class NamespacedResourcesTaskManager {
    @NotNull
    private final TaskFactory taskFactory;
    @NotNull
    private final ComponentCreationConfig creationConfig;

    public NamespacedResourcesTaskManager(@NotNull TaskFactory taskFactory, @NotNull ComponentCreationConfig creationConfig) {
        Intrinsics.checkNotNullParameter((Object)taskFactory, (String)"taskFactory");
        Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
        this.taskFactory = taskFactory;
        this.creationConfig = creationConfig;
    }

    public final void createNamespacedResourceTasks(@Nullable Artifact.Single<Directory> packageOutputType, @NotNull Provider<String> baseName2, boolean useAaptToGenerateLegacyMultidexMainDexProguardRules) {
        Intrinsics.checkNotNullParameter(baseName2, (String)"baseName");
        this.createCompileResourcesTask();
        this.taskFactory.register(new CreateNonNamespacedLibraryManifestTask.CreationAction(this.creationConfig));
        this.taskFactory.register(new StaticLibraryManifestTask.CreationAction(this.creationConfig));
        this.taskFactory.register(new LinkLibraryAndroidResourcesTask.CreationAction(this.creationConfig));
        this.taskFactory.register(new GenerateNamespacedLibraryRFilesTask.CreationAction(this.creationConfig));
        if (this.creationConfig instanceof TestComponentCreationConfig) {
            if (((TestComponentCreationConfig)this.creationConfig).getMainVariant().getComponentType().isAar()) {
                this.createNamespacedLibraryTestProcessResourcesTask(packageOutputType);
            } else {
                this.createNamespacedAppProcessTask(packageOutputType, baseName2, false);
            }
        } else if (this.creationConfig.getComponentType().isApk()) {
            this.createNamespacedAppProcessTask(packageOutputType, baseName2, useAaptToGenerateLegacyMultidexMainDexProguardRules);
        }
        this.taskFactory.register(new CompileRClassTaskCreationAction(this.creationConfig));
    }

    private final void createNamespacedAppProcessTask(Artifact.Single<Directory> packageOutputType, Provider<String> baseName2, boolean useAaptToGenerateLegacyMultidexMainDexProguardRules) {
        ComponentCreationConfig componentCreationConfig = this.creationConfig;
        Intrinsics.checkNotNull((Object)componentCreationConfig, (String)"null cannot be cast to non-null type com.android.build.gradle.internal.component.ApkCreationConfig");
        this.taskFactory.register(new LinkApplicationAndroidResourcesTask.NamespacedCreationAction((ApkCreationConfig)componentCreationConfig, useAaptToGenerateLegacyMultidexMainDexProguardRules, baseName2));
        if (packageOutputType != null) {
            this.creationConfig.getArtifacts().republish(InternalArtifactType.PROCESSED_RES.INSTANCE, packageOutputType);
        }
    }

    private final void createNamespacedLibraryTestProcessResourcesTask(Artifact.Single<Directory> packageOutputType) {
        this.taskFactory.register(new ProcessAndroidAppResourcesTask.CreationAction(this.creationConfig));
        if (packageOutputType != null) {
            this.creationConfig.getArtifacts().republish(InternalArtifactType.PROCESSED_RES.INSTANCE, packageOutputType);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void createCompileResourcesTask() {
        Object object = this.creationConfig.getSources().getRes().getVariantSources().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"creationConfig.sources.r\u2026getVariantSources().get()");
        Iterable $this$forEach$iv = (Iterable)object;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            DirectoryEntry it;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            ConfigurableFileCollection configurableFileCollection;
            DirectoryEntries dimensionSources = (DirectoryEntries)element$iv;
            boolean bl = false;
            ConfigurableFileCollection fileCollection2 = configurableFileCollection = this.creationConfig.getServices().fileCollection();
            boolean bl2 = false;
            Object[] objectArray = new Object[1];
            Iterable iterable = dimensionSources.getDirectoryEntries();
            int n = 0;
            Object[] objectArray2 = objectArray;
            ConfigurableFileCollection configurableFileCollection2 = fileCollection2;
            boolean $i$f$filter = false;
            void var16_16 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (DirectoryEntry)element$iv$iv;
                boolean bl3 = false;
                if (!(!it.isGenerated())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Collection<Provider<? extends Collection<Directory>>> collection = (List)destination$iv$iv;
            $this$filter$iv = collection;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (DirectoryEntry)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl4 = false;
                collection.add(it.asFiles(this.creationConfig.getServices().provider((Function0)new Function0<Directory>(this){
                    final /* synthetic */ NamespacedResourcesTaskManager this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    @Nullable
                    public final Directory invoke() {
                        return NamespacedResourcesTaskManager.access$getCreationConfig$p(this.this$0).getServices().getProjectInfo().getProjectDirectory();
                    }
                })));
            }
            collection = (List)destination$iv$iv;
            objectArray2[n] = collection;
            configurableFileCollection2.from(objectArray);
            ConfigurableFileCollection artifacts2 = configurableFileCollection;
            String sourceSetName = dimensionSources.getName();
            String name = StringHelper.appendCapitalized((String)"compile", (String)sourceSetName) + StringHelper.appendCapitalized((String)"ResourcesFor", (String)this.creationConfig.getName());
            this.taskFactory.register(new CompileLibraryResourcesTask.NamespacedCreationAction(name, (FileCollection)artifacts2, this.creationConfig));
        }
    }

    public static final /* synthetic */ ComponentCreationConfig access$getCreationConfig$p(NamespacedResourcesTaskManager $this) {
        return $this.creationConfig;
    }
}

