/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.attribution;

import com.android.Version;
import com.android.build.gradle.internal.StartParameterUtils;
import com.android.build.gradle.internal.attribution.BuildAttributionService;
import com.android.build.gradle.internal.services.ServiceRegistrationAction;
import com.android.build.gradle.internal.utils.GradlePluginUtils;
import com.android.builder.utils.ExceptionFunction;
import com.android.builder.utils.SynchronizedFile;
import com.android.ide.common.attribution.AndroidGradlePluginAttributionData;
import com.android.tools.analytics.HostData;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.StartParameter;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.execution.TaskExecutionGraph;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;
import org.gradle.build.event.BuildEventsListenerRegistry;
import org.gradle.tooling.events.FinishEvent;
import org.gradle.tooling.events.OperationCompletionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 \u000f2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u00032\u00020\u0004:\u0003\u000f\u0010\u0011B\u0005\u00a2\u0006\u0002\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\f\u001a\u00020\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/android/build/gradle/internal/attribution/BuildAttributionService;", "Lorg/gradle/api/services/BuildService;", "Lcom/android/build/gradle/internal/attribution/BuildAttributionService$Parameters;", "Lorg/gradle/tooling/events/OperationCompletionListener;", "Ljava/lang/AutoCloseable;", "()V", "initialGarbageCollectionData", "", "", "", "close", "", "onFinish", "p0", "Lorg/gradle/tooling/events/FinishEvent;", "Companion", "Parameters", "RegistrationAction", "gradle-core"})
public abstract class BuildAttributionService
implements BuildService<Parameters>,
OperationCompletionListener,
AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, Long> initialGarbageCollectionData;
    private static boolean initialized;

    /*
     * WARNING - void declaration
     */
    public BuildAttributionService() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        List<GarbageCollectorMXBean> list = ManagementFactory.getGarbageCollectorMXBeans();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getGarbageCollectorMXBeans()");
        Iterable iterable = list;
        BuildAttributionService buildAttributionService = this;
        boolean $i$f$map = false;
        void var3_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            GarbageCollectorMXBean garbageCollectorMXBean = (GarbageCollectorMXBean)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)it.getName(), (Object)it.getCollectionTime()));
        }
        buildAttributionService.initialGarbageCollectionData = MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void close() {
        void $this$filterTo$iv$iv;
        Pair it;
        Iterable $this$mapTo$iv$iv;
        initialized = false;
        if (!((Parameters)this.getParameters()).getAttributionFileLocation().isPresent()) {
            return;
        }
        List<GarbageCollectorMXBean> list = ManagementFactory.getGarbageCollectorMXBeans();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getGarbageCollectorMXBeans()");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            GarbageCollectorMXBean garbageCollectorMXBean = (GarbageCollectorMXBean)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getName();
            long l = it.getCollectionTime();
            String string2 = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.name");
            collection.add(TuplesKt.to((Object)string, (Object)(l - ((Number)this.initialGarbageCollectionData.getOrDefault(string2, 0L)).longValue())));
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Pair)element$iv$iv;
            boolean bl = false;
            if (!(((Number)it.getSecond()).longValue() > 0L)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Map gcData = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        File file = new File((String)((Parameters)this.getParameters()).getAttributionFileLocation().get());
        Object object = ((Parameters)this.getParameters()).getTaskNameToClassNameMap().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.taskNameToClassNameMap.get()");
        Map map = (Map)object;
        Object object2 = ((Parameters)this.getParameters()).getTasksSharingOutputs().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"parameters.tasksSharingOutputs.get()");
        Map map2 = (Map)object2;
        ClassLoader classLoader = this.getClass().getClassLoader();
        Intrinsics.checkNotNullExpressionValue((Object)classLoader, (String)"this.javaClass.classLoader");
        Set<String> set = GradlePluginUtils.getBuildSrcPlugins(classLoader);
        Object object3 = ((Parameters)this.getParameters()).getJavaInfo().get();
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"parameters.javaInfo.get()");
        AndroidGradlePluginAttributionData.JavaInfo javaInfo = (AndroidGradlePluginAttributionData.JavaInfo)object3;
        Object object4 = ((Parameters)this.getParameters()).getBuildscriptDependenciesInfo().get();
        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"parameters.buildscriptDependenciesInfo.get()");
        BuildAttributionService.Companion.saveAttributionData(file, new AndroidGradlePluginAttributionData(map, null, map2, gcData, set, javaInfo, (Set)object4, (AndroidGradlePluginAttributionData.BuildInfo)((Parameters)this.getParameters()).getBuildInfo().get(), 2, null));
    }

    public void onFinish(@Nullable FinishEvent p0) {
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0002J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/android/build/gradle/internal/attribution/BuildAttributionService$Companion;", "", "()V", "initialized", "", "getTaskClassName", "", "className", "init", "", "project", "Lorg/gradle/api/Project;", "attributionFileLocation", "parameters", "Lcom/android/build/gradle/internal/attribution/BuildAttributionService$Parameters;", "saveAttributionData", "outputDir", "Ljava/io/File;", "attributionData", "Lcom/android/ide/common/attribution/AndroidGradlePluginAttributionData;", "gradle-core"})
    public static final class Companion {
        private Companion() {
        }

        private final void init(Project project2, String attributionFileLocation, Parameters parameters) {
            if (initialized) {
                return;
            }
            initialized = true;
            project2.getGradle().getTaskGraph().whenReady(new Action(project2, parameters, attributionFileLocation){
                final /* synthetic */ Project $project;
                final /* synthetic */ Parameters $parameters;
                final /* synthetic */ String $attributionFileLocation;
                {
                    this.$project = $project;
                    this.$parameters = $parameters;
                    this.$attributionFileLocation = $attributionFileLocation;
                }

                /*
                 * WARNING - void declaration
                 */
                public final void execute(TaskExecutionGraph taskGraph) {
                    String string;
                    String string2;
                    void $this$filterTo$iv$iv;
                    void $this$filter$iv;
                    Map.Entry<K, V> it;
                    MapProperty<String, List<String>> mapProperty;
                    void $this$mapTo$iv$iv;
                    Map $this$map$iv;
                    Object object;
                    Iterator<Map.Entry<K, V>> iterator2;
                    T element$iv2;
                    Map outputFileToTasksMap = new LinkedHashMap<K, V>();
                    Map taskNameToClassNameMap = new LinkedHashMap<K, V>();
                    Map taskNameToTaskCategoryMap = new LinkedHashMap<K, V>();
                    List list = taskGraph.getAllTasks();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"taskGraph.allTasks");
                    Iterable $this$forEach$iv = list;
                    boolean $i$f$forEach22 = false;
                    for (T element$iv2 : $this$forEach$iv) {
                        String string3;
                        Task task = (Task)element$iv2;
                        boolean bl = false;
                        iterator2 = taskNameToClassNameMap;
                        Intrinsics.checkNotNullExpressionValue((Object)task.getName(), (String)"task.name");
                        String string4 = task.getClass().getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"task.javaClass.name");
                        object = com.android.build.gradle.internal.attribution.BuildAttributionService$Companion.access$getTaskClassName(BuildAttributionService.Companion, string4);
                        iterator2.put(string3, object);
                        FileCollection fileCollection2 = task.getOutputs().getFiles();
                        Intrinsics.checkNotNullExpressionValue((Object)fileCollection2, (String)"task.outputs.files");
                        Iterable $this$forEach$iv2 = (Iterable)fileCollection2;
                        boolean $i$f$forEach = false;
                        for (E element$iv3 : $this$forEach$iv2) {
                            File outputFile = (File)element$iv3;
                            boolean bl2 = false;
                            List list2 = (List)outputFileToTasksMap.computeIfAbsent(outputFile.getAbsolutePath(), (Function)init.1.1.1.INSTANCE);
                            String string5 = task.getPath();
                            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"task.path");
                            list2.add(string5);
                        }
                    }
                    Project project2 = this.$project.getRootProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project.rootProject");
                    Iterable $i$f$forEach22 = GradlePluginUtils.getBuildscriptDependencies(project2);
                    boolean $i$f$map = false;
                    element$iv2 = $this$map$iv;
                    Object destination$iv$iv = (MapProperty<String, List<String>>)new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)$this$map$iv), (int)10));
                    boolean $i$f$mapTo = false;
                    for (E item$iv$iv : $this$mapTo$iv$iv) {
                        object = (ModuleComponentIdentifier)item$iv$iv;
                        mapProperty = destination$iv$iv;
                        boolean bl = false;
                        mapProperty.add(it.getGroup() + ":" + it.getModule() + ":" + it.getVersion());
                    }
                    List buildscriptDependenciesInfo = (List)destination$iv$iv;
                    this.$parameters.getAttributionFileLocation().set((Object)this.$attributionFileLocation);
                    this.$parameters.getTaskNameToClassNameMap().set(taskNameToClassNameMap);
                    $this$map$iv = outputFileToTasksMap;
                    mapProperty = this.$parameters.getTasksSharingOutputs();
                    boolean $i$f$filter = false;
                    $this$mapTo$iv$iv = $this$filter$iv;
                    destination$iv$iv = new LinkedHashMap<K, V>();
                    boolean $i$f$filterTo = false;
                    iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
                    while (iterator2.hasNext()) {
                        Map.Entry<K, V> element$iv$iv;
                        it = element$iv$iv = iterator2.next();
                        boolean bl = false;
                        if (!(((List)it.getValue()).size() > 1)) continue;
                        destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
                    }
                    mapProperty.set(destination$iv$iv);
                    Property<AndroidGradlePluginAttributionData.JavaInfo> property = this.$parameters.getJavaInfo();
                    String string6 = System.getProperty("java.version");
                    if (string6 == null) {
                        string6 = "";
                    }
                    if ((string2 = System.getProperty("java.vendor")) == null) {
                        string2 = "";
                    }
                    if ((string = System.getProperty("java.home")) == null) {
                        string = "";
                    }
                    RuntimeMXBean runtimeMXBean = HostData.getRuntimeBean();
                    List<E> list3 = runtimeMXBean != null ? runtimeMXBean.getInputArguments() : null;
                    if (list3 == null) {
                        list3 = CollectionsKt.emptyList();
                    }
                    property.set((Object)new AndroidGradlePluginAttributionData.JavaInfo(string6, string2, string, list3));
                    this.$parameters.getBuildscriptDependenciesInfo().set((Iterable)buildscriptDependenciesInfo);
                    Property<AndroidGradlePluginAttributionData.BuildInfo> property2 = this.$parameters.getBuildInfo();
                    StartParameter startParameter = this.$project.getGradle().getStartParameter();
                    Intrinsics.checkNotNullExpressionValue((Object)startParameter, (String)"project.gradle.startParameter");
                    property2.set((Object)new AndroidGradlePluginAttributionData.BuildInfo(Version.ANDROID_GRADLE_PLUGIN_VERSION, StartParameterUtils.isConfigurationCache(startParameter)));
                }
            });
        }

        private final void saveAttributionData(File outputDir, AndroidGradlePluginAttributionData attributionData) {
            File file = AndroidGradlePluginAttributionData.Companion.getAttributionFile(outputDir);
            file.getParentFile().mkdirs();
            SynchronizedFile.getInstanceWithMultiProcessLocking((File)file).write(new ExceptionFunction(file, attributionData){
                final /* synthetic */ File $file;
                final /* synthetic */ AndroidGradlePluginAttributionData $attributionData;
                {
                    this.$file = $file;
                    this.$attributionData = $attributionData;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void accept(File it) {
                    Closeable closeable = new BufferedWriter(new FileWriter(this.$file));
                    AndroidGradlePluginAttributionData androidGradlePluginAttributionData = this.$attributionData;
                    Throwable throwable = null;
                    try {
                        BufferedWriter it2 = (BufferedWriter)closeable;
                        boolean bl = false;
                        it2.write(AndroidGradlePluginAttributionData.AttributionDataAdapter.INSTANCE.toJson((Object)androidGradlePluginAttributionData));
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                }
            });
        }

        private final String getTaskClassName(String className) {
            if (StringsKt.endsWith$default((String)className, (String)"_Decorated", (boolean)false, (int)2, null)) {
                String string = className.substring(0, className.length() - "_Decorated".length());
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                return string;
            }
            return className;
        }

        public static final /* synthetic */ String access$getTaskClassName(Companion $this, String className) {
            return $this.getTaskClassName(className);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001R\u0018\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0018\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0006R\u0018\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0018\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0006R\u001e\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0012X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R$\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00160\u0012X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0014\u00a8\u0006\u0018\u00c0\u0006\u0003"}, d2={"Lcom/android/build/gradle/internal/attribution/BuildAttributionService$Parameters;", "Lorg/gradle/api/services/BuildServiceParameters;", "attributionFileLocation", "Lorg/gradle/api/provider/Property;", "", "getAttributionFileLocation", "()Lorg/gradle/api/provider/Property;", "buildInfo", "Lcom/android/ide/common/attribution/AndroidGradlePluginAttributionData$BuildInfo;", "getBuildInfo", "buildscriptDependenciesInfo", "Lorg/gradle/api/provider/SetProperty;", "getBuildscriptDependenciesInfo", "()Lorg/gradle/api/provider/SetProperty;", "javaInfo", "Lcom/android/ide/common/attribution/AndroidGradlePluginAttributionData$JavaInfo;", "getJavaInfo", "taskNameToClassNameMap", "Lorg/gradle/api/provider/MapProperty;", "getTaskNameToClassNameMap", "()Lorg/gradle/api/provider/MapProperty;", "tasksSharingOutputs", "", "getTasksSharingOutputs", "gradle-core"})
    public static interface Parameters
    extends BuildServiceParameters {
        @NotNull
        public Property<String> getAttributionFileLocation();

        @NotNull
        public MapProperty<String, List<String>> getTasksSharingOutputs();

        @NotNull
        public MapProperty<String, String> getTaskNameToClassNameMap();

        @NotNull
        public Property<AndroidGradlePluginAttributionData.JavaInfo> getJavaInfo();

        @NotNull
        public SetProperty<String> getBuildscriptDependenciesInfo();

        @NotNull
        public Property<AndroidGradlePluginAttributionData.BuildInfo> getBuildInfo();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0003H\u0016J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u000fH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/android/build/gradle/internal/attribution/BuildAttributionService$RegistrationAction;", "Lcom/android/build/gradle/internal/services/ServiceRegistrationAction;", "Lcom/android/build/gradle/internal/attribution/BuildAttributionService;", "Lcom/android/build/gradle/internal/attribution/BuildAttributionService$Parameters;", "project", "Lorg/gradle/api/Project;", "attributionFileLocation", "", "listenersRegistry", "Lorg/gradle/build/event/BuildEventsListenerRegistry;", "(Lorg/gradle/api/Project;Ljava/lang/String;Lorg/gradle/build/event/BuildEventsListenerRegistry;)V", "configure", "", "parameters", "execute", "Lorg/gradle/api/provider/Provider;", "gradle-core"})
    public static final class RegistrationAction
    extends ServiceRegistrationAction<BuildAttributionService, Parameters> {
        @NotNull
        private final String attributionFileLocation;
        @NotNull
        private final BuildEventsListenerRegistry listenersRegistry;

        public RegistrationAction(@NotNull Project project2, @NotNull String attributionFileLocation, @NotNull BuildEventsListenerRegistry listenersRegistry) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)attributionFileLocation, (String)"attributionFileLocation");
            Intrinsics.checkNotNullParameter((Object)listenersRegistry, (String)"listenersRegistry");
            super(project2, BuildAttributionService.class, null, null, 12, null);
            this.attributionFileLocation = attributionFileLocation;
            this.listenersRegistry = listenersRegistry;
        }

        @Override
        public void configure(@NotNull Parameters parameters) {
            Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
            Companion.init(this.getProject(), this.attributionFileLocation, parameters);
        }

        @Override
        @NotNull
        public Provider<BuildAttributionService> execute() {
            Provider provider2;
            Provider it = provider2 = super.execute();
            boolean bl = false;
            this.listenersRegistry.onTaskCompletion(it);
            return provider2;
        }
    }
}

