/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.lint;

import com.android.build.api.artifact.impl.ArtifactsImpl;
import com.android.build.api.dsl.Lint;
import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.lint.AndroidLintWorkAction;
import com.android.build.gradle.internal.lint.LintMode;
import com.android.build.gradle.internal.lint.LintTaskManager;
import com.android.build.gradle.internal.profile.AnalyticsService;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.services.BuildServicesKt;
import com.android.build.gradle.internal.services.TaskCreationServices;
import com.android.build.gradle.internal.tasks.BuildAnalyzer;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.TaskCategory;
import com.android.build.gradle.internal.tasks.factory.TaskFactoryUtils;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.utils.HasConfigurableValuesKt;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Task;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.services.BuildServiceRegistry;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.work.DisableCachingByDefault;
import org.jetbrains.annotations.NotNull;

@DisableCachingByDefault
@BuildAnalyzer(primaryTaskCategory=TaskCategory.LINT)
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b'\u0018\u0000 %2\u00020\u0001:\u0005%&'()B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J/\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\b\b\u0002\u0010\n\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b!J\b\u0010\"\u001a\u00020\u001aH\u0014J%\u0010#\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\n\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b$R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0007R\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0007R\u0014\u0010\u000f\u001a\u00020\u00108gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00108gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012\u00a8\u0006*"}, d2={"Lcom/android/build/gradle/internal/lint/AndroidLintTextOutputTask;", "Lcom/android/build/gradle/internal/tasks/NonIncrementalTask;", "()V", "abortOnError", "Lorg/gradle/api/provider/Property;", "", "getAbortOnError", "()Lorg/gradle/api/provider/Property;", "android", "getAndroid", "fatalOnly", "getFatalOnly", "outputStream", "Lcom/android/build/gradle/internal/lint/AndroidLintTextOutputTask$OutputStream;", "getOutputStream", "returnValueInputFile", "Lorg/gradle/api/file/RegularFileProperty;", "getReturnValueInputFile", "()Lorg/gradle/api/file/RegularFileProperty;", "textReportInputFile", "getTextReportInputFile", "abbreviateLintTextFile", "", "file", "Ljava/io/File;", "configureForStandalone", "", "taskCreationServices", "Lcom/android/build/gradle/internal/services/TaskCreationServices;", "artifacts", "Lcom/android/build/api/artifact/impl/ArtifactsImpl;", "lintOptions", "Lcom/android/build/api/dsl/Lint;", "configureForStandalone$gradle_core", "doTaskAction", "initializeCommonInputs", "initializeCommonInputs$gradle_core", "Companion", "LintVitalCreationAction", "OutputStream", "SingleVariantCreationAction", "VariantCreationAction", "gradle-core"})
public abstract class AndroidLintTextOutputTask
extends NonIncrementalTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final List<Integer> HANDLED_ERRORS;

    @InputFile
    @PathSensitive(value=PathSensitivity.NONE)
    @NotNull
    public abstract RegularFileProperty getTextReportInputFile();

    @InputFile
    @PathSensitive(value=PathSensitivity.NONE)
    @NotNull
    public abstract RegularFileProperty getReturnValueInputFile();

    @Input
    @NotNull
    public abstract Property<OutputStream> getOutputStream();

    @Input
    @NotNull
    public abstract Property<Boolean> getFatalOnly();

    @Input
    @NotNull
    public abstract Property<Boolean> getAndroid();

    @Input
    @NotNull
    public abstract Property<Boolean> getAbortOnError();

    @Override
    protected void doTaskAction() {
        if (this.getOutputStream().get() != OutputStream.ABBREVIATED) {
            File textReportFile = ((RegularFile)this.getTextReportInputFile().get()).getAsFile();
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)textReportFile, (String)"textReportFile");
            String text = FilesKt.readText$default((File)textReportFile, null, (int)1, null);
            if (!StringsKt.startsWith$default((String)text, (String)"No issues found", (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)text, (CharSequence)"0 errors, 0 warnings", (boolean)false, (int)2, null)) {
                OutputStream outputStream = (OutputStream)((Object)this.getOutputStream().get());
                switch (outputStream == null ? -1 : WhenMappings.$EnumSwitchMapping$0[outputStream.ordinal()]) {
                    case 1: {
                        this.getLogger().lifecycle(text);
                        break;
                    }
                    case 2: {
                        this.getLogger().error(text);
                    }
                }
            }
        }
        File returnValueFile = ((RegularFile)this.getReturnValueInputFile().get()).getAsFile();
        boolean bl = false;
        if (!returnValueFile.isFile()) {
            throw new RuntimeException("Missing lint invocation return value file.");
        }
        Intrinsics.checkNotNullExpressionValue((Object)returnValueFile, (String)"returnValueFile");
        int returnValue = Integer.parseInt(FilesKt.readText$default((File)returnValueFile, null, (int)1, null));
        if (HANDLED_ERRORS.contains(returnValue)) {
            File file = ((RegularFile)this.getTextReportInputFile().get()).getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"textReportInputFile.get().asFile");
            String abbreviatedLintOutput = this.abbreviateLintTextFile(file);
            if (this.getOutputStream().get() == OutputStream.ABBREVIATED) {
                this.getLogger().lifecycle(abbreviatedLintOutput);
            }
            if (returnValue == 1 && !((Boolean)this.getAbortOnError().get()).booleanValue()) {
                return;
            }
            Object object = this.getAndroid().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"android.get()");
            boolean bl2 = (Boolean)object;
            Object object2 = this.getFatalOnly().get();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"fatalOnly.get()");
            AndroidLintWorkAction.Companion.maybeThrowException(returnValue, bl2, (Boolean)object2, LintMode.REPORTING, abbreviatedLintOutput);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final String abbreviateLintTextFile(File file) {
        int n;
        StringBuilder $this$abbreviateLintTextFile_u24lambda_u2d4;
        StringBuilder stringBuilder;
        List lines;
        block6: {
            Object element$iv;
            StringBuilder stringBuilder2;
            block5: {
                void $this$last$iv;
                lines = FilesKt.readLines$default((File)file, null, (int)1, null);
                if (((Collection)lines).size() < 25) {
                    return CollectionsKt.joinToString$default((Iterable)lines, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
                }
                $this$abbreviateLintTextFile_u24lambda_u2d4 = stringBuilder = new StringBuilder();
                boolean bl = false;
                $this$abbreviateLintTextFile_u24lambda_u2d4.append("Lint found ");
                List list = lines;
                stringBuilder2 = $this$abbreviateLintTextFile_u24lambda_u2d4;
                boolean $i$f$last = false;
                ListIterator iterator$iv = $this$last$iv.listIterator($this$last$iv.size());
                while (iterator$iv.hasPrevious()) {
                    element$iv = iterator$iv.previous();
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    boolean bl3 = ((CharSequence)it).length() > 0;
                    if (!bl3) continue;
                    break block5;
                }
                throw new NoSuchElementException("List contains no element matching the predicate.");
            }
            stringBuilder2.append((String)element$iv);
            $this$abbreviateLintTextFile_u24lambda_u2d4.append(". First failure:\n\n");
            List $this$indexOfFirst$iv = lines;
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            for (Object item$iv : $this$indexOfFirst$iv) {
                String it = (String)item$iv;
                boolean bl = false;
                if (!StringsKt.startsWith$default((String)it, (String)" ", (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)it, (CharSequence)"Error: ", (boolean)false, (int)2, null)) {
                    n = index$iv;
                    break block6;
                }
                ++index$iv;
            }
            n = -1;
        }
        int firstError = n;
        int line = Math.max(0, firstError);
        do {
            $this$abbreviateLintTextFile_u24lambda_u2d4.append((String)lines.get(line)).append("\n");
        } while (StringsKt.startsWith$default((String)((String)lines.get(++line)), (String)" ", (boolean)false, (int)2, null) || !(((CharSequence)lines.get(line)).length() > 0));
        $this$abbreviateLintTextFile_u24lambda_u2d4.append("\nThe full lint text report is located at:\n  ");
        $this$abbreviateLintTextFile_u24lambda_u2d4.append(file.getAbsolutePath());
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply {\n\u2026ath)\n        }.toString()");
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void initializeCommonInputs$gradle_core(@NotNull ArtifactsImpl artifacts2, @NotNull Lint lintOptions2, boolean fatalOnly) {
        File textOutput;
        block6: {
            block5: {
                Intrinsics.checkNotNullParameter((Object)artifacts2, (String)"artifacts");
                Intrinsics.checkNotNullParameter((Object)lintOptions2, (String)"lintOptions");
                HasConfigurableValuesKt.setDisallowChanges((Property)this.getTextReportInputFile(), artifacts2.get(fatalOnly ? (InternalArtifactType)InternalArtifactType.LINT_VITAL_INTERMEDIATE_TEXT_REPORT.INSTANCE : (InternalArtifactType)InternalArtifactType.LINT_INTERMEDIATE_TEXT_REPORT.INSTANCE));
                HasConfigurableValuesKt.setDisallowChanges((Property)this.getReturnValueInputFile(), artifacts2.get(fatalOnly ? (InternalArtifactType)InternalArtifactType.LINT_VITAL_RETURN_VALUE.INSTANCE : (InternalArtifactType)InternalArtifactType.LINT_RETURN_VALUE.INSTANCE));
                HasConfigurableValuesKt.setDisallowChanges(this.getFatalOnly(), fatalOnly);
                HasConfigurableValuesKt.setDisallowChanges(this.getAbortOnError(), lintOptions2.getAbortOnError());
                textOutput = lintOptions2.getTextOutput();
                if (fatalOnly) break block5;
                if (!lintOptions2.getTextReport()) break block6;
                File file = textOutput;
                boolean bl = file != null ? LintTaskManager.Companion.isLintStderr$gradle_core(file) : false;
                if (!bl) break block6;
            }
            HasConfigurableValuesKt.setDisallowChanges(this.getOutputStream(), OutputStream.STDERR);
            return;
        }
        if (lintOptions2.getTextReport()) {
            File file = textOutput;
            if (file != null ? LintTaskManager.Companion.isLintStdout$gradle_core(file) : true) {
                HasConfigurableValuesKt.setDisallowChanges(this.getOutputStream(), OutputStream.STDOUT);
                return;
            }
        }
        HasConfigurableValuesKt.setDisallowChanges(this.getOutputStream(), OutputStream.ABBREVIATED);
    }

    public final void configureForStandalone$gradle_core(@NotNull TaskCreationServices taskCreationServices, @NotNull ArtifactsImpl artifacts2, @NotNull Lint lintOptions2, boolean fatalOnly) {
        Intrinsics.checkNotNullParameter((Object)taskCreationServices, (String)"taskCreationServices");
        Intrinsics.checkNotNullParameter((Object)artifacts2, (String)"artifacts");
        Intrinsics.checkNotNullParameter((Object)lintOptions2, (String)"lintOptions");
        BuildServiceRegistry buildServiceRegistry$iv = taskCreationServices.getBuildServiceRegistry();
        boolean $i$f$getBuildService = false;
        HasConfigurableValuesKt.setDisallowChanges(this.getAnalyticsService(), BuildServicesKt.getBuildService(buildServiceRegistry$iv, AnalyticsService.class));
        this.setGroup("verification");
        this.setDescription("Print text output from the corresponding lint report task");
        HasConfigurableValuesKt.setDisallowChanges(this.getAndroid(), false);
        this.setVariantName("");
        this.initializeCommonInputs$gradle_core(artifacts2, lintOptions2, fatalOnly);
    }

    public static /* synthetic */ void configureForStandalone$gradle_core$default(AndroidLintTextOutputTask androidLintTextOutputTask, TaskCreationServices taskCreationServices, ArtifactsImpl artifactsImpl, Lint lint2, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: configureForStandalone");
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        androidLintTextOutputTask.configureForStandalone$gradle_core(taskCreationServices, artifactsImpl, lint2, bl);
    }

    static {
        Object[] objectArray = new Integer[]{1, 6};
        HANDLED_ERRORS = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/android/build/gradle/internal/lint/AndroidLintTextOutputTask$SingleVariantCreationAction;", "Lcom/android/build/gradle/internal/lint/AndroidLintTextOutputTask$VariantCreationAction;", "creationConfig", "Lcom/android/build/gradle/internal/component/ComponentCreationConfig;", "(Lcom/android/build/gradle/internal/component/ComponentCreationConfig;)V", "fatalOnly", "", "getFatalOnly", "()Z", "name", "", "getName", "()Ljava/lang/String;", "gradle-core"})
    public static final class SingleVariantCreationAction
    extends VariantCreationAction {
        @NotNull
        private final String name;
        private final boolean fatalOnly;

        public SingleVariantCreationAction(@NotNull ComponentCreationConfig creationConfig) {
            Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
            super(creationConfig);
            this.name = VariantTaskCreationAction.computeTaskName$default(this, "lint", null, 2, null);
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        public boolean getFatalOnly() {
            return this.fatalOnly;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0012"}, d2={"Lcom/android/build/gradle/internal/lint/AndroidLintTextOutputTask$LintVitalCreationAction;", "Lcom/android/build/gradle/internal/lint/AndroidLintTextOutputTask$VariantCreationAction;", "variant", "Lcom/android/build/gradle/internal/component/ComponentCreationConfig;", "(Lcom/android/build/gradle/internal/component/ComponentCreationConfig;)V", "fatalOnly", "", "getFatalOnly", "()Z", "name", "", "getName", "()Ljava/lang/String;", "handleProvider", "", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "Lcom/android/build/gradle/internal/lint/AndroidLintTextOutputTask;", "gradle-core"})
    public static final class LintVitalCreationAction
    extends VariantCreationAction {
        @NotNull
        private final String name;
        private final boolean fatalOnly;

        public LintVitalCreationAction(@NotNull ComponentCreationConfig variant2) {
            Intrinsics.checkNotNullParameter((Object)variant2, (String)"variant");
            super(variant2);
            this.name = VariantTaskCreationAction.computeTaskName$default(this, "lintVital", null, 2, null);
            this.fatalOnly = true;
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        public boolean getFatalOnly() {
            return this.fatalOnly;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<AndroidLintTextOutputTask> taskProvider) {
            Intrinsics.checkNotNullParameter(taskProvider, (String)"taskProvider");
            TaskProvider[] taskProviderArray = new TaskProvider[]{taskProvider};
            TaskFactoryUtils.dependsOn(this.creationConfig.getTaskContainer().getAssembleTask(), taskProviderArray);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0011"}, d2={"Lcom/android/build/gradle/internal/lint/AndroidLintTextOutputTask$VariantCreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/internal/lint/AndroidLintTextOutputTask;", "Lcom/android/build/gradle/internal/component/ComponentCreationConfig;", "variant", "(Lcom/android/build/gradle/internal/component/ComponentCreationConfig;)V", "fatalOnly", "", "getFatalOnly", "()Z", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "gradle-core"})
    public static abstract class VariantCreationAction
    extends VariantTaskCreationAction<AndroidLintTextOutputTask, ComponentCreationConfig> {
        public VariantCreationAction(@NotNull ComponentCreationConfig variant2) {
            Intrinsics.checkNotNullParameter((Object)variant2, (String)"variant");
            super(variant2);
        }

        @Override
        @NotNull
        public Class<AndroidLintTextOutputTask> getType() {
            return AndroidLintTextOutputTask.class;
        }

        public abstract boolean getFatalOnly();

        @Override
        public void configure(@NotNull AndroidLintTextOutputTask task) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            super.configure((Task)task);
            task.setGroup("verification");
            task.setDescription("Print text output from the corresponding lint report task");
            HasConfigurableValuesKt.setDisallowChanges(task.getAndroid(), true);
            task.initializeCommonInputs$gradle_core(this.creationConfig.getArtifacts(), this.creationConfig.getGlobal().getLintOptions(), this.getFatalOnly());
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/android/build/gradle/internal/lint/AndroidLintTextOutputTask$OutputStream;", "", "(Ljava/lang/String;I)V", "STDOUT", "STDERR", "ABBREVIATED", "gradle-core"})
    public static final class OutputStream
    extends Enum<OutputStream> {
        public static final /* enum */ OutputStream STDOUT = new OutputStream();
        public static final /* enum */ OutputStream STDERR = new OutputStream();
        public static final /* enum */ OutputStream ABBREVIATED = new OutputStream();
        private static final /* synthetic */ OutputStream[] $VALUES;

        public static OutputStream[] values() {
            return (OutputStream[])$VALUES.clone();
        }

        public static OutputStream valueOf(String value) {
            return Enum.valueOf(OutputStream.class, value);
        }

        static {
            $VALUES = outputStreamArray = new OutputStream[]{OutputStream.STDOUT, OutputStream.STDERR, OutputStream.ABBREVIATED};
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/android/build/gradle/internal/lint/AndroidLintTextOutputTask$Companion;", "", "()V", "HANDLED_ERRORS", "", "", "getHANDLED_ERRORS", "()Ljava/util/List;", "gradle-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<Integer> getHANDLED_ERRORS() {
            return HANDLED_ERRORS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[OutputStream.values().length];
            nArray[OutputStream.STDOUT.ordinal()] = 1;
            nArray[OutputStream.STDERR.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

