/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.pipeline;

import com.android.build.api.transform.DirectoryInput;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.Status;
import com.android.build.gradle.internal.pipeline.ImmutableDirectoryInput;
import com.android.build.gradle.internal.pipeline.QualifiedContentImpl;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Set;

class MutableDirectoryInput
extends QualifiedContentImpl {
    private final Map<File, Status> changedFiles = Maps.newHashMap();
    private List<String> rootLocationSegments = null;

    MutableDirectoryInput(String name, File file, Set<QualifiedContent.ContentType> contentTypes, Set<? super QualifiedContent.Scope> scopes2) {
        super(name, file, contentTypes, scopes2);
    }

    DirectoryInput asImmutable() {
        return new ImmutableDirectoryInput(this.getName(), this.getFile(), this.getContentTypes(), this.getScopes(), this.changedFiles);
    }

    boolean processForChangedFile(File file, List<String> fileSegments, Status status) {
        if (this.rootLocationSegments == null) {
            this.rootLocationSegments = Lists.newArrayList((Iterable)Splitter.on((char)File.separatorChar).split((CharSequence)this.getFile().getAbsolutePath()));
        }
        if (fileSegments.size() <= this.rootLocationSegments.size()) {
            return false;
        }
        for (int i = this.rootLocationSegments.size() - 1; i >= 0; --i) {
            if (this.rootLocationSegments.get(i).equals(fileSegments.get(i))) continue;
            return false;
        }
        this.addChangedFile(file, status);
        return true;
    }

    void addChangedFile(File file, Status status) {
        this.changedFiles.put(file, status);
    }
}

