/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.api.variant.impl.BuiltArtifactImpl;
import com.android.build.api.variant.impl.BuiltArtifactsImpl;
import com.android.build.api.variant.impl.BuiltArtifactsLoaderImpl;
import com.android.build.gradle.internal.component.ApkCreationConfig;
import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.process.GradleProcessExecutor;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.services.Aapt2Daemon;
import com.android.build.gradle.internal.services.Aapt2Input;
import com.android.build.gradle.internal.tasks.BuildAnalyzer;
import com.android.build.gradle.internal.tasks.GenerateApkDataTask;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.TaskCategory;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.utils.HasConfigurableValuesKt;
import com.android.builder.core.ApkInfoParser;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessExecutor;
import com.android.utils.FileUtils;
import com.google.common.base.Charsets;
import com.google.common.collect.Iterables;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.process.ExecOperations;
import org.gradle.process.ExecResult;
import org.gradle.process.ExecSpec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@CacheableTask
@BuildAnalyzer(primaryTaskCategory=TaskCategory.APK_PACKAGING, secondaryTaskCategories={TaskCategory.VERIFICATION, TaskCategory.SOURCE_GENERATION})
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b'\u0018\u00002\u00020\u0001:\u0001-B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010$\u001a\u00020%H\u0014J(\u0010&\u001a\u00020%2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020(2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010*\u001a\u00020(H\u0002J \u0010+\u001a\u00020%2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020\u001c2\u0006\u0010\u0017\u001a\u00020(H\u0002J\u0018\u0010,\u001a\u00020%2\u0006\u0010)\u001a\u00020(2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00108gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u00108gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0013R\u0014\u0010\u0017\u001a\u00020\u00188gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00108gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0013R\u0014\u0010\u001e\u001a\u00020\u001f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u001a\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00108gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u0013\u00a8\u0006."}, d2={"Lcom/android/build/gradle/internal/tasks/GenerateApkDataTask;", "Lcom/android/build/gradle/internal/tasks/NonIncrementalTask;", "()V", "aapt2", "Lcom/android/build/gradle/internal/services/Aapt2Input;", "getAapt2", "()Lcom/android/build/gradle/internal/services/Aapt2Input;", "apkFileCollection", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getApkFileCollection", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "execOperations", "Lorg/gradle/process/ExecOperations;", "getExecOperations", "()Lorg/gradle/process/ExecOperations;", "hasDependency", "Lorg/gradle/api/provider/Property;", "", "getHasDependency", "()Lorg/gradle/api/provider/Property;", "mainPkgName", "", "getMainPkgName", "manifestFile", "Lorg/gradle/api/file/RegularFileProperty;", "getManifestFile", "()Lorg/gradle/api/file/RegularFileProperty;", "minSdkVersion", "", "getMinSdkVersion", "resOutputDir", "Lorg/gradle/api/file/DirectoryProperty;", "getResOutputDir", "()Lorg/gradle/api/file/DirectoryProperty;", "targetSdkVersion", "getTargetSdkVersion", "doTaskAction", "", "generateApkData", "apkFile", "Ljava/io/File;", "outResFolder", "aapt2Executable", "generateApkDataEntryInManifest", "generateUnbundledWearApkData", "CreationAction", "gradle-core"})
public abstract class GenerateApkDataTask
extends NonIncrementalTask {
    @Input
    @NotNull
    public abstract Property<Boolean> getHasDependency();

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @Optional
    @NotNull
    public abstract ConfigurableFileCollection getApkFileCollection();

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getResOutputDir();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getManifestFile();

    @Input
    @NotNull
    public abstract Property<Integer> getMinSdkVersion();

    @Input
    @NotNull
    public abstract Property<Integer> getTargetSdkVersion();

    @Nested
    @NotNull
    public abstract Aapt2Input getAapt2();

    @Input
    @NotNull
    public abstract Property<String> getMainPkgName();

    @Inject
    @NotNull
    public abstract ExecOperations getExecOperations();

    /*
     * WARNING - void declaration
     */
    @Override
    protected void doTaskAction() {
        File outDir = ((Directory)this.getResOutputDir().get()).getAsFile();
        File apkDirectory = null;
        Object object = this.getHasDependency().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"hasDependency.get()");
        if (((Boolean)object).booleanValue()) {
            Set files2 = this.getApkFileCollection().getFiles();
            if (files2.isEmpty()) {
                return;
            }
            if (!(files2.size() <= 1)) {
                boolean $i$a$-check-GenerateApkDataTask$doTaskAction$62 = false;
                String $i$a$-check-GenerateApkDataTask$doTaskAction$62 = "Wear App dependency resolve to more than one file: " + files2;
                throw new IllegalStateException($i$a$-check-GenerateApkDataTask$doTaskAction$62.toString());
            }
            File file = apkDirectory = (File)Iterables.getOnlyElement((Iterable)files2);
            Intrinsics.checkNotNull((Object)file);
            if (!file.isDirectory()) {
                boolean $i$a$-check-GenerateApkDataTask$doTaskAction$72 = false;
                String $i$a$-check-GenerateApkDataTask$doTaskAction$72 = "Wear App dependency does not resolve to a directory: " + files2;
                throw new IllegalStateException($i$a$-check-GenerateApkDataTask$doTaskAction$72.toString());
            }
        }
        if (apkDirectory != null) {
            BuiltArtifactsImpl apks = BuiltArtifactsLoaderImpl.Companion.loadFromDirectory(apkDirectory);
            if (!(apks != null)) {
                boolean $i$a$-check-GenerateApkDataTask$doTaskAction$82 = false;
                String $i$a$-check-GenerateApkDataTask$doTaskAction$82 = "Wear App dependency resolve to zero APK";
                throw new IllegalStateException($i$a$-check-GenerateApkDataTask$doTaskAction$82.toString());
            }
            if (!(!apks.getElements().isEmpty())) {
                boolean $i$a$-check-GenerateApkDataTask$doTaskAction$92 = false;
                String $i$a$-check-GenerateApkDataTask$doTaskAction$92 = "Wear App dependency resolve to zero APK";
                throw new IllegalStateException($i$a$-check-GenerateApkDataTask$doTaskAction$92.toString());
            }
            if (!(apks.getElements().size() <= 1)) {
                void $this$mapTo$iv$iv;
                boolean $i$a$-check-GenerateApkDataTask$doTaskAction$102 = false;
                Iterable $this$map$iv = apks.getElements();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    BuiltArtifactImpl builtArtifactImpl = (BuiltArtifactImpl)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getOutputFile());
                }
                String $i$a$-check-GenerateApkDataTask$doTaskAction$102 = "Wear App dependency resolve to more than one APK: " + (List)destination$iv$iv;
                throw new IllegalStateException($i$a$-check-GenerateApkDataTask$doTaskAction$102.toString());
            }
            String apk = ((BuiltArtifactImpl)Iterables.getOnlyElement((Iterable)apks.getElements())).getOutputFile();
            File rawDir = new File(outDir, "raw");
            FileUtils.mkdirs((File)rawDir);
            File to = new File(rawDir, "android_wear_micro_apk.apk");
            Files.copy((File)new File(apk), (File)to);
            File file = new File(apk);
            Intrinsics.checkNotNullExpressionValue((Object)outDir, (String)"outDir");
            Object object2 = this.getMainPkgName().get();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"mainPkgName.get()");
            String string = (String)object2;
            File file2 = Aapt2Daemon.getAapt2Executable(this.getAapt2()).toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"aapt2.getAapt2Executable().toFile()");
            this.generateApkData(file, outDir, string, file2);
        } else {
            Intrinsics.checkNotNullExpressionValue((Object)outDir, (String)"outDir");
            Object object3 = this.getMainPkgName().get();
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"mainPkgName.get()");
            this.generateUnbundledWearApkData(outDir, (String)object3);
        }
        Object object4 = this.getMinSdkVersion().get();
        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"minSdkVersion.get()");
        int n = ((Number)object4).intValue();
        Object object5 = this.getTargetSdkVersion().get();
        Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"targetSdkVersion.get()");
        int n2 = ((Number)object5).intValue();
        File file = ((RegularFile)this.getManifestFile().get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"manifestFile.get().asFile");
        this.generateApkDataEntryInManifest(n, n2, file);
    }

    private final void generateApkData(File apkFile, File outResFolder, String mainPkgName, File aapt2Executable) throws ProcessException, IOException {
        ExecOperations execOperations = this.getExecOperations();
        ApkInfoParser parser2 = new ApkInfoParser(aapt2Executable, (ProcessExecutor)new GradleProcessExecutor(new Function(execOperations){
            final /* synthetic */ ExecOperations $tmp0;
            {
                this.$tmp0 = $tmp0;
            }

            public final ExecResult apply(Action<? super ExecSpec> p0) {
                return this.$tmp0.exec(p0);
            }
        }));
        ApkInfoParser.ApkInfo apkInfo = parser2.parseApk(apkFile);
        if (!Intrinsics.areEqual((Object)apkInfo.getPackageName(), (Object)mainPkgName)) {
            throw new RuntimeException("The main and the micro apps do not have the same package name.");
        }
        String content2 = StringsKt.trimMargin((String)("|<?xml version=\"1.0\" encoding=\"utf-8\"?>\n                    |<wearableApp package=\"" + apkInfo.getPackageName() + "\">\n                    |    <versionCode>" + apkInfo.getVersionCode() + "</versionCode>\n                    |    <versionName>" + apkInfo.getVersionName() + "</versionName>\n                    |    <rawPathResId>android_wear_micro_apk</rawPathResId>\n                    |</wearableApp>"), (String)"|");
        File resXmlFile = new File(outResFolder, "xml");
        FileUtils.mkdirs((File)resXmlFile);
        Files.asCharSink((File)new File(resXmlFile, "android_wear_micro_apk.xml"), (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)content2);
    }

    private final void generateUnbundledWearApkData(File outResFolder, String mainPkgName) {
        String content2 = StringsKt.trimMargin((String)("|<?xml version=\"1.0\" encoding=\"utf-8\"?>\n                    |<wearableApp package=\"" + mainPkgName + "\">\n                    |    <unbundled />\n                    |</wearableApp>"), (String)"|");
        File resXmlFile = new File(outResFolder, "xml");
        FileUtils.mkdirs((File)resXmlFile);
        Files.asCharSink((File)new File(resXmlFile, "android_wear_micro_apk.xml"), (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)content2);
    }

    private final void generateApkDataEntryInManifest(int minSdkVersion2, int targetSdkVersion2, File manifestFile) {
        Object targetVersionString = targetSdkVersion2 == -1 ? "" : " android:targetSdkVersion=\"" + targetSdkVersion2 + "\"";
        String content2 = StringsKt.trimMargin((String)("|<?xml version=\"1.0\" encoding=\"utf-8\"?>\n            |<manifest xmlns:android=\"http://schemas.android.com/apk/res/android\">\n            |    <uses-sdk android:minSdkVersion=\"" + minSdkVersion2 + "\"" + (String)targetVersionString + "/>\n            |    <application>\n            |        <meta-data android:name=\"com.google.android.wearable.beta.app\"\n            |                   android:resource=\"@xml/android_wear_micro_apk\" />\n            |   </application>\n            |</manifest>\n            |"), (String)"|");
        Files.asCharSink((File)manifestFile, (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)content2);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0002H\u0016J\u0016\u0010\u0013\u001a\u00020\u00112\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00020\u0015H\u0016R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0016"}, d2={"Lcom/android/build/gradle/internal/tasks/GenerateApkDataTask$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/GenerateApkDataTask;", "Lcom/android/build/gradle/internal/component/ApkCreationConfig;", "creationConfig", "apkFileCollection", "Lorg/gradle/api/file/FileCollection;", "(Lcom/android/build/gradle/internal/component/ApkCreationConfig;Lorg/gradle/api/file/FileCollection;)V", "name", "", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "handleProvider", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "gradle-core"})
    public static final class CreationAction
    extends VariantTaskCreationAction<GenerateApkDataTask, ApkCreationConfig> {
        @Nullable
        private final FileCollection apkFileCollection;
        @NotNull
        private final String name;
        @NotNull
        private final Class<GenerateApkDataTask> type;

        public CreationAction(@NotNull ApkCreationConfig creationConfig, @Nullable FileCollection apkFileCollection) {
            Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
            super((ComponentCreationConfig)creationConfig);
            this.apkFileCollection = apkFileCollection;
            this.name = this.computeTaskName("handle", "MicroApk");
            this.type = GenerateApkDataTask.class;
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        @NotNull
        public Class<GenerateApkDataTask> getType() {
            return this.type;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<GenerateApkDataTask> taskProvider) {
            Intrinsics.checkNotNullParameter(taskProvider, (String)"taskProvider");
            super.handleProvider(taskProvider);
            String[] stringArray = new String[]{"manifests", "microapk", ((ApkCreationConfig)this.creationConfig).getDirName()};
            File manifestLocation = ((Directory)((ApkCreationConfig)this.creationConfig).getPaths().generatedDir(stringArray).get()).getAsFile();
            ((ApkCreationConfig)this.creationConfig).getArtifacts().setInitialProvider(taskProvider, (Function1)handleProvider.1.INSTANCE).atLocation(manifestLocation.getAbsolutePath()).withName("AndroidManifest.xml").on(InternalArtifactType.MICRO_APK_MANIFEST_FILE.INSTANCE);
            String[] stringArray2 = new String[]{"res", "microapk", ((ApkCreationConfig)this.creationConfig).getDirName()};
            File microApkResDirectory = ((Directory)((ApkCreationConfig)this.creationConfig).getPaths().generatedDir(stringArray2).get()).getAsFile();
            ((ApkCreationConfig)this.creationConfig).getArtifacts().setInitialProvider(taskProvider, (Function1)handleProvider.2.INSTANCE).atLocation(microApkResDirectory.getAbsolutePath()).on(InternalArtifactType.MICRO_APK_RES.INSTANCE);
            ((ApkCreationConfig)this.creationConfig).getTaskContainer().setMicroApkTask(taskProvider);
            ((ApkCreationConfig)this.creationConfig).getTaskContainer().setGenerateApkDataTask(taskProvider);
        }

        @Override
        public void configure(@NotNull GenerateApkDataTask task) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            super.configure((Task)task);
            FileCollection fileCollection2 = this.apkFileCollection;
            if (fileCollection2 != null) {
                FileCollection it = fileCollection2;
                boolean bl = false;
                Object[] objectArray = new Object[]{it};
                task.getApkFileCollection().from(objectArray);
            }
            task.getApkFileCollection().disallowChanges();
            HasConfigurableValuesKt.setDisallowChanges(task.getHasDependency(), this.apkFileCollection != null);
            HasConfigurableValuesKt.setDisallowChanges(task.getMainPkgName(), ((ApkCreationConfig)this.creationConfig).getApplicationId());
            HasConfigurableValuesKt.setDisallowChanges(task.getMinSdkVersion(), ((ApkCreationConfig)this.creationConfig).getMinSdkVersion().getApiLevel());
            HasConfigurableValuesKt.setDisallowChanges(task.getTargetSdkVersion(), ((ApkCreationConfig)this.creationConfig).getTargetSdkVersion().getApiLevel());
            ((ApkCreationConfig)this.creationConfig).getServices().initializeAapt2Input(task.getAapt2());
        }
    }
}

