/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.api.artifact.impl.ArtifactsImpl;
import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.profile.AnalyticsService;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.ProjectInfo;
import com.android.build.gradle.internal.services.BuildServicesKt;
import com.android.build.gradle.internal.tasks.BuildAnalyzer;
import com.android.build.gradle.internal.tasks.LintModelMetadataTask;
import com.android.build.gradle.internal.tasks.LintModelMetadataTaskKt;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.TaskCategory;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.utils.HasConfigurableValuesKt;
import com.android.utils.FileUtils;
import com.google.common.io.Files;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.services.BuildServiceRegistry;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.work.DisableCachingByDefault;
import org.jetbrains.annotations.NotNull;

@DisableCachingByDefault
@BuildAnalyzer(primaryTaskCategory=TaskCategory.LINT, secondaryTaskCategories={TaskCategory.METADATA})
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b'\u0018\u0000 \u00142\u00020\u0001:\u0002\u0014\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b\u0012J\b\u0010\u0013\u001a\u00020\u000fH\u0014R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0014\u0010\n\u001a\u00020\u000b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0016"}, d2={"Lcom/android/build/gradle/internal/tasks/LintModelMetadataTask;", "Lcom/android/build/gradle/internal/tasks/NonIncrementalTask;", "()V", "mavenArtifactId", "Lorg/gradle/api/provider/Property;", "", "getMavenArtifactId", "()Lorg/gradle/api/provider/Property;", "mavenGroupId", "getMavenGroupId", "outputFile", "Lorg/gradle/api/file/RegularFileProperty;", "getOutputFile", "()Lorg/gradle/api/file/RegularFileProperty;", "configureForStandalone", "", "project", "Lorg/gradle/api/Project;", "configureForStandalone$gradle_core", "doTaskAction", "Companion", "CreationAction", "gradle-core"})
public abstract class LintModelMetadataTask
extends NonIncrementalTask {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutputFile();

    @Input
    @NotNull
    public abstract Property<String> getMavenGroupId();

    @Input
    @NotNull
    public abstract Property<String> getMavenArtifactId();

    @Override
    protected void doTaskAction() {
        File lintModelMetadataFile = ((RegularFile)this.getOutputFile().get()).getAsFile();
        FileUtils.deleteIfExists((File)lintModelMetadataFile);
        Files.createParentDirs((File)lintModelMetadataFile);
        Intrinsics.checkNotNullExpressionValue((Object)lintModelMetadataFile, (String)"lintModelMetadataFile");
        Object object = this.getMavenGroupId().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"mavenGroupId.get()");
        String string = (String)object;
        Object object2 = this.getMavenArtifactId().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"mavenArtifactId.get()");
        LintModelMetadataTaskKt.writeLintModelMetadataFile(lintModelMetadataFile, string, (String)object2);
    }

    public final void configureForStandalone$gradle_core(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.setGroup("verification");
        this.setVariantName("");
        Property<AnalyticsService> property = this.getAnalyticsService();
        BuildServiceRegistry buildServiceRegistry = project2.getGradle().getSharedServices();
        Intrinsics.checkNotNullExpressionValue((Object)buildServiceRegistry, (String)"project.gradle.sharedServices");
        BuildServiceRegistry buildServiceRegistry$iv = buildServiceRegistry;
        boolean $i$f$getBuildService = false;
        HasConfigurableValuesKt.setDisallowChanges(property, BuildServicesKt.getBuildService(buildServiceRegistry$iv, AnalyticsService.class));
        HasConfigurableValuesKt.setDisallowChanges(this.getMavenGroupId(), project2.getGroup().toString());
        HasConfigurableValuesKt.setDisallowChanges(this.getMavenArtifactId(), project2.getName());
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\u0016\u0010\u0011\u001a\u00020\u000f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u0013H\u0016R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0014"}, d2={"Lcom/android/build/gradle/internal/tasks/LintModelMetadataTask$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/LintModelMetadataTask;", "Lcom/android/build/gradle/internal/component/ComponentCreationConfig;", "creationConfig", "(Lcom/android/build/gradle/internal/component/ComponentCreationConfig;)V", "name", "", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "handleProvider", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "gradle-core"})
    public static final class CreationAction
    extends VariantTaskCreationAction<LintModelMetadataTask, ComponentCreationConfig> {
        public CreationAction(@NotNull ComponentCreationConfig creationConfig) {
            Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
            super(creationConfig);
        }

        @Override
        @NotNull
        public String getName() {
            return this.computeTaskName("write", "LintModelMetadata");
        }

        @Override
        @NotNull
        public Class<LintModelMetadataTask> getType() {
            return LintModelMetadataTask.class;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<LintModelMetadataTask> taskProvider) {
            Intrinsics.checkNotNullParameter(taskProvider, (String)"taskProvider");
            super.handleProvider(taskProvider);
            Companion.registerOutputArtifacts(taskProvider, this.creationConfig.getArtifacts());
        }

        @Override
        public void configure(@NotNull LintModelMetadataTask task) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            super.configure((Task)task);
            ProjectInfo projectInfo = this.creationConfig.getServices().getProjectInfo();
            HasConfigurableValuesKt.setDisallowChanges(task.getMavenGroupId(), projectInfo.getGroup());
            HasConfigurableValuesKt.setDisallowChanges(task.getMavenArtifactId(), projectInfo.getName());
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lcom/android/build/gradle/internal/tasks/LintModelMetadataTask$Companion;", "", "()V", "registerOutputArtifacts", "", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "Lcom/android/build/gradle/internal/tasks/LintModelMetadataTask;", "artifacts", "Lcom/android/build/api/artifact/impl/ArtifactsImpl;", "gradle-core"})
    public static final class Companion {
        private Companion() {
        }

        public final void registerOutputArtifacts(@NotNull TaskProvider<LintModelMetadataTask> taskProvider, @NotNull ArtifactsImpl artifacts2) {
            Intrinsics.checkNotNullParameter(taskProvider, (String)"taskProvider");
            Intrinsics.checkNotNullParameter((Object)artifacts2, (String)"artifacts");
            artifacts2.setInitialProvider(taskProvider, (Function1)registerOutputArtifacts.1.INSTANCE).withName("lint-model-metadata.properties").on(InternalArtifactType.LINT_MODEL_METADATA.INSTANCE);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

