/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.component.VariantCreationConfig;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.tasks.BuildAnalyzer;
import com.android.build.gradle.internal.tasks.ExportConsumerProguardFilesTask;
import com.android.build.gradle.internal.tasks.MergeFileTask;
import com.android.build.gradle.internal.tasks.TaskCategory;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.utils.HasConfigurableValuesKt;
import com.android.builder.errors.EvalIssueException;
import java.io.IOException;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.work.DisableCachingByDefault;

@DisableCachingByDefault
@BuildAnalyzer(primaryTaskCategory=TaskCategory.OPTIMIZATION)
public abstract class MergeConsumerProguardFilesTask
extends MergeFileTask {
    private boolean isDynamicFeature;
    private boolean isBaseModule;

    @Input
    public boolean getIsDynamicFeature() {
        return this.isDynamicFeature;
    }

    @Input
    public boolean getIsBaseModule() {
        return this.isBaseModule;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public abstract ConfigurableFileCollection getConsumerProguardFiles();

    @Internal(value="only for task execution")
    public abstract DirectoryProperty getBuildDirectory();

    @Override
    public void doTaskAction() throws IOException {
        if (!this.isBaseModule) {
            ExportConsumerProguardFilesTask.checkProguardFiles(this.getBuildDirectory(), this.isDynamicFeature, this.getConsumerProguardFiles().getFiles(), errorMessage -> {
                throw new EvalIssueException(errorMessage);
            });
        }
        super.doTaskAction();
    }

    public static class CreationAction
    extends VariantTaskCreationAction<MergeConsumerProguardFilesTask, VariantCreationConfig> {
        public CreationAction(VariantCreationConfig creationConfig) {
            super(creationConfig);
        }

        @Override
        public String getName() {
            return this.computeTaskName("merge", "ConsumerProguardFiles");
        }

        @Override
        public Class<MergeConsumerProguardFilesTask> getType() {
            return MergeConsumerProguardFilesTask.class;
        }

        @Override
        public void handleProvider(TaskProvider<MergeConsumerProguardFilesTask> taskProvider) {
            super.handleProvider(taskProvider);
            ((VariantCreationConfig)this.creationConfig).getArtifacts().setInitialProvider(taskProvider, MergeFileTask::getOutputFile).withName("proguard.txt").on(InternalArtifactType.MERGED_CONSUMER_PROGUARD_FILE.INSTANCE);
        }

        @Override
        public void configure(MergeConsumerProguardFilesTask task) {
            super.configure(task);
            task.isBaseModule = ((VariantCreationConfig)this.creationConfig).getComponentType().isBaseModule();
            task.isDynamicFeature = ((VariantCreationConfig)this.creationConfig).getComponentType().isDynamicFeature();
            task.getConsumerProguardFiles().from(new Object[]{((VariantCreationConfig)this.creationConfig).getConsumerProguardFiles()});
            ConfigurableFileCollection inputFiles2 = ((VariantCreationConfig)this.creationConfig).getServices().fileCollection(task.getConsumerProguardFiles(), ((VariantCreationConfig)this.creationConfig).getArtifacts().get(InternalArtifactType.GENERATED_PROGUARD_FILE.INSTANCE));
            task.getInputFiles().from(new Object[]{inputFiles2});
            task.getInputFiles().disallowChanges();
            HasConfigurableValuesKt.setDisallowChanges(task.getBuildDirectory(), task.getProject().getLayout().getBuildDirectory());
        }
    }
}

