/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.testing.utp;

import com.android.build.gradle.internal.testing.utp.EmulatorGrpcInfo;
import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Locale;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.streams.jdk8.StreamsKt;
import kotlin.text.StringsKt;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u001a\n\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002\u001a\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u001a\u0018\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\b\u001a\n\u0010\u000e\u001a\u0004\u0018\u00010\fH\u0002\"\u0016\u0010\u0000\u001a\u00020\u00018\u0006X\u0087T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0002\u0010\u0003\"\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"DEFAULT_EMULATOR_GRPC_PORT", "", "getDEFAULT_EMULATOR_GRPC_PORT$annotations", "()V", "LOG", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "computeRegistrationDirectoryContainer", "Ljava/nio/file/Path;", "findGrpcInfo", "Lcom/android/build/gradle/internal/testing/utp/EmulatorGrpcInfo;", "deviceSerial", "", "file", "getUid", "gradle-core"})
public final class IceboxConfigUtilsKt {
    public static final int DEFAULT_EMULATOR_GRPC_PORT = 8554;
    private static final Logger LOG = Logger.getLogger("IceboxConfigUtils");

    @VisibleForTesting
    public static /* synthetic */ void getDEFAULT_EMULATOR_GRPC_PORT$annotations() {
    }

    private static final Path computeRegistrationDirectoryContainer() {
        String[] stringArray = System.getProperty("os.name");
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getProperty(\"os.name\")");
        String[] stringArray2 = stringArray;
        Locale locale = Locale.ROOT;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
        String string = stringArray2.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(locale)");
        String os = string;
        if (StringsKt.startsWith$default((String)os, (String)"mac", (boolean)false, (int)2, null)) {
            String string2 = System.getenv("HOME");
            if (string2 == null) {
                string2 = "/";
            }
            stringArray2 = new String[]{"Library", "Caches", "TemporaryItems"};
            return Paths.get(string2, stringArray2);
        }
        if (StringsKt.startsWith$default((String)os, (String)"win", (boolean)false, (int)2, null)) {
            String string3 = System.getenv("LOCALAPPDATA");
            if (string3 == null) {
                string3 = "/";
            }
            stringArray2 = new String[]{"Temp"};
            return Paths.get(string3, stringArray2);
        }
        String[] stringArray3 = new String[7];
        stringArray3[0] = System.getenv("XDG_RUNTIME_DIR");
        stringArray3[1] = "/run/user/" + IceboxConfigUtilsKt.getUid();
        stringArray3[2] = System.getenv("ANDROID_EMULATOR_HOME");
        stringArray3[3] = System.getenv("ANDROID_PREFS_ROOT");
        stringArray3[4] = System.getenv("ANDROID_SDK_HOME");
        String string4 = System.getenv("HOME");
        if (string4 == null) {
            string4 = "/";
        }
        stringArray3[5] = string4 + ".android";
        stringArray3[6] = System.getProperty("android.emulator.home");
        for (String dirstr : stringArray3) {
            if (dirstr == null) continue;
            try {
                Path dir = Paths.get(dirstr, new String[0]);
                if (!Files.isDirectory(dir, new LinkOption[0])) continue;
                return dir;
            }
            catch (InvalidPathException exception) {
                LOG.finer("Failed to parse dir " + dirstr + ", exception " + exception);
            }
        }
        stringArray2 = new String[]{"android-" + System.getProperty("USER")};
        return Paths.get(FileUtils.getTempDirectory().getAbsolutePath(), stringArray2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String getUid() {
        try {
            String userName = System.getProperty("user.name");
            String command = "id -u " + userName;
            Process process2 = Runtime.getRuntime().exec(command);
            Closeable closeable = process2.getInputStream();
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                byte[] byArray = ByteStreamsKt.readBytes((InputStream)it);
                Charset charset = StandardCharsets.UTF_8;
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
                Charset charset2 = charset;
                String result2 = ((Object)StringsKt.trim((CharSequence)new String(byArray, charset2))).toString();
                if (((CharSequence)result2).length() == 0) {
                    String string = null;
                    return string;
                }
                String string = result2;
                return string;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException e) {
            return null;
        }
    }

    @Nullable
    public static final EmulatorGrpcInfo findGrpcInfo(@NotNull String deviceSerial, @NotNull Path file) {
        Intrinsics.checkNotNullParameter((Object)deviceSerial, (String)"deviceSerial");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        int currentGrpcPort = 0;
        currentGrpcPort = 8554;
        String currentGrpcToken = null;
        boolean matchedAvd = false;
        List<String> list = Files.readAllLines(file);
        Intrinsics.checkNotNullExpressionValue(list, (String)"readAllLines(file)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String serial;
            String line = (String)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)line, (String)"line");
            if (StringsKt.startsWith$default((String)line, (String)"grpc.port=", (boolean)false, (int)2, null)) {
                String string = line.substring("grpc.port=".length());
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
                currentGrpcPort = Integer.parseInt(string, 10);
                continue;
            }
            if (StringsKt.startsWith$default((String)line, (String)"grpc.token=", (boolean)false, (int)2, null)) {
                Intrinsics.checkNotNullExpressionValue((Object)line.substring("grpc.token=".length()), (String)"this as java.lang.String).substring(startIndex)");
                continue;
            }
            if (!StringsKt.startsWith$default((String)line, (String)"port.serial=", (boolean)false, (int)2, null)) continue;
            Intrinsics.checkNotNullExpressionValue((Object)line.substring("port.serial=".length()), (String)"this as java.lang.String).substring(startIndex)");
            matchedAvd = Intrinsics.areEqual((Object)("emulator-" + serial), (Object)deviceSerial);
        }
        if (matchedAvd) {
            return new EmulatorGrpcInfo(currentGrpcPort, currentGrpcToken);
        }
        return null;
    }

    @NotNull
    public static final EmulatorGrpcInfo findGrpcInfo(@NotNull String deviceSerial) {
        Intrinsics.checkNotNullParameter((Object)deviceSerial, (String)"deviceSerial");
        try {
            Pattern fileNamePattern = Pattern.compile("pid_\\d+.ini");
            Path path = IceboxConfigUtilsKt.computeRegistrationDirectoryContainer();
            Path directory2 = path != null ? path.resolve("avd/running") : null;
            Stream<Path> stream2 = Files.list(directory2);
            Intrinsics.checkNotNullExpressionValue(stream2, (String)"list(directory)");
            EmulatorGrpcInfo emulatorGrpcInfo = (EmulatorGrpcInfo)SequencesKt.firstOrNull((Sequence)SequencesKt.filterNotNull((Sequence)SequencesKt.map((Sequence)StreamsKt.asSequence(stream2), (Function1)((Function1)new Function1<Path, EmulatorGrpcInfo>(fileNamePattern, deviceSerial){
                final /* synthetic */ Pattern $fileNamePattern;
                final /* synthetic */ String $deviceSerial;
                {
                    this.$fileNamePattern = $fileNamePattern;
                    this.$deviceSerial = $deviceSerial;
                    super(1);
                }

                @Nullable
                public final EmulatorGrpcInfo invoke(Path file) {
                    EmulatorGrpcInfo emulatorGrpcInfo;
                    if (this.$fileNamePattern.matcher(((Object)file.getFileName()).toString()).matches()) {
                        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file");
                        emulatorGrpcInfo = IceboxConfigUtilsKt.findGrpcInfo(this.$deviceSerial, file);
                    } else {
                        emulatorGrpcInfo = null;
                    }
                    return emulatorGrpcInfo;
                }
            }))));
            if (emulatorGrpcInfo == null) {
                emulatorGrpcInfo = new EmulatorGrpcInfo(8554, null);
            }
            return emulatorGrpcInfo;
        }
        catch (Throwable exception) {
            LOG.fine("Failed to parse emulator gRPC port, fallback to default, exception " + exception);
            return new EmulatorGrpcInfo(8554, null);
        }
    }
}

