/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.dependency.GenericTransformParameters;
import com.android.bundle.SdkMetadataOuterClass;
import com.android.tools.build.bundletool.model.RuntimeEnabledSdkVersionEncoder;
import com.android.zipflinger.ZipArchive;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.artifacts.transform.CacheableTransform;
import org.gradle.api.artifacts.transform.InputArtifact;
import org.gradle.api.artifacts.transform.TransformAction;
import org.gradle.api.artifacts.transform.TransformOutputs;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.jetbrains.annotations.NotNull;

@CacheableTransform
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b'\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H'J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/android/build/gradle/internal/tasks/AsarToManifestSnippetTransform;", "Lorg/gradle/api/artifacts/transform/TransformAction;", "Lcom/android/build/gradle/internal/dependency/GenericTransformParameters;", "()V", "getInputArtifact", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/FileSystemLocation;", "transform", "", "outputs", "Lorg/gradle/api/artifacts/transform/TransformOutputs;", "gradle-core"})
public abstract class AsarToManifestSnippetTransform
implements TransformAction<GenericTransformParameters> {
    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    @InputArtifact
    @NotNull
    public abstract Provider<FileSystemLocation> getInputArtifact();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transform(@NotNull TransformOutputs outputs) {
        Intrinsics.checkNotNullParameter((Object)outputs, (String)"outputs");
        Path inputFile = ((FileSystemLocation)this.getInputArtifact().get()).getAsFile().toPath();
        Path path = inputFile.getFileName();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"inputFile.fileName");
        Path outputFile = outputs.file((Object)(PathsKt.getNameWithoutExtension((Path)path) + "-privacy-sandbox-sdk-dependency-manifest-snippet.xml")).toPath();
        Closeable closeable = (Closeable)new ZipArchive(inputFile);
        Throwable throwable = null;
        try {
            ZipArchive it = (ZipArchive)closeable;
            boolean bl = false;
            Closeable closeable2 = it.getInputStream("SdkMetadata.pb");
            Throwable throwable2 = null;
            try {
                InputStream protoBytes = (InputStream)closeable2;
                boolean bl2 = false;
                SdkMetadataOuterClass.SdkMetadata metadata = SdkMetadataOuterClass.SdkMetadata.parseFrom((InputStream)protoBytes);
                int encodedVersion = RuntimeEnabledSdkVersionEncoder.encodeSdkMajorAndMinorVersion((int)metadata.getSdkVersion().getMajor(), (int)metadata.getSdkVersion().getMinor());
                File file = outputFile.toFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"outputFile.toFile()");
                FilesKt.writeText$default((File)file, (String)StringsKt.trimIndent((String)("\n                    <manifest\n                        xmlns:android=\"http://schemas.android.com/apk/res/android\">\n                        <application>\n                            <uses-sdk-library\n                                android:name=\"" + metadata.getPackageName() + "\"\n                                android:certDigest=\"" + metadata.getCertificateDigest() + "\"\n                                android:versionMajor=\"" + encodedVersion + "\" />\n                        </application>\n                    </manifest>\n                ")), null, (int)2, null);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }
}

