/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.test.report;

import com.android.build.gradle.internal.test.report.CompositeTestResults;
import com.android.build.gradle.internal.test.report.PackageTestResults;
import com.android.build.gradle.internal.test.report.TestResult;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

class ClassTestResults
extends CompositeTestResults {
    private final String name;
    private final PackageTestResults packageResults;
    private final Set<TestResult> results = new TreeSet<TestResult>();

    public ClassTestResults(String name, PackageTestResults packageResults) {
        super(packageResults);
        this.name = name;
        this.packageResults = packageResults;
    }

    @Override
    public String getTitle() {
        return String.format("Class %s", this.name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getSimpleName() {
        int pos = this.name.lastIndexOf(".");
        if (pos != -1) {
            return this.name.substring(pos + 1);
        }
        return this.name;
    }

    public PackageTestResults getPackageResults() {
        return this.packageResults;
    }

    public Map<String, Map<String, TestResult>> getTestResultsMap() {
        HashMap map = Maps.newHashMap();
        for (TestResult result2 : this.results) {
            String device = result2.getDevice();
            Map deviceMap = (Map)map.get(device);
            if (deviceMap == null) {
                deviceMap = Maps.newHashMap();
                map.put(device, deviceMap);
            }
            deviceMap.put(result2.getName(), result2);
        }
        return map;
    }

    public TestResult addTest(String testName, long duration, String device, String project2, String flavor) {
        TestResult test = new TestResult(testName, duration, device, project2, flavor, this);
        this.results.add(test);
        this.addDevice(device, test);
        this.addVariant(project2, flavor, test);
        return this.addTest(test);
    }
}

