/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.external.cmake.server;

import com.android.build.gradle.external.cmake.server.CacheRequest;
import com.android.build.gradle.external.cmake.server.CacheResult;
import com.android.build.gradle.external.cmake.server.CmakeInputsResult;
import com.android.build.gradle.external.cmake.server.CodeModel;
import com.android.build.gradle.external.cmake.server.ComputeResult;
import com.android.build.gradle.external.cmake.server.ConfigureCommandResult;
import com.android.build.gradle.external.cmake.server.ConfigureRequest;
import com.android.build.gradle.external.cmake.server.ConfigureResult;
import com.android.build.gradle.external.cmake.server.GlobalSettings;
import com.android.build.gradle.external.cmake.server.HandshakeRequest;
import com.android.build.gradle.external.cmake.server.HandshakeResult;
import com.android.build.gradle.external.cmake.server.HelloResult;
import com.android.build.gradle.external.cmake.server.ProtocolVersion;
import com.android.build.gradle.external.cmake.server.Server;
import com.android.build.gradle.external.cmake.server.ServerUtils;
import com.android.build.gradle.external.cmake.server.TypeOfMessage;
import com.android.build.gradle.external.cmake.server.receiver.InteractiveMessage;
import com.android.build.gradle.external.cmake.server.receiver.InteractiveProgress;
import com.android.build.gradle.external.cmake.server.receiver.ServerReceiver;
import com.android.build.gradle.internal.cxx.logging.LoggingEnvironmentKt;
import com.android.utils.cxx.CxxBugDiagnosticCode;
import com.google.common.annotations.VisibleForTesting;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.FormatFlagsConversionMismatchException;
import java.util.List;

public class ServerProtocolV1
implements Server {
    public static final String CMAKE_SERVER_HEADER_MSG = "[== \"CMake Server\" ==[";
    public static final String CMAKE_SERVER_FOOTER_MSG = "]== \"CMake Server\" ==]";
    public static final String CMAKE_SERVER_C_COMPILER_PREFIX = "Check for working C compiler: ";
    public static final String CMAKE_SERVER_CXX_COMPILER_PREFIX = "Check for working CXX compiler: ";
    public static final String CMAKE_SERVER_C_COMPILER_SUFFIX = " -- works";
    private BufferedReader input;
    private BufferedWriter output;
    private final File cmakeInstallPath;
    private final ServerReceiver serverReceiver;
    private HelloResult helloResult = null;
    private boolean connected = false;
    private boolean configured = false;
    private boolean computed = false;
    private List<InteractiveMessage> configureMessages;
    Process process = null;

    ServerProtocolV1(File cmakeInstallPath, ServerReceiver serverReceiver2) {
        this.cmakeInstallPath = cmakeInstallPath;
        this.serverReceiver = serverReceiver2;
    }

    @VisibleForTesting
    ServerProtocolV1(File cmakeInstallPath, ServerReceiver serverReceiver2, Process process2, BufferedReader input, BufferedWriter output2) {
        this.cmakeInstallPath = cmakeInstallPath;
        this.serverReceiver = serverReceiver2;
        this.process = process2;
        this.input = input;
        this.output = output2;
    }

    public void finalize() {
        try {
            this.disconnect();
        }
        catch (IOException e) {
            this.diagnostic("Error when disconnecting from Cmake server: %s", e.toString());
        }
    }

    @Override
    public boolean connect() throws IOException {
        this.init();
        this.helloResult = this.decodeResponse(HelloResult.class);
        this.connected = ServerUtils.isHelloResultValid(this.helloResult);
        return this.connected;
    }

    @Override
    public void disconnect() throws IOException {
        if (this.input != null) {
            this.input.close();
            this.input = null;
        }
        if (this.output != null) {
            this.output.close();
            this.output = null;
        }
        if (this.process != null) {
            this.process.destroy();
            this.process = null;
        }
        this.connected = false;
        this.configured = false;
        this.computed = false;
        this.configureMessages = null;
        this.helloResult = null;
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public List<ProtocolVersion> getSupportedVersion() {
        if (this.helloResult == null || this.helloResult.supportedProtocolVersions == null) {
            return null;
        }
        ArrayList<ProtocolVersion> result2 = new ArrayList<ProtocolVersion>();
        for (ProtocolVersion protocolVersion : this.helloResult.supportedProtocolVersions) {
            if (protocolVersion.major != 1) continue;
            result2.add(protocolVersion);
            break;
        }
        return result2;
    }

    @Override
    public HandshakeResult handshake(HandshakeRequest handshakeRequest) throws IOException {
        this.throwIfNotConnected("handshake");
        this.writeMessage(new GsonBuilder().setPrettyPrinting().create().toJson((Object)handshakeRequest));
        return this.decodeResponse(HandshakeResult.class);
    }

    @Override
    public ConfigureCommandResult configure(String ... cacheArguments) throws IOException {
        this.throwIfNotConnected("configure");
        ConfigureRequest configureRequest = new ConfigureRequest();
        configureRequest.cacheArguments = new String[cacheArguments.length + 1];
        configureRequest.cacheArguments[0] = "";
        System.arraycopy(cacheArguments, 0, configureRequest.cacheArguments, 1, cacheArguments.length);
        this.writeMessage(new GsonBuilder().setPrettyPrinting().create().toJson((Object)configureRequest));
        this.configureMessages = new ArrayList<InteractiveMessage>();
        ConfigureResult configureResult = this.decodeResponse(ConfigureResult.class, this.configureMessages);
        this.configured = ServerUtils.isConfigureResultValid(configureResult);
        return new ConfigureCommandResult(configureResult, !this.configureMessages.isEmpty() ? ServerProtocolV1.getInteractiveMessagesAsString(this.configureMessages) : "");
    }

    @Override
    public ComputeResult compute() throws IOException {
        this.throwIfNotConnected("compute");
        this.throwIfNotConfigured("compute");
        this.writeMessage("{\"type\":\"compute\"}");
        ComputeResult computeResult = this.decodeResponse(ComputeResult.class);
        this.computed = ServerUtils.isComputedResultValid(computeResult);
        return computeResult;
    }

    @Override
    public CodeModel codemodel() throws IOException {
        this.throwIfNotConnected("codemodel");
        this.throwIfNotComputed("codemodel");
        this.writeMessage("{\"type\":\"codemodel\"}");
        return this.decodeResponse(CodeModel.class);
    }

    @Override
    public CacheResult cache() throws IOException {
        this.throwIfNotConnected("cache");
        CacheRequest request2 = new CacheRequest();
        this.writeMessage(new GsonBuilder().setPrettyPrinting().create().toJson((Object)request2));
        return this.decodeResponse(CacheResult.class);
    }

    @Override
    public GlobalSettings globalSettings() throws IOException {
        this.throwIfNotConnected("globalSettings");
        this.writeMessage("{\"type\":\"globalSettings\"}");
        return this.decodeResponse(GlobalSettings.class);
    }

    @Override
    public CmakeInputsResult cmakeInputs() throws IOException {
        this.throwIfNotConnected("cmakeInputs");
        this.throwIfNotConfigured("cmakeInputs");
        this.writeMessage("{\"type\":\"cmakeInputs\"}");
        return this.decodeResponse(CmakeInputsResult.class);
    }

    @Override
    public String getCCompilerExecutable() {
        String prefixMessage = CMAKE_SERVER_C_COMPILER_PREFIX;
        String suffixMessage = CMAKE_SERVER_C_COMPILER_SUFFIX;
        return this.hackyGetLangExecutable(CMAKE_SERVER_C_COMPILER_PREFIX, CMAKE_SERVER_C_COMPILER_SUFFIX);
    }

    @Override
    public String getCppCompilerExecutable() {
        String prefixMessage = CMAKE_SERVER_CXX_COMPILER_PREFIX;
        String suffixMessage = CMAKE_SERVER_C_COMPILER_SUFFIX;
        return this.hackyGetLangExecutable(CMAKE_SERVER_CXX_COMPILER_PREFIX, CMAKE_SERVER_C_COMPILER_SUFFIX);
    }

    @Override
    public String getCmakePath() {
        return this.cmakeInstallPath.getAbsolutePath();
    }

    public HelloResult getHelloResult() {
        return this.helloResult;
    }

    private void throwIfNotConnected(String operation) {
        if (!this.connected) {
            ServerProtocolV1.throwError("Need to connect to CMake server before requesting for", operation);
        }
    }

    private void throwIfNotConfigured(String operation) {
        if (!this.configured) {
            ServerProtocolV1.throwError("Need to configure before requesting for", operation);
        }
    }

    private void throwIfNotComputed(String operation) {
        if (!this.computed) {
            ServerProtocolV1.throwError("Need to compute before requesting for", operation);
        }
    }

    private static void throwError(String message2, String operation) {
        throw new RuntimeException(message2 + " " + operation + ".");
    }

    private String hackyGetLangExecutable(String prefixMessage, String suffixMessage) {
        if (this.configureMessages == null || this.configureMessages.isEmpty()) {
            return "";
        }
        for (InteractiveMessage message2 : this.configureMessages) {
            if (message2.message == null || !message2.message.startsWith(prefixMessage) || !message2.message.endsWith(suffixMessage)) continue;
            return message2.message.substring(prefixMessage.length(), message2.message.length() - suffixMessage.length());
        }
        return "";
    }

    private void init() throws IOException {
        if (this.process == null) {
            ProcessBuilder processBuilder = this.getCmakeServerProcessBuilder();
            processBuilder.environment().putAll(new ProcessBuilder(new String[0]).environment());
            this.process = processBuilder.start();
        }
        if (this.input == null) {
            this.input = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
        }
        if (this.output == null) {
            this.output = new BufferedWriter(new OutputStreamWriter(this.process.getOutputStream()));
        }
    }

    private void diagnostic(String format, Object ... args) {
        if (this.serverReceiver.getDiagnosticReceiver() != null) {
            try {
                this.serverReceiver.getDiagnosticReceiver().receive(String.format(format, args));
            }
            catch (FormatFlagsConversionMismatchException e) {
                this.serverReceiver.getDiagnosticReceiver().receive(format);
            }
        }
    }

    private void diagnostic(String message2) {
        if (this.serverReceiver.getDiagnosticReceiver() != null) {
            this.serverReceiver.getDiagnosticReceiver().receive(message2);
        }
    }

    private ProcessBuilder getCmakeServerProcessBuilder() {
        String cmakeBinPath = new File(this.cmakeInstallPath, "cmake").getPath();
        return new ProcessBuilder(cmakeBinPath, "-E", "server", "--experimental", "--debug");
    }

    private <T> T decodeResponse(Class<T> clazz) throws IOException {
        return this.decodeResponse(clazz, null);
    }

    private <T> T decodeResponse(Class<T> clazz, List<InteractiveMessage> interactiveMessages) throws IOException {
        InteractiveMessage interactiveMessage;
        Gson gson2 = new GsonBuilder().create();
        String message2 = this.readMessage();
        String messageType = ((TypeOfMessage)gson2.fromJson((String)message2, TypeOfMessage.class)).type;
        List<String> supportedTypes = Arrays.asList("message", "progress", "signal");
        while (supportedTypes.contains(messageType)) {
            switch (messageType) {
                case "message": {
                    if (this.serverReceiver.getMessageReceiver() == null) break;
                    interactiveMessage = (InteractiveMessage)gson2.fromJson(message2, InteractiveMessage.class);
                    this.serverReceiver.getMessageReceiver().receive(interactiveMessage);
                    if (interactiveMessages == null) break;
                    this.serverReceiver.getMessageReceiver().receive(interactiveMessage);
                    interactiveMessages.add(interactiveMessage);
                    break;
                }
                case "progress": {
                    if (this.serverReceiver.getProgressReceiver() == null) break;
                    this.serverReceiver.getProgressReceiver().receive((InteractiveProgress)gson2.fromJson(message2, InteractiveProgress.class));
                    break;
                }
                case "signal": {
                    if (this.serverReceiver.getProgressReceiver() == null) break;
                    this.serverReceiver.getProgressReceiver().receive((InteractiveProgress)gson2.fromJson(message2, InteractiveProgress.class));
                }
            }
            message2 = this.readMessage();
            messageType = ((TypeOfMessage)gson2.fromJson((String)message2, TypeOfMessage.class)).type;
        }
        switch (messageType) {
            case "hello": 
            case "reply": {
                if (this.serverReceiver.getDeserializationMonitor() != null) {
                    this.serverReceiver.getDeserializationMonitor().receive(message2, clazz);
                }
                return (T)gson2.fromJson(message2, clazz);
            }
            case "error": {
                if (this.serverReceiver.getMessageReceiver() != null) {
                    interactiveMessage = (InteractiveMessage)gson2.fromJson(message2, InteractiveMessage.class);
                    this.serverReceiver.getMessageReceiver().receive(interactiveMessage);
                }
                return (T)gson2.fromJson(message2, clazz);
            }
        }
        throw new RuntimeException("Unsupported message type " + messageType + " received from CMake server.");
    }

    private static String getInteractiveMessagesAsString(List<InteractiveMessage> interactiveMessages) {
        StringBuilder result2 = new StringBuilder();
        for (InteractiveMessage interactiveMessage : interactiveMessages) {
            result2.append(interactiveMessage.message).append("\n");
        }
        return result2.toString();
    }

    private String readLine() throws IOException {
        String line = this.input.readLine();
        this.diagnostic(line + "\n");
        return line;
    }

    private void writeLine(String message2) throws IOException {
        this.diagnostic("%s\n", message2);
        this.output.write(message2);
        this.output.newLine();
    }

    private void readExpected(String expectedString) throws IOException {
        StringBuilder sb = new StringBuilder();
        String line = this.readLine();
        while (line != null && !line.equals(expectedString)) {
            sb.append(line);
            sb.append("\n");
            if (!line.isEmpty() && this.serverReceiver.getDiagnosticReceiver() != null) {
                this.serverReceiver.getDiagnosticReceiver().receive(line);
            }
            line = this.readLine();
        }
        if (line == null) {
            LoggingEnvironmentKt.bugln(CxxBugDiagnosticCode.CMAKE_SERVER_HANDSHAKE_FAILED, "Handshake with CMake Server failed, please consider upgrading to CMake 3.18.1 or higher.\nThe raw CMake Server log was:\n" + sb, new Object[0]);
        }
    }

    private String readMessage() throws IOException {
        this.readExpected(CMAKE_SERVER_HEADER_MSG);
        String line = this.readLine();
        this.readExpected(CMAKE_SERVER_FOOTER_MSG);
        return line;
    }

    private void writeMessage(String message2) throws IOException {
        this.writeLine(CMAKE_SERVER_HEADER_MSG);
        this.writeLine(message2);
        this.writeLine(CMAKE_SERVER_FOOTER_MSG);
        this.output.flush();
    }
}

