/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.api.component.impl.features;

import com.android.build.api.artifact.Artifact;
import com.android.build.api.artifact.MultipleArtifact;
import com.android.build.api.variant.AndroidVersion;
import com.android.build.api.variant.impl.AndroidVersionImpl;
import com.android.build.api.variant.impl.VariantApiExtensionsKt;
import com.android.build.gradle.internal.component.AndroidTestCreationConfig;
import com.android.build.gradle.internal.component.ApkCreationConfig;
import com.android.build.gradle.internal.component.DynamicFeatureCreationConfig;
import com.android.build.gradle.internal.component.features.DexingCreationConfig;
import com.android.build.gradle.internal.core.dsl.features.DexingDslInfo;
import com.android.build.gradle.internal.scope.Java8LangSupport;
import com.android.build.gradle.internal.services.VariantServices;
import com.android.build.gradle.options.BooleanOption;
import com.android.builder.dexing.DexingType;
import com.android.builder.errors.IssueReporter;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000fR\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0016\u0010\u0019\u001a\u0004\u0018\u00010\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u000fR\u0014\u0010\u001f\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u000fR\u0014\u0010!\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u000f\u00a8\u0006#"}, d2={"Lcom/android/build/api/component/impl/features/DexingCreationConfigImpl;", "Lcom/android/build/gradle/internal/component/features/DexingCreationConfig;", "component", "Lcom/android/build/gradle/internal/component/ApkCreationConfig;", "dslInfo", "Lcom/android/build/gradle/internal/core/dsl/features/DexingDslInfo;", "internalServices", "Lcom/android/build/gradle/internal/services/VariantServices;", "(Lcom/android/build/gradle/internal/component/ApkCreationConfig;Lcom/android/build/gradle/internal/core/dsl/features/DexingDslInfo;Lcom/android/build/gradle/internal/services/VariantServices;)V", "dexingType", "Lcom/android/builder/dexing/DexingType;", "getDexingType", "()Lcom/android/builder/dexing/DexingType;", "isCoreLibraryDesugaringEnabled", "", "()Z", "isMultiDexEnabled", "java8LangSupportType", "Lcom/android/build/gradle/internal/scope/Java8LangSupport;", "getJava8LangSupportType", "()Lcom/android/build/gradle/internal/scope/Java8LangSupport;", "minSdkVersionForDexing", "Lcom/android/build/api/variant/AndroidVersion;", "getMinSdkVersionForDexing", "()Lcom/android/build/api/variant/AndroidVersion;", "multiDexKeepFile", "Ljava/io/File;", "getMultiDexKeepFile", "()Ljava/io/File;", "needsMainDexListForBundle", "getNeedsMainDexListForBundle", "needsShrinkDesugarLibrary", "getNeedsShrinkDesugarLibrary", "shouldPackageDesugarLibDex", "getShouldPackageDesugarLibDex", "gradle-core"})
public final class DexingCreationConfigImpl
implements DexingCreationConfig {
    @NotNull
    private final ApkCreationConfig component;
    @NotNull
    private final DexingDslInfo dslInfo;
    @NotNull
    private final VariantServices internalServices;

    public DexingCreationConfigImpl(@NotNull ApkCreationConfig component2, @NotNull DexingDslInfo dslInfo, @NotNull VariantServices internalServices) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
            Intrinsics.checkNotNullParameter((Object)dslInfo, (String)"dslInfo");
            Intrinsics.checkNotNullParameter((Object)internalServices, (String)"internalServices");
            this.component = component2;
            this.dslInfo = dslInfo;
            this.internalServices = internalServices;
            File file = this.dslInfo.getMultiDexKeepProguard();
            if (file == null) break block0;
            File it = file;
            boolean bl = false;
            this.component.getArtifacts().getArtifactContainer$gradle_core((Artifact.Multiple)MultipleArtifact.MULTIDEX_KEEP_PROGUARD.INSTANCE).addInitialProvider((TaskProvider<?>)null, this.internalServices.toRegularFileProvider(it));
        }
    }

    @Override
    @Nullable
    public File getMultiDexKeepFile() {
        return this.dslInfo.getMultiDexKeepFile();
    }

    @Override
    public boolean isMultiDexEnabled() {
        Boolean bl = this.dslInfo.isMultiDexEnabled();
        return bl != null ? bl : VariantApiExtensionsKt.getFeatureLevel(this.component.getMinSdkVersion()) >= 21;
    }

    @Override
    public boolean getNeedsMainDexListForBundle() {
        return this.component.getComponentType().isBaseModule() && this.component.getGlobal().getHasDynamicFeatures() && this.getDexingType().getNeedsMainDexList();
    }

    @Override
    public boolean getShouldPackageDesugarLibDex() {
        ApkCreationConfig apkCreationConfig = this.component;
        return apkCreationConfig instanceof AndroidTestCreationConfig ? (!this.isCoreLibraryDesugaringEnabled() ? false : (((AndroidTestCreationConfig)this.component).getMainVariant().getComponentType().isAar() ? true : ((AndroidTestCreationConfig)this.component).getMainVariant().getComponentType().isBaseModule() && this.getNeedsShrinkDesugarLibrary())) : (apkCreationConfig instanceof DynamicFeatureCreationConfig ? false : this.isCoreLibraryDesugaringEnabled());
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public DexingType getDexingType() {
        DexingType dexingType;
        if (this.component instanceof DynamicFeatureCreationConfig) {
            dexingType = DexingType.NATIVE_MULTIDEX;
            return dexingType;
        }
        if (!this.isMultiDexEnabled()) {
            dexingType = DexingType.MONO_DEX;
            return dexingType;
        }
        if (VariantApiExtensionsKt.getFeatureLevel(this.component.getMinSdkVersion()) < 21) {
            boolean bl;
            Integer n = this.dslInfo.getTargetDeployApiFromIDE();
            if (n != null) {
                int it = ((Number)n).intValue();
                boolean bl2 = false;
                bl = it >= 21;
            } else {
                bl = false;
            }
            if (!bl) {
                dexingType = DexingType.LEGACY_MULTIDEX;
                return dexingType;
            }
        }
        dexingType = DexingType.NATIVE_MULTIDEX;
        return dexingType;
    }

    @Override
    @NotNull
    public Java8LangSupport getJava8LangSupportType() {
        return !this.component.getGlobal().getCompileOptions().getTargetCompatibility().isJava8Compatible() ? Java8LangSupport.UNUSED : (this.component.getServices().getProjectInfo().hasPlugin("me.tatarka.retrolambda") ? Java8LangSupport.RETROLAMBDA : (this.component.getOptimizationCreationConfig().getMinifiedEnabled() ? Java8LangSupport.R8 : Java8LangSupport.D8));
    }

    @Override
    public boolean getNeedsShrinkDesugarLibrary() {
        if (!this.isCoreLibraryDesugaringEnabled()) {
            return false;
        }
        return this.getJava8LangSupportType() != Java8LangSupport.D8 || !this.component.getDebuggable();
    }

    @Override
    public boolean isCoreLibraryDesugaringEnabled() {
        boolean langDesugarEnabled;
        if (this.component instanceof AndroidTestCreationConfig && this.component.getServices().getProjectOptions().get(BooleanOption.ENABLE_INSTRUMENTATION_TEST_DESUGARING)) {
            return true;
        }
        boolean libDesugarEnabled = this.component.getGlobal().getCompileOptions().isCoreLibraryDesugaringEnabled();
        Java8LangSupport langSupportType = this.getJava8LangSupportType();
        boolean bl = langDesugarEnabled = langSupportType == Java8LangSupport.D8 || langSupportType == Java8LangSupport.R8;
        if (libDesugarEnabled && !langDesugarEnabled) {
            IssueReporter.reportError$default((IssueReporter)this.component.getServices().getIssueReporter(), (IssueReporter.Type)IssueReporter.Type.GENERIC, (String)"In order to use core library desugaring, please enable java 8 language desugaring with D8 or R8.", null, null, (int)12, null);
        }
        if (libDesugarEnabled && !this.isMultiDexEnabled()) {
            IssueReporter.reportError$default((IssueReporter)this.component.getServices().getIssueReporter(), (IssueReporter.Type)IssueReporter.Type.GENERIC, (String)"In order to use core library desugaring, please enable multidex.", null, null, (int)12, null);
        }
        return libDesugarEnabled;
    }

    @Override
    @NotNull
    public AndroidVersion getMinSdkVersionForDexing() {
        Integer n = this.dslInfo.getTargetDeployApiFromIDE();
        int targetDeployApiFromIDE = n != null ? n : 1;
        int minForDexing = targetDeployApiFromIDE >= 24 ? Math.max(24, VariantApiExtensionsKt.getFeatureLevel(this.component.getMinSdkVersion())) : VariantApiExtensionsKt.getFeatureLevel(this.component.getMinSdkVersion());
        return new AndroidVersionImpl(minForDexing, null, 2, null);
    }
}

