/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.core.dsl.impl.features;

import com.android.build.api.dsl.ApplicationBuildType;
import com.android.build.api.dsl.BuildType;
import com.android.build.gradle.internal.core.MergedFlavor;
import com.android.build.gradle.internal.core.dsl.features.DexingDslInfo;
import com.android.build.gradle.internal.services.BaseServices;
import com.android.build.gradle.options.IntegerOption;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\u0004\u0018\u00010\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\u0004\u0018\u00010\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\u0004\u0018\u00010\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u0016\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0017"}, d2={"Lcom/android/build/gradle/internal/core/dsl/impl/features/DexingDslInfoImpl;", "Lcom/android/build/gradle/internal/core/dsl/features/DexingDslInfo;", "buildTypeObj", "Lcom/android/build/api/dsl/BuildType;", "mergedFlavor", "Lcom/android/build/gradle/internal/core/MergedFlavor;", "services", "Lcom/android/build/gradle/internal/services/BaseServices;", "(Lcom/android/build/api/dsl/BuildType;Lcom/android/build/gradle/internal/core/MergedFlavor;Lcom/android/build/gradle/internal/services/BaseServices;)V", "isMultiDexEnabled", "", "()Ljava/lang/Boolean;", "multiDexKeepFile", "Ljava/io/File;", "getMultiDexKeepFile", "()Ljava/io/File;", "multiDexKeepProguard", "getMultiDexKeepProguard", "targetDeployApiFromIDE", "", "getTargetDeployApiFromIDE", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "gradle-core"})
public final class DexingDslInfoImpl
implements DexingDslInfo {
    @NotNull
    private final BuildType buildTypeObj;
    @NotNull
    private final MergedFlavor mergedFlavor;
    @NotNull
    private final BaseServices services;
    @Nullable
    private final Integer targetDeployApiFromIDE;

    public DexingDslInfoImpl(@NotNull BuildType buildTypeObj, @NotNull MergedFlavor mergedFlavor2, @NotNull BaseServices services) {
        Intrinsics.checkNotNullParameter((Object)buildTypeObj, (String)"buildTypeObj");
        Intrinsics.checkNotNullParameter((Object)mergedFlavor2, (String)"mergedFlavor");
        Intrinsics.checkNotNullParameter((Object)services, (String)"services");
        this.buildTypeObj = buildTypeObj;
        this.mergedFlavor = mergedFlavor2;
        this.services = services;
        this.targetDeployApiFromIDE = this.services.getProjectOptions().get(IntegerOption.IDE_TARGET_DEVICE_API);
    }

    @Override
    @Nullable
    public Boolean isMultiDexEnabled() {
        BuildType buildType = this.buildTypeObj;
        Object object = buildType instanceof ApplicationBuildType ? (ApplicationBuildType)buildType : null;
        if (object == null || (object = object.getMultiDexEnabled()) == null) {
            object = this.mergedFlavor.getMultiDexEnabled();
        }
        return object;
    }

    @Override
    @Nullable
    public File getMultiDexKeepProguard() {
        File value = this.buildTypeObj.getMultiDexKeepProguard();
        if (value != null) {
            return value;
        }
        value = this.mergedFlavor.getMultiDexKeepProguard();
        return value;
    }

    @Override
    @Nullable
    public File getMultiDexKeepFile() {
        File value = this.buildTypeObj.getMultiDexKeepFile();
        if (value != null) {
            return value;
        }
        value = this.mergedFlavor.getMultiDexKeepFile();
        return value;
    }

    @Override
    @Nullable
    public Integer getTargetDeployApiFromIDE() {
        return this.targetDeployApiFromIDE;
    }
}

