/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.api.artifact.Artifact;
import com.android.build.api.artifact.ArtifactTransformationRequest;
import com.android.build.api.artifact.InAndOutDirectoryOperationRequest;
import com.android.build.api.artifact.SingleArtifact;
import com.android.build.gradle.internal.component.ApkCreationConfig;
import com.android.build.gradle.internal.component.features.AndroidResourcesCreationConfig;
import com.android.build.gradle.internal.profile.AnalyticsService;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.tasks.BuildAnalyzer;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.tasks.PackageAndroidArtifact;
import com.android.build.gradle.tasks.PackageApplication;
import com.android.buildanalyzer.common.TaskCategory;
import com.google.wireless.android.sdk.stats.GradleBuildProject;
import com.google.wireless.android.sdk.stats.GradleBuildProjectMetrics;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.file.Directory;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.work.DisableCachingByDefault;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@DisableCachingByDefault
@BuildAnalyzer(primaryTaskCategory=TaskCategory.APK_PACKAGING)
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b'\u0018\u0000 \u00062\u00020\u0001:\u0002\u0006\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00000\u0004H\u0017R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00000\u0004X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/android/build/gradle/tasks/PackageApplication;", "Lcom/android/build/gradle/tasks/PackageAndroidArtifact;", "()V", "transformationRequest", "Lcom/android/build/api/artifact/ArtifactTransformationRequest;", "getTransformationRequest", "Companion", "CreationAction", "gradle-core"})
public abstract class PackageApplication
extends PackageAndroidArtifact {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private ArtifactTransformationRequest<PackageApplication> transformationRequest;

    @Internal
    @NotNull
    public ArtifactTransformationRequest<PackageApplication> getTransformationRequest() {
        ArtifactTransformationRequest<PackageApplication> artifactTransformationRequest = this.transformationRequest;
        if (artifactTransformationRequest == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"transformationRequest");
            artifactTransformationRequest = null;
        }
        return artifactTransformationRequest;
    }

    @JvmStatic
    public static final void recordMetrics(@Nullable String projectPath, @Nullable File apkOutputFile, @Nullable File resourcesApFile, @NotNull AnalyticsService analyticsService) {
        Companion.recordMetrics(projectPath, apkOutputFile, resourcesApFile, analyticsService);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B1\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0011\u001a\u00020\u0002H\u0014J\u0016\u0010\u001a\u001a\u00020\u00192\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00020\u001cH\u0016R\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001d"}, d2={"Lcom/android/build/gradle/tasks/PackageApplication$CreationAction;", "Lcom/android/build/gradle/tasks/PackageAndroidArtifact$CreationAction;", "Lcom/android/build/gradle/tasks/PackageApplication;", "creationConfig", "Lcom/android/build/gradle/internal/component/ApkCreationConfig;", "outputDirectory", "Ljava/io/File;", "manifests", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/Directory;", "manifestType", "Lcom/android/build/api/artifact/Artifact;", "(Lcom/android/build/gradle/internal/component/ApkCreationConfig;Ljava/io/File;Lorg/gradle/api/provider/Provider;Lcom/android/build/api/artifact/Artifact;)V", "name", "", "getName", "()Ljava/lang/String;", "task", "transformationRequest", "Lcom/android/build/api/artifact/ArtifactTransformationRequest;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "finalConfigure", "", "handleProvider", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "gradle-core"})
    public static final class CreationAction
    extends PackageAndroidArtifact.CreationAction<PackageApplication> {
        @NotNull
        private final File outputDirectory;
        @Nullable
        private ArtifactTransformationRequest<PackageApplication> transformationRequest;
        @Nullable
        private PackageApplication task;

        public CreationAction(@NotNull ApkCreationConfig creationConfig, @NotNull File outputDirectory, @NotNull Provider<Directory> manifests2, @NotNull Artifact<Directory> manifestType) {
            Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
            Intrinsics.checkNotNullParameter((Object)outputDirectory, (String)"outputDirectory");
            Intrinsics.checkNotNullParameter(manifests2, (String)"manifests");
            Intrinsics.checkNotNullParameter(manifestType, (String)"manifestType");
            super(creationConfig, manifests2, manifestType);
            this.outputDirectory = outputDirectory;
        }

        @Override
        @NotNull
        public String getName() {
            return VariantTaskCreationAction.computeTaskName$default(this, "package", null, 2, null);
        }

        @Override
        @NotNull
        public Class<PackageApplication> getType() {
            return PackageApplication.class;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<PackageApplication> taskProvider) {
            Intrinsics.checkNotNullParameter(taskProvider, (String)"taskProvider");
            super.handleProvider(taskProvider);
            ((ApkCreationConfig)this.creationConfig).getTaskContainer().setPackageAndroidTask(taskProvider);
            boolean useOptimizedResources = !((ApkCreationConfig)this.creationConfig).getDebuggable() && !((ApkCreationConfig)this.creationConfig).getComponentType().isForTesting() && ((ApkCreationConfig)this.creationConfig).getServices().getProjectOptions().get(BooleanOption.ENABLE_RESOURCE_OPTIMIZATIONS);
            AndroidResourcesCreationConfig androidResourcesCreationConfig2 = ((ApkCreationConfig)this.creationConfig).getAndroidResourcesCreationConfig();
            boolean useResourcesShrinker = androidResourcesCreationConfig2 != null ? androidResourcesCreationConfig2.getUseResourceShrinker() : false;
            InAndOutDirectoryOperationRequest operationRequest2 = ((ApkCreationConfig)this.creationConfig).getArtifacts().use((TaskProvider)taskProvider).wiredWithDirectories(handleProvider.operationRequest.1.INSTANCE, handleProvider.operationRequest.2.INSTANCE);
            this.transformationRequest = useOptimizedResources ? (ArtifactTransformationRequest)operationRequest2.toTransformMany((Artifact.Single)InternalArtifactType.OPTIMIZED_PROCESSED_RES.INSTANCE, (Artifact.Single)SingleArtifact.APK.INSTANCE, this.outputDirectory.getAbsolutePath()) : (useResourcesShrinker ? (ArtifactTransformationRequest)operationRequest2.toTransformMany((Artifact.Single)InternalArtifactType.SHRUNK_PROCESSED_RES.INSTANCE, (Artifact.Single)SingleArtifact.APK.INSTANCE, this.outputDirectory.getAbsolutePath()) : (ArtifactTransformationRequest)operationRequest2.toTransformMany((Artifact.Single)InternalArtifactType.PROCESSED_RES.INSTANCE, (Artifact.Single)SingleArtifact.APK.INSTANCE, this.outputDirectory.getAbsolutePath()));
            ArtifactTransformationRequest<PackageApplication> artifactTransformationRequest = this.transformationRequest;
            if (artifactTransformationRequest != null) {
                ArtifactTransformationRequest<PackageApplication> it = artifactTransformationRequest;
                boolean bl = false;
                PackageApplication packageApplication = this.task;
                if (packageApplication != null) {
                    PackageApplication t = packageApplication;
                    boolean bl2 = false;
                    t.transformationRequest = it;
                }
            }
            ((ApkCreationConfig)this.creationConfig).getArtifacts().setInitialProvider(taskProvider, handleProvider.2.INSTANCE).atLocation(this.outputDirectory).withName("output-metadata.json").on(InternalArtifactType.APK_IDE_MODEL.INSTANCE);
        }

        @Override
        protected void finalConfigure(@NotNull PackageApplication task) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)task, (String)"task");
                super.finalConfigure((PackageAndroidArtifact)task);
                this.task = task;
                ArtifactTransformationRequest<PackageApplication> artifactTransformationRequest = this.transformationRequest;
                if (artifactTransformationRequest == null) break block0;
                ArtifactTransformationRequest<PackageApplication> it = artifactTransformationRequest;
                boolean bl = false;
                task.transformationRequest = it;
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002\u00a2\u0006\u0002\u0010\u0007J.\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u00062\b\u0010\r\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0007\u00a8\u0006\u0010"}, d2={"Lcom/android/build/gradle/tasks/PackageApplication$Companion;", "", "()V", "getSize", "", "file", "Ljava/io/File;", "(Ljava/io/File;)Ljava/lang/Long;", "recordMetrics", "", "projectPath", "", "apkOutputFile", "resourcesApFile", "analyticsService", "Lcom/android/build/gradle/internal/profile/AnalyticsService;", "gradle-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void recordMetrics(@Nullable String projectPath, @Nullable File apkOutputFile, @Nullable File resourcesApFile, @NotNull AnalyticsService analyticsService) {
            block2: {
                Long resourcesApSize;
                Intrinsics.checkNotNullParameter((Object)analyticsService, (String)"analyticsService");
                long metricsStartTime = System.nanoTime();
                GradleBuildProjectMetrics.Builder metrics = GradleBuildProjectMetrics.newBuilder();
                Long apkSize = this.getSize(apkOutputFile);
                if (apkSize != null) {
                    metrics.setApkSize(apkSize.longValue());
                }
                if ((resourcesApSize = this.getSize(resourcesApFile)) != null) {
                    metrics.setResourcesApSize(resourcesApSize.longValue());
                }
                metrics.setMetricsTimeNs(System.nanoTime() - metricsStartTime);
                String string = projectPath;
                Intrinsics.checkNotNull((Object)string);
                GradleBuildProject.Builder builder = analyticsService.getProjectBuillder(string);
                if (builder == null) break block2;
                builder.setMetrics(metrics);
            }
        }

        private final Long getSize(File file) {
            Long l;
            if (file == null) {
                l = null;
            } else {
                Long l2;
                try {
                    l2 = Files.size(file.toPath());
                }
                catch (IOException e) {
                    l2 = null;
                }
                l = l2;
            }
            return l;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

