/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.tasks.BuildAnalyzer;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.tasks.ProcessLibraryArtProfileTask;
import com.android.buildanalyzer.common.TaskCategory;
import com.android.tools.profgen.Diagnostics;
import com.android.tools.profgen.HumanReadableProfileKt;
import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Task;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.work.DisableCachingByDefault;
import org.jetbrains.annotations.NotNull;

@DisableCachingByDefault
@BuildAnalyzer(primaryTaskCategory=TaskCategory.ART_PROFILE)
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\b'\u0018\u00002\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH\u0015R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\f"}, d2={"Lcom/android/build/gradle/tasks/ProcessLibraryArtProfileTask;", "Lcom/android/build/gradle/internal/tasks/NonIncrementalTask;", "()V", "outputFile", "Lorg/gradle/api/file/RegularFileProperty;", "getOutputFile", "()Lorg/gradle/api/file/RegularFileProperty;", "profileSource", "getProfileSource", "doTaskAction", "", "CreationAction", "gradle-core"})
public abstract class ProcessLibraryArtProfileTask
extends NonIncrementalTask {
    @InputFiles
    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    @NotNull
    public abstract RegularFileProperty getProfileSource();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutputFile();

    @Override
    @TaskAction
    protected void doTaskAction() {
        File sourceFile = ((RegularFile)this.getProfileSource().get()).getAsFile();
        if (sourceFile.isFile()) {
            Intrinsics.checkNotNullExpressionValue((Object)sourceFile, (String)"sourceFile");
            HumanReadableProfileKt.HumanReadableProfile(sourceFile, new Diagnostics(sourceFile){
                final /* synthetic */ File $sourceFile;
                {
                    this.$sourceFile = $sourceFile;
                }

                public final void onError(@NotNull String it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    throw new RuntimeException("Error while parsing " + this.$sourceFile.getAbsolutePath() + " : " + it);
                }
            });
            File file = ((RegularFile)this.getOutputFile().get()).getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"outputFile.get().asFile");
            FilesKt.copyTo$default((File)sourceFile, (File)file, (boolean)true, (int)0, (int)4, null);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\u0016\u0010\u0011\u001a\u00020\u000f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u0013H\u0016R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0014"}, d2={"Lcom/android/build/gradle/tasks/ProcessLibraryArtProfileTask$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/tasks/ProcessLibraryArtProfileTask;", "Lcom/android/build/gradle/internal/component/ComponentCreationConfig;", "creationConfig", "(Lcom/android/build/gradle/internal/component/ComponentCreationConfig;)V", "name", "", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "handleProvider", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "gradle-core"})
    public static final class CreationAction
    extends VariantTaskCreationAction<ProcessLibraryArtProfileTask, ComponentCreationConfig> {
        public CreationAction(@NotNull ComponentCreationConfig creationConfig) {
            Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
            super(creationConfig);
        }

        @Override
        @NotNull
        public String getName() {
            return this.creationConfig.computeTaskName("prepare", "ArtProfile");
        }

        @Override
        @NotNull
        public Class<ProcessLibraryArtProfileTask> getType() {
            return ProcessLibraryArtProfileTask.class;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<ProcessLibraryArtProfileTask> taskProvider) {
            Intrinsics.checkNotNullParameter(taskProvider, (String)"taskProvider");
            super.handleProvider(taskProvider);
            this.creationConfig.getArtifacts().setInitialProvider(taskProvider, (Function1)handleProvider.1.INSTANCE).on(InternalArtifactType.LIBRARY_ART_PROFILE.INSTANCE);
        }

        @Override
        public void configure(@NotNull ProcessLibraryArtProfileTask task) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            super.configure((Task)task);
            task.getProfileSource().fileProvider(this.creationConfig.getSources().getArtProfile());
            task.getProfileSource().disallowChanges();
        }
    }
}

