/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.utils;

import com.android.build.gradle.internal.utils.ComponentPath;
import com.android.build.gradle.internal.utils.DependencyInfo;
import com.android.build.gradle.internal.utils.ResolutionResultUtils;
import com.android.ide.common.repository.GradleVersion;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.result.ResolutionResult;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.jetbrains.annotations.NotNull;

@VisibleForTesting
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\b\u0001\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/android/build/gradle/internal/utils/ViolatingPluginDetector;", "", "buildscriptClasspath", "Lorg/gradle/api/artifacts/result/ResolutionResult;", "pluginToSearch", "Lcom/android/build/gradle/internal/utils/DependencyInfo;", "projectDisplayName", "", "(Lorg/gradle/api/artifacts/result/ResolutionResult;Lcom/android/build/gradle/internal/utils/DependencyInfo;Ljava/lang/String;)V", "detect", "", "Companion", "gradle-core"})
@SourceDebugExtension(value={"SMAP\nGradlePluginUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradlePluginUtils.kt\ncom/android/build/gradle/internal/utils/ViolatingPluginDetector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,261:1\n1603#2,9:262\n1855#2:271\n1856#2:273\n1612#2:274\n1#3:272\n*S KotlinDebug\n*F\n+ 1 GradlePluginUtils.kt\ncom/android/build/gradle/internal/utils/ViolatingPluginDetector\n*L\n201#1:262,9\n201#1:271\n201#1:273\n201#1:274\n201#1:272\n*E\n"})
public final class ViolatingPluginDetector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ResolutionResult buildscriptClasspath;
    @NotNull
    private final DependencyInfo pluginToSearch;
    @NotNull
    private final String projectDisplayName;
    @NotNull
    private static final String SAFE_ARGS_2_3_1 = "androidx.navigation:navigation-safe-args-gradle-plugin:2.3.1";

    public ViolatingPluginDetector(@NotNull ResolutionResult buildscriptClasspath, @NotNull DependencyInfo pluginToSearch, @NotNull String projectDisplayName) {
        Intrinsics.checkNotNullParameter((Object)buildscriptClasspath, (String)"buildscriptClasspath");
        Intrinsics.checkNotNullParameter((Object)pluginToSearch, (String)"pluginToSearch");
        Intrinsics.checkNotNullParameter((Object)projectDisplayName, (String)"projectDisplayName");
        this.buildscriptClasspath = buildscriptClasspath;
        this.pluginToSearch = pluginToSearch;
        this.projectDisplayName = projectDisplayName;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> detect() {
        void $this$mapNotNullTo$iv$iv;
        List<ResolvedComponentResult> violatingPlugins2 = ResolutionResultUtils.getModuleComponents(this.buildscriptClasspath, (Function1<? super ModuleComponentIdentifier, Boolean>)((Function1)new Function1<ModuleComponentIdentifier, Boolean>(this){
            final /* synthetic */ ViolatingPluginDetector this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull ModuleComponentIdentifier moduleComponentId) {
                GradleVersion parsedVersion;
                Intrinsics.checkNotNullParameter((Object)moduleComponentId, (String)"moduleComponentId");
                return Intrinsics.areEqual((Object)moduleComponentId.getGroup(), (Object)ViolatingPluginDetector.access$getPluginToSearch$p(this.this$0).getDependencyGroup()) && Intrinsics.areEqual((Object)moduleComponentId.getModule(), (Object)ViolatingPluginDetector.access$getPluginToSearch$p(this.this$0).getDependencyName()) ? (parsedVersion = GradleVersion.tryParse((String)moduleComponentId.getVersion())) != null && parsedVersion.compareTo(ViolatingPluginDetector.access$getPluginToSearch$p(this.this$0).getMinimumVersion()) < 0 : false;
            }
        }));
        Iterable $this$mapNotNull$iv = violatingPlugins2;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            String it$iv$iv;
            String string;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            ResolvedComponentResult component2 = (ResolvedComponentResult)element$iv$iv;
            boolean bl2 = false;
            String it = string = ComponentPath.getPathString$default(ResolutionResultUtils.getPathToComponent(this.buildscriptClasspath, component2), this.projectDisplayName, null, 2, null);
            boolean bl3 = false;
            if ((!StringsKt.contains$default((CharSequence)it, (CharSequence)SAFE_ARGS_2_3_1, (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)it, (String)SAFE_ARGS_2_3_1, (boolean)false, (int)2, null) ? string : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static final /* synthetic */ DependencyInfo access$getPluginToSearch$p(ViolatingPluginDetector $this) {
        return $this.pluginToSearch;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/android/build/gradle/internal/utils/ViolatingPluginDetector$Companion;", "", "()V", "SAFE_ARGS_2_3_1", "", "gradle-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

