/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.api.artifact.impl.ArtifactsImpl;
import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.profile.AnalyticsService;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.services.BuildServicesKt;
import com.android.build.gradle.internal.tasks.factory.TaskCreationAction;
import com.android.build.gradle.tasks.JavaCompileCreationAction;
import com.android.build.gradle.tasks.JavaCompileKt;
import com.android.build.gradle.tasks.JavaCompileOptionsForRoom;
import com.android.build.gradle.tasks.JavaCompileUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.provider.Provider;
import org.gradle.api.services.BuildServiceRegistry;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.jvm.toolchain.JavaToolchainService;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0002H\u0016J\u0016\u0010\u001a\u001a\u00020\u00182\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00020\u001cH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/android/build/gradle/tasks/JavaCompileCreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/TaskCreationAction;", "Lorg/gradle/api/tasks/compile/JavaCompile;", "creationConfig", "Lcom/android/build/gradle/internal/component/ComponentCreationConfig;", "objectFactory", "Lorg/gradle/api/model/ObjectFactory;", "usingKapt", "", "(Lcom/android/build/gradle/internal/component/ComponentCreationConfig;Lorg/gradle/api/model/ObjectFactory;Z)V", "dataBindingArtifactDir", "Lorg/gradle/api/file/DirectoryProperty;", "kotlin.jvm.PlatformType", "dataBindingExportClassListFile", "Lorg/gradle/api/file/RegularFileProperty;", "name", "", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "handleProvider", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "gradle-core"})
@SourceDebugExtension(value={"SMAP\nJavaCompile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaCompile.kt\ncom/android/build/gradle/tasks/JavaCompileCreationAction\n+ 2 buildServices.kt\ncom/android/build/gradle/internal/services/BuildServicesKt\n*L\n1#1,294:1\n67#2:295\n*S KotlinDebug\n*F\n+ 1 JavaCompile.kt\ncom/android/build/gradle/tasks/JavaCompileCreationAction\n*L\n149#1:295\n*E\n"})
public final class JavaCompileCreationAction
extends TaskCreationAction<JavaCompile> {
    @NotNull
    private final ComponentCreationConfig creationConfig;
    private final boolean usingKapt;
    private final DirectoryProperty dataBindingArtifactDir;
    private final RegularFileProperty dataBindingExportClassListFile;

    public JavaCompileCreationAction(@NotNull ComponentCreationConfig creationConfig, @NotNull ObjectFactory objectFactory, boolean usingKapt) {
        Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
        Intrinsics.checkNotNullParameter((Object)objectFactory, (String)"objectFactory");
        this.creationConfig = creationConfig;
        this.usingKapt = usingKapt;
        this.dataBindingArtifactDir = objectFactory.directoryProperty();
        this.dataBindingExportClassListFile = objectFactory.fileProperty();
    }

    @Override
    @NotNull
    public String getName() {
        return this.creationConfig.computeTaskName("compile", "JavaWithJavac");
    }

    @Override
    @NotNull
    public Class<JavaCompile> getType() {
        return JavaCompile.class;
    }

    @Override
    public void handleProvider(@NotNull TaskProvider<JavaCompile> taskProvider) {
        Intrinsics.checkNotNullParameter(taskProvider, (String)"taskProvider");
        super.handleProvider(taskProvider);
        this.creationConfig.getTaskContainer().setJavacTask(taskProvider);
        ArtifactsImpl artifacts2 = this.creationConfig.getArtifacts();
        artifacts2.setInitialProvider(taskProvider, handleProvider.1.INSTANCE).withName("classes").on(InternalArtifactType.JAVAC.INSTANCE);
        artifacts2.setInitialProvider(taskProvider, handleProvider.2.INSTANCE).withName("out").on(InternalArtifactType.AP_GENERATED_SOURCES.INSTANCE);
        if (this.creationConfig.getBuildFeatures().getDataBinding()) {
            DirectoryProperty directoryProperty = this.dataBindingArtifactDir;
            Intrinsics.checkNotNullExpressionValue((Object)directoryProperty, (String)"dataBindingArtifactDir");
            RegularFileProperty regularFileProperty = this.dataBindingExportClassListFile;
            Intrinsics.checkNotNullExpressionValue((Object)regularFileProperty, (String)"dataBindingExportClassListFile");
            JavaCompileKt.registerDataBindingOutputs(directoryProperty, regularFileProperty, this.creationConfig.getComponentType().isExportDataBindingClassList(), taskProvider, artifacts2, true);
        }
    }

    @Override
    public void configure(@NotNull JavaCompile task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Object[] objectArray = new Object[]{this.creationConfig.getTaskContainer().getPreBuildTask()};
        task.dependsOn(objectArray);
        task.getExtensions().add("AGP_VARIANT_NAME", (Object)this.creationConfig.getName());
        Object[] it = (Object[])task.getProject().getExtensions().getByType(JavaPluginExtension.class);
        boolean bl = false;
        if (it.getToolchain().getLanguageVersion().isPresent()) {
            JavaToolchainService toolchainService = (JavaToolchainService)task.getProject().getExtensions().getByType(JavaToolchainService.class);
            task.getJavaCompiler().set(toolchainService.compilerFor(it.getToolchain()));
        }
        JavaCompileUtils.configureProperties(task, this.creationConfig);
        JavaCompileUtils.configurePropertiesForAnnotationProcessing(task, this.creationConfig);
        task.setSource(JavaCompileKt.computeJavaSourceWithoutDependencies(this.creationConfig));
        task.getOptions().getCompilerArgumentProviders().add(new JavaCompileOptionsForRoom(this.creationConfig.getArtifacts().get(InternalArtifactType.ANNOTATION_PROCESSOR_LIST.INSTANCE), this.creationConfig.getGlobal().getCompileOptions().getTargetCompatibility().isJava8Compatible()));
        Boolean bl2 = this.creationConfig.getGlobal().getCompileOptionsIncremental();
        task.getOptions().setIncremental(bl2 != null ? bl2 : true);
        Provider apList = this.creationConfig.getArtifacts().get(InternalArtifactType.ANNOTATION_PROCESSOR_LIST.INSTANCE);
        it = new Object[]{apList};
        task.getInputs().files(it).withPathSensitivity(PathSensitivity.NONE).withPropertyName("annotationProcessorList");
        BuildServiceRegistry buildServiceRegistry$iv = this.creationConfig.getServices().getBuildServiceRegistry();
        boolean $i$f$getBuildService = false;
        JavaCompileKt.access$recordAnnotationProcessors(task, apList, this.creationConfig.getName(), BuildServicesKt.getBuildService(buildServiceRegistry$iv, AnalyticsService.class));
        if (this.creationConfig.getBuildFeatures().getDataBinding() && !this.usingKapt) {
            task.getOutputs().dir((Object)this.dataBindingArtifactDir).withPropertyName("dataBindingArtifactDir");
            if (this.creationConfig.getComponentType().isExportDataBindingClassList()) {
                task.getOutputs().file((Object)this.dataBindingExportClassListFile).withPropertyName("dataBindingExportClassListFile");
            }
        }
        task.getLogger().debug("Configuring Java sources compilation for '" + task.getName() + "' with source level " + task.getSourceCompatibility() + " and target level " + task.getTargetCompatibility() + ".");
    }
}

