/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.AvdComponentsBuildService;
import com.android.build.gradle.internal.ManagedDeviceUtilsKt;
import com.android.build.gradle.internal.SdkComponentsBuildService;
import com.android.build.gradle.internal.dsl.ManagedVirtualDevice;
import com.android.build.gradle.internal.profile.AnalyticsService;
import com.android.build.gradle.internal.profile.ProfileAwareWorkAction;
import com.android.build.gradle.internal.services.BuildServicesKt;
import com.android.build.gradle.internal.tasks.BuildAnalyzer;
import com.android.build.gradle.internal.tasks.NonIncrementalGlobalTask;
import com.android.build.gradle.internal.tasks.factory.GlobalTaskCreationAction;
import com.android.build.gradle.internal.tasks.factory.GlobalTaskCreationConfig;
import com.android.build.gradle.internal.testing.utp.ManagedDeviceImageSuggestionGenerator;
import com.android.build.gradle.internal.utils.HasConfigurableValuesKt;
import com.android.buildanalyzer.common.TaskCategory;
import com.android.repository.Revision;
import com.android.testing.utils.SystemImageHashUtilsKt;
import com.android.utils.ComputerArchUtilsKt;
import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.services.BuildServiceRegistry;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.work.DisableCachingByDefault;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@DisableCachingByDefault
@BuildAnalyzer(primaryTaskCategory=TaskCategory.TEST)
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\b'\u0018\u0000 -2\u00020\u0001:\u0004*+,-B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010&\u001a\u00020'H\u0014J\b\u0010(\u001a\u00020'H\u0002J\b\u0010)\u001a\u00020'H\u0002R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\bR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\bR\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\bR\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\bR\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\r0\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\bR\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00150\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\bR\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\r0\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\bR\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\r0\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\bR\u001a\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\r0\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\bR\u001a\u0010!\u001a\b\u0012\u0004\u0012\u00020\r0\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\bR\u001a\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010\b\u00a8\u0006."}, d2={"Lcom/android/build/gradle/internal/tasks/ManagedDeviceInstrumentationTestSetupTask;", "Lcom/android/build/gradle/internal/tasks/NonIncrementalGlobalTask;", "<init>", "()V", "sdkService", "Lorg/gradle/api/provider/Property;", "Lcom/android/build/gradle/internal/SdkComponentsBuildService;", "getSdkService", "()Lorg/gradle/api/provider/Property;", "avdService", "Lcom/android/build/gradle/internal/AvdComponentsBuildService;", "getAvdService", "compileSdkVersion", "", "getCompileSdkVersion", "buildToolsRevision", "Lcom/android/repository/Revision;", "getBuildToolsRevision", "abi", "getAbi", "sdkVersion", "", "getSdkVersion", "systemImageVendor", "getSystemImageVendor", "sdkExtensionVersion", "getSdkExtensionVersion", "pageAlignmentSuffix", "getPageAlignmentSuffix", "hardwareProfile", "getHardwareProfile", "emulatorGpuFlag", "getEmulatorGpuFlag", "managedDeviceName", "getManagedDeviceName", "require64Bit", "", "getRequire64Bit", "doTaskAction", "", "assertNoTvOrAuto", "assertSourceDoesNotIncludePageAlignment", "ManagedDeviceSetupRunnable", "ManagedDeviceSetupParams", "CreationAction", "Companion", "gradle-core"})
public abstract class ManagedDeviceInstrumentationTestSetupTask
extends NonIncrementalGlobalTask {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Internal
    @NotNull
    public abstract Property<SdkComponentsBuildService> getSdkService();

    @Internal
    @NotNull
    public abstract Property<AvdComponentsBuildService> getAvdService();

    @Input
    @NotNull
    public abstract Property<String> getCompileSdkVersion();

    @Input
    @NotNull
    public abstract Property<Revision> getBuildToolsRevision();

    @Input
    @NotNull
    public abstract Property<String> getAbi();

    @Input
    @NotNull
    public abstract Property<Integer> getSdkVersion();

    @Input
    @NotNull
    public abstract Property<String> getSystemImageVendor();

    @Input
    @Optional
    @NotNull
    public abstract Property<Integer> getSdkExtensionVersion();

    @Input
    @NotNull
    public abstract Property<String> getPageAlignmentSuffix();

    @Input
    @NotNull
    public abstract Property<String> getHardwareProfile();

    @Input
    @NotNull
    public abstract Property<String> getEmulatorGpuFlag();

    @Internal
    @NotNull
    public abstract Property<String> getManagedDeviceName();

    @Internal
    @NotNull
    public abstract Property<Boolean> getRequire64Bit();

    @Override
    protected void doTaskAction() {
        this.assertSourceDoesNotIncludePageAlignment();
        this.assertNoTvOrAuto();
        Function1 function1 = (Function1)new Function1<ManagedDeviceSetupParams, Unit>(this){
            final /* synthetic */ ManagedDeviceInstrumentationTestSetupTask this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(ManagedDeviceSetupParams it) {
                Provider provider2 = (Provider)this.this$0.getProjectPath();
                String string = this.this$0.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                it.initializeWith((Provider<String>)provider2, string, (Provider<AnalyticsService>)((Provider)this.this$0.getAnalyticsService()));
                it.getSdkService().set((Provider)this.this$0.getSdkService());
                it.getCompileSdkVersion().set((Provider)this.this$0.getCompileSdkVersion());
                it.getBuildToolsRevision().set((Provider)this.this$0.getBuildToolsRevision());
                it.getAvdService().set((Provider)this.this$0.getAvdService());
                Property<String> property = it.getDeviceName();
                Object object = this.this$0.getSdkVersion().get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                int n = ((Number)object).intValue();
                Integer n2 = (Integer)this.this$0.getSdkExtensionVersion().getOrNull();
                Object object2 = this.this$0.getSystemImageVendor().get();
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
                String string2 = (String)object2;
                Object object3 = this.this$0.getPageAlignmentSuffix().get();
                Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"get(...)");
                String string3 = (String)object3;
                Object object4 = this.this$0.getAbi().get();
                Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"get(...)");
                String string4 = (String)object4;
                Object object5 = this.this$0.getHardwareProfile().get();
                Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"get(...)");
                property.set((Object)ManagedDeviceUtilsKt.computeAvdName(n, n2, string2, string3, string4, (String)object5));
                it.getHardwareProfile().set((Provider)this.this$0.getHardwareProfile());
                it.getEmulatorGpuFlag().set((Provider)this.this$0.getEmulatorGpuFlag());
                it.getManagedDeviceName().set((Provider)this.this$0.getManagedDeviceName());
                it.getSystemImageVendor().set((Provider)this.this$0.getSystemImageVendor());
                it.getPageAlignmentSuffix().set((Provider)this.this$0.getPageAlignmentSuffix());
                it.getSdkVersion().set((Provider)this.this$0.getSdkVersion());
                it.getSdkExtensionVersion().set((Provider)this.this$0.getSdkExtensionVersion());
                it.getRequire64Bit().set((Provider)this.this$0.getRequire64Bit());
                it.getAbi().set((Provider)this.this$0.getAbi());
            }
        };
        this.getWorkerExecutor().noIsolation().submit(ManagedDeviceSetupRunnable.class, new Action(function1){
            private final /* synthetic */ Function1 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ void execute(Object p0) {
                this.function.invoke(p0);
            }
        });
    }

    private final void assertNoTvOrAuto() {
        Object object = this.getSystemImageVendor().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        if (SystemImageHashUtilsKt.isTvOrAutoSource((String)((String)object))) {
            throw new IllegalStateException(StringsKt.trimIndent((String)("\n                    " + this.getManagedDeviceName().get() + " has a systemImageSource of " + this.getSystemImageVendor().get() + ".\n                    TV and Auto devices are presently not supported with Gradle Managed Devices.\n                ")).toString());
        }
        Object object2 = this.getHardwareProfile().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
        if (SystemImageHashUtilsKt.isTvOrAutoDevice((String)((String)object2))) {
            throw new IllegalStateException(StringsKt.trimIndent((String)("\n                    " + this.getManagedDeviceName().get() + " has a device profile of " + this.getHardwareProfile().get() + ".\n                    TV and Auto devices are presently not supported with Gradle Managed Devices.\n                ")).toString());
        }
    }

    private final void assertSourceDoesNotIncludePageAlignment() {
        Object object = this.getSystemImageVendor().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        String sourcePageAlignment = SystemImageHashUtilsKt.getPageAlignmentSuffix((String)((String)object));
        if (sourcePageAlignment != null) {
            throw new IllegalStateException(StringsKt.trimIndent((String)("\n                    " + this.getManagedDeviceName().get() + " has a systemImageSource = " + this.getSystemImageVendor().get() + ",\n                    The system image source should not include page alignment information\n                    (" + sourcePageAlignment + "). Use the ManagedVirtualDevice.pageAlignment instead.\n                ")).toString());
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JG\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007\u00a2\u0006\u0002\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lcom/android/build/gradle/internal/tasks/ManagedDeviceInstrumentationTestSetupTask$Companion;", "", "<init>", "()V", "generateSystemImageErrorMessage", "", "deviceName", "sdkVersion", "", "extensionVersion", "systemImageSource", "pageAlignmentSuffix", "require64Bit", "", "versionedSdkLoader", "Lcom/android/build/gradle/internal/SdkComponentsBuildService$VersionedSdkLoader;", "(Ljava/lang/String;ILjava/lang/Integer;Ljava/lang/String;Ljava/lang/String;ZLcom/android/build/gradle/internal/SdkComponentsBuildService$VersionedSdkLoader;)Ljava/lang/String;", "gradle-core"})
    public static final class Companion {
        private Companion() {
        }

        @VisibleForTesting
        @NotNull
        public final String generateSystemImageErrorMessage(@NotNull String deviceName, int sdkVersion, @Nullable Integer extensionVersion, @NotNull String systemImageSource, @NotNull String pageAlignmentSuffix, boolean require64Bit, @NotNull SdkComponentsBuildService.VersionedSdkLoader versionedSdkLoader2) {
            Intrinsics.checkNotNullParameter((Object)deviceName, (String)"deviceName");
            Intrinsics.checkNotNullParameter((Object)systemImageSource, (String)"systemImageSource");
            Intrinsics.checkNotNullParameter((Object)pageAlignmentSuffix, (String)"pageAlignmentSuffix");
            Intrinsics.checkNotNullParameter((Object)versionedSdkLoader2, (String)"versionedSdkLoader");
            if (versionedSdkLoader2.getOfflineMode()) {
                return StringsKt.trimIndent((String)("\n                    The system image for " + deviceName + " is not available and Gradle is in offline mode.\n                    Could not download the image or find other compatible images.\n                "));
            }
            List list = versionedSdkLoader2.allSystemImageHashes();
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            List allImages = list;
            return new ManagedDeviceImageSuggestionGenerator(ComputerArchUtilsKt.getOsArchitecture(), deviceName, sdkVersion, extensionVersion, systemImageSource, pageAlignmentSuffix, require64Bit, allImages).getMessage();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001BY\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\n\u001a\u00020\u0004\u0012\u0006\u0010\u000b\u001a\u00020\u0004\u0012\u0006\u0010\f\u001a\u00020\u0004\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012B!\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0015J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0002H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0018R\u000e\u0010\n\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00020\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006 "}, d2={"Lcom/android/build/gradle/internal/tasks/ManagedDeviceInstrumentationTestSetupTask$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/GlobalTaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/ManagedDeviceInstrumentationTestSetupTask;", "name", "", "systemImageSource", "pageAlignmentSuffix", "sdkVersion", "", "sdkExtensionVersion", "abi", "hardwareProfile", "managedDeviceName", "require64Bit", "", "creationConfig", "Lcom/android/build/gradle/internal/tasks/factory/GlobalTaskCreationConfig;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ILjava/lang/Integer;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ZLcom/android/build/gradle/internal/tasks/factory/GlobalTaskCreationConfig;)V", "managedDevice", "Lcom/android/build/gradle/internal/dsl/ManagedVirtualDevice;", "(Ljava/lang/String;Lcom/android/build/gradle/internal/dsl/ManagedVirtualDevice;Lcom/android/build/gradle/internal/tasks/factory/GlobalTaskCreationConfig;)V", "getName", "()Ljava/lang/String;", "Ljava/lang/Integer;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "gradle-core"})
    @SourceDebugExtension(value={"SMAP\nManagedDeviceInstrumentationTestSetupTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ManagedDeviceInstrumentationTestSetupTask.kt\ncom/android/build/gradle/internal/tasks/ManagedDeviceInstrumentationTestSetupTask$CreationAction\n+ 2 buildServices.kt\ncom/android/build/gradle/internal/services/BuildServicesKt\n*L\n1#1,326:1\n78#2:327\n78#2:328\n*S KotlinDebug\n*F\n+ 1 ManagedDeviceInstrumentationTestSetupTask.kt\ncom/android/build/gradle/internal/tasks/ManagedDeviceInstrumentationTestSetupTask$CreationAction\n*L\n268#1:327\n273#1:328\n*E\n"})
    public static final class CreationAction
    extends GlobalTaskCreationAction<ManagedDeviceInstrumentationTestSetupTask> {
        @NotNull
        private final String name;
        @NotNull
        private final String systemImageSource;
        @NotNull
        private final String pageAlignmentSuffix;
        private final int sdkVersion;
        @Nullable
        private final Integer sdkExtensionVersion;
        @NotNull
        private final String abi;
        @NotNull
        private final String hardwareProfile;
        @NotNull
        private final String managedDeviceName;
        private final boolean require64Bit;
        @NotNull
        private final GlobalTaskCreationConfig creationConfig;

        public CreationAction(@NotNull String name, @NotNull String systemImageSource, @NotNull String pageAlignmentSuffix, int sdkVersion, @Nullable Integer sdkExtensionVersion, @NotNull String abi, @NotNull String hardwareProfile, @NotNull String managedDeviceName, boolean require64Bit, @NotNull GlobalTaskCreationConfig creationConfig) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)systemImageSource, (String)"systemImageSource");
            Intrinsics.checkNotNullParameter((Object)pageAlignmentSuffix, (String)"pageAlignmentSuffix");
            Intrinsics.checkNotNullParameter((Object)abi, (String)"abi");
            Intrinsics.checkNotNullParameter((Object)hardwareProfile, (String)"hardwareProfile");
            Intrinsics.checkNotNullParameter((Object)managedDeviceName, (String)"managedDeviceName");
            Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
            this.name = name;
            this.systemImageSource = systemImageSource;
            this.pageAlignmentSuffix = pageAlignmentSuffix;
            this.sdkVersion = sdkVersion;
            this.sdkExtensionVersion = sdkExtensionVersion;
            this.abi = abi;
            this.hardwareProfile = hardwareProfile;
            this.managedDeviceName = managedDeviceName;
            this.require64Bit = require64Bit;
            this.creationConfig = creationConfig;
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        public CreationAction(@NotNull String name, @NotNull ManagedVirtualDevice managedDevice, @NotNull GlobalTaskCreationConfig creationConfig) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)managedDevice, (String)"managedDevice");
            Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
            this(name, managedDevice.getSystemImageSource(), managedDevice.getPageAlignmentSuffix(), managedDevice.getSdkVersion(), managedDevice.getSdkExtensionVersion(), ManagedDeviceUtilsKt.computeAbiFromArchitecture(managedDevice), managedDevice.getDevice(), managedDevice.getName(), managedDevice.getRequire64Bit(), creationConfig);
        }

        @Override
        @NotNull
        public Class<ManagedDeviceInstrumentationTestSetupTask> getType() {
            return ManagedDeviceInstrumentationTestSetupTask.class;
        }

        @Override
        public void configure(@NotNull ManagedDeviceInstrumentationTestSetupTask task) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            super.configure((Task)task);
            BuildServiceRegistry buildServiceRegistry$iv = this.creationConfig.getServices().getBuildServiceRegistry();
            boolean $i$f$getBuildService = false;
            HasConfigurableValuesKt.setDisallowChanges(task.getSdkService(), BuildServicesKt.getBuildService(buildServiceRegistry$iv, SdkComponentsBuildService.class));
            HasConfigurableValuesKt.setDisallowChanges(task.getCompileSdkVersion(), this.creationConfig.getCompileSdkHashString());
            HasConfigurableValuesKt.setDisallowChanges(task.getBuildToolsRevision(), this.creationConfig.getBuildToolsRevision());
            buildServiceRegistry$iv = this.creationConfig.getServices().getBuildServiceRegistry();
            $i$f$getBuildService = false;
            HasConfigurableValuesKt.setDisallowChanges(task.getAvdService(), BuildServicesKt.getBuildService(buildServiceRegistry$iv, AvdComponentsBuildService.class));
            HasConfigurableValuesKt.setDisallowChanges(task.getSystemImageVendor(), this.systemImageSource);
            HasConfigurableValuesKt.setDisallowChanges(task.getPageAlignmentSuffix(), this.pageAlignmentSuffix);
            HasConfigurableValuesKt.setDisallowChanges(task.getSdkVersion(), this.sdkVersion);
            HasConfigurableValuesKt.setDisallowChanges(task.getSdkExtensionVersion(), this.sdkExtensionVersion);
            HasConfigurableValuesKt.setDisallowChanges(task.getAbi(), this.abi);
            HasConfigurableValuesKt.setDisallowChanges(task.getHardwareProfile(), this.hardwareProfile);
            HasConfigurableValuesKt.setDisallowChanges(task.getEmulatorGpuFlag(), ManagedDeviceUtilsKt.computeManagedDeviceEmulatorMode(this.creationConfig.getServices().getProjectOptions()));
            HasConfigurableValuesKt.setDisallowChanges(task.getManagedDeviceName(), this.managedDeviceName);
            HasConfigurableValuesKt.setDisallowChanges(task.getRequire64Bit(), this.require64Bit);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0018\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0018\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\bR\u0018\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\bR\u0018\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\bR\u0018\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\bR\u0018\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\n0\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\bR\u0018\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\n0\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\bR\u0018\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\n0\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\bR\u0018\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\n0\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\bR\u0018\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\n0\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\bR\u0018\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\bR\u0018\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001f0\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\bR\u0018\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010\bR\u0018\u0010&\u001a\b\u0012\u0004\u0012\u00020\n0\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010\b\u00a8\u0006("}, d2={"Lcom/android/build/gradle/internal/tasks/ManagedDeviceInstrumentationTestSetupTask$ManagedDeviceSetupParams;", "Lcom/android/build/gradle/internal/profile/ProfileAwareWorkAction$Parameters;", "<init>", "()V", "sdkService", "Lorg/gradle/api/provider/Property;", "Lcom/android/build/gradle/internal/SdkComponentsBuildService;", "getSdkService", "()Lorg/gradle/api/provider/Property;", "compileSdkVersion", "", "getCompileSdkVersion", "buildToolsRevision", "Lcom/android/repository/Revision;", "getBuildToolsRevision", "avdService", "Lcom/android/build/gradle/internal/AvdComponentsBuildService;", "getAvdService", "deviceName", "getDeviceName", "hardwareProfile", "getHardwareProfile", "emulatorGpuFlag", "getEmulatorGpuFlag", "managedDeviceName", "getManagedDeviceName", "systemImageVendor", "getSystemImageVendor", "pageAlignmentSuffix", "getPageAlignmentSuffix", "sdkVersion", "", "getSdkVersion", "sdkExtensionVersion", "getSdkExtensionVersion", "require64Bit", "", "getRequire64Bit", "abi", "getAbi", "gradle-core"})
    public static abstract class ManagedDeviceSetupParams
    extends ProfileAwareWorkAction.Parameters {
        @NotNull
        public abstract Property<SdkComponentsBuildService> getSdkService();

        @NotNull
        public abstract Property<String> getCompileSdkVersion();

        @NotNull
        public abstract Property<Revision> getBuildToolsRevision();

        @NotNull
        public abstract Property<AvdComponentsBuildService> getAvdService();

        @NotNull
        public abstract Property<String> getDeviceName();

        @NotNull
        public abstract Property<String> getHardwareProfile();

        @NotNull
        public abstract Property<String> getEmulatorGpuFlag();

        @NotNull
        public abstract Property<String> getManagedDeviceName();

        @NotNull
        public abstract Property<String> getSystemImageVendor();

        @NotNull
        public abstract Property<String> getPageAlignmentSuffix();

        @NotNull
        public abstract Property<Integer> getSdkVersion();

        @NotNull
        public abstract Property<Integer> getSdkExtensionVersion();

        @NotNull
        public abstract Property<Boolean> getRequire64Bit();

        @NotNull
        public abstract Property<String> getAbi();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\t"}, d2={"Lcom/android/build/gradle/internal/tasks/ManagedDeviceInstrumentationTestSetupTask$ManagedDeviceSetupRunnable;", "Lcom/android/build/gradle/internal/profile/ProfileAwareWorkAction;", "Lcom/android/build/gradle/internal/tasks/ManagedDeviceInstrumentationTestSetupTask$ManagedDeviceSetupParams;", "<init>", "()V", "run", "", "computeImageHash", "", "gradle-core"})
    public static abstract class ManagedDeviceSetupRunnable
    extends ProfileAwareWorkAction<ManagedDeviceSetupParams> {
        @Override
        public void run() {
            String imageHash;
            SdkComponentsBuildService.VersionedSdkLoader versionedSdkLoader2 = ((SdkComponentsBuildService)((ManagedDeviceSetupParams)this.getParameters()).getSdkService().get()).sdkLoader((Provider<String>)((Provider)((ManagedDeviceSetupParams)this.getParameters()).getCompileSdkVersion()), (Provider<Revision>)((Provider)((ManagedDeviceSetupParams)this.getParameters()).getBuildToolsRevision()));
            Provider<Directory> sdkImageProvider = versionedSdkLoader2.sdkImageDirectoryProvider(imageHash = this.computeImageHash());
            if (!sdkImageProvider.isPresent()) {
                Object object = ((ManagedDeviceSetupParams)this.getParameters()).getManagedDeviceName().get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                String string = (String)object;
                Object object2 = ((ManagedDeviceSetupParams)this.getParameters()).getSdkVersion().get();
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
                int n = ((Number)object2).intValue();
                Integer n2 = (Integer)((ManagedDeviceSetupParams)this.getParameters()).getSdkExtensionVersion().getOrNull();
                Object object3 = ((ManagedDeviceSetupParams)this.getParameters()).getSystemImageVendor().get();
                Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"get(...)");
                String string2 = (String)object3;
                Object object4 = ((ManagedDeviceSetupParams)this.getParameters()).getPageAlignmentSuffix().get();
                Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"get(...)");
                String string3 = (String)object4;
                Object object5 = ((ManagedDeviceSetupParams)this.getParameters()).getRequire64Bit().get();
                Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"get(...)");
                String string4 = Companion.generateSystemImageErrorMessage(string, n, n2, string2, string3, (Boolean)object5, versionedSdkLoader2);
                throw new IllegalStateException(string4.toString());
            }
            versionedSdkLoader2.getEmulatorDirectoryProvider().get();
            AvdComponentsBuildService avdComponentsBuildService = (AvdComponentsBuildService)((ManagedDeviceSetupParams)this.getParameters()).getAvdService().get();
            Object object = ((ManagedDeviceSetupParams)this.getParameters()).getDeviceName().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            String string = (String)object;
            Object object6 = ((ManagedDeviceSetupParams)this.getParameters()).getHardwareProfile().get();
            Intrinsics.checkNotNullExpressionValue((Object)object6, (String)"get(...)");
            avdComponentsBuildService.avdProvider(sdkImageProvider, imageHash, string, (String)object6).get();
            AvdComponentsBuildService avdComponentsBuildService2 = (AvdComponentsBuildService)((ManagedDeviceSetupParams)this.getParameters()).getAvdService().get();
            Object object7 = ((ManagedDeviceSetupParams)this.getParameters()).getDeviceName().get();
            Intrinsics.checkNotNullExpressionValue((Object)object7, (String)"get(...)");
            String string5 = (String)object7;
            Object object8 = ((ManagedDeviceSetupParams)this.getParameters()).getEmulatorGpuFlag().get();
            Intrinsics.checkNotNullExpressionValue((Object)object8, (String)"get(...)");
            avdComponentsBuildService2.ensureLoadableSnapshot(string5, (String)object8);
        }

        private final String computeImageHash() {
            Object object = ((ManagedDeviceSetupParams)this.getParameters()).getSdkVersion().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            int n = ((Number)object).intValue();
            Integer n2 = (Integer)((ManagedDeviceSetupParams)this.getParameters()).getSdkExtensionVersion().getOrNull();
            Object object2 = ((ManagedDeviceSetupParams)this.getParameters()).getSystemImageVendor().get();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
            String string = (String)object2;
            Object object3 = ((ManagedDeviceSetupParams)this.getParameters()).getPageAlignmentSuffix().get();
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"get(...)");
            String string2 = (String)object3;
            Object object4 = ((ManagedDeviceSetupParams)this.getParameters()).getAbi().get();
            Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"get(...)");
            return SystemImageHashUtilsKt.computeSystemImageHashFromDsl((int)n, (Integer)n2, (String)string, (String)string2, (String)((String)object4));
        }
    }
}

