/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.utils;

import com.android.build.api.variant.DeviceSpec;
import com.android.build.gradle.internal.utils.InstallApkUtilsKt;
import com.android.builder.testing.api.DeviceConnector;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.file.Directory;
import org.gradle.api.provider.Provider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u001a<\u0010\n\u001a\u00020\u000b2\u000e\u0010\f\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u00112\u0006\u0010\u0012\u001a\u00020\u0013\u00a8\u0006\u0014"}, d2={"getDeviceSpec", "Lcom/android/build/api/variant/DeviceSpec;", "device", "Lcom/android/builder/testing/api/DeviceConnector;", "getFiles", "", "Ljava/io/File;", "directoryProvider", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/Directory;", "addDexMetadataFiles", "", "dexMetadataDirectory", "apkDirectory", "deviceApiLevel", "", "apkFiles", "", "iLogger", "Lcom/android/utils/ILogger;", "gradle-core"})
public final class InstallApkUtilsKt {
    @NotNull
    public static final DeviceSpec getDeviceSpec(@NotNull DeviceConnector device) {
        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
        DeviceSpec.Builder builder = new DeviceSpec.Builder().setName(device.getName()).setApiLevel(device.getApiLevel()).setCodeName(device.getApiCodeName());
        List list = device.getAbis();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAbis(...)");
        return builder.setAbis(list).setSupportsPrivacySandbox(device.getSupportsPrivacySandbox()).setScreenDensity(device.getDensity()).build();
    }

    @NotNull
    public static final List<File> getFiles(@NotNull Provider<Directory> directoryProvider) {
        Intrinsics.checkNotNullParameter(directoryProvider, (String)"directoryProvider");
        if (directoryProvider.isPresent()) {
            Function1 function1 = getFiles.1.INSTANCE;
            List<File> list = ((Directory)directoryProvider.get()).getAsFileTree().getFiles().stream().filter(new Predicate(function1){
                private final /* synthetic */ Function1 function;
                {
                    Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                    this.function = function;
                }

                public final /* synthetic */ boolean test(Object p0) {
                    return (Boolean)this.function.invoke(p0);
                }
            }).collect(Collectors.toList());
            Intrinsics.checkNotNullExpressionValue(list, (String)"collect(...)");
            return list;
        }
        return CollectionsKt.emptyList();
    }

    public static final void addDexMetadataFiles(@Nullable Provider<Directory> dexMetadataDirectory, @NotNull Directory apkDirectory, int deviceApiLevel, @NotNull List<File> apkFiles2, @NotNull ILogger iLogger) throws IOException {
        String dmPath;
        Directory dmDir;
        Intrinsics.checkNotNullParameter((Object)apkDirectory, (String)"apkDirectory");
        Intrinsics.checkNotNullParameter(apkFiles2, (String)"apkFiles");
        Intrinsics.checkNotNullParameter((Object)iLogger, (String)"iLogger");
        Provider<Directory> provider2 = dexMetadataDirectory;
        Object object = dmDir = provider2 != null ? (Directory)provider2.getOrNull() : null;
        if (dmDir == null || !dmDir.file("dex-metadata-map.properties").getAsFile().exists()) {
            return;
        }
        File dexMetadataProperties = dmDir.file("dex-metadata-map.properties").getAsFile();
        InputStream inputStream = new FileInputStream(dexMetadataProperties);
        Properties properties = new Properties();
        properties.load(inputStream);
        String string = dmPath = deviceApiLevel > 31 ? properties.getProperty("2147483647") : properties.getProperty(String.valueOf(deviceApiLevel));
        if (dmPath == null) {
            Object[] objectArray = new Object[]{deviceApiLevel};
            iLogger.info("Baseline Profile not found for API level {}", objectArray);
            return;
        }
        if (!((Collection)apkFiles2).isEmpty()) {
            String fileIndex = new File(dmPath).getParentFile().getName();
            int numApks = apkFiles2.size();
            for (int i = 0; i < numApks; ++i) {
                String apkFileName = apkFiles2.get(i).getName();
                Intrinsics.checkNotNull((Object)apkFileName);
                if (!StringsKt.endsWith$default((String)apkFileName, (String)".apk", (boolean)false, (int)2, null)) continue;
                String apkName = Files.getNameWithoutExtension((String)apkFileName);
                Object[] objectArray = new String[]{"baselineProfiles", fileIndex, apkName + ".dm"};
                File renamedBaselineProfile = FileUtils.join((File)apkDirectory.getAsFile(), (String[])objectArray);
                if (!renamedBaselineProfile.exists()) {
                    objectArray = new Object[]{renamedBaselineProfile.getAbsolutePath()};
                    iLogger.info("Baseline Profile at {} was not found.", objectArray);
                    return;
                }
                Intrinsics.checkNotNull((Object)renamedBaselineProfile);
                apkFiles2.add(renamedBaselineProfile);
            }
        }
    }
}

