/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.api.artifact.Artifact;
import com.android.build.api.artifact.SingleArtifact;
import com.android.build.gradle.internal.component.ApkCreationConfig;
import com.android.build.gradle.internal.profile.ProfileAwareWorkAction;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.tasks.ApkZipPackagingTask;
import com.android.build.gradle.internal.tasks.BuildAnalyzer;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.buildanalyzer.common.TaskCategory;
import com.android.builder.packaging.JarFlinger;
import com.android.utils.FileUtils;
import java.io.Closeable;
import java.io.File;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.work.DisableCachingByDefault;
import org.jetbrains.annotations.NotNull;

@DisableCachingByDefault
@BuildAnalyzer(primaryTaskCategory=TaskCategory.APK_PACKAGING)
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\b'\u0018\u00002\u00020\u0001:\u0003\u0010\u0011\u0012B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u000e\u001a\u00020\u000fH\u0014R\u0014\u0010\u0004\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000b\u00a8\u0006\u0013"}, d2={"Lcom/android/build/gradle/internal/tasks/ApkZipPackagingTask;", "Lcom/android/build/gradle/internal/tasks/NonIncrementalTask;", "<init>", "()V", "apkFolder", "Lorg/gradle/api/file/DirectoryProperty;", "getApkFolder", "()Lorg/gradle/api/file/DirectoryProperty;", "mappingFile", "Lorg/gradle/api/file/RegularFileProperty;", "getMappingFile", "()Lorg/gradle/api/file/RegularFileProperty;", "apkZipFile", "getApkZipFile", "doTaskAction", "", "Params", "ApkZipPackagingRunnable", "CreationAction", "gradle-core"})
public abstract class ApkZipPackagingTask
extends NonIncrementalTask {
    @InputDirectory
    @PathSensitive(value=PathSensitivity.NONE)
    @NotNull
    public abstract DirectoryProperty getApkFolder();

    @InputFile
    @Optional
    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    @NotNull
    public abstract RegularFileProperty getMappingFile();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getApkZipFile();

    @Override
    protected void doTaskAction() {
        Function1 function1 = (Function1)new Function1<Params, Unit>(this){
            final /* synthetic */ ApkZipPackagingTask this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(Params it) {
                it.initializeFromBaseTask(this.this$0);
                it.getApkFolder().set((Provider)this.this$0.getApkFolder());
                it.getMappingFile().set((Provider)this.this$0.getMappingFile());
                it.getZipOutputFile().set((Provider)this.this$0.getApkZipFile());
            }
        };
        this.getWorkerExecutor().noIsolation().submit(ApkZipPackagingRunnable.class, new Action(function1){
            private final /* synthetic */ Function1 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ void execute(Object p0) {
                this.function.invoke(p0);
            }
        });
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/android/build/gradle/internal/tasks/ApkZipPackagingTask$ApkZipPackagingRunnable;", "Lcom/android/build/gradle/internal/profile/ProfileAwareWorkAction;", "Lcom/android/build/gradle/internal/tasks/ApkZipPackagingTask$Params;", "<init>", "()V", "run", "", "gradle-core"})
    public static abstract class ApkZipPackagingRunnable
    extends ProfileAwareWorkAction<Params> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            FileUtils.deleteIfExists((File)((File)((Params)this.getParameters()).getZipOutputFile().getAsFile().get()));
            File[] fileArray = ((File)((Params)this.getParameters()).getApkFolder().getAsFile().get()).listFiles();
            if (fileArray == null) {
                fileArray = new File[]{};
            }
            File[] sourceFiles = fileArray;
            Closeable closeable = (Closeable)new JarFlinger(((File)((Params)this.getParameters()).getZipOutputFile().getAsFile().get()).toPath());
            Throwable throwable = null;
            try {
                Unit unit;
                JarFlinger jar = (JarFlinger)closeable;
                boolean bl = false;
                for (File sourceFile : sourceFiles) {
                    if (sourceFile.isDirectory()) {
                        jar.addDirectory(sourceFile.toPath(), null, null, new JarFlinger.Relocator(sourceFile){
                            final /* synthetic */ File $sourceFile;
                            {
                                this.$sourceFile = $sourceFile;
                            }

                            public final String relocate(String entryPath) {
                                return this.$sourceFile.getName() + "/" + entryPath;
                            }
                        });
                        continue;
                    }
                    jar.addFile(sourceFile.getName(), sourceFile.toPath());
                }
                File file = (File)((Params)this.getParameters()).getMappingFile().getAsFile().getOrNull();
                if (file != null) {
                    File it = file;
                    boolean bl2 = false;
                    jar.addFile(it.getName(), it.toPath());
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                Unit unit2 = unit;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0016\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0002H\u0016R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0015"}, d2={"Lcom/android/build/gradle/internal/tasks/ApkZipPackagingTask$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/ApkZipPackagingTask;", "Lcom/android/build/gradle/internal/component/ApkCreationConfig;", "creationConfig", "<init>", "(Lcom/android/build/gradle/internal/component/ApkCreationConfig;)V", "name", "", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "handleProvider", "", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "configure", "task", "gradle-core"})
    public static final class CreationAction
    extends VariantTaskCreationAction<ApkZipPackagingTask, ApkCreationConfig> {
        public CreationAction(@NotNull ApkCreationConfig creationConfig) {
            Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
            super(creationConfig, false, 2, null);
        }

        @Override
        @NotNull
        public String getName() {
            return this.computeTaskName("zipApksFor");
        }

        @Override
        @NotNull
        public Class<ApkZipPackagingTask> getType() {
            return ApkZipPackagingTask.class;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<ApkZipPackagingTask> taskProvider) {
            Intrinsics.checkNotNullParameter(taskProvider, (String)"taskProvider");
            super.handleProvider(taskProvider);
            ((ApkCreationConfig)this.creationConfig).getArtifacts().setInitialProvider(taskProvider, (Function1)handleProvider.1.INSTANCE).withName("apks.zip").on(InternalArtifactType.APK_ZIP.INSTANCE);
        }

        @Override
        public void configure(@NotNull ApkZipPackagingTask task) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            super.configure((Task)task);
            ((ApkCreationConfig)this.creationConfig).getArtifacts().setTaskInputToFinalProduct((Artifact.Single)SingleArtifact.APK.INSTANCE, (Property)task.getApkFolder());
            ((ApkCreationConfig)this.creationConfig).getArtifacts().setTaskInputToFinalProduct((Artifact.Single)SingleArtifact.OBFUSCATION_MAPPING_FILE.INSTANCE, (Property)task.getMappingFile());
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\f\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lcom/android/build/gradle/internal/tasks/ApkZipPackagingTask$Params;", "Lcom/android/build/gradle/internal/profile/ProfileAwareWorkAction$Parameters;", "<init>", "()V", "apkFolder", "Lorg/gradle/api/file/DirectoryProperty;", "getApkFolder", "()Lorg/gradle/api/file/DirectoryProperty;", "mappingFile", "Lorg/gradle/api/file/RegularFileProperty;", "getMappingFile", "()Lorg/gradle/api/file/RegularFileProperty;", "zipOutputFile", "getZipOutputFile", "gradle-core"})
    public static abstract class Params
    extends ProfileAwareWorkAction.Parameters {
        @NotNull
        public abstract DirectoryProperty getApkFolder();

        @NotNull
        public abstract RegularFileProperty getMappingFile();

        @NotNull
        public abstract RegularFileProperty getZipOutputFile();
    }
}

