/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.testing;

import com.android.build.gradle.internal.testing.EmulatorVersionMetadata;
import com.android.ide.common.gradle.Version;
import com.android.repository.api.NullProgressIndicator;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.Repository;
import com.android.repository.impl.meta.SchemaModuleUtil;
import com.android.sdklib.repository.AndroidSdkHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"SNAPSHOT_LOADABLE_VERSION", "Lcom/android/ide/common/gradle/Version;", "FORCE_SNAPSHOT_LOAD_VERSION", "getEmulatorMetadata", "Lcom/android/build/gradle/internal/testing/EmulatorVersionMetadata;", "emulatorDir", "Ljava/io/File;", "gradle-core"})
@SourceDebugExtension(value={"SMAP\nEmulatorVersionUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EmulatorVersionUtils.kt\ncom/android/build/gradle/internal/testing/EmulatorVersionUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,59:1\n1#2:60\n*E\n"})
public final class EmulatorVersionUtilsKt {
    @NotNull
    private static final Version SNAPSHOT_LOADABLE_VERSION = Version.Companion.parse("30.6.4");
    @NotNull
    private static final Version FORCE_SNAPSHOT_LOAD_VERSION = Version.Companion.parse("34.2.14");

    @NotNull
    public static final EmulatorVersionMetadata getEmulatorMetadata(@NotNull File emulatorDir) {
        Repository repository;
        block7: {
            Object repository2;
            block6: {
                Object $i$a$-runCatching-EmulatorVersionUtilsKt$getEmulatorMetadata$repository$22;
                Intrinsics.checkNotNullParameter((Object)emulatorDir, (String)"emulatorDir");
                File packageFile = FilesKt.resolve((File)emulatorDir, (String)"package.xml");
                try {
                    boolean $i$a$-runCatching-EmulatorVersionUtilsKt$getEmulatorMetadata$repository$22 = false;
                    Object object = SchemaModuleUtil.unmarshal((InputStream)new FileInputStream(packageFile), (Collection)AndroidSdkHandler.getAllModules(), (boolean)false, (ProgressIndicator)((ProgressIndicator)NullProgressIndicator.INSTANCE), (String)packageFile.toString());
                    $i$a$-runCatching-EmulatorVersionUtilsKt$getEmulatorMetadata$repository$22 = Result.constructor-impl((Object)(object instanceof Repository ? (Repository)object : null));
                }
                catch (Throwable throwable) {
                    $i$a$-runCatching-EmulatorVersionUtilsKt$getEmulatorMetadata$repository$22 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                repository2 = $i$a$-runCatching-EmulatorVersionUtilsKt$getEmulatorMetadata$repository$22;
                repository = (Repository)(Result.isFailure-impl((Object)repository2) ? null : repository2);
                if (repository == null || (repository = repository.getLocalPackage()) == null || (repository = repository.getVersion()) == null) break block6;
                Repository it = repository;
                boolean bl = false;
                Version version = Version.Companion.parse(it.getMajor() + "." + it.getMinor() + "." + it.getMicro());
                repository = version;
                if (version != null) break block7;
            }
            throw new IllegalStateException("Could not determine version of Emulator in " + emulatorDir.getAbsolutePath() + ". Update emulator in order to use Managed Devices.", Result.exceptionOrNull-impl((Object)repository2));
        }
        Repository version = repository;
        if (version.compareTo(SNAPSHOT_LOADABLE_VERSION) < 0) {
            throw new IllegalStateException("Emulator needs to be updated in order to use managed devices. Minimum version required: " + SNAPSHOT_LOADABLE_VERSION + ". Version found: " + (Version)version);
        }
        return new EmulatorVersionMetadata(version.compareTo(FORCE_SNAPSHOT_LOAD_VERSION) >= 0);
    }
}

