/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.attribution;

import com.android.Version;
import com.android.build.gradle.internal.attribution.BuildAnalyzerConfiguratorService;
import com.android.build.gradle.internal.attribution.BuildAnalyzerService;
import com.android.build.gradle.internal.services.ServiceRegistrationAction;
import com.android.build.gradle.internal.tasks.BuildAnalyzer;
import com.android.build.gradle.internal.utils.GradlePluginUtils;
import com.android.buildanalyzer.common.AndroidGradlePluginAttributionData;
import com.android.buildanalyzer.common.TaskCategory;
import com.android.buildanalyzer.common.TaskCategoryIssue;
import com.android.tools.analytics.HostData;
import com.android.utils.HelpfulEnumConverter;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.execution.TaskExecutionGraph;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u0018\u0019B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\tJ\u001e\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0013H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R2\u0010\u0007\u001a&\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t \n*\u0012\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t\u0018\u00010\u000b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/android/build/gradle/internal/attribution/BuildAnalyzerConfiguratorService;", "Lorg/gradle/api/services/BuildService;", "Lorg/gradle/api/services/BuildServiceParameters$None;", "<init>", "()V", "state", "Lcom/android/build/gradle/internal/attribution/BuildAnalyzerConfiguratorService$State;", "taskCategoryIssues", "", "Lcom/android/buildanalyzer/common/TaskCategoryIssue;", "kotlin.jvm.PlatformType", "", "reportBuildAnalyzerIssue", "", "issue", "initBuildAnalyzerService", "project", "Lorg/gradle/api/Project;", "attributionFileLocation", "", "parameters", "Lcom/android/build/gradle/internal/attribution/BuildAnalyzerService$Parameters;", "getTaskClassName", "className", "State", "RegistrationAction", "gradle-core"})
public abstract class BuildAnalyzerConfiguratorService
implements BuildService<BuildServiceParameters.None> {
    @NotNull
    private State state = State.NOT_INITIALIZED;
    private final Set<TaskCategoryIssue> taskCategoryIssues = Collections.synchronizedSet(new LinkedHashSet());

    public final void reportBuildAnalyzerIssue(@NotNull TaskCategoryIssue issue) {
        Intrinsics.checkNotNullParameter((Object)((Object)issue), (String)"issue");
        if (this.state == State.MAIN_SERVICE_CONFIGURED) {
            throw new RuntimeException("The configurator service has already configured the build analyzer service. To add execution time warnings, add them directly to the BuildAnalyzerService.");
        }
        this.taskCategoryIssues.add(issue);
    }

    public final void initBuildAnalyzerService(@NotNull Project project, @NotNull String attributionFileLocation, @NotNull BuildAnalyzerService.Parameters parameters) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)attributionFileLocation, (String)"attributionFileLocation");
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        if (this.state != State.NOT_INITIALIZED) {
            return;
        }
        this.state = State.INITIALIZED;
        HelpfulEnumConverter taskCategoryConverter = new HelpfulEnumConverter(TaskCategory.class);
        project.getGradle().getTaskGraph().whenReady(new Action(project, parameters, attributionFileLocation, this, (HelpfulEnumConverter<TaskCategory>)taskCategoryConverter){
            final /* synthetic */ Project $project;
            final /* synthetic */ BuildAnalyzerService.Parameters $parameters;
            final /* synthetic */ String $attributionFileLocation;
            final /* synthetic */ BuildAnalyzerConfiguratorService this$0;
            final /* synthetic */ HelpfulEnumConverter<TaskCategory> $taskCategoryConverter;
            {
                this.$project = $project;
                this.$parameters = $parameters;
                this.$attributionFileLocation = $attributionFileLocation;
                this.this$0 = $receiver;
                this.$taskCategoryConverter = $taskCategoryConverter;
            }

            /*
             * WARNING - void declaration
             */
            public final void execute(TaskExecutionGraph taskGraph) {
                Object object;
                String string;
                String string2;
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                Map.Entry it;
                MapProperty<String, List<String>> mapProperty;
                void $this$mapTo$iv$iv;
                Map $this$map$iv;
                AndroidGradlePluginAttributionData.TaskCategoryInfo taskCategoryInfo;
                void $this$forEach$iv;
                Map outputFileToTasksMap = new LinkedHashMap<K, V>();
                Map taskNameToTaskInfoMap = new LinkedHashMap<K, V>();
                List list = taskGraph.getAllTasks();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAllTasks(...)");
                Iterable iterable = list;
                Object object2 = this.$taskCategoryConverter;
                BuildAnalyzerConfiguratorService buildAnalyzerConfiguratorService = this.this$0;
                boolean $i$f$forEach22 = false;
                for (T element$iv : $this$forEach$iv) {
                    AndroidGradlePluginAttributionData.TaskCategoryInfo taskCategoryInfo2;
                    Task task = (Task)element$iv;
                    boolean bl = false;
                    FileCollection fileCollection2 = task.getOutputs().getFiles();
                    Intrinsics.checkNotNullExpressionValue((Object)fileCollection2, (String)"getFiles(...)");
                    Iterable $this$forEach$iv2 = (Iterable)fileCollection2;
                    boolean $i$f$forEach = false;
                    for (T element$iv2 : $this$forEach$iv2) {
                        File outputFile = (File)element$iv2;
                        boolean bl2 = false;
                        List list2 = (List)outputFileToTasksMap.computeIfAbsent(outputFile.getAbsolutePath(), (Function)initBuildAnalyzerService.1.1.1.INSTANCE);
                        String string3 = task.getPath();
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getPath(...)");
                        list2.add(string3);
                    }
                    if (task.getClass().isAnnotationPresent(BuildAnalyzer.class)) {
                        void $this$mapTo$iv$iv2;
                        BuildAnalyzer annotation = task.getClass().getAnnotation(BuildAnalyzer.class);
                        Object object3 = object2.convert((Object)annotation.primaryTaskCategory().toString());
                        Intrinsics.checkNotNull((Object)object3);
                        TaskCategory primaryTaskCategory = (TaskCategory)((Object)object3);
                        TaskCategory[] $this$map$iv2 = annotation.secondaryTaskCategories();
                        boolean $i$f$map = false;
                        TaskCategory[] taskCategoryArray = $this$map$iv2;
                        Collection destination$iv$iv = new ArrayList<E>($this$map$iv2.length);
                        boolean $i$f$mapTo = false;
                        int n = ((void)$this$mapTo$iv$iv2).length;
                        for (int i = 0; i < n; ++i) {
                            void it2;
                            void item$iv$iv;
                            void var24_33 = item$iv$iv = $this$mapTo$iv$iv2[i];
                            Collection collection = destination$iv$iv;
                            boolean bl3 = false;
                            Object object4 = object2.convert((Object)it2.toString());
                            Intrinsics.checkNotNull((Object)object4);
                            collection.add((TaskCategory)((Object)object4));
                        }
                        List secondaryTaskCategories = (List)destination$iv$iv;
                        taskCategoryInfo2 = new AndroidGradlePluginAttributionData.TaskCategoryInfo(primaryTaskCategory, secondaryTaskCategories);
                    } else {
                        taskCategoryInfo2 = new AndroidGradlePluginAttributionData.TaskCategoryInfo(TaskCategory.UNCATEGORIZED, null, 2, null);
                    }
                    taskCategoryInfo = taskCategoryInfo2;
                    Map annotation = taskNameToTaskInfoMap;
                    String string4 = task.getName();
                    String string5 = task.getClass().getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getName(...)");
                    AndroidGradlePluginAttributionData.TaskInfo taskInfo = new AndroidGradlePluginAttributionData.TaskInfo(BuildAnalyzerConfiguratorService.access$getTaskClassName(buildAnalyzerConfiguratorService, string5), taskCategoryInfo);
                    annotation.put(string4, taskInfo);
                }
                Project project = this.$project.getRootProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getRootProject(...)");
                object2 = GradlePluginUtils.getBuildscriptDependencies(project);
                boolean $i$f$map = false;
                void $i$f$forEach22 = $this$map$iv;
                Object destination$iv$iv = (MapProperty<String, List<String>>)new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)$this$map$iv), (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    taskCategoryInfo = (ModuleComponentIdentifier)item$iv$iv;
                    mapProperty = destination$iv$iv;
                    boolean bl = false;
                    mapProperty.add(it.getGroup() + ":" + it.getModule() + ":" + it.getVersion());
                }
                List buildscriptDependenciesInfo = (List)destination$iv$iv;
                this.$parameters.getAttributionFileLocation().set((Object)this.$attributionFileLocation);
                $this$map$iv = outputFileToTasksMap;
                mapProperty = this.$parameters.getTasksSharingOutputs();
                boolean $i$f$filter = false;
                $this$mapTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new LinkedHashMap<K, V>();
                boolean $i$f$filterTo = false;
                Iterator<Object> iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry element$iv$iv;
                    it = element$iv$iv = (Map.Entry)iterator2.next();
                    boolean bl = false;
                    if (!(((List)it.getValue()).size() > 1)) continue;
                    destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
                }
                mapProperty.set(destination$iv$iv);
                Property<AndroidGradlePluginAttributionData.JavaInfo> property = this.$parameters.getJavaInfo();
                String string6 = System.getProperty("java.version");
                if (string6 == null) {
                    string6 = "";
                }
                if ((string2 = System.getProperty("java.vendor")) == null) {
                    string2 = "";
                }
                if ((string = System.getProperty("java.home")) == null) {
                    string = "";
                }
                if ((object = HostData.getRuntimeBean()) == null || (object = object.getInputArguments()) == null) {
                    object = CollectionsKt.emptyList();
                }
                property.set((Object)new AndroidGradlePluginAttributionData.JavaInfo(string6, string2, string, (List<String>)object));
                this.$parameters.getBuildscriptDependenciesInfo().set((Iterable)buildscriptDependenciesInfo);
                this.$parameters.getBuildInfo().set((Object)new AndroidGradlePluginAttributionData.BuildInfo(Version.ANDROID_GRADLE_PLUGIN_VERSION, this.$project.getGradle().getGradleVersion(), this.$project.getGradle().getStartParameter().isConfigurationCacheRequested()));
                this.$parameters.getTaskNameToTaskInfoMap().set(taskNameToTaskInfoMap);
                this.$parameters.getTaskCategoryIssues().set((Iterable)BuildAnalyzerConfiguratorService.access$getTaskCategoryIssues$p(this.this$0));
                BuildAnalyzerConfiguratorService.access$setState$p(this.this$0, State.MAIN_SERVICE_CONFIGURED);
            }
        });
    }

    private final String getTaskClassName(String className) {
        if (StringsKt.endsWith$default((String)className, (String)"_Decorated", (boolean)false, (int)2, null)) {
            String string = className.substring(0, className.length() - 10);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            return string;
        }
        return className;
    }

    public static final /* synthetic */ Set access$getTaskCategoryIssues$p(BuildAnalyzerConfiguratorService $this) {
        return $this.taskCategoryIssues;
    }

    public static final /* synthetic */ void access$setState$p(BuildAnalyzerConfiguratorService $this, State state) {
        $this.state = state;
    }

    public static final /* synthetic */ String access$getTaskClassName(BuildAnalyzerConfiguratorService $this, String className) {
        return $this.getTaskClassName(className);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0003H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/android/build/gradle/internal/attribution/BuildAnalyzerConfiguratorService$RegistrationAction;", "Lcom/android/build/gradle/internal/services/ServiceRegistrationAction;", "Lcom/android/build/gradle/internal/attribution/BuildAnalyzerConfiguratorService;", "Lorg/gradle/api/services/BuildServiceParameters$None;", "project", "Lorg/gradle/api/Project;", "<init>", "(Lorg/gradle/api/Project;)V", "configure", "", "parameters", "gradle-core"})
    public static final class RegistrationAction
    extends ServiceRegistrationAction<BuildAnalyzerConfiguratorService, BuildServiceParameters.None> {
        public RegistrationAction(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            super(project, BuildAnalyzerConfiguratorService.class, null, null, 12, null);
        }

        @Override
        public void configure(@NotNull BuildServiceParameters.None parameters) {
            Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/android/build/gradle/internal/attribution/BuildAnalyzerConfiguratorService$State;", "", "<init>", "(Ljava/lang/String;I)V", "NOT_INITIALIZED", "INITIALIZED", "MAIN_SERVICE_CONFIGURED", "gradle-core"})
    private static final class State
    extends Enum<State> {
        public static final /* enum */ State NOT_INITIALIZED = new State();
        public static final /* enum */ State INITIALIZED = new State();
        public static final /* enum */ State MAIN_SERVICE_CONFIGURED = new State();
        private static final /* synthetic */ State[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String value) {
            return Enum.valueOf(State.class, value);
        }

        @NotNull
        public static EnumEntries<State> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = stateArray = new State[]{State.NOT_INITIALIZED, State.INITIALIZED, State.MAIN_SERVICE_CONFIGURED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

