/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dependency;

import com.android.build.gradle.internal.BuildToolsExecutableInput;
import com.android.build.gradle.internal.dependency.ExtractCompileSdkShimTransform;
import com.android.build.gradle.internal.dependency.ExtractSdkShimTransform;
import com.android.build.gradle.internal.dependency.GenericTransformParameters;
import com.android.utils.FileUtils;
import com.google.common.collect.ImmutableList;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.inject.Inject;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.path.PathsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.Action;
import org.gradle.api.artifacts.transform.InputArtifact;
import org.gradle.api.artifacts.transform.TransformAction;
import org.gradle.api.artifacts.transform.TransformOutputs;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.process.ExecOperations;
import org.gradle.process.JavaExecSpec;
import org.gradle.work.DisableCachingByDefault;
import org.jetbrains.annotations.NotNull;

@DisableCachingByDefault
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b'\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002#$B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J&\u0010\u0016\u001a\u00020\u000f2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0015H\u0002J&\u0010\u001d\u001a\u00020\u000f2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u0015H\u0002J\u0018\u0010\u001f\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020\u00152\u0006\u0010!\u001a\u00020\"H\u0002R\u0014\u0010\u0005\u001a\u00020\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006%"}, d2={"Lcom/android/build/gradle/internal/dependency/ExtractSdkShimTransform;", "Lorg/gradle/api/artifacts/transform/TransformAction;", "Lcom/android/build/gradle/internal/dependency/ExtractSdkShimTransform$Parameters;", "<init>", "()V", "execOperations", "Lorg/gradle/process/ExecOperations;", "getExecOperations", "()Lorg/gradle/process/ExecOperations;", "inputArtifact", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/FileSystemLocation;", "getInputArtifact", "()Lorg/gradle/api/provider/Provider;", "transform", "", "transformOutputs", "Lorg/gradle/api/artifacts/transform/TransformOutputs;", "checkEmptyJar", "", "sdkInterfaceDescriptorJar", "Ljava/io/File;", "compileJava", "generatedFiles", "", "Ljava/nio/file/Path;", "totalClasspathStr", "", "javaOutDir", "compileKotlin", "kotlinOutDir", "writeCompiledClassesToZip", "classesDir", "outJar", "Ljava/util/zip/ZipOutputStream;", "Parameters", "Generator", "gradle-core"})
@SourceDebugExtension(value={"SMAP\nExtractSdkShimTransform.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExtractSdkShimTransform.kt\ncom/android/build/gradle/internal/dependency/ExtractSdkShimTransform\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,228:1\n1611#2,9:229\n1863#2:238\n1864#2:240\n1620#2:241\n774#2:244\n865#2,2:245\n1557#2:247\n1628#2,3:248\n1#3:239\n37#4,2:242\n*S KotlinDebug\n*F\n+ 1 ExtractSdkShimTransform.kt\ncom/android/build/gradle/internal/dependency/ExtractSdkShimTransform\n*L\n120#1:229,9\n120#1:238\n120#1:240\n120#1:241\n168#1:244\n168#1:245,2\n170#1:247\n170#1:248,3\n120#1:239\n120#1:242,2\n*E\n"})
public abstract class ExtractSdkShimTransform
implements TransformAction<Parameters> {
    @Inject
    @NotNull
    public abstract ExecOperations getExecOperations();

    @InputArtifact
    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    @NotNull
    public abstract Provider<FileSystemLocation> getInputArtifact();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void transform(@NotNull TransformOutputs transformOutputs) {
        void $this$toTypedArray$iv;
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)transformOutputs, (String)"transformOutputs");
        File sdkInterfaceDescriptorJar = ((FileSystemLocation)this.getInputArtifact().get()).getAsFile();
        if (!sdkInterfaceDescriptorJar.isFile()) {
            throw new IOException(sdkInterfaceDescriptorJar.getAbsolutePath() + " must be a file.");
        }
        Intrinsics.checkNotNull((Object)sdkInterfaceDescriptorJar);
        if (this.checkEmptyJar(sdkInterfaceDescriptorJar)) {
            if (((Boolean)((Parameters)this.getParameters()).getRequireServices().get()).booleanValue()) {
                throw new RuntimeException("Unable to proceed generating shim with no provided sdk descriptor entries in: " + sdkInterfaceDescriptorJar.getAbsolutePath() + ".Privacy Sandbox Sdk modules require at least one service declaration.");
            }
            return;
        }
        File output2 = transformOutputs.file((Object)"sdk-shim-generated.jar");
        File aidlExecutable2 = ((File)((Parameters)this.getParameters()).getBuildTools().aidlExecutableProvider().get()).getAbsoluteFile();
        Set set = ((Parameters)this.getParameters()).getBootstrapClasspath().getFiles();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getFiles(...)");
        Set set2 = ((Parameters)this.getParameters()).getRuntimeDependencies().getFiles();
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"getFiles(...)");
        Set totalClasspath = SetsKt.plus((Set)set, (Iterable)set2);
        Iterable iterable = totalClasspath;
        String string = File.pathSeparator;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pathSeparator");
        String totalClasspathStr2 = CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string, null, null, (int)0, null, (Function1)transform.totalClasspathStr.1.INSTANCE, (int)30, null);
        Set set3 = ((Parameters)this.getParameters()).getApiGenerator().getFiles();
        if (set3 == null) {
            throw new IllegalStateException("No library has been specified for client SDK shim generation.".toString());
        }
        Set apiGeneratorJarsFiles = set3;
        Iterable $this$mapNotNull$iv = apiGeneratorJarsFiles;
        boolean $i$f$mapNotNull = false;
        Iterable iterable2 = $this$mapNotNull$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            URL it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            File it = (File)element$iv$iv;
            boolean bl2 = false;
            if (it.toURI().toURL() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        URL[] apiGeneratorUrls = thisCollection$iv.toArray(new URL[0]);
        Path tempDirForApiGeneratorOutputs = Files.createTempDirectory("extract-shim-transform", new FileAttribute[0]);
        try {
            Object object;
            Object object2;
            File kotlinOutDir = new File(tempDirForApiGeneratorOutputs.toFile(), "kotlin-compiled");
            File javaOutDir = new File(tempDirForApiGeneratorOutputs.toFile(), "java-compiled");
            destination$iv$iv = new URLClassLoader(apiGeneratorUrls);
            Object object3 = null;
            try {
                URLClassLoader it = (URLClassLoader)destination$iv$iv;
                boolean bl = false;
                Generator generator = new Generator(it);
                Path path = sdkInterfaceDescriptorJar.toPath();
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
                Path path2 = aidlExecutable2.toPath();
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"toPath(...)");
                Intrinsics.checkNotNull((Object)tempDirForApiGeneratorOutputs);
                generator.generate(path, path2, tempDirForApiGeneratorOutputs);
                object2 = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                object3 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)destination$iv$iv, (Throwable)object3);
            }
            object2 = Files.walk(tempDirForApiGeneratorOutputs, new FileVisitOption[0]);
            Throwable bl = null;
            try {
                Object stream2 = (Stream)object2;
                boolean bl4 = false;
                stream2 = stream2.filter(transform.generatedFiles.1.1.INSTANCE).collect(Collectors.toList());
                object = stream2;
            }
            catch (Throwable stream2) {
                bl = stream2;
                throw stream2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)object2, (Throwable)bl);
            }
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"use(...)");
            Object generatedFiles2 = object;
            this.compileKotlin((List<? extends Path>)generatedFiles2, totalClasspathStr2, kotlinOutDir);
            this.compileJava((List<? extends Path>)generatedFiles2, totalClasspathStr2, javaOutDir);
            Intrinsics.checkNotNull((Object)output2);
            object3 = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(output2)));
            object2 = null;
            try {
                ZipOutputStream outJar = (ZipOutputStream)object3;
                boolean bl5 = false;
                this.writeCompiledClassesToZip(kotlinOutDir, outJar);
                this.writeCompiledClassesToZip(javaOutDir, outJar);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object3, (Throwable)object2);
            }
        }
        finally {
            try {
                FileUtils.deleteRecursivelyIfExists((File)tempDirForApiGeneratorOutputs.toFile());
            }
            catch (AccessDeniedException e) {
                Logger.getLogger(ExtractCompileSdkShimTransform.class.getName()).log(Level.WARNING, e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean checkEmptyJar(File sdkInterfaceDescriptorJar) {
        Closeable closeable = new ZipInputStream(sdkInterfaceDescriptorJar != null ? new FileInputStream(sdkInterfaceDescriptorJar) : null);
        Throwable throwable = null;
        try {
            ZipInputStream jar = (ZipInputStream)closeable;
            boolean bl = false;
            boolean bl2 = jar.getNextEntry() == null;
            return bl2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void compileJava(List<? extends Path> generatedFiles2, String totalClasspathStr2, File javaOutDir) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterTo$iv$iv;
        JavaCompiler javac = ToolProvider.getSystemJavaCompiler();
        StandardJavaFileManager manager = javac.getStandardFileManager(null, null, null);
        Iterable $this$filter$iv = generatedFiles2;
        boolean $i$f$filter22 = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Path it = (Path)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)PathsKt.getExtension((Path)it), (Object)"java")) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List javaSourceClasspaths = (List)destination$iv$iv;
        Iterable $i$f$filter22 = javaSourceClasspaths;
        StandardJavaFileManager standardJavaFileManager = manager;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Path bl = (Path)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(it.toFile());
        }
        Iterable<? extends JavaFileObject> source = standardJavaFileManager.getJavaFileObjectsFromFiles((List)destination$iv$iv2);
        javac.getTask(null, manager, null, (Iterable)ImmutableList.of((Object)"-classpath", (Object)totalClasspathStr2, (Object)"-d", (Object)javaOutDir.getAbsolutePath()), null, source).call();
    }

    private final void compileKotlin(List<? extends Path> generatedFiles2, String totalClasspathStr2, File kotlinOutDir) {
        this.getExecOperations().javaexec(new Action(this, generatedFiles2, totalClasspathStr2, kotlinOutDir){
            final /* synthetic */ ExtractSdkShimTransform this$0;
            final /* synthetic */ List<Path> $generatedFiles;
            final /* synthetic */ String $totalClasspathStr;
            final /* synthetic */ File $kotlinOutDir;
            {
                this.this$0 = $receiver;
                this.$generatedFiles = $generatedFiles;
                this.$totalClasspathStr = $totalClasspathStr;
                this.$kotlinOutDir = $kotlinOutDir;
            }

            /*
             * WARNING - void declaration
             */
            public final void execute(JavaExecSpec spec) {
                Collection<String> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                spec.getMainClass().set((Object)"org.jetbrains.kotlin.cli.jvm.K2JVMCompilerKt");
                Object[] objectArray = new Object[]{((Parameters)this.this$0.getParameters()).getKotlinCompiler()};
                spec.classpath(objectArray);
                objectArray = new String[]{"-no-jdk", "-no-reflect"};
                Collection collection2 = CollectionsKt.listOf((Object[])objectArray);
                objectArray = this.$generatedFiles;
                Collection collection3 = collection2;
                JavaExecSpec javaExecSpec = spec;
                boolean $i$f$map = false;
                void var4_6 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Path path = (Path)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.toString());
                }
                collection = (List)destination$iv$iv;
                objectArray = new String[]{"-classpath", this.$totalClasspathStr, "-d", this.$kotlinOutDir.getPath()};
                javaExecSpec.setArgs(CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)collection3, (Iterable)collection), (Iterable)CollectionsKt.listOf((Object[])objectArray)));
            }
        });
    }

    private final void writeCompiledClassesToZip(File classesDir, ZipOutputStream outJar) {
        Files.walk(classesDir.toPath(), new FileVisitOption[0]).filter(writeCompiledClassesToZip.1.INSTANCE).forEach(new Consumer(classesDir, outJar){
            final /* synthetic */ File $classesDir;
            final /* synthetic */ ZipOutputStream $outJar;
            {
                this.$classesDir = $classesDir;
                this.$outJar = $outJar;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void accept(Path it) {
                File file = it.toFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
                ZipEntry entry2 = new ZipEntry(FilesKt.getInvariantSeparatorsPath((File)FilesKt.relativeTo((File)file, (File)this.$classesDir)));
                this.$outJar.putNextEntry(entry2);
                Intrinsics.checkNotNull((Object)it);
                OpenOption[] openOptionArray = new OpenOption[]{};
                InputStream inputStream = Files.newInputStream(it, Arrays.copyOf(openOptionArray, openOptionArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
                Closeable closeable = inputStream;
                ZipOutputStream zipOutputStream = this.$outJar;
                Throwable throwable = null;
                try {
                    InputStream inputStream2 = (InputStream)closeable;
                    boolean bl = false;
                    zipOutputStream.write(ByteStreamsKt.readBytes((InputStream)inputStream2));
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                this.$outJar.closeEntry();
            }
        });
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u0012\u0012\u0002\b\u0003 \f*\b\u0012\u0002\b\u0003\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \f*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n \f*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/android/build/gradle/internal/dependency/ExtractSdkShimTransform$Generator;", "", "classLoader", "Ljava/net/URLClassLoader;", "<init>", "(Ljava/net/URLClassLoader;)V", "getClassLoader", "()Ljava/net/URLClassLoader;", "apiGeneratorPackage", "", "privacySandboxApiGeneratorClass", "Ljava/lang/Class;", "kotlin.jvm.PlatformType", "privacySandboxSdkGenerator", "generateMethod", "Ljava/lang/reflect/Method;", "generate", "", "sdkInterfaceDescriptors", "Ljava/nio/file/Path;", "aidlCompiler", "outputDirectory", "gradle-core"})
    public static final class Generator {
        @NotNull
        private final URLClassLoader classLoader;
        @NotNull
        private final String apiGeneratorPackage;
        private final Class<?> privacySandboxApiGeneratorClass;
        private final Object privacySandboxSdkGenerator;
        private final Method generateMethod;

        public Generator(@NotNull URLClassLoader classLoader) {
            Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
            this.classLoader = classLoader;
            this.apiGeneratorPackage = "androidx.privacysandbox.tools.apigenerator";
            this.privacySandboxApiGeneratorClass = this.classLoader.loadClass(this.apiGeneratorPackage + ".PrivacySandboxApiGenerator");
            this.privacySandboxSdkGenerator = this.privacySandboxApiGeneratorClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            Class[] classArray = new Class[]{Path.class, Path.class, Path.class};
            this.generateMethod = this.privacySandboxApiGeneratorClass.getMethod("generate", classArray);
        }

        @NotNull
        public final URLClassLoader getClassLoader() {
            return this.classLoader;
        }

        public final void generate(@NotNull Path sdkInterfaceDescriptors, @NotNull Path aidlCompiler, @NotNull Path outputDirectory) {
            Intrinsics.checkNotNullParameter((Object)sdkInterfaceDescriptors, (String)"sdkInterfaceDescriptors");
            Intrinsics.checkNotNullParameter((Object)aidlCompiler, (String)"aidlCompiler");
            Intrinsics.checkNotNullParameter((Object)outputDirectory, (String)"outputDirectory");
            Object[] objectArray = new Object[]{sdkInterfaceDescriptors, aidlCompiler, outputDirectory};
            this.generateMethod.invoke(this.privacySandboxSdkGenerator, objectArray);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001R\u0014\u0010\u0002\u001a\u00020\u00038gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0006\u001a\u00020\u00078gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u00038gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0005R\u0014\u0010\f\u001a\u00020\u00038gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0005R\u0014\u0010\u000e\u001a\u00020\u00038gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0005R\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00118gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015\u00c0\u0006\u0003"}, d2={"Lcom/android/build/gradle/internal/dependency/ExtractSdkShimTransform$Parameters;", "Lcom/android/build/gradle/internal/dependency/GenericTransformParameters;", "apiGenerator", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getApiGenerator", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "buildTools", "Lcom/android/build/gradle/internal/BuildToolsExecutableInput;", "getBuildTools", "()Lcom/android/build/gradle/internal/BuildToolsExecutableInput;", "kotlinCompiler", "getKotlinCompiler", "bootstrapClasspath", "getBootstrapClasspath", "runtimeDependencies", "getRuntimeDependencies", "requireServices", "Lorg/gradle/api/provider/Property;", "", "getRequireServices", "()Lorg/gradle/api/provider/Property;", "gradle-core"})
    public static interface Parameters
    extends GenericTransformParameters {
        @InputFiles
        @PathSensitive(value=PathSensitivity.NONE)
        @NotNull
        public ConfigurableFileCollection getApiGenerator();

        @Nested
        @NotNull
        public BuildToolsExecutableInput getBuildTools();

        @InputFiles
        @PathSensitive(value=PathSensitivity.NONE)
        @NotNull
        public ConfigurableFileCollection getKotlinCompiler();

        @InputFiles
        @PathSensitive(value=PathSensitivity.NONE)
        @NotNull
        public ConfigurableFileCollection getBootstrapClasspath();

        @InputFiles
        @PathSensitive(value=PathSensitivity.NONE)
        @NotNull
        public ConfigurableFileCollection getRuntimeDependencies();

        @Input
        @NotNull
        public Property<Boolean> getRequireServices();
    }
}

