/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dependency;

import com.android.build.gradle.internal.services.ServiceRegistrationAction;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheBuilderSpec;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.concurrent.ThreadSafe;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.Project;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b'\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00060\u0003j\u0002`\u0004:\u0003\u001f !B\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J,\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u0013J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\u0016\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0016RT\u0010\u0007\u001aB\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t\u0012\f\u0012\n \n*\u0004\u0018\u00010\u000b0\u000b \n* \u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t\u0012\f\u0012\n \n*\u0004\u0018\u00010\u000b0\u000b\u0018\u00010\b0\bX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\""}, d2={"Lcom/android/build/gradle/internal/dependency/JacocoInstrumentationService;", "Lorg/gradle/api/services/BuildService;", "Lorg/gradle/api/services/BuildServiceParameters$None;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "<init>", "()V", "instrumenterCache", "Lcom/google/common/cache/LoadingCache;", "Lcom/android/build/gradle/internal/dependency/JacocoInstrumentationService$ClassLoaderCacheKey;", "kotlin.jvm.PlatformType", "Lcom/android/build/gradle/internal/dependency/JacocoInstrumentationService$Instrumenter;", "getInstrumenterCache", "()Lcom/google/common/cache/LoadingCache;", "instrument", "", "input", "Ljava/io/InputStream;", "name", "", "classpaths", "", "Ljava/io/File;", "jacocoVersion", "getPlatformClassLoader", "Ljava/lang/ClassLoader;", "createClassLoader", "Ljava/net/URLClassLoader;", "classpath", "close", "", "ClassLoaderCacheKey", "Instrumenter", "RegistrationAction", "gradle-core"})
@ThreadSafe
@SourceDebugExtension(value={"SMAP\nJacocoInstrumentationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JacocoInstrumentationService.kt\ncom/android/build/gradle/internal/dependency/JacocoInstrumentationService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,122:1\n1557#2:123\n1628#2,3:124\n37#3,2:127\n216#4,2:129\n*S KotlinDebug\n*F\n+ 1 JacocoInstrumentationService.kt\ncom/android/build/gradle/internal/dependency/JacocoInstrumentationService\n*L\n70#1:123\n70#1:124,3\n70#1:127,2\n75#1:129,2\n*E\n"})
public abstract class JacocoInstrumentationService
implements BuildService<BuildServiceParameters.None>,
AutoCloseable {
    private final LoadingCache<ClassLoaderCacheKey, Instrumenter> instrumenterCache = CacheBuilder.from((CacheBuilderSpec)CacheBuilderSpec.parse((String)"softValues")).build((CacheLoader)new CacheLoader<ClassLoaderCacheKey, Instrumenter>(this){
        final /* synthetic */ JacocoInstrumentationService this$0;
        {
            this.this$0 = $receiver;
        }

        public Instrumenter load(ClassLoaderCacheKey key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return new Instrumenter(JacocoInstrumentationService.access$createClassLoader(this.this$0, key.getClasspath()));
        }
    });

    protected LoadingCache<ClassLoaderCacheKey, Instrumenter> getInstrumenterCache() {
        return this.instrumenterCache;
    }

    @NotNull
    public final byte[] instrument(@NotNull InputStream input, @NotNull String name, @NotNull Iterable<? extends File> classpaths, @NotNull String jacocoVersion) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(classpaths, (String)"classpaths");
        Intrinsics.checkNotNullParameter((Object)jacocoVersion, (String)"jacocoVersion");
        Instrumenter instrumenter = (Instrumenter)this.getInstrumenterCache().get((Object)new ClassLoaderCacheKey(jacocoVersion, classpaths));
        return instrumenter.instrument(input, name);
    }

    private final ClassLoader getPlatformClassLoader() {
        Object object = ClassLoader.class.getMethod("getPlatformClassLoader", new Class[0]).invoke(null, new Object[0]);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.lang.ClassLoader");
        return (ClassLoader)object;
    }

    /*
     * WARNING - void declaration
     */
    private final URLClassLoader createClassLoader(Iterable<? extends File> classpath) {
        void $this$mapTo$iv$iv;
        Iterable<? extends File> $this$map$iv = classpath;
        boolean $i$f$map = false;
        Iterable<? extends File> iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            File file = (File)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.toURI().toURL());
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        URL[] classpathUrls = thisCollection$iv.toArray(new URL[0]);
        return new URLClassLoader(classpathUrls, this.getPlatformClassLoader());
    }

    @Override
    public void close() {
        ConcurrentMap concurrentMap = this.getInstrumenterCache().asMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"asMap(...)");
        Map $this$forEach$iv = concurrentMap;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry it = element$iv = iterator2.next();
            boolean bl = false;
            ((Instrumenter)it.getValue()).getClassLoader().close();
        }
        this.getInstrumenterCache().invalidateAll();
    }

    public static final /* synthetic */ URLClassLoader access$createClassLoader(JacocoInstrumentationService $this, Iterable classpath) {
        return $this.createClassLoader(classpath);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lcom/android/build/gradle/internal/dependency/JacocoInstrumentationService$ClassLoaderCacheKey;", "", "jacocoVersion", "", "classpath", "", "Ljava/io/File;", "<init>", "(Ljava/lang/String;Ljava/lang/Iterable;)V", "getJacocoVersion", "()Ljava/lang/String;", "getClasspath", "()Ljava/lang/Iterable;", "equals", "", "other", "hashCode", "", "component1", "component2", "copy", "toString", "gradle-core"})
    public static final class ClassLoaderCacheKey {
        @NotNull
        private final String jacocoVersion;
        @NotNull
        private final Iterable<File> classpath;

        public ClassLoaderCacheKey(@NotNull String jacocoVersion, @NotNull Iterable<? extends File> classpath) {
            Intrinsics.checkNotNullParameter((Object)jacocoVersion, (String)"jacocoVersion");
            Intrinsics.checkNotNullParameter(classpath, (String)"classpath");
            this.jacocoVersion = jacocoVersion;
            this.classpath = classpath;
        }

        @NotNull
        public final String getJacocoVersion() {
            return this.jacocoVersion;
        }

        @NotNull
        public final Iterable<File> getClasspath() {
            return this.classpath;
        }

        public boolean equals(@Nullable Object other) {
            return other instanceof ClassLoaderCacheKey && Intrinsics.areEqual((Object)this.jacocoVersion, (Object)((ClassLoaderCacheKey)other).jacocoVersion);
        }

        public int hashCode() {
            Object[] objectArray = new Object[]{this.jacocoVersion};
            return Objects.hash(objectArray);
        }

        @NotNull
        public final String component1() {
            return this.jacocoVersion;
        }

        @NotNull
        public final Iterable<File> component2() {
            return this.classpath;
        }

        @NotNull
        public final ClassLoaderCacheKey copy(@NotNull String jacocoVersion, @NotNull Iterable<? extends File> classpath) {
            Intrinsics.checkNotNullParameter((Object)jacocoVersion, (String)"jacocoVersion");
            Intrinsics.checkNotNullParameter(classpath, (String)"classpath");
            return new ClassLoaderCacheKey(jacocoVersion, classpath);
        }

        public static /* synthetic */ ClassLoaderCacheKey copy$default(ClassLoaderCacheKey classLoaderCacheKey, String string, Iterable iterable, int n, Object object) {
            if ((n & 1) != 0) {
                string = classLoaderCacheKey.jacocoVersion;
            }
            if ((n & 2) != 0) {
                iterable = classLoaderCacheKey.classpath;
            }
            return classLoaderCacheKey.copy(string, iterable);
        }

        @NotNull
        public String toString() {
            return "ClassLoaderCacheKey(jacocoVersion=" + this.jacocoVersion + ", classpath=" + this.classpath + ")";
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\tJ \u0010\u0017\u001a\u0012\u0012\u0002\b\u0003 \u000b*\b\u0012\u0002\b\u0003\u0018\u00010\r0\r2\u0006\u0010\u0018\u001a\u00020\tH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \u000b*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u0012\u0012\u0002\b\u0003 \u000b*\b\u0012\u0002\b\u0003\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000e\u001a\u0012\u0012\u0002\b\u0003 \u000b*\b\u0012\u0002\b\u0003\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n \u000b*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n \u000b*\u0004\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/android/build/gradle/internal/dependency/JacocoInstrumentationService$Instrumenter;", "", "classLoader", "Ljava/net/URLClassLoader;", "<init>", "(Ljava/net/URLClassLoader;)V", "getClassLoader", "()Ljava/net/URLClassLoader;", "jacocoCorePackage", "", "offlineInstrumentationAccessGenerator", "kotlin.jvm.PlatformType", "iExecutionDataAccessorGeneratorInterface", "Ljava/lang/Class;", "instrumenterClass", "instrumenter", "instrumentMethod", "Ljava/lang/reflect/Method;", "instrument", "", "input", "Ljava/io/InputStream;", "name", "loadClass", "classToLoad", "gradle-core"})
    public static final class Instrumenter {
        @NotNull
        private final URLClassLoader classLoader;
        @NotNull
        private final String jacocoCorePackage;
        private final Object offlineInstrumentationAccessGenerator;
        private final Class<?> iExecutionDataAccessorGeneratorInterface;
        private final Class<?> instrumenterClass;
        private final Object instrumenter;
        private final Method instrumentMethod;

        public Instrumenter(@NotNull URLClassLoader classLoader) {
            Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
            this.classLoader = classLoader;
            this.jacocoCorePackage = "org.jacoco.core";
            this.offlineInstrumentationAccessGenerator = this.loadClass(this.jacocoCorePackage + ".runtime.OfflineInstrumentationAccessGenerator").getConstructor(new Class[0]).newInstance(new Object[0]);
            this.iExecutionDataAccessorGeneratorInterface = this.loadClass(this.jacocoCorePackage + ".runtime.IExecutionDataAccessorGenerator");
            this.instrumenterClass = this.loadClass(this.jacocoCorePackage + ".instr.Instrumenter");
            Object[] objectArray = new Class[]{this.iExecutionDataAccessorGeneratorInterface};
            Constructor<?> constructor = this.instrumenterClass.getConstructor((Class<?>[])objectArray);
            objectArray = new Object[]{this.offlineInstrumentationAccessGenerator};
            this.instrumenter = constructor.newInstance(objectArray);
            objectArray = new Class[]{InputStream.class, String.class};
            this.instrumentMethod = this.instrumenterClass.getMethod("instrument", (Class<?>[])objectArray);
        }

        @NotNull
        public final URLClassLoader getClassLoader() {
            return this.classLoader;
        }

        @NotNull
        public final byte[] instrument(@NotNull InputStream input, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Object[] objectArray = new Object[]{input, name};
            Object object = this.instrumentMethod.invoke(this.instrumenter, objectArray);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.ByteArray");
            return (byte[])object;
        }

        private final Class<?> loadClass(String classToLoad) {
            return this.classLoader.loadClass(classToLoad);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0003H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/android/build/gradle/internal/dependency/JacocoInstrumentationService$RegistrationAction;", "Lcom/android/build/gradle/internal/services/ServiceRegistrationAction;", "Lcom/android/build/gradle/internal/dependency/JacocoInstrumentationService;", "Lorg/gradle/api/services/BuildServiceParameters$None;", "project", "Lorg/gradle/api/Project;", "<init>", "(Lorg/gradle/api/Project;)V", "configure", "", "parameters", "gradle-core"})
    public static final class RegistrationAction
    extends ServiceRegistrationAction<JacocoInstrumentationService, BuildServiceParameters.None> {
        public RegistrationAction(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            super(project, JacocoInstrumentationService.class, null, null, 12, null);
        }

        @Override
        public void configure(@NotNull BuildServiceParameters.None parameters) {
            Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        }
    }
}

