/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.services;

import com.android.build.gradle.internal.services.R8D8ThreadPoolBuildServiceKt;
import com.android.build.gradle.internal.services.ServiceRegistrationAction;
import com.android.build.gradle.options.IntegerOption;
import com.android.build.gradle.options.ProjectOptions;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.provider.Property;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b&\u0018\u0000 \u00132\b\u0012\u0004\u0012\u00020\u00020\u00012\u00060\u0003j\u0002`\u0004:\u0003\u0011\u0012\u0013B\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u001b\u0010\u0007\u001a\u00020\b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/android/build/gradle/internal/services/R8D8ThreadPoolBuildService;", "Lorg/gradle/api/services/BuildService;", "Lcom/android/build/gradle/internal/services/R8D8ThreadPoolBuildService$Parameters;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "<init>", "()V", "threadPool", "Ljava/util/concurrent/ExecutorService;", "getThreadPool", "()Ljava/util/concurrent/ExecutorService;", "threadPool$delegate", "Lkotlin/Lazy;", "threadPoolCreated", "", "close", "", "Parameters", "RegistrationAction", "Companion", "gradle-core"})
public abstract class R8D8ThreadPoolBuildService
implements BuildService<Parameters>,
AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy threadPool$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ExecutorService>(this){
        final /* synthetic */ R8D8ThreadPoolBuildService this$0;
        {
            this.this$0 = $receiver;
            super(0);
        }

        public final ExecutorService invoke() {
            R8D8ThreadPoolBuildService.access$setThreadPoolCreated$p(this.this$0, true);
            Object object = ((Parameters)this.this$0.getParameters()).getThreadPoolSize().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            return R8D8ThreadPoolBuildService.Companion.newThreadPool(((Number)object).intValue());
        }
    }));
    private boolean threadPoolCreated;

    @NotNull
    public final ExecutorService getThreadPool() {
        Lazy lazy = this.threadPool$delegate;
        return (ExecutorService)lazy.getValue();
    }

    @Override
    public void close() {
        if (this.threadPoolCreated) {
            R8D8ThreadPoolBuildServiceKt.doClose(this.getThreadPool());
        }
    }

    public static final /* synthetic */ void access$setThreadPoolCreated$p(R8D8ThreadPoolBuildService $this, boolean bl) {
        $this.threadPoolCreated = bl;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0006\u0010\b\u001a\u00020\u0007\u00a8\u0006\t"}, d2={"Lcom/android/build/gradle/internal/services/R8D8ThreadPoolBuildService$Companion;", "", "<init>", "()V", "newThreadPool", "Ljava/util/concurrent/ExecutorService;", "threadPoolSize", "", "defaultThreadPoolSize", "gradle-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ExecutorService newThreadPool(int threadPoolSize) {
            ExecutorService executorService = Executors.newWorkStealingPool(threadPoolSize);
            Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"newWorkStealingPool(...)");
            return executorService;
        }

        public final int defaultThreadPoolSize() {
            int n;
            int processors = Runtime.getRuntime().availableProcessors();
            if (processors <= 16) {
                n = processors;
            } else {
                int threadPoolSize = 16 + (int)Math.round((double)(processors - 16) / 2.0);
                n = Math.min(threadPoolSize, 48);
            }
            return n;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0018\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/android/build/gradle/internal/services/R8D8ThreadPoolBuildService$Parameters;", "Lorg/gradle/api/services/BuildServiceParameters;", "<init>", "()V", "threadPoolSize", "Lorg/gradle/api/provider/Property;", "", "getThreadPoolSize", "()Lorg/gradle/api/provider/Property;", "gradle-core"})
    public static abstract class Parameters
    implements BuildServiceParameters {
        @NotNull
        public abstract Property<Integer> getThreadPoolSize();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0003H\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/android/build/gradle/internal/services/R8D8ThreadPoolBuildService$RegistrationAction;", "Lcom/android/build/gradle/internal/services/ServiceRegistrationAction;", "Lcom/android/build/gradle/internal/services/R8D8ThreadPoolBuildService;", "Lcom/android/build/gradle/internal/services/R8D8ThreadPoolBuildService$Parameters;", "project", "Lorg/gradle/api/Project;", "projectOptions", "Lcom/android/build/gradle/options/ProjectOptions;", "<init>", "(Lorg/gradle/api/Project;Lcom/android/build/gradle/options/ProjectOptions;)V", "r8ThreadPoolSize", "", "configure", "", "parameters", "gradle-core"})
    public static final class RegistrationAction
    extends ServiceRegistrationAction<R8D8ThreadPoolBuildService, Parameters> {
        private final int r8ThreadPoolSize;

        public RegistrationAction(@NotNull Project project, @NotNull ProjectOptions projectOptions) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)projectOptions, (String)"projectOptions");
            super(project, R8D8ThreadPoolBuildService.class, null, null, 12, null);
            Integer n = projectOptions.get(IntegerOption.R8_THREAD_POOL_SIZE);
            Intrinsics.checkNotNull((Object)n);
            this.r8ThreadPoolSize = n;
        }

        @Override
        public void configure(@NotNull Parameters parameters) {
            Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
            parameters.getThreadPoolSize().set((Object)this.r8ThreadPoolSize);
        }
    }
}

