/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.component.VariantCreationConfig;
import com.android.build.gradle.internal.profile.ProfileAwareWorkAction;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.tasks.BuildAnalyzer;
import com.android.build.gradle.internal.tasks.IntegrityConfigParser;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.ParseIntegrityConfigTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.utils.HasConfigurableValuesKt;
import com.android.buildanalyzer.common.TaskCategory;
import com.android.bundle.AppIntegrityConfigOuterClass;
import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;

@CacheableTask
@BuildAnalyzer(primaryTaskCategory=TaskCategory.METADATA)
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b'\u0018\u00002\u00020\u0001:\u0003\u000e\u000f\u0010B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\f\u001a\u00020\rH\u0016R\u0014\u0010\u0004\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0011"}, d2={"Lcom/android/build/gradle/internal/tasks/ParseIntegrityConfigTask;", "Lcom/android/build/gradle/internal/tasks/NonIncrementalTask;", "<init>", "()V", "integrityConfigDir", "Lorg/gradle/api/file/DirectoryProperty;", "getIntegrityConfigDir", "()Lorg/gradle/api/file/DirectoryProperty;", "appIntegrityConfigProto", "Lorg/gradle/api/file/RegularFileProperty;", "getAppIntegrityConfigProto", "()Lorg/gradle/api/file/RegularFileProperty;", "doTaskAction", "", "Params", "ParseIntegrityConfigRunnable", "CreationAction", "gradle-core"})
public abstract class ParseIntegrityConfigTask
extends NonIncrementalTask {
    @InputDirectory
    @Optional
    @PathSensitive(value=PathSensitivity.NONE)
    @NotNull
    public abstract DirectoryProperty getIntegrityConfigDir();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getAppIntegrityConfigProto();

    @Override
    public void doTaskAction() {
        this.getWorkerExecutor().noIsolation().submit(ParseIntegrityConfigRunnable.class, new Action(this){
            final /* synthetic */ ParseIntegrityConfigTask this$0;
            {
                this.this$0 = $receiver;
            }

            public final void execute(Params it) {
                it.initializeFromBaseTask(this.this$0);
                it.getIntegrityConfigDir().set((Provider)this.this$0.getIntegrityConfigDir());
                it.getAppIntegrityConfigProto().set((Provider)this.this$0.getAppIntegrityConfigProto());
            }
        });
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0016\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0002H\u0016R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0015"}, d2={"Lcom/android/build/gradle/internal/tasks/ParseIntegrityConfigTask$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/ParseIntegrityConfigTask;", "Lcom/android/build/gradle/internal/component/VariantCreationConfig;", "creationConfig", "<init>", "(Lcom/android/build/gradle/internal/component/VariantCreationConfig;)V", "name", "", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "handleProvider", "", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "configure", "task", "gradle-core"})
    public static final class CreationAction
    extends VariantTaskCreationAction<ParseIntegrityConfigTask, VariantCreationConfig> {
        public CreationAction(@NotNull VariantCreationConfig creationConfig) {
            Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
            super(creationConfig, false, 2, null);
        }

        @Override
        @NotNull
        public String getName() {
            return this.computeTaskName("parse", "IntegrityConfig");
        }

        @Override
        @NotNull
        public Class<ParseIntegrityConfigTask> getType() {
            return ParseIntegrityConfigTask.class;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<ParseIntegrityConfigTask> taskProvider) {
            Intrinsics.checkNotNullParameter(taskProvider, (String)"taskProvider");
            super.handleProvider(taskProvider);
            ((VariantCreationConfig)this.creationConfig).getArtifacts().setInitialProvider(taskProvider, (Function1)handleProvider.1.INSTANCE).withName("AppIntegrityConfig.pb").on(InternalArtifactType.APP_INTEGRITY_CONFIG.INSTANCE);
        }

        @Override
        public void configure(@NotNull ParseIntegrityConfigTask task) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            super.configure((Task)task);
            HasConfigurableValuesKt.setDisallowChanges((Property)task.getIntegrityConfigDir(), (Provider)((VariantCreationConfig)this.creationConfig).getGlobal().getBundleOptions().getIntegrityConfigDir());
        }
    }

    @VisibleForTesting
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b'\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/android/build/gradle/internal/tasks/ParseIntegrityConfigTask$Params;", "Lcom/android/build/gradle/internal/profile/ProfileAwareWorkAction$Parameters;", "<init>", "()V", "integrityConfigDir", "Lorg/gradle/api/file/DirectoryProperty;", "getIntegrityConfigDir", "()Lorg/gradle/api/file/DirectoryProperty;", "appIntegrityConfigProto", "Lorg/gradle/api/file/RegularFileProperty;", "getAppIntegrityConfigProto", "()Lorg/gradle/api/file/RegularFileProperty;", "gradle-core"})
    public static abstract class Params
    extends ProfileAwareWorkAction.Parameters {
        @NotNull
        public abstract DirectoryProperty getIntegrityConfigDir();

        @NotNull
        public abstract RegularFileProperty getAppIntegrityConfigProto();
    }

    @VisibleForTesting
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b'\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\nH\u0002\u00a8\u0006\u000f"}, d2={"Lcom/android/build/gradle/internal/tasks/ParseIntegrityConfigTask$ParseIntegrityConfigRunnable;", "Lcom/android/build/gradle/internal/profile/ProfileAwareWorkAction;", "Lcom/android/build/gradle/internal/tasks/ParseIntegrityConfigTask$Params;", "<init>", "()V", "run", "", "loadXML", "Lorg/w3c/dom/Document;", "xmlFile", "Ljava/io/File;", "storeProto", "configProto", "Lcom/android/bundle/AppIntegrityConfigOuterClass$AppIntegrityConfig;", "output", "gradle-core"})
    public static abstract class ParseIntegrityConfigRunnable
    extends ProfileAwareWorkAction<Params> {
        @Override
        public void run() {
            File file = (File)((Params)this.getParameters()).getIntegrityConfigDir().getAsFile().getOrNull();
            if (file != null) {
                File it = file;
                boolean bl = false;
                if (!it.isDirectory()) {
                    throw new FileNotFoundException("Could not find directory " + it.getAbsolutePath());
                }
                Document doc = this.loadXML(FilesKt.resolve((File)it, (String)"IntegrityConfig.xml"));
                AppIntegrityConfigOuterClass.AppIntegrityConfig configProto = new IntegrityConfigParser(doc).parseConfig();
                Object object = ((Params)this.getParameters()).getAppIntegrityConfigProto().getAsFile().get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                this.storeProto(configProto, (File)object);
            } else {
                ParseIntegrityConfigRunnable $this$run_u24lambda_u241 = this;
                boolean bl = false;
                Files.deleteIfExists(((File)((Params)$this$run_u24lambda_u241.getParameters()).getAppIntegrityConfigProto().getAsFile().get()).toPath());
            }
        }

        private final Document loadXML(File xmlFile) {
            DocumentBuilderFactory documentFactory = DocumentBuilderFactory.newInstance();
            documentFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(xmlFile);
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"parse(...)");
            return document;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void storeProto(AppIntegrityConfigOuterClass.AppIntegrityConfig configProto, File output2) {
            Closeable closeable = Files.newOutputStream(output2.toPath(), new OpenOption[0]);
            Throwable throwable = null;
            try {
                OutputStream outputStream = (OutputStream)closeable;
                boolean bl = false;
                configProto.writeTo(outputStream);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
    }
}

