/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.utils;

import com.android.build.api.dsl.AndroidSourceDirectorySet;
import com.android.build.api.dsl.AndroidSourceSet;
import com.android.build.gradle.internal.api.DefaultAndroidSourceDirectorySet;
import com.android.build.gradle.internal.component.ApkCreationConfig;
import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.component.LibraryCreationConfig;
import com.android.build.gradle.internal.profile.AnalyticsConfiguratorService;
import com.android.build.gradle.internal.services.BuildServicesKt;
import com.android.build.gradle.internal.services.BuiltInKotlinServices;
import com.android.build.gradle.internal.services.ProjectServices;
import com.android.build.gradle.internal.utils.KgpUtils;
import com.android.ide.common.gradle.Version;
import com.android.utils.StringHelper;
import com.google.wireless.android.sdk.stats.GradleBuildVariant;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.logging.Logger;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.ClasspathNormalizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.dsl.KotlinJvmOptions;
import org.jetbrains.kotlin.gradle.dsl.KotlinVersion;
import org.jetbrains.kotlin.gradle.plugin.CompilerPluginConfig;
import org.jetbrains.kotlin.gradle.plugin.KotlinBaseApiPlugin;
import org.jetbrains.kotlin.gradle.plugin.KotlinBasePluginWrapper;
import org.jetbrains.kotlin.gradle.plugin.SubpluginOption;
import org.jetbrains.kotlin.gradle.tasks.KotlinCompile;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0094\u0001\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u0000\u001a\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u001a\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\f\u001a\u00020\r\u001a\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0011\u001a\u00020\u0001\u001a\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00012\u0006\u0010\f\u001a\u00020\r\u001a\u0014\u0010\u0013\u001a\u0004\u0018\u00010\u00012\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u0015\u001a\u000e\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u001a\u000e\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u001a\u000e\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u001a\u000e\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u001a6\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\t2\u0018\u0010\u001e\u001a\u0014\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001b0\u001f\u001a\u001c\u0010!\u001a\u00020\u001b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\t\u001a\u0016\u0010\"\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020 2\u0006\u0010$\u001a\u00020\u001d\u001a\u0012\u0010%\u001a\u0004\u0018\u00010\u00012\u0006\u0010#\u001a\u00020 H\u0002\u001a&\u0010&\u001a\u00020\u001b2\u0006\u0010'\u001a\u00020 2\u0006\u0010$\u001a\u00020\u001d2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u000b\u001a\u001e\u0010+\u001a\u00020\u001b2\u0006\u0010'\u001a\u00020 2\u0006\u0010$\u001a\u00020\u001d2\u0006\u0010,\u001a\u00020-\u001a\u001e\u0010.\u001a\u00020\u001b*\u00020 2\b\u0010/\u001a\u0004\u0018\u00010\u000f2\u0006\u0010(\u001a\u00020)H\u0002\u001a.\u00100\u001a\u00020\u001b*\u00020 2\b\u0010/\u001a\u0004\u0018\u00010\u000f2\u0006\u00101\u001a\u00020\u00012\u0006\u00102\u001a\u00020\u00012\u0006\u00103\u001a\u00020\u0001H\u0002\u001a/\u00104\u001a\u00020\u000b*\u0004\u0018\u00010\u000f2\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u0002062\n\b\u0002\u00108\u001a\u0004\u0018\u000106H\u0002\u00a2\u0006\u0002\u00109\u001a\u0016\u0010:\u001a\u00020\u001b*\u00020 2\b\u0010/\u001a\u0004\u0018\u00010\u000fH\u0002\u001a&\u0010;\u001a\u00020\u001b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010<\u001a\u00020=2\u000e\u0010>\u001a\n\u0012\u0006\b\u0001\u0012\u00020@0?\u001a\u001c\u0010A\u001a\b\u0012\u0004\u0012\u00020B0\t2\u0006\u0010$\u001a\u00020\u001d2\u0006\u0010C\u001a\u00020\u0001\u001a \u0010D\u001a\u00020\u001b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010$\u001a\u00020\u001d2\u0006\u0010E\u001a\u00020FH\u0000\u001a&\u0010G\u001a\n I*\u0004\u0018\u00010H0H*\u00020J2\u0006\u0010K\u001a\u00020\u00012\b\u0010L\u001a\u0004\u0018\u00010\u0001H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010M\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010N\u001a\b\u0012\u0004\u0012\u00020\u00010OX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010P\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006Q\u00b2\u0006\u0012\u0010R\u001a\n\u0012\u0004\u0012\u00020S\u0018\u00010?X\u008a\u0084\u0002"}, d2={"KOTLIN_ANDROID_PLUGIN_ID", "", "ANDROID_BUILT_IN_KOTLIN_PLUGIN_ID", "KOTLIN_KAPT_PLUGIN_ID", "ANDROID_BUILT_IN_KAPT_PLUGIN_ID", "COMPOSE_COMPILER_PLUGIN_ID", "KSP_PLUGIN_ID", "KOTLIN_MPP_PLUGIN_ID", "KOTLIN_MPP_PLUGIN_IDS", "", "isKotlinPluginAppliedInTheSameClassloader", "", "project", "Lorg/gradle/api/Project;", "getProjectKotlinPluginKotlinVersion", "Lkotlin/KotlinVersion;", "parseKotlinVersion", "currVersion", "getKotlinAndroidPluginVersion", "getKotlinPluginVersionFromPlugin", "plugin", "Lorg/gradle/api/Plugin;", "isKotlinAndroidPluginApplied", "isKotlinKaptPluginApplied", "isComposeCompilerPluginApplied", "isKspPluginApplied", "configureKotlinCompileTasks", "", "creationConfigs", "Lcom/android/build/gradle/internal/component/ComponentCreationConfig;", "action", "Lkotlin/Function2;", "Lorg/jetbrains/kotlin/gradle/tasks/KotlinCompile;", "recordKgpPropertiesForAnalytics", "recordKotlinCompilePropertiesForAnalytics", "kotlinCompile", "creationConfig", "getLanguageVersionUnsafe", "addComposeArgsToKotlinCompile", "task", "compilerExtension", "Lorg/gradle/api/file/FileCollection;", "useLiveLiterals", "maybeUseInlineScopesNumbers", "logger", "Lorg/gradle/api/logging/Logger;", "addPluginClasspath", "kotlinVersion", "addPluginOption", "pluginId", "key", "value", "isVersionAtLeast", "major", "", "minor", "patch", "(Lkotlin/KotlinVersion;IILjava/lang/Integer;)Z", "maybeAddSourceInformationOption", "syncAgpAndKgpSources", "projectServices", "Lcom/android/build/gradle/internal/services/ProjectServices;", "androidSourceSets", "Lorg/gradle/api/NamedDomainObjectContainer;", "Lcom/android/build/api/dsl/AndroidSourceSet;", "findKaptOrKspConfigurationsForVariant", "Lorg/gradle/api/artifacts/Configuration;", "kaptOrKsp", "maybeAddKotlinStdlibDependency", "kotlinServices", "Lcom/android/build/gradle/internal/services/BuiltInKotlinServices;", "kotlinDependency", "Lorg/gradle/api/artifacts/Dependency;", "kotlin.jvm.PlatformType", "Lorg/gradle/api/artifacts/dsl/DependencyHandler;", "moduleName", "versionOrNull", "KOTLIN_GROUP", "KOTLIN_STDLIB_MODULES", "", "MINIMUM_BUILT_IN_KOTLIN_VERSION", "gradle-core", "kotlinSourceSets", ""})
@JvmName(name="KgpUtils")
@SourceDebugExtension(value={"SMAP\nkgpUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 kgpUtils.kt\ncom/android/build/gradle/internal/utils/KgpUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,484:1\n1755#2,3:485\n1202#2,2:490\n1230#2,4:492\n1755#2,3:497\n1863#2,2:500\n1755#2,3:502\n1611#2,9:505\n1863#2:514\n1864#2:516\n1620#2:517\n1755#2,3:518\n1137#3,2:488\n1#4:496\n1#4:515\n*S KotlinDebug\n*F\n+ 1 kgpUtils.kt\ncom/android/build/gradle/internal/utils/KgpUtils\n*L\n79#1:485,3\n170#1:490,2\n170#1:492,4\n303#1:497,3\n358#1:500,2\n365#1:502,3\n420#1:505,9\n420#1:514\n420#1:516\n420#1:517\n451#1:518,3\n136#1:488,2\n420#1:515\n*E\n"})
public final class KgpUtils {
    @NotNull
    public static final String KOTLIN_ANDROID_PLUGIN_ID = "org.jetbrains.kotlin.android";
    @NotNull
    public static final String ANDROID_BUILT_IN_KOTLIN_PLUGIN_ID = "com.android.experimental.built-in-kotlin";
    @NotNull
    public static final String KOTLIN_KAPT_PLUGIN_ID = "org.jetbrains.kotlin.kapt";
    @NotNull
    public static final String ANDROID_BUILT_IN_KAPT_PLUGIN_ID = "com.android.legacy-kapt";
    @NotNull
    public static final String COMPOSE_COMPILER_PLUGIN_ID = "org.jetbrains.kotlin.plugin.compose";
    @NotNull
    public static final String KSP_PLUGIN_ID = "com.google.devtools.ksp";
    @NotNull
    public static final String KOTLIN_MPP_PLUGIN_ID = "org.jetbrains.kotlin.multiplatform";
    @NotNull
    private static final List<String> KOTLIN_MPP_PLUGIN_IDS;
    @NotNull
    private static final String KOTLIN_GROUP = "org.jetbrains.kotlin";
    @NotNull
    private static final Set<String> KOTLIN_STDLIB_MODULES;
    @NotNull
    public static final String MINIMUM_BUILT_IN_KOTLIN_VERSION = "1.9.20";

    public static final boolean isKotlinPluginAppliedInTheSameClassloader(@NotNull Project project) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        try {
            boolean bl2;
            block6: {
                PluginContainer pluginContainer = project.getPlugins();
                Intrinsics.checkNotNullExpressionValue((Object)pluginContainer, (String)"getPlugins(...)");
                Iterable $this$any$iv = (Iterable)pluginContainer;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Plugin it = (Plugin)element$iv;
                        boolean bl3 = false;
                        if (!(it instanceof KotlinBasePluginWrapper)) continue;
                        bl2 = true;
                        break block6;
                    }
                    bl2 = false;
                }
            }
            bl = bl2;
        }
        catch (Throwable e) {
            if (!(e instanceof ClassNotFoundException) && !(e instanceof NoClassDefFoundError)) {
                throw e;
            }
            bl = false;
        }
        return bl;
    }

    @Nullable
    public static final kotlin.KotlinVersion getProjectKotlinPluginKotlinVersion(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String string = KgpUtils.getKotlinAndroidPluginVersion(project);
        if (string == null) {
            return null;
        }
        String currVersion = string;
        return KgpUtils.parseKotlinVersion(currVersion);
    }

    @Nullable
    public static final kotlin.KotlinVersion parseKotlinVersion(@NotNull String currVersion) {
        Intrinsics.checkNotNullParameter((Object)currVersion, (String)"currVersion");
        try {
            String[] stringArray = new String[]{"."};
            List parts = StringsKt.split$default((CharSequence)currVersion, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            String major = (String)parts.get(0);
            String minor = (String)parts.get(1);
            String patch = StringsKt.substringBefore$default((String)((String)parts.get(2)), (char)'-', null, (int)2, null);
            return new kotlin.KotlinVersion(Integer.parseInt(major), Integer.parseInt(minor), Integer.parseInt(patch));
        }
        catch (Throwable e) {
            kotlin.KotlinVersion kotlinVersion = null;
            return kotlinVersion;
        }
    }

    @Nullable
    public static final String getKotlinAndroidPluginVersion(@NotNull Project project) {
        KotlinBaseApiPlugin kotlinBaseApiPlugin;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        try {
            kotlinBaseApiPlugin = (KotlinBaseApiPlugin)project.getPlugins().findPlugin(KotlinBaseApiPlugin.class);
        }
        catch (Throwable e) {
            if (!(e instanceof ClassNotFoundException) && !(e instanceof NoClassDefFoundError)) {
                throw e;
            }
            kotlinBaseApiPlugin = null;
        }
        KotlinBaseApiPlugin kotlinBaseApiPlugin2 = kotlinBaseApiPlugin;
        Plugin plugin = project.getPlugins().findPlugin("kotlin-android");
        if (plugin == null) {
            KotlinBaseApiPlugin kotlinBaseApiPlugin3 = kotlinBaseApiPlugin2;
            if (kotlinBaseApiPlugin3 != null) {
                plugin = (Plugin)kotlinBaseApiPlugin3;
            } else {
                return null;
            }
        }
        Plugin plugin2 = plugin;
        return KgpUtils.getKotlinPluginVersionFromPlugin(plugin2);
    }

    @Nullable
    public static final String getKotlinPluginVersionFromPlugin(@NotNull Plugin<?> plugin) {
        String string;
        Intrinsics.checkNotNullParameter(plugin, (String)"plugin");
        try {
            Object element$iv2;
            block4: {
                Method[] methodArray = plugin.getClass().getMethods();
                Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"getMethods(...)");
                Object[] $this$first$iv = methodArray;
                boolean $i$f$first = false;
                for (Object element$iv2 : $this$first$iv) {
                    Method it = (Method)element$iv2;
                    boolean bl = false;
                    if (!(Intrinsics.areEqual((Object)it.getName(), (Object)"getKotlinPluginVersion") || Intrinsics.areEqual((Object)it.getName(), (Object)"getPluginVersion"))) {
                        continue;
                    }
                    break block4;
                }
                throw new NoSuchElementException("Array contains no element matching the predicate.");
            }
            Method method = (Method)element$iv2;
            method.setAccessible(true);
            string = method.invoke(plugin, new Object[0]).toString();
        }
        catch (Throwable e) {
            string = null;
        }
        return string;
    }

    public static final boolean isKotlinAndroidPluginApplied(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return project.getPluginManager().hasPlugin(KOTLIN_ANDROID_PLUGIN_ID);
    }

    public static final boolean isKotlinKaptPluginApplied(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return project.getPluginManager().hasPlugin(KOTLIN_KAPT_PLUGIN_ID);
    }

    public static final boolean isComposeCompilerPluginApplied(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return project.getPluginManager().hasPlugin(COMPOSE_COMPILER_PLUGIN_ID);
    }

    public static final boolean isKspPluginApplied(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return project.getPluginManager().hasPlugin(KSP_PLUGIN_ID);
    }

    /*
     * WARNING - void declaration
     */
    public static final void configureKotlinCompileTasks(@NotNull Project project, @NotNull List<? extends ComponentCreationConfig> creationConfigs, @NotNull Function2<? super KotlinCompile, ? super ComponentCreationConfig, Unit> action) {
        void $this$associateByTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(creationConfigs, (String)"creationConfigs");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        Iterable $this$associateBy$iv = creationConfigs;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            ComponentCreationConfig componentCreationConfig = (ComponentCreationConfig)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(it.computeTaskNameInternal("compile", "Kotlin"), element$iv$iv);
        }
        Map taskNamePrefixToVariant = destination$iv$iv;
        project.getTasks().withType(KotlinCompile.class).configureEach(new Action(taskNamePrefixToVariant, action){
            final /* synthetic */ Map<String, ComponentCreationConfig> $taskNamePrefixToVariant;
            final /* synthetic */ Function2<KotlinCompile, ComponentCreationConfig, Unit> $action;
            {
                this.$taskNamePrefixToVariant = $taskNamePrefixToVariant;
                this.$action = $action;
            }

            public final void execute(KotlinCompile kotlinCompile) {
                block1: {
                    ComponentCreationConfig componentCreationConfig;
                    Map<String, ComponentCreationConfig> $this$filterKeys$iv = this.$taskNamePrefixToVariant;
                    boolean $i$f$filterKeys = false;
                    LinkedHashMap<String, ComponentCreationConfig> result$iv = new LinkedHashMap<String, ComponentCreationConfig>();
                    for (Map.Entry<String, ComponentCreationConfig> entry$iv : $this$filterKeys$iv.entrySet()) {
                        String it = entry$iv.getKey();
                        boolean bl = false;
                        String string = kotlinCompile.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                        if (!StringsKt.startsWith$default((String)string, (String)it, (boolean)false, (int)2, null)) continue;
                        result$iv.put(entry$iv.getKey(), entry$iv.getValue());
                    }
                    Map.Entry entry2 = (Map.Entry)CollectionsKt.singleOrNull((Iterable)((Map)result$iv).entrySet());
                    if (entry2 == null || (componentCreationConfig = (ComponentCreationConfig)entry2.getValue()) == null) break block1;
                    ComponentCreationConfig componentCreationConfig2 = componentCreationConfig;
                    Function2<KotlinCompile, ComponentCreationConfig, Unit> function2 = this.$action;
                    ComponentCreationConfig it = componentCreationConfig2;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)kotlinCompile);
                    function2.invoke((Object)kotlinCompile, (Object)it);
                }
            }
        });
    }

    public static final void recordKgpPropertiesForAnalytics(@NotNull Project project, @NotNull List<? extends ComponentCreationConfig> creationConfigs) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(creationConfigs, (String)"creationConfigs");
        KgpUtils.configureKotlinCompileTasks(project, creationConfigs, (Function2<? super KotlinCompile, ? super ComponentCreationConfig, Unit>)((Function2)recordKgpPropertiesForAnalytics.1.INSTANCE));
    }

    public static final void recordKotlinCompilePropertiesForAnalytics(@NotNull KotlinCompile kotlinCompile, @NotNull ComponentCreationConfig creationConfig) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)kotlinCompile, (String)"kotlinCompile");
            Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
            String string = KgpUtils.getLanguageVersionUnsafe(kotlinCompile);
            if (string == null) break block1;
            String languageVersion = string;
            boolean bl = false;
            GradleBuildVariant.Builder builder = ((AnalyticsConfiguratorService)BuildServicesKt.getBuildService(creationConfig.getServices().getBuildServiceRegistry(), AnalyticsConfiguratorService.class).get()).getVariantBuilder(creationConfig.getServices().getProjectInfo().getPath(), creationConfig.getName());
            if (builder != null) {
                GradleBuildVariant.Builder builder2;
                GradleBuildVariant.Builder $this$recordKotlinCompilePropertiesForAnalytics_u24lambda_u244_u24lambda_u243 = builder2 = builder;
                boolean bl2 = false;
                $this$recordKotlinCompilePropertiesForAnalytics_u24lambda_u244_u24lambda_u243.setKotlinOptions(GradleBuildVariant.KotlinOptions.newBuilder().setLanguageVersion(languageVersion));
            }
        }
    }

    private static final String getLanguageVersionUnsafe(KotlinCompile kotlinCompile) {
        String string;
        Object object;
        try {
            boolean bl = false;
            object = Result.constructor-impl((Object)kotlinCompile.getKotlinOptions().getLanguageVersion());
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        if ((string = (String)(Result.isFailure-impl((Object)object) ? null : object)) == null) {
            Object $i$a$-runCatching-KgpUtils$getLanguageVersionUnsafe$42;
            try {
                boolean $i$a$-runCatching-KgpUtils$getLanguageVersionUnsafe$42 = false;
                KotlinVersion kotlinVersion = (KotlinVersion)kotlinCompile.getCompilerOptions().getLanguageVersion().getOrNull();
                $i$a$-runCatching-KgpUtils$getLanguageVersionUnsafe$42 = Result.constructor-impl((Object)(kotlinVersion != null ? kotlinVersion.getVersion() : null));
            }
            catch (Throwable throwable) {
                $i$a$-runCatching-KgpUtils$getLanguageVersionUnsafe$42 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            if ((string = (String)(Result.isFailure-impl((Object)$i$a$-runCatching-KgpUtils$getLanguageVersionUnsafe$42) ? null : $i$a$-runCatching-KgpUtils$getLanguageVersionUnsafe$42)) == null) {
                Object object2;
                try {
                    boolean bl = false;
                    object2 = Result.constructor-impl((Object)KotlinVersion.Companion.getDEFAULT().getVersion());
                }
                catch (Throwable throwable) {
                    object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                string = (String)(Result.isFailure-impl((Object)object2) ? null : object2);
            }
        }
        return string;
    }

    public static final void addComposeArgsToKotlinCompile(@NotNull KotlinCompile task, @NotNull ComponentCreationConfig creationConfig, @NotNull FileCollection compilerExtension, boolean useLiveLiterals) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
        Intrinsics.checkNotNullParameter((Object)compilerExtension, (String)"compilerExtension");
        boolean debuggable = creationConfig instanceof ApkCreationConfig || creationConfig instanceof LibraryCreationConfig ? creationConfig.getDebuggable() : false;
        Project project = task.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        kotlin.KotlinVersion kotlinVersion = KgpUtils.getProjectKotlinPluginKotlinVersion(project);
        KgpUtils.addPluginClasspath(task, kotlinVersion, compilerExtension);
        KgpUtils.maybeAddSourceInformationOption(task, kotlinVersion);
        if (debuggable && useLiveLiterals) {
            KgpUtils.addPluginOption(task, kotlinVersion, "androidx.compose.compiler.plugins.kotlin", "liveLiterals", "true");
        }
        if (KgpUtils.isVersionAtLeast$default(kotlinVersion, 1, 8, null, 4, null)) {
            task.getCompilerOptions().getFreeCompilerArgs().add((Object)"-Xallow-unstable-dependencies");
        } else {
            KotlinJvmOptions kotlinJvmOptions = task.getKotlinOptions();
            kotlinJvmOptions.setFreeCompilerArgs(CollectionsKt.plus((Collection)kotlinJvmOptions.getFreeCompilerArgs(), (Object)"-Xallow-unstable-dependencies"));
        }
    }

    public static final void maybeUseInlineScopesNumbers(@NotNull KotlinCompile task, @NotNull ComponentCreationConfig creationConfig, @NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        if (!creationConfig.getComponentType().isApk() || !creationConfig.getDebuggable()) {
            return;
        }
        Project project = task.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        kotlin.KotlinVersion kotlinVersion = KgpUtils.getProjectKotlinPluginKotlinVersion(project);
        if (kotlinVersion == null || !KgpUtils.isVersionAtLeast$default(kotlinVersion, 2, 0, null, 4, null)) {
            return;
        }
        logger.info("Adding -Xuse-inline-scopes-numbers Kotlin compiler flag for task " + task.getPath());
        task.getCompilerOptions().getFreeCompilerArgs().add((Object)"-Xuse-inline-scopes-numbers");
    }

    private static final void addPluginClasspath(KotlinCompile $this$addPluginClasspath, kotlin.KotlinVersion kotlinVersion, FileCollection compilerExtension) {
        ConfigurableFileCollection configurableFileCollection;
        if (KgpUtils.isVersionAtLeast$default(kotlinVersion, 1, 7, null, 4, null)) {
            Object[] objectArray = new Object[]{compilerExtension};
            configurableFileCollection = $this$addPluginClasspath.getPluginClasspath().from(objectArray);
        } else {
            Object[] objectArray = new Object[]{compilerExtension};
            $this$addPluginClasspath.getInputs().files(objectArray).withPropertyName("composeCompilerExtension").withNormalizer(ClasspathNormalizer.class);
            configurableFileCollection = $this$addPluginClasspath.doFirst(new Action(compilerExtension){
                final /* synthetic */ FileCollection $compilerExtension;
                {
                    this.$compilerExtension = $compilerExtension;
                }

                public final void execute(Task it) {
                    Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.gradle.tasks.KotlinCompile");
                    KotlinJvmOptions kotlinJvmOptions = ((KotlinCompile)it).getKotlinOptions();
                    Collection collection = kotlinJvmOptions.getFreeCompilerArgs();
                    Set set = this.$compilerExtension.getFiles();
                    Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getFiles(...)");
                    kotlinJvmOptions.setFreeCompilerArgs(CollectionsKt.plus((Collection)collection, (Object)("-Xplugin=" + ((File)CollectionsKt.single((Iterable)set)).getPath())));
                }
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void addPluginOption(KotlinCompile $this$addPluginOption, kotlin.KotlinVersion kotlinVersion, String pluginId, String key, String value) {
        KotlinJvmOptions kotlinJvmOptions;
        boolean bl;
        String pluginOption;
        block6: {
            List freeCompilerArgs = KgpUtils.isVersionAtLeast$default(kotlinVersion, 1, 8, null, 4, null) ? (List)$this$addPluginOption.getCompilerOptions().getFreeCompilerArgs().getOrElse((Object)CollectionsKt.emptyList()) : $this$addPluginOption.getKotlinOptions().getFreeCompilerArgs();
            pluginOption = "plugin:" + pluginId + ":" + key;
            Intrinsics.checkNotNull((Object)freeCompilerArgs);
            Iterable $this$any$iv = freeCompilerArgs;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNull((Object)it);
                    if (!StringsKt.startsWith$default((String)it, (String)(pluginOption + "="), (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        if (bl) {
            return;
        }
        if (KgpUtils.isVersionAtLeast(kotlinVersion, 1, 9, 20)) {
            void $this$addPluginOption_u24lambda_u249;
            KotlinJvmOptions $i$f$any = kotlinJvmOptions = new CompilerPluginConfig();
            ListProperty listProperty = $this$addPluginOption.getPluginOptions();
            boolean bl3 = false;
            $this$addPluginOption_u24lambda_u249.addPluginArgument(pluginId, new SubpluginOption(key, value));
            listProperty.add((Object)kotlinJvmOptions);
        } else {
            kotlinJvmOptions = $this$addPluginOption.getKotlinOptions();
            Object[] objectArray = new String[]{"-P", pluginOption + "=" + value};
            kotlinJvmOptions.setFreeCompilerArgs(CollectionsKt.plus((Collection)kotlinJvmOptions.getFreeCompilerArgs(), (Iterable)CollectionsKt.listOf((Object[])objectArray)));
        }
    }

    private static final boolean isVersionAtLeast(kotlin.KotlinVersion $this$isVersionAtLeast, int major, int minor, Integer patch) {
        return $this$isVersionAtLeast == null ? true : (patch == null ? $this$isVersionAtLeast.isAtLeast(major, minor) : $this$isVersionAtLeast.isAtLeast(major, minor, patch.intValue()));
    }

    static /* synthetic */ boolean isVersionAtLeast$default(kotlin.KotlinVersion kotlinVersion, int n, int n2, Integer n3, int n4, Object object) {
        if ((n4 & 4) != 0) {
            n3 = null;
        }
        return KgpUtils.isVersionAtLeast(kotlinVersion, n, n2, n3);
    }

    private static final void maybeAddSourceInformationOption(KotlinCompile $this$maybeAddSourceInformationOption, kotlin.KotlinVersion kotlinVersion) {
        if (KgpUtils.isVersionAtLeast(kotlinVersion, 2, 1, 20)) {
            return;
        }
        KgpUtils.addPluginOption($this$maybeAddSourceInformationOption, kotlinVersion, "androidx.compose.compiler.plugins.kotlin", "sourceInformation", "true");
    }

    public static final void syncAgpAndKgpSources(@NotNull Project project, @NotNull ProjectServices projectServices2, @NotNull NamedDomainObjectContainer<? extends AndroidSourceSet> androidSourceSets) {
        boolean bl;
        boolean $i$f$any;
        block7: {
            String it;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)projectServices2, (String)"projectServices");
            Intrinsics.checkNotNullParameter(androidSourceSets, (String)"androidSourceSets");
            if (projectServices2.getProjectInfo().hasPlugin(ANDROID_BUILT_IN_KOTLIN_PLUGIN_ID)) {
                NamedDomainObjectContainer kotlinSourceSetContainer = projectServices2.getBuiltInKotlinServices().getKotlinAndroidProjectExtension().getSourceSets();
                Iterable $this$forEach$iv = (Iterable)androidSourceSets;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (AndroidSourceSet)element$iv;
                    boolean bl2 = false;
                    kotlinSourceSetContainer.maybeCreate(it.getName());
                }
            }
            Iterable $this$any$iv = KOTLIN_MPP_PLUGIN_IDS;
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    it = (String)element$iv;
                    boolean bl3 = false;
                    if (!project.getPluginManager().hasPlugin(it)) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        boolean hasMpp = bl;
        try {
            Class.forName("org.gradle.api.internal.HasConvention");
            $i$f$any = true;
        }
        catch (Throwable ignored) {
            $i$f$any = false;
        }
        boolean hasConventionSupport = $i$f$any;
        Lazy kotlinSourceSets$delegate = LazyKt.lazy((Function0)((Function0)new Function0<NamedDomainObjectContainer<Object>>(project){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
                super(0);
            }

            public final NamedDomainObjectContainer<Object> invoke() {
                Object object = this.$project.getExtensions().findByName("kotlin");
                if (object == null) {
                    return null;
                }
                Object kotlinExtension2 = object;
                Object object2 = kotlinExtension2.getClass().getMethod("getSourceSets", new Class[0]).invoke(kotlinExtension2, new Object[0]);
                Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type org.gradle.api.NamedDomainObjectContainer<kotlin.Any>");
                return (NamedDomainObjectContainer)object2;
            }
        }));
        androidSourceSets.configureEach(new Action(hasMpp, hasConventionSupport, (Lazy<? extends NamedDomainObjectContainer<Object>>)kotlinSourceSets$delegate){
            final /* synthetic */ boolean $hasMpp;
            final /* synthetic */ boolean $hasConventionSupport;
            final /* synthetic */ Lazy<NamedDomainObjectContainer<Object>> $kotlinSourceSets$delegate;
            {
                this.$hasMpp = $hasMpp;
                this.$hasConventionSupport = $hasConventionSupport;
                this.$kotlinSourceSets$delegate = $kotlinSourceSets$delegate;
            }

            public final void execute(AndroidSourceSet it) {
                Intrinsics.checkNotNull((Object)it);
                SourceDirectorySet kotlinSourceSet = KgpUtils.access$syncAgpAndKgpSources$findKotlinSourceSet(it, this.$hasMpp, this.$hasConventionSupport, this.$kotlinSourceSets$delegate);
                if (kotlinSourceSet != null) {
                    if (!this.$hasMpp) {
                        Object[] objectArray = new Object[1];
                        AndroidSourceDirectorySet androidSourceDirectorySet = it.getKotlin();
                        Intrinsics.checkNotNull((Object)androidSourceDirectorySet, (String)"null cannot be cast to non-null type com.android.build.gradle.internal.api.DefaultAndroidSourceDirectorySet");
                        objectArray[0] = ((DefaultAndroidSourceDirectorySet)androidSourceDirectorySet).getSrcDirs();
                        kotlinSourceSet.srcDirs(objectArray);
                    }
                    AndroidSourceDirectorySet androidSourceDirectorySet = it.getKotlin();
                    Set set = kotlinSourceSet.getSrcDirs();
                    Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getSrcDirs(...)");
                    androidSourceDirectorySet.setSrcDirs((Iterable)set);
                }
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Configuration> findKaptOrKspConfigurationsForVariant(@NotNull ComponentCreationConfig creationConfig, @NotNull String kaptOrKsp) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
        Intrinsics.checkNotNullParameter((Object)kaptOrKsp, (String)"kaptOrKsp");
        Iterable $this$mapNotNull$iv = creationConfig.getSources().getSourceProviderNames();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Configuration it$iv$iv;
            String configurationName;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            String sourceSetName = (String)element$iv$iv;
            boolean bl2 = false;
            String string = configurationName = !Intrinsics.areEqual((Object)sourceSetName, (Object)"main") ? StringHelper.appendCapitalized((String)kaptOrKsp, (String)sourceSetName) : kaptOrKsp;
            if ((Configuration)creationConfig.getServices().getConfigurations().findByName(configurationName) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static final void maybeAddKotlinStdlibDependency(@NotNull Project project, @NotNull ComponentCreationConfig creationConfig, @NotNull BuiltInKotlinServices kotlinServices) {
        String string;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
        Intrinsics.checkNotNullParameter((Object)kotlinServices, (String)"kotlinServices");
        Provider kotlinStdlibDefaultDependencyProperty = project.getProviders().gradleProperty("kotlin.stdlib.default.dependency");
        String string2 = (String)kotlinStdlibDefaultDependencyProperty.getOrNull();
        if (string2 != null) {
            String string3 = string2;
            Locale locale = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
            String string4 = string3.toLowerCase(locale);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
        } else {
            string = null;
        }
        if (Intrinsics.areEqual(string, (Object)"false")) {
            return;
        }
        String kotlinStdlibVersion = kotlinServices.getKotlinAndroidProjectExtension().getCoreLibrariesVersion();
        KgpUtils.maybeAddKotlinStdlibDependency$maybeAddKotlinStdlibDependency(creationConfig.getVariantDependencies().getCompileClasspath(), kotlinStdlibVersion, project);
        KgpUtils.maybeAddKotlinStdlibDependency$maybeAddKotlinStdlibDependency(creationConfig.getVariantDependencies().getRuntimeClasspath(), kotlinStdlibVersion, project);
    }

    /*
     * WARNING - void declaration
     */
    private static final Dependency kotlinDependency(DependencyHandler $this$kotlinDependency, String moduleName, String versionOrNull) {
        String string;
        Object object;
        DependencyHandler dependencyHandler = $this$kotlinDependency;
        String string2 = moduleName;
        String string3 = versionOrNull;
        if (string3 != null) {
            void it;
            String string4 = string3;
            String string5 = string2;
            DependencyHandler dependencyHandler2 = dependencyHandler;
            boolean bl = false;
            String string6 = ":" + (String)it;
            dependencyHandler = dependencyHandler2;
            string2 = string5;
            object = string6;
        } else {
            object = string = null;
        }
        if (object == null) {
            string = "";
        }
        return dependencyHandler.create((Object)("org.jetbrains.kotlin:" + string2 + string));
    }

    private static final NamedDomainObjectContainer<Object> syncAgpAndKgpSources$lambda$12(Lazy<? extends NamedDomainObjectContainer<Object>> $kotlinSourceSets$delegate) {
        Lazy<? extends NamedDomainObjectContainer<Object>> lazy = $kotlinSourceSets$delegate;
        return (NamedDomainObjectContainer)lazy.getValue();
    }

    private static final SourceDirectorySet syncAgpAndKgpSources$findKotlinSourceSet(AndroidSourceSet $this$syncAgpAndKgpSources_u24findKotlinSourceSet, boolean hasMpp, boolean hasConventionSupport, Lazy<? extends NamedDomainObjectContainer<Object>> kotlinSourceSets$delegate) {
        if (hasMpp) {
            if (!hasConventionSupport) {
                return null;
            }
            Object extensions = $this$syncAgpAndKgpSources_u24findKotlinSourceSet.getClass().getMethod("getExtensions", new Class[0]).invoke((Object)$this$syncAgpAndKgpSources_u24findKotlinSourceSet, new Object[0]);
            Object object = extensions.getClass().getMethod("getAsMap", new Class[0]).invoke(extensions, new Object[0]);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any>");
            Map plugins = (Map)object;
            Object v = plugins.get("kotlin");
            if (v == null) {
                return null;
            }
            Object kotlinConvention = v;
            return (SourceDirectorySet)kotlinConvention;
        }
        Object object = KgpUtils.syncAgpAndKgpSources$lambda$12(kotlinSourceSets$delegate);
        if (object == null || (object = object.findByName($this$syncAgpAndKgpSources_u24findKotlinSourceSet.getName())) == null) {
            return null;
        }
        Object kotlinSourceSet = object;
        Object object2 = kotlinSourceSet.getClass().getMethod("getKotlin", new Class[0]).invoke(kotlinSourceSet, new Object[0]);
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type org.gradle.api.file.SourceDirectorySet");
        return (SourceDirectorySet)object2;
    }

    private static final boolean maybeAddKotlinStdlibDependency$hasKotlinStdlibDependency(Configuration $this$maybeAddKotlinStdlibDependency_u24hasKotlinStdlibDependency) {
        boolean bl;
        block3: {
            DomainObjectSet externalDependencies2 = $this$maybeAddKotlinStdlibDependency_u24hasKotlinStdlibDependency.getAllDependencies().matching((Spec)maybeAddKotlinStdlibDependency.hasKotlinStdlibDependency.externalDependencies.1.INSTANCE);
            Intrinsics.checkNotNull((Object)externalDependencies2);
            Iterable $this$any$iv = (Iterable)externalDependencies2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Dependency dependency = (Dependency)element$iv;
                    boolean bl2 = false;
                    if (!(Intrinsics.areEqual((Object)dependency.getGroup(), (Object)KOTLIN_GROUP) && KOTLIN_STDLIB_MODULES.contains(dependency.getName()))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final void maybeAddKotlinStdlibDependency$maybeAddKotlinStdlibDependency(Configuration $this$maybeAddKotlinStdlibDependency_u24maybeAddKotlinStdlibDependency, String kotlinStdlibVersion, Project $project) {
        if (KgpUtils.maybeAddKotlinStdlibDependency$hasKotlinStdlibDependency($this$maybeAddKotlinStdlibDependency_u24maybeAddKotlinStdlibDependency)) {
            return;
        }
        String moduleName = Version.Companion.parse(kotlinStdlibVersion).compareTo(Version.Companion.parse(MINIMUM_BUILT_IN_KOTLIN_VERSION)) < 0 ? "kotlin-stdlib-jdk8" : "kotlin-stdlib";
        DependencySet dependencySet = $this$maybeAddKotlinStdlibDependency_u24maybeAddKotlinStdlibDependency.getDependencies();
        DependencyHandler dependencyHandler = $project.getDependencies();
        Intrinsics.checkNotNullExpressionValue((Object)dependencyHandler, (String)"getDependencies(...)");
        dependencySet.add((Object)KgpUtils.kotlinDependency(dependencyHandler, moduleName, kotlinStdlibVersion));
    }

    public static final /* synthetic */ SourceDirectorySet access$syncAgpAndKgpSources$findKotlinSourceSet(AndroidSourceSet $receiver, boolean hasMpp, boolean hasConventionSupport, Lazy kotlinSourceSets$delegate) {
        return KgpUtils.syncAgpAndKgpSources$findKotlinSourceSet($receiver, hasMpp, hasConventionSupport, (Lazy<? extends NamedDomainObjectContainer<Object>>)kotlinSourceSets$delegate);
    }

    static {
        Object[] objectArray = new String[]{"kotlin-multiplatform", KOTLIN_MPP_PLUGIN_ID};
        KOTLIN_MPP_PLUGIN_IDS = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"kotlin-stdlib", "kotlin-stdlib-jdk7", "kotlin-stdlib-jdk8"};
        KOTLIN_STDLIB_MODULES = SetsKt.setOf((Object[])objectArray);
    }
}

