/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.Version;
import com.android.build.gradle.internal.SdkParsingUtilsKt;
import com.android.build.gradle.internal.utils.ConsoleProgressIndicatorFactory;
import com.android.build.gradle.options.StringOption;
import com.android.builder.core.ToolsRevisionUtils;
import com.android.builder.errors.IssueReporter;
import com.android.ide.common.repository.AgpVersion;
import com.android.io.CancellableFileIo;
import com.android.repository.Revision;
import com.android.repository.api.ConsoleProgressIndicator;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.Repository;
import com.android.repository.impl.meta.SchemaModuleUtil;
import com.android.repository.impl.meta.TypeDetails;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.OptionalLibrary;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.sdklib.repository.meta.Library;
import com.android.sdklib.repository.targets.PlatformTarget;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000R\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0018\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0018\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n\u001a\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u0007\u001a\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u0007\u001a\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000e\u001a\u00020\u0007\u001a \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018\u001a4\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001b2\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0001\u001a\f\u0010\u001c\u001a\u00020\u0018*\u00020\u0011H\u0002\u00a8\u0006\u001d"}, d2={"buildBuildTools", "Lcom/android/sdklib/BuildToolInfo;", "sdkDirectory", "Ljava/io/File;", "revision", "Lcom/android/repository/Revision;", "parsePackage", "Lcom/android/repository/api/LocalPackage;", "packageXml", "consoleProgressIndicatorFactory", "Lcom/android/build/gradle/internal/utils/ConsoleProgressIndicatorFactory;", "parseAdditionalLibraries", "", "Lcom/android/sdklib/OptionalLibrary;", "localPackage", "parseOptionalLibraries", "parseAndroidVersion", "Lcom/android/sdklib/AndroidVersion;", "warnIfCompileSdkTooNew", "", "version", "issueReporter", "Lcom/android/builder/errors/IssueReporter;", "suppressWarningIfTooNewForVersions", "", "maxVersion", "androidGradlePluginVersion", "Lcom/android/ide/common/repository/AgpVersion;", "toStringDescription", "gradle-core"})
@SourceDebugExtension(value={"SMAP\nSdkParsingUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SdkParsingUtils.kt\ncom/android/build/gradle/internal/SdkParsingUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,209:1\n774#2:210\n865#2,2:211\n2642#2:213\n1#3:214\n*S KotlinDebug\n*F\n+ 1 SdkParsingUtils.kt\ncom/android/build/gradle/internal/SdkParsingUtilsKt\n*L\n100#1:210\n100#1:211,2\n101#1:213\n101#1:214\n*E\n"})
public final class SdkParsingUtilsKt {
    @Nullable
    public static final BuildToolInfo buildBuildTools(@NotNull File sdkDirectory2, @NotNull Revision revision) {
        Intrinsics.checkNotNullParameter((Object)sdkDirectory2, (String)"sdkDirectory");
        Intrinsics.checkNotNullParameter((Object)revision, (String)"revision");
        String string = DetailsTypes.getBuildToolsPath((Revision)revision);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getBuildToolsPath(...)");
        String buildToolsPath = StringsKt.replace$default((String)string, (char)';', (char)'/', (boolean)false, (int)4, null);
        BuildToolInfo buildToolInfo = BuildToolInfo.fromStandardDirectoryLayout((Revision)revision, (Path)sdkDirectory2.toPath().resolve(buildToolsPath));
        if (!buildToolInfo.isValid(null)) {
            return null;
        }
        return buildToolInfo;
    }

    @Nullable
    public static final LocalPackage parsePackage(@NotNull File packageXml, @NotNull ConsoleProgressIndicatorFactory consoleProgressIndicatorFactory) {
        Repository repo;
        block4: {
            Intrinsics.checkNotNullParameter((Object)packageXml, (String)"packageXml");
            Intrinsics.checkNotNullParameter((Object)consoleProgressIndicatorFactory, (String)"consoleProgressIndicatorFactory");
            if (!packageXml.exists()) {
                return null;
            }
            ConsoleProgressIndicator progress = consoleProgressIndicatorFactory.create("SDK processing. ");
            repo = null;
            try {
                Object object = SchemaModuleUtil.unmarshal((InputStream)new FileInputStream(packageXml), (Collection)AndroidSdkHandler.getAllModules(), (boolean)false, (ProgressIndicator)((ProgressIndicator)progress), (String)packageXml.getName());
                if (object == null) {
                    return null;
                }
                Object parsedObject = object;
                repo = (Repository)parsedObject;
            }
            catch (IOException e) {
                progress.logError("Error parsing " + packageXml + ".", (Throwable)e);
                return null;
            }
            LocalPackage localPackage = repo.getLocalPackage();
            if (localPackage == null) break block4;
            localPackage.setInstalledPath(packageXml.toPath().getParent());
        }
        return repo.getLocalPackage();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<OptionalLibrary> parseAdditionalLibraries(@NotNull LocalPackage localPackage) {
        List list;
        Intrinsics.checkNotNullParameter((Object)localPackage, (String)"localPackage");
        if (!(localPackage.getTypeDetails() instanceof DetailsTypes.AddonDetailsType)) {
            ImmutableList immutableList = ImmutableList.of();
            Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"of(...)");
            return (List)immutableList;
        }
        TypeDetails typeDetails = localPackage.getTypeDetails();
        Intrinsics.checkNotNull((Object)typeDetails, (String)"null cannot be cast to non-null type com.android.sdklib.repository.meta.DetailsTypes.AddonDetailsType");
        DetailsTypes.AddonDetailsType details = (DetailsTypes.AddonDetailsType)typeDetails;
        DetailsTypes.AddonDetailsType.Libraries libraries = details.getLibraries();
        if (libraries != null) {
            void $this$onEach$iv;
            Library it;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            DetailsTypes.AddonDetailsType.Libraries libraries2 = libraries;
            boolean bl = false;
            List list2 = libraries2.getLibrary();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getLibrary(...)");
            Iterable iterable = list2;
            boolean $i$f$filter = false;
            void var6_6 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (Library)element$iv$iv;
                boolean bl2 = false;
                if (!(it.getLocalJarPath() != null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$onEach = false;
            void $this$onEach_u24lambda_u2419$iv = var6_6 = $this$onEach$iv;
            boolean bl3 = false;
            for (Object element$iv : $this$onEach_u24lambda_u2419$iv) {
                it = (Library)element$iv;
                boolean bl4 = false;
                it.setPackagePath(localPackage.getLocation());
            }
            list = (List)var6_6;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @NotNull
    public static final List<OptionalLibrary> parseOptionalLibraries(@NotNull LocalPackage localPackage) {
        Intrinsics.checkNotNullParameter((Object)localPackage, (String)"localPackage");
        Path optionalJson = localPackage.getLocation().resolve("optional/optional.json");
        if (CancellableFileIo.isRegularFile((Path)optionalJson, (LinkOption[])new LinkOption[0])) {
            List list = PlatformTarget.getLibsFromJson((Path)optionalJson);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getLibsFromJson(...)");
            return list;
        }
        return CollectionsKt.emptyList();
    }

    @Nullable
    public static final AndroidVersion parseAndroidVersion(@NotNull LocalPackage localPackage) {
        Intrinsics.checkNotNullParameter((Object)localPackage, (String)"localPackage");
        TypeDetails typeDetails = localPackage.getTypeDetails();
        DetailsTypes.ApiDetailsType apiDetailsType = typeDetails instanceof DetailsTypes.ApiDetailsType ? (DetailsTypes.ApiDetailsType)typeDetails : null;
        return apiDetailsType != null ? apiDetailsType.getAndroidVersion() : null;
    }

    public static final void warnIfCompileSdkTooNew(@NotNull AndroidVersion version, @NotNull IssueReporter issueReporter2, @Nullable String suppressWarningIfTooNewForVersions) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)issueReporter2, (String)"issueReporter");
        AndroidVersion androidVersion = ToolsRevisionUtils.MAX_RECOMMENDED_COMPILE_SDK_VERSION;
        Intrinsics.checkNotNullExpressionValue((Object)androidVersion, (String)"MAX_RECOMMENDED_COMPILE_SDK_VERSION");
        String string = Version.ANDROID_GRADLE_PLUGIN_VERSION;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ANDROID_GRADLE_PLUGIN_VERSION");
        SdkParsingUtilsKt.warnIfCompileSdkTooNew(version, issueReporter2, androidVersion, AgpVersion.Companion.parse(string), suppressWarningIfTooNewForVersions);
    }

    /*
     * Unable to fully structure code
     */
    @VisibleForTesting
    public static final void warnIfCompileSdkTooNew(@NotNull AndroidVersion version, @NotNull IssueReporter issueReporter, @NotNull AndroidVersion maxVersion, @NotNull AgpVersion androidGradlePluginVersion, @Nullable String suppressWarningIfTooNewForVersions) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)issueReporter, (String)"issueReporter");
        Intrinsics.checkNotNullParameter((Object)maxVersion, (String)"maxVersion");
        Intrinsics.checkNotNullParameter((Object)androidGradlePluginVersion, (String)"androidGradlePluginVersion");
        if (AndroidVersion.API_LEVEL_ORDERING.compare(version, maxVersion) <= 0) {
            return;
        }
        if (version.isPreview() && Intrinsics.areEqual((Object)version.getAndroidApiLevel(), (Object)maxVersion.getAndroidApiLevel()) && !maxVersion.isPreview() && (androidGradlePluginVersion.getPreviewKind() == AgpVersion.PreviewKind.ALPHA || androidGradlePluginVersion.getPreviewKind() == AgpVersion.PreviewKind.DEV)) {
            return;
        }
        suppressName = version.getApiStringWithoutExtension();
        if (suppressWarningIfTooNewForVersions == null) ** GOTO lbl-1000
        var8_6 = new String[]{","};
        var7_7 = StringsKt.splitToSequence$default((CharSequence)suppressWarningIfTooNewForVersions, (String[])var8_6, (boolean)false, (int)0, (int)6, null);
        if (var7_7 != null && (var8_6 = SequencesKt.map((Sequence)var7_7, (Function1)warnIfCompileSdkTooNew.suppressSet.1.INSTANCE)) != null && (var9_8 = SequencesKt.filter((Sequence)var8_6, (Function1)warnIfCompileSdkTooNew.suppressSet.2.INSTANCE)) != null && (var10_9 = SequencesKt.toSet((Sequence)var9_8)) != null) {
            v0 = var10_9;
        } else lbl-1000:
        // 2 sources

        {
            v0 = suppressSet = SetsKt.emptySet();
        }
        if (suppressSet.contains(suppressName)) {
            return;
        }
        currentCompileSdk = SdkParsingUtilsKt.toStringDescription(version);
        maxCompileSdk = SdkParsingUtilsKt.toStringDescription(new AndroidVersion(maxVersion.getAndroidApiLevel())) + (String)(maxVersion.isPreview() != false && version.isPreview() != false ? " (and " + SdkParsingUtilsKt.toStringDescription(maxVersion) + ")" : "");
        preview = version.isPreview() != false ? "preview " : "";
        headline = version.isPreview() != false ? currentCompileSdk + " has not been tested with this version of the Android Gradle plugin." : "We recommend using a newer Android Gradle plugin to use " + currentCompileSdk;
        recommendation = version.isPreview() != false ? "" : "\n        You are strongly encouraged to update your project to use a newer\n        Android Gradle plugin that has been tested with " + currentCompileSdk + ".\n        ";
        var13_12 = suppressWarningIfTooNewForVersions;
        suppressOption = (var13_12 == null || var13_12.length() == 0) != false ? StringOption.SUPPRESS_UNSUPPORTED_COMPILE_SDK.getPropertyName() + "=" + suppressName : StringOption.SUPPRESS_UNSUPPORTED_COMPILE_SDK.getPropertyName() + "=" + CollectionsKt.joinToString$default((Iterable)suppressSet, (CharSequence)",", null, null, (int)0, null, null, (int)62, null) + "," + suppressName;
        IssueReporter.reportWarning$default((IssueReporter)issueReporter, (IssueReporter.Type)IssueReporter.Type.COMPILE_SDK_VERSION_TOO_HIGH, (String)StringsKt.trimIndent((String)("\n        " + headline + "\n\n        This Android Gradle plugin (" + androidGradlePluginVersion + ") was tested up to " + maxCompileSdk + ".\n        " + (String)recommendation + "\n        If you are already using the latest " + preview + "version of the Android Gradle plugin,\n        you may need to wait until a newer version with support for " + currentCompileSdk + " is available.\n\n        For more information refer to the compatibility table:\n        https://d.android.com/r/tools/api-level-support\n\n        To suppress this warning, add/update\n            " + suppressOption + "\n        to this project's gradle.properties.\n        ")), (String)suppressOption, null, (int)8, null);
    }

    public static /* synthetic */ void warnIfCompileSdkTooNew$default(AndroidVersion androidVersion, IssueReporter issueReporter2, AndroidVersion androidVersion2, AgpVersion agpVersion, String string, int n, Object object) {
        if ((n & 0x10) != 0) {
            string = null;
        }
        SdkParsingUtilsKt.warnIfCompileSdkTooNew(androidVersion, issueReporter2, androidVersion2, agpVersion, string);
    }

    private static final String toStringDescription(AndroidVersion $this$toStringDescription) {
        return $this$toStringDescription.isPreview() ? "compile SDK preview version \"" + $this$toStringDescription.getCodename() + "\"" : "compile SDK version " + $this$toStringDescription.getApiStringWithoutExtension();
    }
}

