/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.lint;

import com.android.build.api.component.impl.TestFixturesImpl;
import com.android.build.api.dsl.Lint;
import com.android.build.api.variant.impl.AndroidVersionImpl;
import com.android.build.api.variant.impl.HasTestFixtures;
import com.android.build.gradle.internal.TaskManager;
import com.android.build.gradle.internal.component.ApkCreationConfig;
import com.android.build.gradle.internal.component.ApplicationCreationConfig;
import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.component.DeviceTestCreationConfig;
import com.android.build.gradle.internal.component.HostTestCreationConfig;
import com.android.build.gradle.internal.component.TestComponentCreationConfig;
import com.android.build.gradle.internal.component.TestCreationConfig;
import com.android.build.gradle.internal.component.TestSuiteCreationConfig;
import com.android.build.gradle.internal.component.VariantCreationConfig;
import com.android.build.gradle.internal.lint.AndroidLintAnalysisTask;
import com.android.build.gradle.internal.lint.AndroidLintCopyReportTask;
import com.android.build.gradle.internal.lint.AndroidLintGlobalTask;
import com.android.build.gradle.internal.lint.AndroidLintTask;
import com.android.build.gradle.internal.lint.AndroidLintTextOutputTask;
import com.android.build.gradle.internal.lint.LintModelWriterTask;
import com.android.build.gradle.internal.lint.LintTaskManager;
import com.android.build.gradle.internal.lint.VariantWithTests;
import com.android.build.gradle.internal.tasks.LintModelMetadataTask;
import com.android.build.gradle.internal.tasks.factory.GlobalTaskCreationConfig;
import com.android.build.gradle.internal.tasks.factory.TaskFactory;
import com.android.build.gradle.internal.utils.SdkUtilsKt;
import com.android.builder.core.ComponentType;
import com.android.builder.core.ComponentTypeImpl;
import com.android.builder.errors.IssueReporter;
import com.android.utils.StringHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.execution.TaskExecutionGraph;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 &2\u00020\u0001:\u0001&B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\n\u001a\u00020\u000bJ<\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u0018JH\u0010\u0019\u001a\u001e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u001b0\u001aj\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u001b`\u001c2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u001d\u001a\u00020\u0018H\u0002J\u0018\u0010\u001e\u001a\u00020\u00102\u000e\u0010\u001f\u001a\n\u0012\u0006\b\u0001\u0012\u00020!0 H\u0002J\u0010\u0010\u001e\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020\u0010H\u0002J&\u0010#\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010$\u001a\u00020%H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/android/build/gradle/internal/lint/LintTaskManager;", "", "globalTaskCreationConfig", "Lcom/android/build/gradle/internal/tasks/factory/GlobalTaskCreationConfig;", "taskFactory", "Lcom/android/build/gradle/internal/tasks/factory/TaskFactory;", "project", "Lorg/gradle/api/Project;", "<init>", "(Lcom/android/build/gradle/internal/tasks/factory/GlobalTaskCreationConfig;Lcom/android/build/gradle/internal/tasks/factory/TaskFactory;Lorg/gradle/api/Project;)V", "createBeforeEvaluateLintTasks", "", "createLintTasks", "componentType", "Lcom/android/builder/core/ComponentType;", "defaultVariant", "", "variantPropertiesList", "", "Lcom/android/build/gradle/internal/component/VariantCreationConfig;", "testComponentPropertiesList", "", "Lcom/android/build/gradle/internal/component/TestComponentCreationConfig;", "isPerComponent", "", "attachTestsToVariants", "Ljava/util/LinkedHashMap;", "Lcom/android/build/gradle/internal/lint/VariantWithTests;", "Lkotlin/collections/LinkedHashMap;", "ignoreTestFixturesSources", "getTaskPath", "task", "Lorg/gradle/api/tasks/TaskProvider;", "Lorg/gradle/api/Task;", "taskName", "runConfigurationValidation", "lintOptions", "Lcom/android/build/api/dsl/Lint;", "Companion", "gradle-core"})
@SourceDebugExtension(value={"SMAP\nLintTaskManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LintTaskManager.kt\ncom/android/build/gradle/internal/lint/LintTaskManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,418:1\n1#2:419\n381#3,7:420\n216#4,2:427\n*S KotlinDebug\n*F\n+ 1 LintTaskManager.kt\ncom/android/build/gradle/internal/lint/LintTaskManager\n*L\n375#1:420,7\n379#1:427,2\n*E\n"})
public final class LintTaskManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GlobalTaskCreationConfig globalTaskCreationConfig;
    @NotNull
    private final TaskFactory taskFactory;
    @NotNull
    private final Project project;

    public LintTaskManager(@NotNull GlobalTaskCreationConfig globalTaskCreationConfig, @NotNull TaskFactory taskFactory, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)globalTaskCreationConfig, (String)"globalTaskCreationConfig");
        Intrinsics.checkNotNullParameter((Object)taskFactory, (String)"taskFactory");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.globalTaskCreationConfig = globalTaskCreationConfig;
        this.taskFactory = taskFactory;
        this.project = project;
    }

    public final void createBeforeEvaluateLintTasks() {
        this.taskFactory.register(new AndroidLintGlobalTask.LintFixCreationAction(this.globalTaskCreationConfig));
        TaskProvider globalTask = this.taskFactory.register(new AndroidLintGlobalTask.GlobalCreationAction(this.globalTaskCreationConfig));
        this.taskFactory.configure("check", (Action<? super Task>)new Action(globalTask){
            final /* synthetic */ TaskProvider<AndroidLintGlobalTask> $globalTask;
            {
                this.$globalTask = $globalTask;
            }

            public final void execute(Task it) {
                Object[] objectArray = new Object[]{this.$globalTask};
                it.dependsOn(objectArray);
            }
        });
        this.taskFactory.register(new AndroidLintGlobalTask.UpdateBaselineCreationAction(this.globalTaskCreationConfig));
    }

    public final void createLintTasks(@NotNull ComponentType componentType, @Nullable String defaultVariant, @NotNull List<? extends VariantCreationConfig> variantPropertiesList, @NotNull Collection<? extends TestComponentCreationConfig> testComponentPropertiesList, boolean isPerComponent) {
        Intrinsics.checkNotNullParameter((Object)componentType, (String)"componentType");
        Intrinsics.checkNotNullParameter(variantPropertiesList, (String)"variantPropertiesList");
        Intrinsics.checkNotNullParameter(testComponentPropertiesList, (String)"testComponentPropertiesList");
        Lint lintOptions2 = this.globalTaskCreationConfig.getLintOptions();
        this.runConfigurationValidation(componentType, variantPropertiesList, lintOptions2);
        if (componentType.isForTesting()) {
            return;
        }
        LinkedHashMap<String, VariantWithTests> variantsWithTests = this.attachTestsToVariants(variantPropertiesList, lintOptions2.getIgnoreTestSources() ? (Collection)CollectionsKt.emptyList() : testComponentPropertiesList, lintOptions2.getIgnoreTestFixturesSources());
        Map variantLintTaskToLintVitalTask = new LinkedHashMap();
        boolean needsCopyReportTask = Companion.needsCopyReportTask(lintOptions2);
        Iterator<VariantWithTests> iterator2 = variantsWithTests.values().iterator();
        while (iterator2.hasNext()) {
            TaskProvider taskProvider;
            TaskProvider taskProvider2;
            TaskProvider variantLintTextOutputTask;
            VariantWithTests variantWithTests;
            Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
            VariantCreationConfig mainVariant = variantWithTests.getMain();
            TaskProvider taskProvider3 = variantLintTextOutputTask = componentType.isDynamicFeature() ? null : this.taskFactory.register(new AndroidLintTextOutputTask.SingleVariantCreationAction(mainVariant));
            if (this.globalTaskCreationConfig.getAvoidTaskRegistration()) continue;
            if (componentType.isAar() || componentType.isDynamicFeature()) {
                TaskProvider taskProvider4 = isPerComponent ? this.taskFactory.register(new LintModelWriterTask.PerComponentCreationAction((ComponentCreationConfig)mainVariant, componentType.isAar(), true, false)) : this.taskFactory.register(new LintModelWriterTask.CreationAction(new VariantWithTests(mainVariant, null, null, null), componentType.isAar(), true, false));
                this.taskFactory.register(new AndroidLintAnalysisTask.LintVitalCreationAction(mainVariant));
                if (componentType.isAar()) {
                    this.taskFactory.register(new LintModelMetadataTask.CreationAction(mainVariant));
                }
            }
            if (isPerComponent) {
                this.taskFactory.register(new LintModelWriterTask.PerComponentCreationAction((ComponentCreationConfig)mainVariant, componentType.isAar(), false, false));
                taskProvider2 = this.taskFactory.register(new AndroidLintAnalysisTask.PerComponentCreationAction(mainVariant, false));
            } else {
                this.taskFactory.register(new LintModelWriterTask.CreationAction(variantWithTests, componentType.isAar(), false, false));
                taskProvider2 = this.taskFactory.register(new AndroidLintAnalysisTask.SingleVariantCreationAction(variantWithTests));
            }
            if (componentType.isDynamicFeature()) continue;
            TaskProvider taskProvider5 = isPerComponent ? this.taskFactory.register(new LintModelWriterTask.PerComponentCreationAction((ComponentCreationConfig)mainVariant, true, false, true)) : this.taskFactory.register(new LintModelWriterTask.CreationAction(variantWithTests, true, false, true));
            TaskProvider updateLintBaselineTask2 = this.taskFactory.register(new AndroidLintTask.UpdateBaselineCreationAction(variantWithTests));
            TaskProvider it = taskProvider = this.taskFactory.register(new AndroidLintTask.SingleVariantCreationAction(variantWithTests));
            boolean bl = false;
            it.configure(new Action(updateLintBaselineTask2){
                final /* synthetic */ TaskProvider<AndroidLintTask> $updateLintBaselineTask;
                {
                    this.$updateLintBaselineTask = $updateLintBaselineTask;
                }

                public final void execute(AndroidLintTask task) {
                    Object[] objectArray = new Object[]{this.$updateLintBaselineTask};
                    task.mustRunAfter(objectArray);
                }
            });
            TaskProvider variantLintTask2 = taskProvider;
            if (needsCopyReportTask) {
                TaskProvider copyLintReportTask = this.taskFactory.register(new AndroidLintCopyReportTask.CreationAction(mainVariant));
                TaskProvider taskProvider6 = variantLintTextOutputTask;
                if (taskProvider6 != null) {
                    taskProvider6.configure(new Action(copyLintReportTask){
                        final /* synthetic */ TaskProvider<AndroidLintCopyReportTask> $copyLintReportTask;
                        {
                            this.$copyLintReportTask = $copyLintReportTask;
                        }

                        public final void execute(AndroidLintTextOutputTask it) {
                            Object[] objectArray = new Object[]{this.$copyLintReportTask};
                            it.finalizedBy(objectArray);
                        }
                    });
                }
            }
            if (Companion.shouldRegisterLintVitalTasks(mainVariant)) {
                TaskProvider taskProvider7;
                if (isPerComponent) {
                    this.taskFactory.register(new AndroidLintAnalysisTask.PerComponentCreationAction(mainVariant, true));
                    taskProvider7 = this.taskFactory.register(new LintModelWriterTask.PerComponentCreationAction((ComponentCreationConfig)mainVariant, true, true, true));
                } else {
                    this.taskFactory.register(new AndroidLintAnalysisTask.LintVitalCreationAction(mainVariant));
                    taskProvider7 = this.taskFactory.register(new LintModelWriterTask.CreationAction(new VariantWithTests(mainVariant, null, null, null), true, true, true));
                }
                TaskProvider it2 = it = this.taskFactory.register(new AndroidLintTask.LintVitalCreationAction(mainVariant));
                boolean bl2 = false;
                it2.configure(new Action(updateLintBaselineTask2){
                    final /* synthetic */ TaskProvider<AndroidLintTask> $updateLintBaselineTask;
                    {
                        this.$updateLintBaselineTask = $updateLintBaselineTask;
                    }

                    public final void execute(AndroidLintTask task) {
                        Object[] objectArray = new Object[]{this.$updateLintBaselineTask};
                        task.mustRunAfter(objectArray);
                    }
                });
                TaskProvider lintVitalTask2 = it;
                TaskProvider lintVitalTextOutputTask = this.taskFactory.register(new AndroidLintTextOutputTask.LintVitalCreationAction(mainVariant));
                variantLintTaskToLintVitalTask.put(this.getTaskPath(variantLintTask2), lintVitalTask2);
                if (variantLintTextOutputTask != null) {
                    TaskProvider it3;
                    boolean bl3 = false;
                    variantLintTaskToLintVitalTask.put(this.getTaskPath(it3), lintVitalTextOutputTask);
                }
            }
            it = taskProvider = this.taskFactory.register(new AndroidLintTask.FixSingleVariantCreationAction(variantWithTests));
            boolean bl4 = false;
            it.configure(new Action(updateLintBaselineTask2){
                final /* synthetic */ TaskProvider<AndroidLintTask> $updateLintBaselineTask;
                {
                    this.$updateLintBaselineTask = $updateLintBaselineTask;
                }

                public final void execute(AndroidLintTask task) {
                    Object[] objectArray = new Object[]{this.$updateLintBaselineTask};
                    task.mustRunAfter(objectArray);
                }
            });
        }
        if (componentType.isDynamicFeature()) {
            return;
        }
        if (this.globalTaskCreationConfig.getAvoidTaskRegistration()) {
            return;
        }
        if (defaultVariant != null) {
            this.taskFactory.configure("lint", AndroidLintGlobalTask.class, (Action)new Action(defaultVariant){
                final /* synthetic */ String $defaultVariant;
                {
                    this.$defaultVariant = $defaultVariant;
                }

                public final void execute(AndroidLintGlobalTask globalTask) {
                    Object[] objectArray = new Object[]{StringHelper.appendCapitalized((String)"lint", (String)this.$defaultVariant)};
                    globalTask.dependsOn(objectArray);
                }
            });
            this.taskFactory.configure("lintFix", AndroidLintGlobalTask.class, (Action)new Action(defaultVariant){
                final /* synthetic */ String $defaultVariant;
                {
                    this.$defaultVariant = $defaultVariant;
                }

                public final void execute(AndroidLintGlobalTask globalFixTask) {
                    Object[] objectArray = new Object[]{StringHelper.appendCapitalized((String)"lintFix", (String)this.$defaultVariant)};
                    globalFixTask.dependsOn(objectArray);
                }
            });
            this.taskFactory.configure("updateLintBaseline", AndroidLintGlobalTask.class, (Action)new Action(defaultVariant){
                final /* synthetic */ String $defaultVariant;
                {
                    this.$defaultVariant = $defaultVariant;
                }

                public final void execute(AndroidLintGlobalTask updateLintBaselineTask2) {
                    Object[] objectArray = new Object[]{StringHelper.appendCapitalized((String)"updateLintBaseline", (String)this.$defaultVariant)};
                    updateLintBaselineTask2.dependsOn(objectArray);
                }
            });
        }
        String lintTaskPath = this.getTaskPath("lint");
        this.project.getGradle().getTaskGraph().whenReady(new Action(variantLintTaskToLintVitalTask, lintTaskPath){
            final /* synthetic */ Map<String, TaskProvider<? extends Task>> $variantLintTaskToLintVitalTask;
            final /* synthetic */ String $lintTaskPath;
            {
                this.$variantLintTaskToLintVitalTask = $variantLintTaskToLintVitalTask;
                this.$lintTaskPath = $lintTaskPath;
            }

            public final void execute(TaskExecutionGraph it) {
                Map.Entry<String, TaskProvider<? extends Task>> entry2;
                Map.Entry<String, TaskProvider<? extends Task>> element$iv;
                Map<String, TaskProvider<? extends Task>> $this$forEach$iv = this.$variantLintTaskToLintVitalTask;
                boolean $i$f$forEach = false;
                Iterator<Map.Entry<String, TaskProvider<? extends Task>>> iterator2 = $this$forEach$iv.entrySet().iterator();
                while (iterator2.hasNext()) {
                    entry2 = element$iv = iterator2.next();
                    boolean bl = false;
                    String taskPath = entry2.getKey();
                    TaskProvider<? extends Task> taskToDisable = entry2.getValue();
                    if (!it.hasTask(taskPath)) continue;
                    taskToDisable.configure((Action)createLintTasks.1.1.INSTANCE);
                }
                if (it.hasTask(this.$lintTaskPath)) {
                    $this$forEach$iv = this.$variantLintTaskToLintVitalTask;
                    $i$f$forEach = false;
                    iterator2 = $this$forEach$iv.entrySet().iterator();
                    while (iterator2.hasNext()) {
                        entry2 = element$iv = iterator2.next();
                        boolean bl = false;
                        TaskProvider<? extends Task> lintVitalTask2 = entry2.getValue();
                        lintVitalTask2.configure((Action)createLintTasks.2.1.INSTANCE);
                    }
                }
            }
        });
    }

    private final LinkedHashMap<String, VariantWithTests> attachTestsToVariants(List<? extends VariantCreationConfig> variantPropertiesList, Collection<? extends TestComponentCreationConfig> testComponentPropertiesList, boolean ignoreTestFixturesSources) {
        Object object;
        LinkedHashMap<String, VariantWithTests> variantsWithTests = new LinkedHashMap<String, VariantWithTests>();
        for (VariantCreationConfig variantCreationConfig : variantPropertiesList) {
            TestFixturesImpl testFixturesImpl;
            Map map = variantsWithTests;
            String string = variantCreationConfig.getName();
            if (ignoreTestFixturesSources) {
                testFixturesImpl = null;
            } else {
                HasTestFixtures hasTestFixtures = variantCreationConfig instanceof HasTestFixtures ? (HasTestFixtures)((Object)variantCreationConfig) : null;
                testFixturesImpl = hasTestFixtures != null ? hasTestFixtures.getTestFixtures() : null;
            }
            object = new VariantWithTests(variantCreationConfig, null, null, testFixturesImpl, 6, null);
            map.put(string, object);
        }
        for (TestComponentCreationConfig testComponentCreationConfig : testComponentPropertiesList) {
            VariantWithTests current;
            String key = testComponentCreationConfig.getMainVariant().getName();
            Intrinsics.checkNotNull((Object)variantsWithTests.get(key));
            object = testComponentCreationConfig;
            if (object instanceof DeviceTestCreationConfig) {
                testComponentCreationConfig.getComponentType();
                if (!(current.getAndroidTest() == null)) {
                    boolean bl = false;
                    String string = "Component " + current.getMain() + " appears to have two conflicting android test components " + current.getAndroidTest() + " and " + testComponentCreationConfig;
                    throw new IllegalStateException(string.toString());
                }
                ((Map)variantsWithTests).put(key, new VariantWithTests(current.getMain(), (DeviceTestCreationConfig)testComponentCreationConfig, current.getUnitTest(), current.getTestFixtures()));
                continue;
            }
            if (object instanceof HostTestCreationConfig) {
                ComponentType componentType = testComponentCreationConfig.getComponentType();
                if (componentType == ComponentTypeImpl.UNIT_TEST) {
                    if (!(current.getUnitTest() == null)) {
                        boolean bl = false;
                        String string = "Component " + current.getMain() + " appears to have two conflicting unit test components " + current.getUnitTest() + " and " + testComponentCreationConfig;
                        throw new IllegalStateException(string.toString());
                    }
                    ((Map)variantsWithTests).put(key, new VariantWithTests(current.getMain(), current.getAndroidTest(), (HostTestCreationConfig)testComponentCreationConfig, current.getTestFixtures()));
                    continue;
                }
                if (componentType != ComponentTypeImpl.SCREENSHOT_TEST) continue;
                continue;
            }
            if (object instanceof TestSuiteCreationConfig) continue;
            throw new IllegalStateException("Unexpected test component type");
        }
        return variantsWithTests;
    }

    private final String getTaskPath(TaskProvider<? extends Task> task) {
        String string = task.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return this.getTaskPath(string);
    }

    private final String getTaskPath(String taskName) {
        return TaskManager.Companion.getTaskPath(this.project, taskName);
    }

    /*
     * WARNING - void declaration
     */
    private final void runConfigurationValidation(ComponentType componentType, List<? extends VariantCreationConfig> variantPropertiesList, Lint lintOptions2) {
        Lint $this$runConfigurationValidation_u24lambda_u246 = lintOptions2;
        boolean bl = false;
        AndroidVersionImpl targetSdkVersion2 = SdkUtilsKt.createTargetSdkVersion($this$runConfigurationValidation_u24lambda_u246.getTargetSdk(), $this$runConfigurationValidation_u24lambda_u246.getTargetSdkPreview());
        if (targetSdkVersion2 != null && !componentType.isAar()) {
            Map versionToName = new LinkedHashMap();
            for (VariantCreationConfig variantCreationConfig : variantPropertiesList) {
                Object object;
                void $this$getOrPut$iv;
                Object object2 = variantCreationConfig;
                Object variantTargetSdkVersion = object2 instanceof ApkCreationConfig ? ((ApkCreationConfig)((Object)variantCreationConfig)).getTargetSdk() : (object2 instanceof TestCreationConfig ? ((TestCreationConfig)((Object)variantCreationConfig)).getTargetSdkVersion() : null);
                if (variantTargetSdkVersion == null || targetSdkVersion2.getApiLevel() >= variantTargetSdkVersion.getApiLevel()) continue;
                object2 = versionToName;
                Integer key$iv = variantTargetSdkVersion.getApiLevel();
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl2 = false;
                    List answer$iv = new ArrayList();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                ((List)object).add(variantCreationConfig.getName());
            }
            Map $this$forEach$iv = versionToName;
            boolean bl2 = false;
            Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry2 = element$iv = iterator2.next();
                boolean bl3 = false;
                int variantSdkLevel = ((Number)entry2.getKey()).intValue();
                List names = (List)entry2.getValue();
                IssueReporter issueReporter2 = this.globalTaskCreationConfig.getServices().getIssueReporter();
                Locale locale = Locale.US;
                String string = "lint.targetSdk (%d) for non library is smaller than android.targetSdk (%d) for variants %s. Please change the values such that lint.targetSdk is greater than or equal to android.targetSdk.";
                Object[] objectArray = new Object[]{targetSdkVersion2.getApiLevel(), variantSdkLevel, CollectionsKt.joinToString$default((Iterable)names, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null)};
                String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                IssueReporter.reportError$default((IssueReporter)issueReporter2, (IssueReporter.Type)IssueReporter.Type.GENERIC, (String)string2, null, null, (int)12, null);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0011\u0010\u0004\u001a\u00020\u0005*\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u0007J\u0011\u0010\b\u001a\u00020\u0005*\u00020\u0006H\u0000\u00a2\u0006\u0002\b\tJ\u000e\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f\u00a8\u0006\u0010"}, d2={"Lcom/android/build/gradle/internal/lint/LintTaskManager$Companion;", "", "<init>", "()V", "isLintStdout", "", "Ljava/io/File;", "isLintStdout$gradle_core", "isLintStderr", "isLintStderr$gradle_core", "needsCopyReportTask", "lintOptions", "Lcom/android/build/api/dsl/Lint;", "shouldRegisterLintVitalTasks", "variant", "Lcom/android/build/gradle/internal/component/ComponentCreationConfig;", "gradle-core"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isLintStdout$gradle_core(@NotNull File $this$isLintStdout) {
            Intrinsics.checkNotNullParameter((Object)$this$isLintStdout, (String)"<this>");
            return Intrinsics.areEqual((Object)$this$isLintStdout.getPath(), (Object)new File("stdout").getPath());
        }

        public final boolean isLintStderr$gradle_core(@NotNull File $this$isLintStderr) {
            Intrinsics.checkNotNullParameter((Object)$this$isLintStderr, (String)"<this>");
            return Intrinsics.areEqual((Object)$this$isLintStderr.getPath(), (Object)new File("stderr").getPath());
        }

        public final boolean needsCopyReportTask(@NotNull Lint lintOptions2) {
            Intrinsics.checkNotNullParameter((Object)lintOptions2, (String)"lintOptions");
            File textOutput = lintOptions2.getTextOutput();
            return lintOptions2.getTextReport() && textOutput != null && !this.isLintStdout$gradle_core(textOutput) && !this.isLintStderr$gradle_core(textOutput) || lintOptions2.getHtmlReport() && lintOptions2.getHtmlOutput() != null || lintOptions2.getXmlReport() && lintOptions2.getXmlOutput() != null || lintOptions2.getSarifReport() && lintOptions2.getSarifOutput() != null;
        }

        public final boolean shouldRegisterLintVitalTasks(@NotNull ComponentCreationConfig variant) {
            Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
            return variant.getComponentType().isBaseModule() && !variant.getDebuggable() && !((ApplicationCreationConfig)variant).getProfileable() && variant.getGlobal().getLintOptions().getCheckReleaseBuilds();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

