/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.lint;

import com.android.build.gradle.internal.lint.AndroidLintInputs;
import com.android.build.gradle.internal.lint.AndroidLintWorkAction;
import com.android.build.gradle.internal.lint.LintMode;
import com.android.build.gradle.internal.lint.LintTool;
import com.android.build.gradle.internal.services.BuildServicesKt;
import com.android.build.gradle.internal.services.LintClassLoaderBuildService;
import com.android.build.gradle.internal.services.LintParallelBuildService;
import com.android.build.gradle.internal.services.TaskCreationServices;
import com.android.build.gradle.internal.utils.HasConfigurableValuesKt;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.options.StringOption;
import com.android.utils.PathUtils;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.function.BiFunction;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.services.BuildServiceRegistry;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.workers.ProcessWorkerSpec;
import org.gradle.workers.WorkQueue;
import org.gradle.workers.WorkerExecutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\n0\u0017J\u0016\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 J$\u0010!\u001a\b\u0012\u0004\u0012\u00020\n0\"2\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\"H\u0002J4\u0010#\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\n2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\n0\u00172\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u000eJ`\u0010#\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\n2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\n0\u00172\u0006\u0010+\u001a\u00020\u000e2\u0006\u0010,\u001a\u00020\u000e2\u0006\u0010-\u001a\u00020\u000e2\u0006\u0010(\u001a\u00020)2\u0006\u0010.\u001a\u00020\u000e2\u0006\u0010*\u001a\u00020\u000e2\n\b\u0002\u0010/\u001a\u0004\u0018\u000100R\u0014\u0010\u0004\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\fR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\fR\u0014\u0010\u0012\u001a\u00020\u00138gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\f\u00a8\u00061"}, d2={"Lcom/android/build/gradle/internal/lint/LintTool;", "", "<init>", "()V", "classpath", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getClasspath", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "versionKey", "Lorg/gradle/api/provider/Property;", "", "getVersionKey", "()Lorg/gradle/api/provider/Property;", "runInProcess", "", "getRunInProcess", "workerHeapSize", "getWorkerHeapSize", "lintCacheDirectory", "Lorg/gradle/api/file/DirectoryProperty;", "getLintCacheDirectory", "()Lorg/gradle/api/file/DirectoryProperty;", "initializeLintCacheDir", "", "lintClassLoaderBuildService", "Lcom/android/build/gradle/internal/services/LintClassLoaderBuildService;", "getLintClassLoaderBuildService", "initialize", "", "taskCreationServices", "Lcom/android/build/gradle/internal/services/TaskCreationServices;", "task", "Lorg/gradle/api/Task;", "deriveVersionKey", "Lorg/gradle/api/provider/Provider;", "submit", "workerExecutor", "Lorg/gradle/workers/WorkerExecutor;", "mainClass", "arguments", "lintMode", "Lcom/android/build/gradle/internal/lint/LintMode;", "useK2Uast", "android", "fatalOnly", "await", "hasBaseline", "returnValueOutputFile", "Ljava/io/File;", "gradle-core"})
@SourceDebugExtension(value={"SMAP\nAndroidLintInputs.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidLintInputs.kt\ncom/android/build/gradle/internal/lint/LintTool\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 buildServices.kt\ncom/android/build/gradle/internal/services/BuildServicesKt\n*L\n1#1,2951:1\n1#2:2952\n78#3:2953\n*S KotlinDebug\n*F\n+ 1 AndroidLintInputs.kt\ncom/android/build/gradle/internal/lint/LintTool\n*L\n208#1:2953\n*E\n"})
public abstract class LintTool {
    @Classpath
    @NotNull
    public abstract ConfigurableFileCollection getClasspath();

    @Input
    @NotNull
    public abstract Property<String> getVersionKey();

    @Input
    @NotNull
    public abstract Property<Boolean> getRunInProcess();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getWorkerHeapSize();

    @Internal
    @NotNull
    public abstract DirectoryProperty getLintCacheDirectory();

    @NotNull
    public final List<String> initializeLintCacheDir() {
        String previousVersion;
        String string;
        Path path;
        Path directory2 = ((Directory)this.getLintCacheDirectory().get()).getAsFile().toPath();
        Path lintVersionMarkerFile = directory2.resolve("lint-cache-version.txt");
        String currentVersion = "Cache for Android Lint" + this.getVersionKey().get();
        Path it = path = lintVersionMarkerFile;
        boolean bl = false;
        Path path2 = Files.exists(it, new LinkOption[0]) ? path : null;
        if (path2 != null) {
            it = path2;
            boolean bl2 = false;
            List<String> list = Files.readAllLines(it);
            Intrinsics.checkNotNullExpressionValue(list, (String)"readAllLines(...)");
            string = (String)CollectionsKt.singleOrNull(list);
        } else {
            string = previousVersion = null;
        }
        if (!Intrinsics.areEqual(previousVersion, (Object)currentVersion)) {
            PathUtils.deleteRecursivelyIfExists((Path)directory2);
            Files.createDirectories(directory2, new FileAttribute[0]);
            Files.write(lintVersionMarkerFile, (Iterable<? extends CharSequence>)CollectionsKt.listOf((Object)currentVersion), new OpenOption[0]);
        }
        Object[] objectArray = new String[]{"--cache-dir", ((Object)directory2).toString()};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Internal
    @NotNull
    public abstract Property<LintClassLoaderBuildService> getLintClassLoaderBuildService();

    public final void initialize(@NotNull TaskCreationServices taskCreationServices, @NotNull Task task) {
        Intrinsics.checkNotNullParameter((Object)taskCreationServices, (String)"taskCreationServices");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Object[] objectArray = new Object[]{taskCreationServices.getLintFromMaven().getFiles()};
        HasConfigurableValuesKt.fromDisallowChanges(this.getClasspath(), objectArray);
        BuildServiceRegistry buildServiceRegistry$iv = taskCreationServices.getBuildServiceRegistry();
        boolean $i$f$getBuildService = false;
        Provider<LintClassLoaderBuildService> it = BuildServicesKt.getBuildService(buildServiceRegistry$iv, LintClassLoaderBuildService.class);
        boolean bl = false;
        HasConfigurableValuesKt.setDisallowChanges(this.getLintClassLoaderBuildService(), it);
        task.usesService(it);
        HasConfigurableValuesKt.setDisallowChanges(this.getVersionKey(), this.deriveVersionKey(taskCreationServices, (Provider<LintClassLoaderBuildService>)((Provider)this.getLintClassLoaderBuildService())));
        ProjectOptions projectOptions = taskCreationServices.getProjectOptions();
        Property<Boolean> property = this.getRunInProcess();
        Provider<Boolean> provider2 = projectOptions.getProvider(BooleanOption.RUN_LINT_IN_PROCESS);
        Intrinsics.checkNotNullExpressionValue(provider2, (String)"getProvider(...)");
        HasConfigurableValuesKt.setDisallowChanges(property, provider2);
        Property<String> property2 = this.getWorkerHeapSize();
        Provider<String> provider3 = projectOptions.getProvider(StringOption.LINT_HEAP_SIZE);
        Intrinsics.checkNotNullExpressionValue(provider3, (String)"getProvider(...)");
        HasConfigurableValuesKt.setDisallowChanges(property2, provider3);
        Property property3 = (Property)this.getLintCacheDirectory();
        Provider provider4 = taskCreationServices.getProjectInfo().getBuildDirectory().dir("intermediates/lint-cache/" + task.getName());
        Intrinsics.checkNotNullExpressionValue((Object)provider4, (String)"dir(...)");
        HasConfigurableValuesKt.setDisallowChanges(property3, provider4);
    }

    private final Provider<String> deriveVersionKey(TaskCreationServices taskCreationServices, Provider<LintClassLoaderBuildService> lintClassLoaderBuildService) {
        Provider provider2;
        String string = taskCreationServices.getProjectOptions().get(StringOption.LINT_VERSION_OVERRIDE);
        String lintVersion = AndroidLintInputs.getLintMavenArtifactVersion$default(string != null ? ((Object)StringsKt.trim((CharSequence)string)).toString() : null, null, null, null, 12, null);
        Provider versionProvider2 = taskCreationServices.provider((Function0)new Function0<String>(lintVersion){
            final /* synthetic */ String $lintVersion;
            {
                this.$lintVersion = $lintVersion;
                super(0);
            }

            public final String invoke() {
                return this.$lintVersion;
            }
        });
        if (StringsKt.endsWith$default((String)lintVersion, (String)"-dev", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)lintVersion, (String)"SNAPSHOT", (boolean)false, (int)2, null)) {
            Provider jarsHash2 = lintClassLoaderBuildService.zip(this.getClasspath().getElements(), (BiFunction)deriveVersionKey.jarsHash.1.INSTANCE);
            Provider provider3 = versionProvider2.zip(jarsHash2, (BiFunction)deriveVersionKey.1.INSTANCE);
            Intrinsics.checkNotNull((Object)provider3);
            provider2 = provider3;
        } else {
            provider2 = versionProvider2;
        }
        return provider2;
    }

    public final void submit(@NotNull WorkerExecutor workerExecutor, @NotNull String mainClass, @NotNull List<String> arguments, @NotNull LintMode lintMode, boolean useK2Uast) {
        Intrinsics.checkNotNullParameter((Object)workerExecutor, (String)"workerExecutor");
        Intrinsics.checkNotNullParameter((Object)mainClass, (String)"mainClass");
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        Intrinsics.checkNotNullParameter((Object)((Object)lintMode), (String)"lintMode");
        LintTool.submit$default(this, workerExecutor, mainClass, arguments, true, false, false, lintMode, false, useK2Uast, null, 512, null);
    }

    public final void submit(@NotNull WorkerExecutor workerExecutor, @NotNull String mainClass, @NotNull List<String> arguments, boolean android, boolean fatalOnly, boolean await, @NotNull LintMode lintMode, boolean hasBaseline, boolean useK2Uast, @Nullable File returnValueOutputFile) {
        Intrinsics.checkNotNullParameter((Object)workerExecutor, (String)"workerExecutor");
        Intrinsics.checkNotNullParameter((Object)mainClass, (String)"mainClass");
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        Intrinsics.checkNotNullParameter((Object)((Object)lintMode), (String)"lintMode");
        WorkQueue workQueue2 = (Boolean)this.getRunInProcess().get() != false ? workerExecutor.noIsolation() : workerExecutor.processIsolation(new Action(this){
            final /* synthetic */ LintTool this$0;
            {
                this.this$0 = $receiver;
            }

            public final void execute(ProcessWorkerSpec it) {
                Object[] objectArray = new Object[]{this.this$0.getClasspath()};
                it.getClasspath().from(objectArray);
                it.getForkOptions().setMaxHeapSize(LintParallelBuildService.Companion.calculateLintHeapSize((String)this.this$0.getWorkerHeapSize().getOrNull(), Runtime.getRuntime().maxMemory()));
            }
        });
        workQueue2.submit(AndroidLintWorkAction.class, new Action(mainClass, arguments, this, android, fatalOnly, returnValueOutputFile, lintMode, hasBaseline, useK2Uast){
            final /* synthetic */ String $mainClass;
            final /* synthetic */ List<String> $arguments;
            final /* synthetic */ LintTool this$0;
            final /* synthetic */ boolean $android;
            final /* synthetic */ boolean $fatalOnly;
            final /* synthetic */ File $returnValueOutputFile;
            final /* synthetic */ LintMode $lintMode;
            final /* synthetic */ boolean $hasBaseline;
            final /* synthetic */ boolean $useK2Uast;
            {
                this.$mainClass = $mainClass;
                this.$arguments = $arguments;
                this.this$0 = $receiver;
                this.$android = $android;
                this.$fatalOnly = $fatalOnly;
                this.$returnValueOutputFile = $returnValueOutputFile;
                this.$lintMode = $lintMode;
                this.$hasBaseline = $hasBaseline;
                this.$useK2Uast = $useK2Uast;
            }

            public final void execute(AndroidLintWorkAction.LintWorkActionParameters parameters) {
                parameters.getMainClass().set((Object)this.$mainClass);
                parameters.getArguments().set((Iterable)this.$arguments);
                Object[] objectArray = new Object[]{this.this$0.getClasspath()};
                parameters.getClasspath().from(objectArray);
                parameters.getVersionKey().set((Provider)this.this$0.getVersionKey());
                parameters.getAndroid().set((Object)this.$android);
                parameters.getFatalOnly().set((Object)this.$fatalOnly);
                parameters.getRunInProcess().set(this.this$0.getRunInProcess().get());
                parameters.getReturnValueOutputFile().set(this.$returnValueOutputFile);
                parameters.getLintMode().set((Object)((Object)this.$lintMode));
                parameters.getHasBaseline().set((Object)this.$hasBaseline);
                parameters.getUseK2Uast().set((Object)this.$useK2Uast);
            }
        });
        if (await) {
            workQueue2.await();
        }
    }

    public static /* synthetic */ void submit$default(LintTool lintTool, WorkerExecutor workerExecutor, String string, List list, boolean bl, boolean bl2, boolean bl3, LintMode lintMode, boolean bl4, boolean bl5, File file, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: submit");
        }
        if ((n & 0x200) != 0) {
            file = null;
        }
        lintTool.submit(workerExecutor, string, list, bl, bl2, bl3, lintMode, bl4, bl5, file);
    }
}

