/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.test.report;

import com.android.build.gradle.internal.test.report.ClassPageRenderer;
import com.android.build.gradle.internal.test.report.ClassTestResults;
import com.android.build.gradle.internal.test.report.ErroringAction;
import com.android.build.gradle.internal.test.report.ImagePanelRenderer;
import com.android.build.gradle.internal.test.report.ReportType;
import com.android.build.gradle.internal.test.report.ScreenshotTestImages;
import com.android.build.gradle.internal.test.report.SimpleHtmlWriter;
import com.android.build.gradle.internal.test.report.TestResult;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0014J\u0010\u0010\u000e\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rJ\b\u0010\u000f\u001a\u00020\u000bH\u0014R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/android/build/gradle/internal/test/report/ScreenshotClassPageRenderer;", "Lcom/android/build/gradle/internal/test/report/ClassPageRenderer;", "reportType", "Lcom/android/build/gradle/internal/test/report/ReportType;", "isRecordGolden", "", "<init>", "(Lcom/android/build/gradle/internal/test/report/ReportType;Z)V", "imagePanelRenderer", "Lcom/android/build/gradle/internal/test/report/ImagePanelRenderer;", "renderFailures", "", "htmlWriter", "Lcom/android/build/gradle/internal/test/report/SimpleHtmlWriter;", "renderTests", "registerTabs", "gradle-core"})
public final class ScreenshotClassPageRenderer
extends ClassPageRenderer {
    @NotNull
    private final ImagePanelRenderer imagePanelRenderer;

    public ScreenshotClassPageRenderer(@NotNull ReportType reportType, boolean isRecordGolden) {
        Intrinsics.checkNotNullParameter((Object)((Object)reportType), (String)"reportType");
        super(reportType);
        this.imagePanelRenderer = new ImagePanelRenderer(isRecordGolden);
    }

    @Override
    protected void renderFailures(@Nullable SimpleHtmlWriter htmlWriter) {
        for (TestResult test : ((ClassTestResults)this.getResults()).getFailures()) {
            String testName = test.getName();
            SimpleHtmlWriter simpleHtmlWriter = htmlWriter;
            Intrinsics.checkNotNull((Object)simpleHtmlWriter);
            simpleHtmlWriter.startElement("div").attribute("class", "test").startElement("a").attribute("name", test.getId().toString()).characters("").endElement().startElement("h3").attribute("class", test.getStatusClass()).characters(testName).endElement();
            ScreenshotTestImages screenshotTestImages = test.getScreenshotshotImages();
            Intrinsics.checkNotNullExpressionValue((Object)screenshotTestImages, (String)"getScreenshotshotImages(...)");
            this.imagePanelRenderer.render(screenshotTestImages, htmlWriter);
            htmlWriter.endElement();
        }
    }

    public final void renderTests(@Nullable SimpleHtmlWriter htmlWriter) {
        for (TestResult test : ((ClassTestResults)this.getResults()).results) {
            SimpleHtmlWriter simpleHtmlWriter = htmlWriter;
            Intrinsics.checkNotNull((Object)simpleHtmlWriter);
            simpleHtmlWriter.startElement("div").attribute("class", "test").startElement("a").attribute("name", test.getId().toString()).characters("").endElement().startElement("h3").attribute("class", test.getStatusClass()).characters(test.name).endElement();
            ScreenshotTestImages screenshotTestImages = test.getScreenshotshotImages();
            Intrinsics.checkNotNullExpressionValue((Object)screenshotTestImages, (String)"getScreenshotshotImages(...)");
            this.imagePanelRenderer.render(screenshotTestImages, htmlWriter);
            htmlWriter.endElement();
        }
    }

    @Override
    protected void registerTabs() {
        this.addFailuresTab();
        this.addTab("Tests", (Action<SimpleHtmlWriter>)new ErroringAction<SimpleHtmlWriter>(this){
            final /* synthetic */ ScreenshotClassPageRenderer this$0;
            {
                this.this$0 = $receiver;
            }

            protected void doExecute(SimpleHtmlWriter writer) throws IOException {
                this.this$0.renderTests(writer);
            }
        });
        this.addDeviceAndVariantTabs();
    }
}

