/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.testing.utp;

import com.android.build.gradle.internal.testing.utp.UtpTestResultListener;
import com.android.build.gradle.internal.testing.utp.UtpTestUtilsKt;
import com.android.ddmlib.testrunner.TestIdentifier;
import com.android.ddmlib.testrunner.XmlTestRunListener;
import com.android.tools.utp.plugins.result.listener.gradle.proto.GradleAndroidTestResultListenerProto;
import com.google.protobuf.Any;
import com.google.protobuf.Message;
import com.google.testing.platform.proto.api.core.IssueProto;
import com.google.testing.platform.proto.api.core.TestCaseProto;
import com.google.testing.platform.proto.api.core.TestResultProto;
import com.google.testing.platform.proto.api.core.TestStatusProto;
import com.google.testing.platform.proto.api.core.TestSuiteResultProto;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/android/build/gradle/internal/testing/utp/DdmlibTestResultAdapter;", "Lcom/android/build/gradle/internal/testing/utp/UtpTestResultListener;", "ddmlibTestRunName", "", "ddmlibTestResultListener", "Lcom/android/ddmlib/testrunner/XmlTestRunListener;", "<init>", "(Ljava/lang/String;Lcom/android/ddmlib/testrunner/XmlTestRunListener;)V", "numTestFails", "", "startTimestamp", "", "onTestResultEvent", "", "testResultEvent", "Lcom/android/tools/utp/plugins/result/listener/gradle/proto/GradleAndroidTestResultListenerProto$TestResultEvent;", "gradle-core"})
@SourceDebugExtension(value={"SMAP\nDdmlibTestResultAdapter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DdmlibTestResultAdapter.kt\ncom/android/build/gradle/internal/testing/utp/DdmlibTestResultAdapter\n+ 2 DdmlibTestResultAdapter.kt\ncom/android/build/gradle/internal/testing/utp/DdmlibTestResultAdapterKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,106:1\n105#2:107\n105#2:108\n105#2:109\n105#2:110\n1863#3,2:111\n*S KotlinDebug\n*F\n+ 1 DdmlibTestResultAdapter.kt\ncom/android/build/gradle/internal/testing/utp/DdmlibTestResultAdapter\n*L\n46#1:107\n54#1:108\n62#1:109\n85#1:110\n91#1:111,2\n*E\n"})
public final class DdmlibTestResultAdapter
implements UtpTestResultListener {
    @NotNull
    private final String ddmlibTestRunName;
    @NotNull
    private final XmlTestRunListener ddmlibTestResultListener;
    private int numTestFails;
    private long startTimestamp;

    public DdmlibTestResultAdapter(@NotNull String ddmlibTestRunName, @NotNull XmlTestRunListener ddmlibTestResultListener) {
        Intrinsics.checkNotNullParameter((Object)ddmlibTestRunName, (String)"ddmlibTestRunName");
        Intrinsics.checkNotNullParameter((Object)ddmlibTestResultListener, (String)"ddmlibTestResultListener");
        this.ddmlibTestRunName = ddmlibTestRunName;
        this.ddmlibTestResultListener = ddmlibTestResultListener;
    }

    @Override
    public void onTestResultEvent(@NotNull GradleAndroidTestResultListenerProto.TestResultEvent testResultEvent) {
        Intrinsics.checkNotNullParameter((Object)testResultEvent, (String)"testResultEvent");
        GradleAndroidTestResultListenerProto.TestResultEvent.StateCase stateCase = testResultEvent.getStateCase();
        switch (stateCase == null ? -1 : WhenMappings.$EnumSwitchMapping$1[stateCase.ordinal()]) {
            case 1: {
                this.startTimestamp = System.currentTimeMillis();
                Any any = testResultEvent.getTestSuiteStarted().getTestSuiteMetadata();
                Intrinsics.checkNotNullExpressionValue((Object)any, (String)"getTestSuiteMetadata(...)");
                Any $this$unpack$iv = any;
                boolean $i$f$unpack = false;
                Message message2 = $this$unpack$iv.unpack(TestSuiteResultProto.TestSuiteMetaData.class);
                Intrinsics.checkNotNullExpressionValue((Object)message2, (String)"unpack(...)");
                TestSuiteResultProto.TestSuiteMetaData testSuite = (TestSuiteResultProto.TestSuiteMetaData)message2;
                this.ddmlibTestResultListener.testRunStarted(this.ddmlibTestRunName, testSuite.getScheduledTestCaseCount());
                break;
            }
            case 2: {
                Any any = testResultEvent.getTestCaseStarted().getTestCase();
                Intrinsics.checkNotNullExpressionValue((Object)any, (String)"getTestCase(...)");
                Any $this$unpack$iv = any;
                boolean $i$f$unpack = false;
                Message message3 = $this$unpack$iv.unpack(TestCaseProto.TestCase.class);
                Intrinsics.checkNotNullExpressionValue((Object)message3, (String)"unpack(...)");
                TestCaseProto.TestCase testCase = (TestCaseProto.TestCase)message3;
                TestIdentifier testId = new TestIdentifier(testCase.getTestPackage() + "." + testCase.getTestClass(), testCase.getTestMethod());
                this.ddmlibTestResultListener.testStarted(testId);
                break;
            }
            case 3: {
                Any any = testResultEvent.getTestCaseFinished().getTestCaseResult();
                Intrinsics.checkNotNullExpressionValue((Object)any, (String)"getTestCaseResult(...)");
                Any $this$unpack$iv = any;
                boolean $i$f$unpack = false;
                Message message4 = $this$unpack$iv.unpack(TestResultProto.TestResult.class);
                Intrinsics.checkNotNullExpressionValue((Object)message4, (String)"unpack(...)");
                TestResultProto.TestResult testResult = (TestResultProto.TestResult)message4;
                TestIdentifier testId = new TestIdentifier(testResult.getTestCase().getTestPackage() + "." + testResult.getTestCase().getTestClass(), testResult.getTestCase().getTestMethod());
                TestStatusProto.TestStatus testStatus = testResult.getTestStatus();
                switch (testStatus == null ? -1 : WhenMappings.$EnumSwitchMapping$0[testStatus.ordinal()]) {
                    case 1: 
                    case 2: {
                        this.ddmlibTestResultListener.testFailed(testId, testResult.getError().getStackTrace());
                        ++this.numTestFails;
                        break;
                    }
                    case 3: {
                        this.ddmlibTestResultListener.testIgnored(testId);
                    }
                }
                this.ddmlibTestResultListener.testEnded(testId, MapsKt.emptyMap());
                break;
            }
            case 4: {
                if (this.numTestFails > 0) {
                    this.ddmlibTestResultListener.testRunFailed("There was " + this.numTestFails + " failure(s).");
                }
                Any any = testResultEvent.getTestSuiteFinished().getTestSuiteResult();
                Intrinsics.checkNotNullExpressionValue((Object)any, (String)"getTestSuiteResult(...)");
                Any $this$unpack$iv = any;
                boolean $i$f$unpack = false;
                Message message5 = $this$unpack$iv.unpack(TestSuiteResultProto.TestSuiteResult.class);
                Intrinsics.checkNotNullExpressionValue((Object)message5, (String)"unpack(...)");
                TestSuiteResultProto.TestSuiteResult testSuiteResult = (TestSuiteResultProto.TestSuiteResult)message5;
                if (testSuiteResult.hasPlatformError()) {
                    this.ddmlibTestResultListener.addSystemError(UtpTestUtilsKt.getPlatformErrorMessage(testSuiteResult) + "\n");
                }
                List list = testSuiteResult.getIssueList();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getIssueList(...)");
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    IssueProto.Issue issue = (IssueProto.Issue)element$iv;
                    boolean bl = false;
                    this.ddmlibTestResultListener.addSystemError(issue.getMessage() + "\n");
                }
                this.ddmlibTestResultListener.testRunEnded(System.currentTimeMillis() - this.startTimestamp, MapsKt.emptyMap());
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[TestStatusProto.TestStatus.values().length];
            try {
                nArray[TestStatusProto.TestStatus.FAILED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TestStatusProto.TestStatus.ERROR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TestStatusProto.TestStatus.IGNORED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[GradleAndroidTestResultListenerProto.TestResultEvent.StateCase.values().length];
            try {
                nArray[GradleAndroidTestResultListenerProto.TestResultEvent.StateCase.TEST_SUITE_STARTED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GradleAndroidTestResultListenerProto.TestResultEvent.StateCase.TEST_CASE_STARTED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GradleAndroidTestResultListenerProto.TestResultEvent.StateCase.TEST_CASE_FINISHED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GradleAndroidTestResultListenerProto.TestResultEvent.StateCase.TEST_SUITE_FINISHED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

