/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.cxx.process;

import com.android.build.gradle.internal.cxx.process.ChunkBytesToLineOutputStream;
import com.android.build.gradle.internal.cxx.process.DefaultProcessOutput;
import com.android.build.gradle.internal.cxx.process.DefaultProcessOutputHandler;
import com.android.build.gradle.internal.cxx.process.LifecycleLineOutputStream;
import com.android.build.gradle.internal.cxx.process.MultiplexingOutputStream;
import com.android.ide.common.process.ProcessOutput;
import com.android.ide.common.process.ProcessOutputHandler;
import com.android.utils.cxx.process.LineOutputStream;
import com.android.utils.cxx.process.NativeBuildOutputClassifier;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0016H\u0016R\u000e\u0010\n\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\f\u001a\u0004\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0012\u001a\u0004\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u000f\"\u0004\b\u0014\u0010\u0011R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/android/build/gradle/internal/cxx/process/DefaultProcessOutputHandler;", "Lcom/android/ide/common/process/ProcessOutputHandler;", "stderrFile", "Ljava/io/File;", "stdoutFile", "logPrefix", "", "logStderr", "", "logStdout", "logFullStdout", "(Ljava/io/File;Ljava/io/File;Ljava/lang/String;ZZZ)V", "stderr", "Ljava/io/FileOutputStream;", "getStderr", "()Ljava/io/FileOutputStream;", "setStderr", "(Ljava/io/FileOutputStream;)V", "stdout", "getStdout", "setStdout", "createOutput", "Lcom/android/ide/common/process/ProcessOutput;", "handleOutput", "", "processOutput", "gradle-core"})
public final class DefaultProcessOutputHandler
implements ProcessOutputHandler {
    @NotNull
    private final File stderrFile;
    @NotNull
    private final File stdoutFile;
    @NotNull
    private final String logPrefix;
    private final boolean logStderr;
    private final boolean logStdout;
    private final boolean logFullStdout;
    @Nullable
    private FileOutputStream stderr;
    @Nullable
    private FileOutputStream stdout;

    public DefaultProcessOutputHandler(@NotNull File stderrFile, @NotNull File stdoutFile, @NotNull String logPrefix, boolean logStderr, boolean logStdout, boolean logFullStdout) {
        Intrinsics.checkNotNullParameter((Object)stderrFile, (String)"stderrFile");
        Intrinsics.checkNotNullParameter((Object)stdoutFile, (String)"stdoutFile");
        Intrinsics.checkNotNullParameter((Object)logPrefix, (String)"logPrefix");
        this.stderrFile = stderrFile;
        this.stdoutFile = stdoutFile;
        this.logPrefix = logPrefix;
        this.logStderr = logStderr;
        this.logStdout = logStdout;
        this.logFullStdout = logFullStdout;
    }

    @Nullable
    public final FileOutputStream getStderr() {
        return this.stderr;
    }

    public final void setStderr(@Nullable FileOutputStream fileOutputStream) {
        this.stderr = fileOutputStream;
    }

    @Nullable
    public final FileOutputStream getStdout() {
        return this.stdout;
    }

    public final void setStdout(@Nullable FileOutputStream fileOutputStream) {
        this.stdout = fileOutputStream;
    }

    @NotNull
    public ProcessOutput createOutput() {
        FileOutputStream singleStderr = new FileOutputStream(this.stderrFile, true);
        FileOutputStream singleStdout = new FileOutputStream(this.stdoutFile, true);
        Object[] objectArray = new OutputStream[]{singleStderr};
        List stderrReceivers = CollectionsKt.mutableListOf((Object[])objectArray);
        Object[] objectArray2 = new OutputStream[]{singleStdout};
        List stdoutReceivers = CollectionsKt.mutableListOf((Object[])objectArray2);
        if (this.logStderr) {
            stderrReceivers.add(new ChunkBytesToLineOutputStream(this.logPrefix, new LifecycleLineOutputStream(), 0, 4, null));
        }
        if (this.logStdout) {
            if (this.logFullStdout) {
                stdoutReceivers.add(new ChunkBytesToLineOutputStream(this.logPrefix, new LifecycleLineOutputStream(), 0, 4, null));
            } else {
                stdoutReceivers.add(new ChunkBytesToLineOutputStream(this.logPrefix, (LineOutputStream)new NativeBuildOutputClassifier((Function1)createOutput.1.INSTANCE), 0, 4, null));
            }
        }
        return new DefaultProcessOutput(singleStderr, singleStdout, new MultiplexingOutputStream(stdoutReceivers), new MultiplexingOutputStream(stderrReceivers));
    }

    public void handleOutput(@NotNull ProcessOutput processOutput) {
        Intrinsics.checkNotNullParameter((Object)processOutput, (String)"processOutput");
        if (this.stdout != null) {
            throw new RuntimeException("Multiple calls");
        }
        DefaultProcessOutput output2 = (DefaultProcessOutput)processOutput;
        this.stderr = output2.getStderr();
        this.stdout = output2.getStdout();
    }
}

