/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.test;

import com.android.build.gradle.internal.component.DeviceTestCreationConfig;
import com.android.build.gradle.internal.tasks.BundleInstallUtils;
import com.android.build.gradle.internal.test.AbstractTestDataImpl;
import com.android.build.gradle.internal.test.ApksFinder;
import com.android.build.gradle.internal.test.BundleTestDataImpl;
import com.android.build.gradle.internal.utils.GuavaKtxKt;
import com.android.builder.testing.api.DeviceConfigProvider;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0001#Bi\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\u000b\u0012\u000e\u0010\r\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0003\u0012\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u000f\u00a2\u0006\u0002\u0010\u0010R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u00020\u000b8\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0015\u0010\t\u001a\u0004\u0018\u00010\u00048\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00040\u001cX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020 8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006$"}, d2={"Lcom/android/build/gradle/internal/test/BundleTestDataImpl;", "Lcom/android/build/gradle/internal/test/AbstractTestDataImpl;", "namespace", "Lorg/gradle/api/provider/Provider;", "", "creationConfig", "Lcom/android/build/gradle/internal/component/DeviceTestCreationConfig;", "testApkDir", "Lorg/gradle/api/file/Directory;", "moduleName", "apkBundle", "Lorg/gradle/api/file/FileCollection;", "privacySandboxSdkApks", "privacySandboxCompatSdkApks", "extraInstrumentationTestRunnerArgs", "", "(Lorg/gradle/api/provider/Provider;Lcom/android/build/gradle/internal/component/DeviceTestCreationConfig;Lorg/gradle/api/provider/Provider;Ljava/lang/String;Lorg/gradle/api/file/FileCollection;Lorg/gradle/api/file/FileCollection;Lorg/gradle/api/provider/Provider;Ljava/util/Map;)V", "_testedApksFinder", "Lcom/android/build/gradle/internal/test/BundleTestDataImpl$BundleApksFinder;", "getApkBundle", "()Lorg/gradle/api/file/FileCollection;", "libraryType", "", "getLibraryType", "()Lorg/gradle/api/provider/Provider;", "getModuleName", "()Ljava/lang/String;", "supportedAbis", "", "getSupportedAbis", "()Ljava/util/Set;", "testedApksFinder", "Lcom/android/build/gradle/internal/test/ApksFinder;", "getTestedApksFinder", "()Lcom/android/build/gradle/internal/test/ApksFinder;", "BundleApksFinder", "gradle-core"})
public final class BundleTestDataImpl
extends AbstractTestDataImpl {
    @Nullable
    private final String moduleName;
    @NotNull
    private final FileCollection apkBundle;
    @NotNull
    private final Set<String> supportedAbis;
    @NotNull
    private final Provider<Boolean> libraryType;
    @Nullable
    private BundleApksFinder _testedApksFinder;

    public BundleTestDataImpl(@NotNull Provider<String> namespace2, @NotNull DeviceTestCreationConfig creationConfig, @NotNull Provider<Directory> testApkDir, @Nullable String moduleName, @NotNull FileCollection apkBundle, @Nullable FileCollection privacySandboxSdkApks, @Nullable Provider<Directory> privacySandboxCompatSdkApks, @NotNull Map<String, String> extraInstrumentationTestRunnerArgs) {
        Intrinsics.checkNotNullParameter(namespace2, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
        Intrinsics.checkNotNullParameter(testApkDir, (String)"testApkDir");
        Intrinsics.checkNotNullParameter((Object)apkBundle, (String)"apkBundle");
        Intrinsics.checkNotNullParameter(extraInstrumentationTestRunnerArgs, (String)"extraInstrumentationTestRunnerArgs");
        super(namespace2, creationConfig, testApkDir, null, privacySandboxSdkApks, privacySandboxCompatSdkApks, null, extraInstrumentationTestRunnerArgs);
        this.moduleName = moduleName;
        this.apkBundle = apkBundle;
        this.supportedAbis = SetsKt.emptySet();
        this.libraryType = creationConfig.getServices().provider(libraryType.1.INSTANCE);
    }

    @Input
    @Optional
    @Nullable
    public final String getModuleName() {
        return this.moduleName;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @Optional
    @NotNull
    public final FileCollection getApkBundle() {
        return this.apkBundle;
    }

    @Override
    @NotNull
    public Set<String> getSupportedAbis() {
        return this.supportedAbis;
    }

    @Override
    @NotNull
    public Provider<Boolean> getLibraryType() {
        return this.libraryType;
    }

    @Override
    @NotNull
    public ApksFinder getTestedApksFinder() {
        ApksFinder apksFinder;
        BundleApksFinder bundleApksFinder = this._testedApksFinder;
        if (bundleApksFinder != null) {
            apksFinder = bundleApksFinder;
        } else {
            BundleApksFinder bundleApksFinder2;
            Path path = this.apkBundle.getSingleFile().toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
            BundleApksFinder it = bundleApksFinder2 = new BundleApksFinder(path, this.moduleName);
            boolean bl = false;
            this._testedApksFinder = it;
            apksFinder = bundleApksFinder2;
        }
        return apksFinder;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/android/build/gradle/internal/test/BundleTestDataImpl$BundleApksFinder;", "Lcom/android/build/gradle/internal/test/ApksFinder;", "apkPath", "Ljava/nio/file/Path;", "moduleName", "", "(Ljava/nio/file/Path;Ljava/lang/String;)V", "findApks", "", "Ljava/io/File;", "deviceConfigProvider", "Lcom/android/builder/testing/api/DeviceConfigProvider;", "gradle-core"})
    @SourceDebugExtension(value={"SMAP\nBundleTestDataImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BundleTestDataImpl.kt\ncom/android/build/gradle/internal/test/BundleTestDataImpl$BundleApksFinder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,104:1\n1549#2:105\n1620#2,3:106\n*S KotlinDebug\n*F\n+ 1 BundleTestDataImpl.kt\ncom/android/build/gradle/internal/test/BundleTestDataImpl$BundleApksFinder\n*L\n99#1:105\n99#1:106,3\n*E\n"})
    public static final class BundleApksFinder
    implements ApksFinder {
        @NotNull
        private final Path apkPath;
        @Nullable
        private final String moduleName;

        public BundleApksFinder(@NotNull Path apkPath, @Nullable String moduleName) {
            Intrinsics.checkNotNullParameter((Object)apkPath, (String)"apkPath");
            this.apkPath = apkPath;
            this.moduleName = moduleName;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public List<File> findApks(@NotNull DeviceConfigProvider deviceConfigProvider) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)deviceConfigProvider, (String)"deviceConfigProvider");
            if (this.moduleName != null && deviceConfigProvider.getApiLevel() < 21) {
                Logging.getLogger(BundleTestDataImpl.class).warn("Testing dynamic features on devices API < 21 is not currently supported.");
                ImmutableList immutableList = ImmutableList.of();
                Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"of(...)");
                return (List)immutableList;
            }
            Iterable $this$map$iv = BundleInstallUtils.getApkFiles(this.apkPath, deviceConfigProvider, this.moduleName);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Path path = (Path)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.toFile());
            }
            return (List)GuavaKtxKt.toImmutableList((List)destination$iv$iv);
        }
    }
}

