/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.external.cmake;

import com.android.SdkConstants;
import com.android.build.gradle.external.cmake.server.CodeModel;
import com.android.build.gradle.external.cmake.server.Configuration;
import com.android.build.gradle.external.cmake.server.FileGroup;
import com.android.build.gradle.external.cmake.server.Project;
import com.android.build.gradle.external.cmake.server.Target;
import com.android.build.gradle.internal.cxx.json.NativeToolchainValue;
import com.android.build.gradle.internal.cxx.json.PlainFileGsonTypeAdaptor;
import com.android.repository.Revision;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;

public class CmakeUtils {
    private static final String CMAKE_VERSION_LINE_PREFIX = "cmake version ";

    public static Revision getVersion(File cmakeInstallPath, Function<File, String> versionExecutor) throws IOException {
        String versionOutput = versionExecutor.apply(new File(cmakeInstallPath, "cmake"));
        if (!versionOutput.startsWith(CMAKE_VERSION_LINE_PREFIX)) {
            throw new RuntimeException("Did not recognize stdout line as a cmake version: " + versionOutput);
        }
        String versionString = versionOutput.substring(CMAKE_VERSION_LINE_PREFIX.length());
        return Revision.parseRevision((String)CmakeUtils.keepWhileNumbersAndDots(versionString));
    }

    public static String keepWhileNumbersAndDots(String versionString) {
        Object stripped = "";
        for (char c : versionString.toCharArray()) {
            if ((c < '0' || c > '9') && c != '.') break;
            stripped = (String)stripped + c;
        }
        return stripped;
    }

    public static Revision getVersion(String cmakeVersionString) {
        return Revision.parseRevision((String)cmakeVersionString);
    }

    public static Set<String> getCppExtensionSet(CodeModel codeModel) {
        return CmakeUtils.getLangExtensions(codeModel, "CXX");
    }

    public static Set<String> getCExtensionSet(CodeModel codeModel) {
        return CmakeUtils.getLangExtensions(codeModel, "C");
    }

    public static int getToolchainHash(NativeToolchainValue toolchainValue) {
        StringBuilder toolchainString = new StringBuilder();
        if (toolchainValue.cppCompilerExecutable != null) {
            toolchainString = toolchainString.append(toolchainValue.cppCompilerExecutable.getAbsolutePath()).append(" ");
        }
        if (toolchainValue.cCompilerExecutable != null) {
            toolchainString = toolchainString.append(toolchainValue.cCompilerExecutable.getAbsolutePath());
        }
        return toolchainString.toString().hashCode();
    }

    public static <ContentType> String getObjectToString(ContentType content2) {
        Gson gson2 = new GsonBuilder().registerTypeAdapter(File.class, (Object)new PlainFileGsonTypeAdaptor()).disableHtmlEscaping().setPrettyPrinting().create();
        return gson2.toJson(content2);
    }

    private static Set<String> getLangExtensions(CodeModel codeModel, String language) {
        HashSet<String> languageSet = new HashSet<String>();
        if (codeModel.configurations == null) {
            return languageSet;
        }
        for (Configuration configuration : codeModel.configurations) {
            if (configuration.projects == null) continue;
            for (Project project : configuration.projects) {
                if (project.targets == null) continue;
                for (Target target : project.targets) {
                    if (target.fileGroups == null) continue;
                    for (FileGroup fileGroup : target.fileGroups) {
                        if (fileGroup.sources == null || fileGroup.language == null || !fileGroup.language.equals(language)) continue;
                        for (String source : fileGroup.sources) {
                            String extension2 = source.substring(source.lastIndexOf(46) + 1).trim();
                            languageSet.add(extension2);
                        }
                    }
                }
            }
        }
        return languageSet;
    }

    static boolean isWindows() {
        return SdkConstants.CURRENT_PLATFORM == 2;
    }
}

