/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.cxx.hashing;

import com.android.Version;
import com.android.build.gradle.internal.cxx.hashing.MessageDigestKt;
import com.android.build.gradle.internal.cxx.json.JsonHelpersKt;
import java.security.MessageDigest;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\u001a#\u0010\u0000\u001a\u00020\u0001\"\u0004\b\u0000\u0010\u00022\u0006\u0010\u0003\u001a\u0002H\u00022\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006\u001a#\u0010\u0007\u001a\u00020\u0001\"\u0004\b\u0000\u0010\u00022\u0006\u0010\u0003\u001a\u0002H\u00022\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006\u00a8\u0006\b"}, d2={"sha256Of", "", "T", "value", "includeGradleVersionInHash", "", "(Ljava/lang/Object;Z)Ljava/lang/String;", "shortSha256Of", "gradle-core"})
public final class HashHelpersKt {
    @NotNull
    public static final <T> String sha256Of(T value, boolean includeGradleVersionInHash) {
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        Intrinsics.checkNotNull((Object)digest);
        MessageDigestKt.update(digest, JsonHelpersKt.jsonStringOf(value));
        if (includeGradleVersionInHash) {
            String string = Version.ANDROID_GRADLE_PLUGIN_VERSION;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ANDROID_GRADLE_PLUGIN_VERSION");
            MessageDigestKt.update(digest, string);
        }
        return MessageDigestKt.toBase36(digest);
    }

    public static /* synthetic */ String sha256Of$default(Object object, boolean bl, int n, Object object2) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return HashHelpersKt.sha256Of(object, bl);
    }

    @NotNull
    public static final <T> String shortSha256Of(T value, boolean includeGradleVersionInHash) {
        String string = HashHelpersKt.sha256Of(value, includeGradleVersionInHash).substring(0, 8);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return string;
    }

    public static /* synthetic */ String shortSha256Of$default(Object object, boolean bl, int n, Object object2) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return HashHelpersKt.shortSha256Of(object, bl);
    }
}

