/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.utils;

import com.android.build.gradle.internal.plugins.AppPlugin;
import com.android.build.gradle.internal.plugins.DynamicFeaturePlugin;
import com.android.build.gradle.internal.plugins.FusedLibraryPlugin;
import com.android.build.gradle.internal.plugins.KotlinMultiplatformAndroidPlugin;
import com.android.build.gradle.internal.plugins.LibraryPlugin;
import com.android.build.gradle.internal.plugins.PrivacySandboxSdkPlugin;
import com.android.build.gradle.internal.plugins.TestPlugin;
import com.android.build.gradle.internal.utils.ResolutionResultUtils;
import java.io.Closeable;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.result.ResolutionResult;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00010\t2\u0006\u0010\n\u001a\u00020\u000b\u001a\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"'\u0010\u0002\u001a\u0018\u0012\u000e\b\u0001\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0004\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"ANDROID_GRADLE_PLUGIN_ID", "", "MUTUALLY_EXCLUSIVE_ANDROID_GRADLE_PLUGINS", "", "Ljava/lang/Class;", "", "getMUTUALLY_EXCLUSIVE_ANDROID_GRADLE_PLUGINS", "()Ljava/util/Map;", "getBuildSrcPlugins", "", "classLoader", "Ljava/lang/ClassLoader;", "getBuildscriptDependencies", "", "Lorg/gradle/api/artifacts/component/ModuleComponentIdentifier;", "project", "Lorg/gradle/api/Project;", "gradle-core"})
@JvmName(name="GradlePluginUtils")
@SourceDebugExtension(value={"SMAP\nGradlePluginUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradlePluginUtils.kt\ncom/android/build/gradle/internal/utils/GradlePluginUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,87:1\n1549#2:88\n1620#2,3:89\n*S KotlinDebug\n*F\n+ 1 GradlePluginUtils.kt\ncom/android/build/gradle/internal/utils/GradlePluginUtils\n*L\n38#1:88\n38#1:89,3\n*E\n"})
public final class GradlePluginUtils {
    @NotNull
    public static final String ANDROID_GRADLE_PLUGIN_ID = "com.android.base";
    @NotNull
    private static final Map<? extends Class<? extends Object>, String> MUTUALLY_EXCLUSIVE_ANDROID_GRADLE_PLUGINS;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<ModuleComponentIdentifier> getBuildscriptDependencies(@NotNull Project project) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Configuration buildScriptClasspath = project.getBuildscript().getConfigurations().getByName("classpath");
        ResolutionResult resolutionResult = buildScriptClasspath.getIncoming().getResolutionResult();
        Intrinsics.checkNotNullExpressionValue((Object)resolutionResult, (String)"getResolutionResult(...)");
        Iterable $this$map$iv = ResolutionResultUtils.getModuleComponents$default(resolutionResult, null, 1, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ResolvedComponentResult resolvedComponentResult = (ResolvedComponentResult)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            ComponentIdentifier componentIdentifier = it.getId();
            Intrinsics.checkNotNull((Object)componentIdentifier, (String)"null cannot be cast to non-null type org.gradle.api.artifacts.component.ModuleComponentIdentifier");
            collection.add((ModuleComponentIdentifier)componentIdentifier);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final Set<String> getBuildSrcPlugins(@NotNull ClassLoader classLoader) {
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        Pattern pattern = Pattern.compile("META-INF/gradle-plugins/(.+)\\.properties");
        Enumeration<URL> urls = classLoader.getResources("META-INF/gradle-plugins");
        HashSet<String> buildSrcPlugins = new HashSet<String>();
        while (urls.hasMoreElements()) {
            URLConnection urlConnection;
            URL url = urls.nextElement();
            String string = url.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            if (!StringsKt.endsWith$default((String)string, (String)"buildSrc.jar!/META-INF/gradle-plugins", (boolean)false, (int)2, null) || !((urlConnection = url.openConnection()) instanceof JarURLConnection)) continue;
            Closeable closeable = ((JarURLConnection)urlConnection).getJarFile();
            Throwable throwable = null;
            try {
                JarFile jar = (JarFile)closeable;
                boolean bl = false;
                Enumeration<JarEntry> jarEntries = jar.entries();
                while (jarEntries.hasMoreElements()) {
                    JarEntry entry2 = jarEntries.nextElement();
                    Matcher matcher = pattern.matcher(entry2.getName());
                    if (!matcher.matches()) continue;
                    buildSrcPlugins.add(matcher.group(1));
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        return buildSrcPlugins;
    }

    @NotNull
    public static final Map<? extends Class<? extends Object>, String> getMUTUALLY_EXCLUSIVE_ANDROID_GRADLE_PLUGINS() {
        return MUTUALLY_EXCLUSIVE_ANDROID_GRADLE_PLUGINS;
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to(AppPlugin.class, (Object)"com.android.application"), TuplesKt.to(LibraryPlugin.class, (Object)"com.android.library"), TuplesKt.to(DynamicFeaturePlugin.class, (Object)"com.android.dynamic-feature"), TuplesKt.to(TestPlugin.class, (Object)"com.android.test"), TuplesKt.to(KotlinMultiplatformAndroidPlugin.class, (Object)"com.android.kotlin.multiplatform.library"), TuplesKt.to(FusedLibraryPlugin.class, (Object)"com.android.fused-library"), TuplesKt.to(PrivacySandboxSdkPlugin.class, (Object)"com.android.privacy-sandbox-sdk")};
        MUTUALLY_EXCLUSIVE_ANDROID_GRADLE_PLUGINS = MapsKt.mapOf((Pair[])pairArray);
    }
}

