/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.utils;

import com.android.build.api.variant.DeviceSpec;
import com.android.build.gradle.internal.utils.InstallApkUtilsKt;
import com.android.builder.testing.api.DeviceConnector;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.file.Directory;
import org.gradle.api.provider.Provider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\u001a<\u0010\u0000\u001a\u00020\u00012\u000e\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00032\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f\u001a\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a8\u0006\u0014"}, d2={"addDexMetadataFiles", "", "dexMetadataDirectory", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/Directory;", "apkDirectory", "deviceApiLevel", "", "apkFiles", "", "Ljava/io/File;", "iLogger", "Lcom/android/utils/ILogger;", "getDeviceSpec", "Lcom/android/build/api/variant/DeviceSpec;", "device", "Lcom/android/builder/testing/api/DeviceConnector;", "getFiles", "", "directoryProvider", "gradle-core"})
public final class InstallApkUtilsKt {
    @NotNull
    public static final DeviceSpec getDeviceSpec(@NotNull DeviceConnector device) {
        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
        DeviceSpec.Builder builder = new DeviceSpec.Builder().setName(device.getName()).setApiLevel(device.getApiLevel()).setCodeName(device.getApiCodeName());
        List list = device.getAbis();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAbis(...)");
        return builder.setAbis(list).setSupportsPrivacySandbox(device.getSupportsPrivacySandbox()).setScreenDensity(device.getDensity()).build();
    }

    @NotNull
    public static final List<File> getFiles(@NotNull Provider<Directory> directoryProvider) {
        Intrinsics.checkNotNullParameter(directoryProvider, (String)"directoryProvider");
        if (directoryProvider.isPresent()) {
            List<File> list = ((Directory)directoryProvider.get()).getAsFileTree().getFiles().stream().filter(getFiles.1.INSTANCE).collect(Collectors.toList());
            Intrinsics.checkNotNullExpressionValue(list, (String)"collect(...)");
            return list;
        }
        return CollectionsKt.emptyList();
    }

    public static final void addDexMetadataFiles(@Nullable Provider<Directory> dexMetadataDirectory, @NotNull Directory apkDirectory, int deviceApiLevel, @NotNull List<File> apkFiles2, @NotNull ILogger iLogger) throws IOException {
        String dmPath;
        Directory dmDir;
        Intrinsics.checkNotNullParameter((Object)apkDirectory, (String)"apkDirectory");
        Intrinsics.checkNotNullParameter(apkFiles2, (String)"apkFiles");
        Intrinsics.checkNotNullParameter((Object)iLogger, (String)"iLogger");
        Provider<Directory> provider2 = dexMetadataDirectory;
        Object object = dmDir = provider2 != null ? (Directory)provider2.getOrNull() : null;
        if (dmDir == null || !dmDir.file("dex-metadata-map.properties").getAsFile().exists()) {
            return;
        }
        File dexMetadataProperties = dmDir.file("dex-metadata-map.properties").getAsFile();
        InputStream inputStream = new FileInputStream(dexMetadataProperties);
        Properties properties = new Properties();
        properties.load(inputStream);
        String string = dmPath = deviceApiLevel > 31 ? properties.getProperty("2147483647") : properties.getProperty(String.valueOf(deviceApiLevel));
        if (dmPath == null) {
            Object[] objectArray = new Object[]{deviceApiLevel};
            iLogger.info("Baseline Profile not found for API level {}", objectArray);
            return;
        }
        if (!((Collection)apkFiles2).isEmpty()) {
            String fileIndex = new File(dmPath).getParentFile().getName();
            int numApks = apkFiles2.size();
            for (int i = 0; i < numApks; ++i) {
                String apkFileName = apkFiles2.get(i).getName();
                Intrinsics.checkNotNull((Object)apkFileName);
                if (!StringsKt.endsWith$default((String)apkFileName, (String)".apk", (boolean)false, (int)2, null)) continue;
                String apkName = Files.getNameWithoutExtension((String)apkFileName);
                Object[] objectArray = new String[]{"baselineProfiles", fileIndex, apkName + ".dm"};
                File renamedBaselineProfile = FileUtils.join((File)apkDirectory.getAsFile(), (String[])objectArray);
                if (!renamedBaselineProfile.exists()) {
                    objectArray = new Object[]{renamedBaselineProfile.getAbsolutePath()};
                    iLogger.info("Baseline Profile at {} was not found.", objectArray);
                    return;
                }
                Intrinsics.checkNotNull((Object)renamedBaselineProfile);
                apkFiles2.add(renamedBaselineProfile);
            }
        }
    }
}

