/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.cxx.configure;

import com.android.build.gradle.external.cmake.CmakeUtils;
import com.android.build.gradle.internal.cxx.configure.CMakeVersion;
import com.android.build.gradle.internal.cxx.configure.CmakeVersionRequirements;
import com.android.build.gradle.internal.cxx.logging.LoggingEnvironmentKt;
import com.android.build.gradle.internal.cxx.logging.ThreadLoggingEnvironment;
import com.android.prefs.AndroidLocationsProvider;
import com.android.repository.Revision;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RepoManager;
import com.android.repository.impl.meta.RepositoryPackages;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.LoggerProgressIndicatorWrapper;
import com.android.utils.cxx.CxxDiagnosticCode;
import com.android.utils.cxx.os.OsBehaviorKt;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\u001a\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\f\u001a \u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\fH\u0002\u001a&\u0010\u0013\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0014\u001a\u00020\f2\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00170\u0016H\u0002\u001a~\u0010\u0018\u001a\u0004\u0018\u00010\f2\b\u0010\u0019\u001a\u0004\u0018\u00010\u00172\b\u0010\u001a\u001a\u0004\u0018\u00010\f2\u000e\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u001c2\u0012\u0010\u001d\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\u001e2\u0012\u0010\u001f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\u001e2\u0014\u0010 \u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00162\u0012\u0010!\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000b0\u001e\u001a\n\u0010\"\u001a\u00020#*\u00020\u0001\"\u001e\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\u0005\u001a\u0004\b\u0003\u0010\u0004\"\u001e\u0010\u0006\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\u0005\u001a\u0004\b\u0007\u0010\u0004\"\u001b\u0010\b\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001\u00a2\u0006\n\n\u0002\u0010\u0005\u001a\u0004\b\t\u0010\u0004\u00a8\u0006$"}, d2={"forkCmakeSdkVersionRevision", "Lcom/android/repository/Revision;", "kotlin.jvm.PlatformType", "getForkCmakeSdkVersionRevision", "()Lcom/android/repository/Revision;", "Lcom/android/repository/Revision;", "forkCmakeReportedVersion", "getForkCmakeReportedVersion", "defaultCmakeVersion", "getDefaultCmakeVersion", "getSdkCmakeFolders", "", "Ljava/io/File;", "sdkRoot", "getSdkCmakePackages", "Lcom/android/repository/api/LocalPackage;", "androidLocationsProvider", "Lcom/android/prefs/AndroidLocationsProvider;", "sdkFolder", "getCmakeRevisionFromExecutable", "cmakeFolder", "versionExecutor", "Lkotlin/Function1;", "", "findCmakePathLogic", "cmakeVersionFromDsl", "cmakePathFromLocalProperties", "downloader", "Ljava/util/function/Consumer;", "environmentPaths", "Lkotlin/Function0;", "sdkFolders", "cmakeVersionGetter", "repositoryPackages", "isCmakeForkVersion", "", "gradle-core"})
@SourceDebugExtension(value={"SMAP\nCmakeLocator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CmakeLocator.kt\ncom/android/build/gradle/internal/cxx/configure/CmakeLocatorKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,486:1\n11165#2:487\n11500#2,3:488\n774#3:491\n865#3,2:492\n2642#3:494\n1#4:495\n*S KotlinDebug\n*F\n+ 1 CmakeLocator.kt\ncom/android/build/gradle/internal/cxx/configure/CmakeLocatorKt\n*L\n197#1:487\n197#1:488,3\n198#1:491\n198#1:492,2\n443#1:494\n443#1:495\n*E\n"})
public final class CmakeLocatorKt {
    private static final Revision forkCmakeSdkVersionRevision = Revision.parseRevision((String)CMakeVersion.FORK.getSdkFolderName());
    private static final Revision forkCmakeReportedVersion = Revision.parseRevision((String)CMakeVersion.FORK.getVersion());
    private static final Revision defaultCmakeVersion = Revision.parseRevision((String)CMakeVersion.DEFAULT.getVersion());

    public static final Revision getForkCmakeSdkVersionRevision() {
        return forkCmakeSdkVersionRevision;
    }

    public static final Revision getForkCmakeReportedVersion() {
        return forkCmakeReportedVersion;
    }

    public static final Revision getDefaultCmakeVersion() {
        return defaultCmakeVersion;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<File> getSdkCmakeFolders(@Nullable File sdkRoot) {
        void $this$filterTo$iv$iv;
        Iterable $this$mapTo$iv$iv;
        File[] fileArray;
        File file;
        File[] $this$map$iv = sdkRoot != null && (file = FilesKt.resolve((File)sdkRoot, (String)"cmake")) != null && (fileArray = file.listFiles()) != null ? fileArray : new File[]{};
        boolean $i$f$map = false;
        File[] fileArray2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var9_12 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            collection.add(FilesKt.resolve((File)it, (String)"bin"));
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            File it = (File)element$iv$iv;
            boolean bl = false;
            if (!it.isDirectory()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    private static final List<LocalPackage> getSdkCmakePackages(AndroidLocationsProvider androidLocationsProvider, File sdkFolder) {
        File file = sdkFolder;
        AndroidSdkHandler androidSdkHandler = AndroidSdkHandler.getInstance((AndroidLocationsProvider)androidLocationsProvider, (Path)(file != null ? file.toPath() : null));
        RepoManager sdkManager = androidSdkHandler.getSdkManager((ProgressIndicator)new LoggerProgressIndicatorWrapper(ThreadLoggingEnvironment.Companion.getILogger(CxxDiagnosticCode.CMAKE_PACKAGES_SDK, CxxDiagnosticCode.CMAKE_PACKAGES_SDK)));
        RepositoryPackages packages = sdkManager.getPackages();
        Collection collection = packages.getLocalPackagesForPrefix("cmake");
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getLocalPackagesForPrefix(...)");
        return CollectionsKt.toList((Iterable)collection);
    }

    private static final Revision getCmakeRevisionFromExecutable(File cmakeFolder, Function1<? super File, String> versionExecutor) {
        if (!cmakeFolder.exists()) {
            return null;
        }
        File cmakeExecutable = new File(cmakeFolder, "cmake" + OsBehaviorKt.getExe());
        if (!cmakeExecutable.isFile()) {
            return null;
        }
        return CmakeUtils.getVersion(cmakeFolder, new Function(versionExecutor){
            private final /* synthetic */ Function1 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ Object apply(Object p0) {
                return this.function.invoke(p0);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final File findCmakePathLogic(@Nullable String cmakeVersionFromDsl, @Nullable File cmakePathFromLocalProperties, @Nullable Consumer<String> downloader, @NotNull Function0<? extends List<? extends File>> environmentPaths, @NotNull Function0<? extends List<? extends File>> sdkFolders, @NotNull Function1<? super File, ? extends Revision> cmakeVersionGetter, @NotNull Function0<? extends List<? extends LocalPackage>> repositoryPackages) {
        Revision version;
        Intrinsics.checkNotNullParameter(environmentPaths, (String)"environmentPaths");
        Intrinsics.checkNotNullParameter(sdkFolders, (String)"sdkFolders");
        Intrinsics.checkNotNullParameter(cmakeVersionGetter, (String)"cmakeVersionGetter");
        Intrinsics.checkNotNullParameter(repositoryPackages, (String)"repositoryPackages");
        CmakeVersionRequirements dsl = new CmakeVersionRequirements(cmakeVersionFromDsl);
        List nonsatisfiers = new ArrayList();
        if (cmakePathFromLocalProperties != null) {
            Revision version2 = CmakeLocatorKt.findCmakePathLogic$versionGetter(cmakeVersionGetter, FilesKt.resolve((File)cmakePathFromLocalProperties, (String)"bin"));
            if (version2 == null) {
                LoggingEnvironmentKt.errorln(CxxDiagnosticCode.CMAKE_VERSION_IS_INVALID, "Could not get version from cmake.dir path '" + cmakePathFromLocalProperties + "'.", new Object[0]);
            } else {
                if (cmakeVersionFromDsl == null) {
                    return cmakePathFromLocalProperties;
                }
                if (!dsl.isSatisfiedBy(version2)) {
                    ((Collection)nonsatisfiers).add("'" + version2 + "' found from cmake.dir");
                } else {
                    return cmakePathFromLocalProperties;
                }
            }
        }
        Set cmakePaths = new LinkedHashSet();
        for (LocalPackage localPackage : (List)repositoryPackages.invoke()) {
            Path packagePath = localPackage.getLocation().resolve("bin");
            if (cmakePaths.contains(((Object)packagePath).toString())) continue;
            Revision version3 = Intrinsics.areEqual((Object)localPackage.getVersion(), (Object)forkCmakeSdkVersionRevision) ? forkCmakeReportedVersion : localPackage.getVersion();
            Intrinsics.checkNotNull((Object)version3);
            if (!dsl.isSatisfiedBy(version3)) {
                ((Collection)nonsatisfiers).add("'" + version3 + "' found in SDK");
                continue;
            }
            cmakePaths.add(((Object)packagePath).toString());
        }
        if (cmakePaths.isEmpty()) {
            for (File environmentPath : (List)environmentPaths.invoke()) {
                if (cmakePaths.contains(environmentPath.getPath()) || CmakeLocatorKt.findCmakePathLogic$versionGetter(cmakeVersionGetter, environmentPath) == null) continue;
                if (!dsl.isSatisfiedBy(version)) {
                    ((Collection)nonsatisfiers).add("'" + version + "' found in PATH");
                    continue;
                }
                String string = environmentPath.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                cmakePaths.add(string);
            }
        }
        if (cmakePaths.isEmpty()) {
            for (File sdkFolder : (List)sdkFolders.invoke()) {
                Revision revision;
                Revision revision2;
                if (cmakePaths.contains(sdkFolder.getPath())) continue;
                try {
                    revision2 = Revision.parseRevision((String)CmakeUtils.keepWhileNumbersAndDots(sdkFolder.getParentFile().getName()));
                }
                catch (Throwable e) {
                    revision2 = null;
                }
                if ((revision = revision2) == null && (revision = CmakeLocatorKt.findCmakePathLogic$versionGetter(cmakeVersionGetter, sdkFolder)) == null || !dsl.isSatisfiedBy(version = revision)) continue;
                String string = sdkFolder.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                cmakePaths.add(string);
            }
        }
        if (cmakePaths.isEmpty()) {
            void $this$onEach$iv;
            void var12_13;
            if (downloader != null && dsl.getDownloadVersion() != null) {
                downloader.accept(dsl.getDownloadVersion());
                return CmakeLocatorKt.findCmakePathLogic(cmakeVersionFromDsl, cmakePathFromLocalProperties, null, environmentPaths, sdkFolders, cmakeVersionGetter, repositoryPackages);
            }
            LoggingEnvironmentKt.errorln(CxxDiagnosticCode.CMAKE_IS_MISSING, "CMake " + dsl.getHumanReadableVersionLanguage() + " was not found in SDK, PATH, or by cmake.dir property.", new Object[0]);
            Iterable iterable = CollectionsKt.distinct((Iterable)nonsatisfiers);
            boolean $i$f$onEach = false;
            void $this$onEach_u24lambda_u2419$iv = var12_13 = $this$onEach$iv;
            boolean bl = false;
            for (Object element$iv : $this$onEach_u24lambda_u2419$iv) {
                String it = (String)element$iv;
                boolean bl2 = false;
                LoggingEnvironmentKt.errorln(CxxDiagnosticCode.CMAKE_VERSION_IS_INVALID, "- CMake " + it + " did not satisfy requested version.", new Object[0]);
            }
            return null;
        }
        return new File((String)CollectionsKt.first((Iterable)cmakePaths)).getParentFile();
    }

    public static final boolean isCmakeForkVersion(@NotNull Revision $this$isCmakeForkVersion) {
        Intrinsics.checkNotNullParameter((Object)$this$isCmakeForkVersion, (String)"<this>");
        return $this$isCmakeForkVersion.getMajor() == 3 && $this$isCmakeForkVersion.getMinor() == 6 && $this$isCmakeForkVersion.getMicro() == 0;
    }

    private static final Revision findCmakePathLogic$versionGetter(Function1<? super File, ? extends Revision> $cmakeVersionGetter, File cmakePath) {
        Revision revision;
        try {
            revision = (Revision)$cmakeVersionGetter.invoke((Object)cmakePath);
        }
        catch (IOException e) {
            LoggingEnvironmentKt.warnln("Could not execute cmake at '" + cmakePath + "' to get version. Skipping.", new Object[0]);
            revision = null;
        }
        return revision;
    }

    public static final /* synthetic */ Revision access$getCmakeRevisionFromExecutable(File cmakeFolder, Function1 versionExecutor) {
        return CmakeLocatorKt.getCmakeRevisionFromExecutable(cmakeFolder, (Function1<? super File, String>)versionExecutor);
    }

    public static final /* synthetic */ List access$getSdkCmakePackages(AndroidLocationsProvider androidLocationsProvider, File sdkFolder) {
        return CmakeLocatorKt.getSdkCmakePackages(androidLocationsProvider, sdkFolder);
    }
}

