/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.ide;

import com.android.build.gradle.internal.ide.BaseConfigImpl;
import com.android.builder.model.BaseConfig;
import com.android.builder.model.BuildType;
import com.android.builder.model.SigningConfig;
import java.io.Serializable;
import java.util.Objects;

final class BuildTypeImpl
extends BaseConfigImpl
implements BuildType,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final boolean debuggable;
    private final boolean testCoverageEnabled;
    private final boolean jniDebuggable;
    private final boolean pseudoLocalesEnabled;
    private final boolean renderscriptDebuggable;
    private final int renderscriptOptimLevel;
    private final String versionNameSuffix;
    private final boolean minifyEnabled;
    private final boolean zipAlignEnabled;
    private final boolean embedMicroApp;

    BuildTypeImpl(BuildType buildType) {
        super((BaseConfig)buildType);
        this.name = buildType.getName();
        this.debuggable = buildType.isDebuggable();
        this.testCoverageEnabled = buildType.isTestCoverageEnabled();
        this.jniDebuggable = buildType.isJniDebuggable();
        this.pseudoLocalesEnabled = buildType.isPseudoLocalesEnabled();
        this.renderscriptDebuggable = false;
        this.renderscriptOptimLevel = buildType.getRenderscriptOptimLevel();
        this.versionNameSuffix = buildType.getVersionNameSuffix();
        this.minifyEnabled = buildType.isMinifyEnabled();
        this.zipAlignEnabled = buildType.isZipAlignEnabled();
        this.embedMicroApp = buildType.isEmbedMicroApp();
    }

    public String getName() {
        return this.name;
    }

    public boolean isDebuggable() {
        return this.debuggable;
    }

    public boolean isTestCoverageEnabled() {
        return this.testCoverageEnabled;
    }

    public boolean isJniDebuggable() {
        return this.jniDebuggable;
    }

    public boolean isRenderscriptDebuggable() {
        return this.renderscriptDebuggable;
    }

    public boolean isPseudoLocalesEnabled() {
        return this.pseudoLocalesEnabled;
    }

    public int getRenderscriptOptimLevel() {
        return this.renderscriptOptimLevel;
    }

    @Override
    public String getVersionNameSuffix() {
        return this.versionNameSuffix;
    }

    public boolean isMinifyEnabled() {
        return this.minifyEnabled;
    }

    public boolean isZipAlignEnabled() {
        return this.zipAlignEnabled;
    }

    public boolean isEmbedMicroApp() {
        return this.embedMicroApp;
    }

    public SigningConfig getSigningConfig() {
        return null;
    }

    @Override
    public String toString() {
        return "BuildTypeImpl{name='" + this.name + "', debuggable=" + this.debuggable + ", testCoverageEnabled=" + this.testCoverageEnabled + ", jniDebuggable=" + this.jniDebuggable + ", renderscriptDebuggable=" + this.renderscriptDebuggable + ", renderscriptOptimLevel=" + this.renderscriptOptimLevel + ", versionNameSuffix='" + this.versionNameSuffix + "', minifyEnabled=" + this.minifyEnabled + ", zipAlignEnabled=" + this.zipAlignEnabled + ", embedMicroApp=" + this.embedMicroApp + "} " + super.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BuildTypeImpl buildType = (BuildTypeImpl)o;
        return this.debuggable == buildType.debuggable && this.testCoverageEnabled == buildType.testCoverageEnabled && this.jniDebuggable == buildType.jniDebuggable && this.pseudoLocalesEnabled == buildType.pseudoLocalesEnabled && this.renderscriptDebuggable == buildType.renderscriptDebuggable && this.renderscriptOptimLevel == buildType.renderscriptOptimLevel && this.minifyEnabled == buildType.minifyEnabled && this.zipAlignEnabled == buildType.zipAlignEnabled && this.embedMicroApp == buildType.embedMicroApp && Objects.equals(this.name, buildType.name) && Objects.equals(this.versionNameSuffix, buildType.versionNameSuffix);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.name, this.debuggable, this.testCoverageEnabled, this.jniDebuggable, this.pseudoLocalesEnabled, this.renderscriptDebuggable, this.renderscriptOptimLevel, this.versionNameSuffix, this.minifyEnabled, this.zipAlignEnabled, this.embedMicroApp);
    }
}

