/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.manifest;

import com.android.build.gradle.internal.manifest.ManifestData;
import com.android.build.gradle.internal.manifest.ManifestDataKt;
import com.android.build.gradle.internal.manifest.ManifestDataProvider;
import com.android.build.gradle.internal.manifest.ManifestValueSource;
import com.android.build.gradle.internal.services.ProjectServices;
import com.android.builder.errors.EvalIssueException;
import com.android.builder.errors.IssueReporter;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.Transformer;
import org.gradle.api.file.RegularFile;
import org.gradle.api.logging.Logger;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ValueSourceSpec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B3\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00110\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\u00020\"8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$\u00a8\u0006%"}, d2={"Lcom/android/build/gradle/internal/manifest/LazyManifestParser;", "Lcom/android/build/gradle/internal/manifest/ManifestDataProvider;", "manifestFile", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/RegularFile;", "manifestFileRequired", "", "manifestParsingAllowed", "projectServices", "Lcom/android/build/gradle/internal/services/ProjectServices;", "<init>", "(Lorg/gradle/api/provider/Provider;ZLorg/gradle/api/provider/Provider;Lcom/android/build/gradle/internal/services/ProjectServices;)V", "logger", "Lorg/gradle/api/logging/Logger;", "getLogger", "()Lorg/gradle/api/logging/Logger;", "rawManifestData", "Lcom/android/build/gradle/internal/manifest/ManifestData;", "getRawManifestData", "()Lcom/android/build/gradle/internal/manifest/ManifestData;", "setRawManifestData", "(Lcom/android/build/gradle/internal/manifest/ManifestData;)V", "manifestDataCalculated", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getManifestDataCalculated", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "issueReporter", "Lcom/android/builder/errors/IssueReporter;", "getIssueReporter", "()Lcom/android/builder/errors/IssueReporter;", "manifestData", "getManifestData", "()Lorg/gradle/api/provider/Provider;", "manifestLocation", "", "getManifestLocation", "()Ljava/lang/String;", "gradle-core"})
public final class LazyManifestParser
implements ManifestDataProvider {
    @NotNull
    private final Provider<RegularFile> manifestFile;
    private final boolean manifestFileRequired;
    @NotNull
    private final Provider<Boolean> manifestParsingAllowed;
    @NotNull
    private final Logger logger;
    @Nullable
    private ManifestData rawManifestData;
    @NotNull
    private final AtomicBoolean manifestDataCalculated;
    @NotNull
    private final IssueReporter issueReporter;
    @NotNull
    private final Provider<ManifestData> manifestData;

    public LazyManifestParser(@NotNull Provider<RegularFile> manifestFile, boolean manifestFileRequired, @NotNull Provider<Boolean> manifestParsingAllowed, @NotNull ProjectServices projectServices2) {
        Intrinsics.checkNotNullParameter(manifestFile, (String)"manifestFile");
        Intrinsics.checkNotNullParameter(manifestParsingAllowed, (String)"manifestParsingAllowed");
        Intrinsics.checkNotNullParameter((Object)projectServices2, (String)"projectServices");
        this.manifestFile = manifestFile;
        this.manifestFileRequired = manifestFileRequired;
        this.manifestParsingAllowed = manifestParsingAllowed;
        this.logger = projectServices2.getLogger();
        this.manifestDataCalculated = new AtomicBoolean(false);
        this.issueReporter = projectServices2.getIssueReporter().isInStandardEvaluationMode() ? (IssueReporter)new IssueReporter(this){
            private final Set<IssueReporter.Type> issues;
            final /* synthetic */ LazyManifestParser this$0;
            {
                this.this$0 = $receiver;
                this.issues = new LinkedHashSet<E>();
            }

            public final Set<IssueReporter.Type> getIssues() {
                return this.issues;
            }

            protected void reportIssue(IssueReporter.Type type, IssueReporter.Severity severity, EvalIssueException exception) {
                Intrinsics.checkNotNullParameter((Object)type, (String)"type");
                Intrinsics.checkNotNullParameter((Object)severity, (String)"severity");
                Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
                this.issues.add(type);
                if (severity == IssueReporter.Severity.ERROR) {
                    this.this$0.getLogger().error(exception.getMessage());
                } else {
                    this.this$0.getLogger().warn(exception.getMessage());
                }
            }

            public boolean hasIssue(IssueReporter.Type type) {
                Intrinsics.checkNotNullParameter((Object)type, (String)"type");
                return this.issues.contains(type);
            }
        } : (IssueReporter)projectServices2.getIssueReporter();
        Function1 function1 = (Function1)new Function1<ValueSourceSpec<ManifestValueSource.Params>, Unit>(this){
            final /* synthetic */ LazyManifestParser this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(ValueSourceSpec<ManifestValueSource.Params> it) {
                ((ManifestValueSource.Params)it.getParameters()).getManifestFile().set(LazyManifestParser.access$getManifestFile$p(this.this$0));
            }
        };
        Action action = new Action(function1){
            private final /* synthetic */ Function1 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ void execute(Object p0) {
                this.function.invoke(p0);
            }
        };
        function1 = (Function1)new Function1<String, ManifestData>(this){
            final /* synthetic */ LazyManifestParser this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final ManifestData invoke(String it) {
                ManifestData manifestData2;
                if (!this.this$0.getManifestDataCalculated().get()) {
                    this.this$0.getManifestDataCalculated().set(true);
                    Intrinsics.checkNotNull((Object)it);
                    String string = ((RegularFile)LazyManifestParser.access$getManifestFile$p(this.this$0).get()).getAsFile().getAbsolutePath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
                    this.this$0.setRawManifestData(ManifestDataKt.parseManifest(it, string, LazyManifestParser.access$getManifestFileRequired$p(this.this$0), (Provider<Boolean>)LazyManifestParser.access$getManifestParsingAllowed$p(this.this$0), this.this$0.getIssueReporter()));
                }
                if ((manifestData2 = this.this$0.getRawManifestData()) == null) {
                    manifestData2 = new ManifestData("fake.package.name.for.sync", null, null, null, null, null, null, null, null, null, null, null, 4094, null);
                }
                return manifestData2;
            }
        };
        Provider provider2 = projectServices2.getProviderFactory().of(ManifestValueSource.class, action).map(new Transformer(function1){
            private final /* synthetic */ Function1 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ Object transform(Object in) {
                return this.function.invoke(in);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"map(...)");
        this.manifestData = provider2;
    }

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    @Nullable
    public final ManifestData getRawManifestData() {
        return this.rawManifestData;
    }

    public final void setRawManifestData(@Nullable ManifestData manifestData2) {
        this.rawManifestData = manifestData2;
    }

    @NotNull
    public final AtomicBoolean getManifestDataCalculated() {
        return this.manifestDataCalculated;
    }

    @NotNull
    public final IssueReporter getIssueReporter() {
        return this.issueReporter;
    }

    @Override
    @NotNull
    public Provider<ManifestData> getManifestData() {
        return this.manifestData;
    }

    @Override
    @NotNull
    public String getManifestLocation() {
        String string = ((RegularFile)this.manifestFile.get()).getAsFile().getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
        return string;
    }

    public static final /* synthetic */ Provider access$getManifestFile$p(LazyManifestParser $this) {
        return $this.manifestFile;
    }

    public static final /* synthetic */ boolean access$getManifestFileRequired$p(LazyManifestParser $this) {
        return $this.manifestFileRequired;
    }

    public static final /* synthetic */ Provider access$getManifestParsingAllowed$p(LazyManifestParser $this) {
        return $this.manifestParsingAllowed;
    }
}

